/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.ECCurve;
import org.keycloak.crypto.ECDSASignatureVerifierContext;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.util.JWKSUtils;

public class JwkParsingUtils {
    public static SignatureVerifierContext convertJwkNodeToVerifierContext(JsonNode jwkNode) {
        JWK jwk;
        try {
            jwk = (JWK)SdJwtUtils.mapper.convertValue((Object)jwkNode, JWK.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed JWK");
        }
        return JwkParsingUtils.convertJwkToVerifierContext(jwk);
    }

    public static SignatureVerifierContext convertJwkToVerifierContext(JWK jwk) {
        KeyWrapper keyWrapper;
        try {
            keyWrapper = JWKSUtils.getKeyWrapper(jwk);
            Objects.requireNonNull(keyWrapper);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported or invalid JWK");
        }
        if (keyWrapper.getType().equals("EC")) {
            if (keyWrapper.getAlgorithm() == null) {
                Objects.requireNonNull(keyWrapper.getCurve());
                String alg = null;
                switch (ECCurve.fromStdCrv(keyWrapper.getCurve())) {
                    case P256: {
                        alg = "ES256";
                        break;
                    }
                    case P384: {
                        alg = "ES384";
                        break;
                    }
                    case P521: {
                        alg = "ES512";
                    }
                }
                keyWrapper.setAlgorithm(alg);
            }
            return new ECDSASignatureVerifierContext(keyWrapper);
        }
        if (keyWrapper.getType().equals("RSA")) {
            return new AsymmetricSignatureVerifierContext(keyWrapper);
        }
        throw new IllegalArgumentException("Unexpected key type: " + keyWrapper.getType());
    }
}

