/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.common;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.keycloak.client.cli.common.BaseAuthOptionsCmd;
import org.keycloak.client.cli.common.CommandState;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.config.RealmConfigData;
import org.keycloak.client.cli.util.AuthUtil;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.common.util.IoUtils;
import org.keycloak.representations.AccessTokenResponse;

public class BaseConfigCredentialsCmd
extends BaseAuthOptionsCmd {
    private int sigLifetime = 600;

    public BaseConfigCredentialsCmd(CommandState commandState) {
        super(commandState);
    }

    public void init(ConfigData configData) {
        RealmConfigData rdata;
        if (this.server == null) {
            this.server = configData.getServerUrl();
        }
        if (this.realm == null) {
            this.realm = configData.getRealm();
        }
        if (this.trustStore == null) {
            this.trustStore = configData.getTruststore();
        }
        if ((rdata = configData.getRealmConfigData(this.server, this.realm)) == null) {
            return;
        }
        if (this.clientId == null) {
            this.clientId = rdata.getClientId();
        }
    }

    @Override
    protected String[] getUnsupportedOptions() {
        return new String[]{"--no-config", BaseConfigCredentialsCmd.booleanOptionForCheck(this.noconfig)};
    }

    @Override
    public void process() {
        if (this.server == null) {
            throw new IllegalArgumentException("Required option not specified: --server");
        }
        try {
            new URL(this.server);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid server endpoint url: " + this.server, e);
        }
        if (this.realm == null) {
            throw new IllegalArgumentException("Required option not specified: --realm");
        }
        String signedRequestToken = null;
        boolean clientSet = this.clientId != null;
        this.applyDefaultOptionValues();
        String grantTypeForAuthentication = null;
        if (this.user != null) {
            grantTypeForAuthentication = "password";
            IoUtil.printErr("Logging into " + this.server + " as user " + this.user + " of realm " + this.realm);
            if (this.password == null) {
                this.password = System.getenv("KC_CLI_PASSWORD");
            }
            if (this.password == null) {
                this.password = IoUtils.readPasswordFromConsole("password");
            }
            if ("-".equals(this.secret) && this.keystore == null) {
                this.secret = IoUtils.readPasswordFromConsole("client secret");
            }
        } else if (this.keystore != null || this.secret != null || clientSet) {
            grantTypeForAuthentication = "client_credentials";
            IoUtil.printErr("Logging into " + this.server + " as service-account-" + this.clientId + " of realm " + this.realm);
            if (this.keystore == null && this.secret == null) {
                this.secret = System.getenv("KC_CLI_CLIENT_SECRET");
                if (this.secret == null) {
                    this.secret = IoUtils.readPasswordFromConsole("client secret");
                }
            }
        }
        if (this.keystore != null) {
            if (this.secret != null) {
                throw new IllegalArgumentException("Can't use both --keystore and --secret");
            }
            if (!new File(this.keystore).isFile()) {
                throw new RuntimeException("No such keystore file: " + this.keystore);
            }
            if (this.storePass == null) {
                this.storePass = System.getenv("KC_CLI_STORE_PASSWORD");
            }
            if (this.keyPass == null) {
                this.keyPass = System.getenv("KC_CLI_KEY_PASSWORD");
            }
            if (this.storePass == null) {
                this.storePass = IoUtils.readPasswordFromConsole("keystore password");
                if (this.keyPass == null) {
                    this.keyPass = IoUtils.readPasswordFromConsole("key password");
                }
            }
            if (this.keyPass == null) {
                this.keyPass = this.storePass;
            }
            if (this.alias == null) {
                this.alias = this.clientId;
            }
            String realmInfoUrl = this.server + "/realms/" + this.realm;
            signedRequestToken = AuthUtil.getSignedRequestToken(this.keystore, this.storePass, this.keyPass, this.alias, this.sigLifetime, this.clientId, realmInfoUrl);
        }
        if (this.user == null && this.secret == null && this.keystore == null) {
            ConfigUtil.getHandler().saveMergeConfig(config -> {
                config.setServerUrl(this.server);
                config.setRealm(this.realm);
            });
            return;
        }
        this.setupTruststore(this.copyWithServerInfo(ConfigUtil.loadConfig()));
        AccessTokenResponse tokens = signedRequestToken != null ? AuthUtil.getAuthTokensByJWT(this.server, this.realm, this.user, this.password, this.clientId, signedRequestToken) : (this.secret != null ? AuthUtil.getAuthTokensBySecret(this.server, this.realm, this.user, this.password, this.clientId, this.secret) : AuthUtil.getAuthTokens(this.server, this.realm, this.user, this.password, this.clientId));
        Long sigExpiresAt = signedRequestToken == null ? null : Long.valueOf(System.currentTimeMillis() + (long)(this.sigLifetime * 1000));
        ConfigUtil.saveTokens(tokens, this.server, this.realm, this.clientId, signedRequestToken, sigExpiresAt, this.secret, grantTypeForAuthentication);
    }

    @Override
    public String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + this.getCommand() + " config credentials --server SERVER_URL --realm REALM [ARGUMENTS]");
        out.println("       " + this.getCommand() + " config credentials --server SERVER_URL --realm REALM --user USER [--password PASSWORD] [ARGUMENTS]");
        out.println("       " + this.getCommand() + " config credentials --server SERVER_URL --realm REALM --client CLIENT_ID [--secret SECRET] [ARGUMENTS]");
        out.println("       " + this.getCommand() + " config credentials --server SERVER_URL --realm REALM --client CLIENT_ID [--keystore KEYSTORE] [ARGUMENTS]");
        out.println("       " + this.getCommand() + " config credentials --status");
        out.println();
        out.println("Command to establish an authenticated client session with the server. There are many authentication");
        out.println("options available, and it depends on server side client authentication configuration how client can or should authenticate.");
        out.println("The information always required includes --server, and --realm. Then, --user and / or --client need to be used to authenticate.");
        out.println("If --client is not provided it defaults to 'admin-cli'. The authentication options / requirements depend on how this client is configured.");
        out.println();
        out.println("If confidential client authentication is also configured, you may have to specify a client id, and client credentials in addition to");
        out.println("user credentials. Client credentials are either a client secret, or a keystore information to use Signed JWT mechanism.");
        out.println("If only client credentials are provided, and no user credentials, then the service account is used for login.");
        out.println("If validity of the authentication needs to be checked use the --status option. This would only check the status of the existing config and does not update the config.");
        out.println("Other arguments which are passed along with status are ignored");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                      Print full stack trace when exiting with error");
        out.println("    --config                Path to a config file (" + this.getDefaultConfigFilePath() + " by default)");
        out.println("    --truststore PATH       Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified, --truststore is used, and the KC_CLI_TRUSTSTORE_PASSWORD env property is not defined)");
        out.println();
        out.println("  Command specific options:");
        out.println("    --server SERVER_URL     Server endpoint url (e.g. 'http://localhost:8080')");
        out.println("    --realm REALM           Realm name to use");
        out.println("    --user USER             Username to login with");
        out.println("    --password PASSWORD     Password to login with (prompted for if not specified, --user is used, and the env variable KC_CLI_PASSWORD is not defined)");
        out.println("    --client CLIENT_ID      ClientId used by this client tool ('admin-cli' by default)");
        out.println("    --secret SECRET         Secret to authenticate the client (prompted for if no --user nor --keystore is specified, and the env variable KC_CLI_CLIENT_SECRET is not defined)");
        out.println("    --keystore PATH         Path to a keystore containing private key");
        out.println("    --storepass PASSWORD    Keystore password (prompted for if not specified, --keystore is used, and the env variable KC_CLI_STORE_PASSWORD)");
        out.println("    --keypass PASSWORD      Key password (prompted for if not specified, --keystore is used without --storepass, and KC_CLI_KEY_PASSWORD");
        out.println("                            otherwise defaults to keystore password)");
        out.println("    --alias ALIAS           Alias of the key inside a keystore (defaults to the value of ClientId)");
        out.println("    --status                Checks the validity of the existing connection (Note: It does not update the config)");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Login as 'admin' user of 'master' realm to a local Keycloak server running on default port.");
        out.println("You will be prompted for a password:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config credentials --server http://localhost:8080 --realm master --user admin");
        out.println();
        out.println("Login to Keycloak server at non-default endpoint passing the password via standard input:");
        if (OsUtil.OS_ARCH.isWindows()) {
            out.println("  " + OsUtil.PROMPT + " echo mypassword | " + this.getCommand() + " config credentials --server http://localhost:9080 --realm master --user admin");
        } else {
            out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config credentials --server http://localhost:9080 --realm master --user admin << EOF");
            out.println("  mypassword");
            out.println("  EOF");
        }
        out.println();
        out.println("Login specifying a password through command line:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config credentials --server http://localhost:9080 --realm master --user admin --password " + OsUtil.OS_ARCH.envVar("PASSWORD"));
        out.println();
        out.println("Login using a client service account of a custom client. You will be prompted for a client secret:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config credentials --server http://localhost:9080 --realm master --client reg-cli");
        out.println();
        out.println("Login using a client service account of a custom client, authenticating with signed JWT.");
        out.println("You will be prompted for a keystore password, and a key password:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config credentials --server http://localhost:9080 --realm master --client reg-cli --keystore " + OsUtil.OS_ARCH.path("~/.keycloak/keystore.jks"));
        out.println();
        out.println("Login as 'user' while also authenticating a custom client with signed JWT.");
        out.println("You will be prompted for a user password, a keystore password, and a key password:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config credentials --server http://localhost:9080 --realm master --user user --client reg-cli --keystore " + OsUtil.OS_ARCH.path("~/.keycloak/keystore.jks"));
        out.println();
        out.println();
        out.println("Use '" + this.getCommand() + " help' for general information and a list of commands");
        return sb.toString();
    }
}

