/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.classloader.ClassDefiner;
import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingGenerator;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config._private.ConfigMessages;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ConfigMappingLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ConcurrentHashMap<String, Object> classLoaderLocks = new ConcurrentHashMap();
    private static final ClassValue<ConfigMappingImplementation> CACHE = new ClassValue<ConfigMappingImplementation>(){

        @Override
        protected ConfigMappingImplementation computeValue(Class<?> type) {
            return new ConfigMappingImplementation(ConfigMappingLoader.loadImplementation(type));
        }
    };

    public static List<ConfigMappingMetadata> getConfigMappingsMetadata(Class<?> type) {
        ConfigMappingClass configMappingClass;
        ArrayList<ConfigMappingMetadata> mappings = new ArrayList<ConfigMappingMetadata>();
        ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(type);
        if (configurationInterface != null) {
            mappings.add(configurationInterface);
            mappings.addAll(configurationInterface.getNested());
            for (ConfigMappingInterface superType : configurationInterface.getSuperTypes()) {
                mappings.add(superType);
                mappings.addAll(superType.getNested());
            }
        }
        if ((configMappingClass = ConfigMappingClass.getConfigurationClass(type)) != null) {
            mappings.add(configMappingClass);
            mappings.addAll(ConfigMappingLoader.getConfigMappingsMetadata(ConfigMappingLoader.getConfigMapping(type).getInterfaceType()));
        }
        return List.copyOf(mappings);
    }

    public static ConfigMappingInterface getConfigMapping(Class<?> type) {
        return ConfigMappingInterface.getConfigurationInterface(ConfigMappingLoader.getConfigMappingClass(type));
    }

    static Class<?> getConfigMappingClass(Class<?> type) {
        ConfigMappingClass configMappingClass = ConfigMappingClass.getConfigurationClass(type);
        if (configMappingClass == null) {
            return type;
        }
        return ConfigMappingLoader.loadClass(type, configMappingClass);
    }

    static <T> Map<String, String> configMappingProperties(Class<T> interfaceType) {
        try {
            return CACHE.get(interfaceType).getProperties().invoke();
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException r) {
                throw r;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    static <T> T configMappingObject(Class<T> interfaceType, ConfigMappingContext configMappingContext) {
        try {
            return (T)CACHE.get(interfaceType).constructor().invokeExact(configMappingContext);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException r) {
                throw r;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public static ConfigMappingImplementation ensureLoaded(Class<?> type) {
        return CACHE.get(type);
    }

    static <T> Class<?> loadImplementation(Class<T> type) {
        try {
            Class<?> implementationClass = type.getClassLoader().loadClass(ConfigMappingInterface.getImplementationClassName(type));
            if (type.isAssignableFrom(implementationClass)) {
                return implementationClass;
            }
            ConfigMappingInterface mappingMetadata = ConfigMappingInterface.getConfigurationInterface(type);
            if (mappingMetadata == null) {
                throw ConfigMessages.msg.classIsNotAMapping(type);
            }
            return ConfigMappingLoader.loadClass(type, mappingMetadata);
        }
        catch (ClassNotFoundException e) {
            ConfigMappingInterface mappingMetadata = ConfigMappingInterface.getConfigurationInterface(type);
            if (mappingMetadata == null) {
                throw ConfigMessages.msg.classIsNotAMapping(type);
            }
            return ConfigMappingLoader.loadClass(type, mappingMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<?> loadClass(Class<?> parent, ConfigMappingMetadata configMappingMetadata) {
        Object object = ConfigMappingLoader.getClassLoaderLock(configMappingMetadata.getClassName());
        synchronized (object) {
            try {
                Class<?> klass = parent.getClassLoader().loadClass(configMappingMetadata.getClassName());
                if (parent.isAssignableFrom(klass)) {
                    return klass;
                }
                if (configMappingMetadata instanceof ConfigMappingClass) {
                    return klass;
                }
                return ConfigMappingLoader.defineClass(parent, configMappingMetadata.getClassName(), configMappingMetadata.getClassBytes());
            }
            catch (ClassNotFoundException e) {
                return ConfigMappingLoader.defineClass(parent, configMappingMetadata.getClassName(), configMappingMetadata.getClassBytes());
            }
        }
    }

    private static Class<?> defineClass(Class<?> parent, String className, byte[] classBytes) {
        return ClassDefiner.defineClass((MethodHandles.Lookup)LOOKUP, parent, (String)className, (byte[])classBytes);
    }

    private static Object getClassLoaderLock(String className) {
        return classLoaderLocks.computeIfAbsent(className, c -> new Object());
    }

    static final class ConfigMappingClass
    implements ConfigMappingMetadata {
        private static final ClassValue<ConfigMappingClass> cv = new ClassValue<ConfigMappingClass>(){

            @Override
            protected ConfigMappingClass computeValue(Class<?> classType) {
                return ConfigMappingClass.createConfigurationClass(classType);
            }
        };
        private final Class<?> classType;
        private final String interfaceName;

        static ConfigMappingClass getConfigurationClass(Class<?> classType) {
            Assert.checkNotNullParam((String)"classType", classType);
            return cv.get(classType);
        }

        private static ConfigMappingClass createConfigurationClass(Class<?> classType) {
            if (classType.isInterface() && classType.getTypeParameters().length == 0 || Modifier.isAbstract(classType.getModifiers()) || classType.isEnum()) {
                return null;
            }
            return new ConfigMappingClass(classType);
        }

        private static String generateInterfaceName(Class<?> classType) {
            if (classType.isInterface() && classType.getTypeParameters().length == 0 || Modifier.isAbstract(classType.getModifiers()) || classType.isEnum()) {
                throw new IllegalArgumentException();
            }
            return classType.getPackage().getName() + "." + classType.getSimpleName() + classType.getName().hashCode() + "I";
        }

        public ConfigMappingClass(Class<?> classType) {
            this.classType = classType;
            this.interfaceName = ConfigMappingClass.generateInterfaceName(classType);
        }

        @Override
        public Class<?> getInterfaceType() {
            return this.classType;
        }

        @Override
        public String getClassName() {
            return this.interfaceName;
        }

        @Override
        public byte[] getClassBytes() {
            return ConfigMappingGenerator.generate(this.classType, this.interfaceName);
        }
    }

    public static final class ConfigMappingImplementation {
        private final Class<?> implementation;
        private final MethodHandle constructor;
        private final MethodHandle getProperties;

        ConfigMappingImplementation(Class<?> implementation) {
            try {
                this.implementation = implementation;
                MethodHandle constructor = LOOKUP.findConstructor(implementation, MethodType.methodType(Void.TYPE, ConfigMappingContext.class));
                this.constructor = constructor.asType(constructor.type().changeReturnType(Object.class));
                this.getProperties = LOOKUP.findStatic(implementation, "getProperties", MethodType.methodType(Map.class));
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }

        public Class<?> implementation() {
            return this.implementation;
        }

        public MethodHandle constructor() {
            return this.constructor;
        }

        public MethodHandle getProperties() {
            return this.getProperties;
        }
    }
}

