/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.workflow.admin.resource;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.models.ModelException;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.services.ErrorResponse;

@Tag(name="Workflow Steps", description="Manage steps within workflows")
public class WorkflowStepsResource {
    private final WorkflowsManager workflowsManager;
    private final Workflow workflow;

    public WorkflowStepsResource(WorkflowsManager workflowsManager, Workflow workflow) {
        this.workflowsManager = workflowsManager;
        this.workflow = workflow;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all steps for this workflow")
    @APIResponses(value={@APIResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.ARRAY, implementation=WorkflowStepRepresentation.class))})})
    public List<WorkflowStepRepresentation> getSteps() {
        return this.workflowsManager.getSteps(this.workflow.getId()).stream().map(this.workflowsManager::toRepresentation).toList();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add a new step to this workflow")
    @APIResponses(value={@APIResponse(responseCode="200", description="Step created successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowStepRepresentation.class))}), @APIResponse(responseCode="400", description="Invalid step representation or position")})
    public Response addStep(@RequestBody(description="Step to add", required=true, content={@Content(schema=@Schema(implementation=WorkflowStepRepresentation.class))}) WorkflowStepRepresentation stepRep, @Parameter(description="Position to insert the step at (0-based index). If not specified, step is added at the end.") @QueryParam(value="position") Integer position) {
        if (stepRep == null) {
            throw ErrorResponse.error("Step representation cannot be null", Response.Status.BAD_REQUEST);
        }
        try {
            WorkflowStep step = this.workflowsManager.toModel(stepRep);
            WorkflowStep addedStep = this.workflowsManager.addStepToWorkflow(this.workflow, step, position);
            return Response.ok((Object)this.workflowsManager.toRepresentation(addedStep)).build();
        }
        catch (ModelException e) {
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="{stepId}")
    @DELETE
    @Operation(summary="Remove a step from this workflow")
    @APIResponses(value={@APIResponse(responseCode="204", description="Step removed successfully"), @APIResponse(responseCode="400", description="Invalid step ID"), @APIResponse(responseCode="404", description="Step not found")})
    public Response removeStep(@Parameter(description="ID of the step to remove", required=true) @PathParam(value="stepId") String stepId) {
        if (stepId == null || stepId.trim().isEmpty()) {
            throw new BadRequestException("Step ID cannot be null or empty");
        }
        this.workflowsManager.removeStepFromWorkflow(this.workflow, stepId);
        return Response.noContent().build();
    }

    @Path(value="{stepId}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific step by its ID")
    @APIResponses(value={@APIResponse(responseCode="200", description="Step found", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkflowStepRepresentation.class))}), @APIResponse(responseCode="400", description="Invalid step ID"), @APIResponse(responseCode="404", description="Step not found")})
    public WorkflowStepRepresentation getStep(@Parameter(description="ID of the step to retrieve", required=true) @PathParam(value="stepId") String stepId) {
        if (stepId == null || stepId.trim().isEmpty()) {
            throw new BadRequestException("Step ID cannot be null or empty");
        }
        WorkflowStep step = this.workflowsManager.getStepById(stepId);
        if (step == null) {
            throw new BadRequestException("Step not found: " + stepId);
        }
        return this.workflowsManager.toRepresentation(step);
    }
}

