/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import org.jboss.logging.Logger;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;

public class JwtCredentialBody
implements CredentialBody {
    private static final Logger LOGGER = Logger.getLogger(JwtCredentialBody.class);
    private final JWSBuilder.EncodingBuilder jwsEncodingBuilder;

    public JwtCredentialBody(JWSBuilder.EncodingBuilder jwsEncodingBuilder) {
        this.jwsEncodingBuilder = jwsEncodingBuilder;
    }

    @Override
    public void addKeyBinding(JWK jwk) throws CredentialBuilderException {
        LOGGER.warnf("Key binding is not yet implemented for JWT credentials", new Object[0]);
    }

    public String sign(SignatureSignerContext signatureSignerContext) {
        return this.jwsEncodingBuilder.sign(signatureSignerContext);
    }
}

