/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMulti;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMultiConnection;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class MultiPublishOp<T>
extends ConnectableMulti<T> {
    private static final long CANCELLED = Long.MIN_VALUE;
    private final AtomicReference<PublishSubscriber<T>> current;
    private final int bufferSize;
    private final Flow.Publisher<T> onSubscribe;

    public static <T> ConnectableMulti<T> create(Multi<T> upstream) {
        AtomicReference curr = new AtomicReference();
        InnerPublisher onSubscribe = new InnerPublisher(curr, 128);
        return new MultiPublishOp(onSubscribe, upstream, curr, 128);
    }

    private MultiPublishOp(Flow.Publisher<T> onSubscribe, Multi<T> upstream, AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
        super(upstream);
        this.onSubscribe = onSubscribe;
        this.current = current;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> s) {
        this.onSubscribe.subscribe(Infrastructure.onMultiSubscription(this.upstream, s));
    }

    @Override
    public void connect(ConnectableMultiConnection connection) {
        boolean doConnect;
        PublishSubscriber<T> ps;
        while ((ps = this.current.get()) == null || ps.cancelled.get()) {
            MultiSubscriber<?> subscriber = connection.getSubscriber();
            Context context = subscriber instanceof ContextSupport ? ((ContextSupport)((Object)subscriber)).context() : Context.empty();
            PublishSubscriber<T> u = new PublishSubscriber<T>(this.current, this.bufferSize, context);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean bl = doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        if (connection != null) {
            connection.accept(ps);
        }
        if (doConnect) {
            this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, ps));
        }
    }

    static final class InnerPublisher<T>
    implements Flow.Publisher<T> {
        private final AtomicReference<PublishSubscriber<T>> curr;
        private final int bufferSize;

        InnerPublisher(AtomicReference<PublishSubscriber<T>> curr, int bufferSize) {
            this.curr = curr;
            this.bufferSize = bufferSize;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> child) {
            PublishSubscriber<Object> r;
            Context context = child instanceof ContextSupport ? ((ContextSupport)((Object)child)).context() : Context.empty();
            InnerSubscriber<? super T> inner = new InnerSubscriber<T>(child);
            child.onSubscribe(inner);
            while (true) {
                if ((r = this.curr.get()) == null || r.cancelled.get()) {
                    PublishSubscriber<T> u = new PublishSubscriber<T>(this.curr, this.bufferSize, context);
                    if (!this.curr.compareAndSet(r, u)) continue;
                    r = u;
                }
                if (r.add(inner)) break;
            }
            if (inner.requested.get() == Long.MIN_VALUE) {
                r.remove(inner);
            } else {
                inner.parent.set(r);
            }
            r.drain();
        }
    }

    static final class PublishSubscriber<T>
    implements Cancellable,
    MultiSubscriber<T>,
    ContextSupport {
        static final InnerSubscriber[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber[] TERMINATED = new InnerSubscriber[0];
        final AtomicReference<PublishSubscriber<T>> current;
        final int bufferSize;
        final AtomicReference<InnerSubscriber<T>[]> subscribers;
        final AtomicBoolean shouldConnect;
        final AtomicReference<Flow.Subscription> upstream = new AtomicReference();
        private final AtomicReference<Throwable> failureOrCompletion = new AtomicReference();
        private static final Throwable COMPLETED = new Exception();
        private final Queue<T> queue;
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicInteger wip = new AtomicInteger();
        private final Context context;

        PublishSubscriber(AtomicReference<PublishSubscriber<T>> current, int bufferSize, Context context) {
            this.context = context;
            this.subscribers = new AtomicReference<InnerSubscriber[]>(EMPTY);
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
            this.bufferSize = bufferSize;
            this.queue = Queues.get(bufferSize).get();
        }

        @Override
        public void cancel() {
            InnerSubscriber[] ps;
            this.cancelled.set(true);
            if (this.subscribers.get() != TERMINATED && (ps = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
                this.current.compareAndSet(this, null);
                Subscriptions.cancel(this.upstream);
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (this.upstream.compareAndSet(null, s)) {
                s.request(this.bufferSize);
            }
        }

        @Override
        public void onItem(T t) {
            if (!this.queue.offer(t)) {
                this.onFailure(new BackPressureFailure("Queue is full"));
                return;
            }
            this.drain();
        }

        @Override
        public void onFailure(Throwable e) {
            if (this.failureOrCompletion.compareAndSet(null, e)) {
                this.drain();
            }
        }

        @Override
        public void onCompletion() {
            if (this.failureOrCompletion.compareAndSet(null, COMPLETED)) {
                this.drain();
            }
        }

        boolean add(InnerSubscriber<T> producer) {
            InnerSubscriber[] u;
            InnerSubscriber<T>[] c;
            do {
                if ((c = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerSubscriber[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.subscribers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerSubscriber<T> producer) {
            InnerSubscriber<T>[] c;
            int len;
            while ((len = (c = this.subscribers.get()).length) != 0) {
                InnerSubscriber[] u;
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                } else {
                    u = new InnerSubscriber[len - 1];
                    System.arraycopy(c, 0, u, 0, j);
                    System.arraycopy(c, j + 1, u, j, len - j - 1);
                }
                if (!this.subscribers.compareAndSet(c, u)) continue;
                break;
            }
        }

        boolean isEmptyOrCompleted(Throwable term, boolean empty) {
            if (term != null) {
                if (term == COMPLETED) {
                    if (empty) {
                        this.current.compareAndSet(this, null);
                        for (InnerSubscriber actual : this.subscribers.getAndSet(TERMINATED)) {
                            actual.downstream.onComplete();
                        }
                        return true;
                    }
                } else {
                    this.current.compareAndSet(this, null);
                    for (InnerSubscriber actual : this.subscribers.getAndSet(TERMINATED)) {
                        actual.downstream.onError(term);
                    }
                    return true;
                }
            }
            return false;
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<InnerSubscriber<T>[]> subscribers = this.subscribers;
            InnerSubscriber<T>[] ps = subscribers.get();
            block4: while (true) {
                Queue<T> q;
                boolean isEmpty;
                Throwable term;
                if (this.isEmptyOrCompleted(term = this.failureOrCompletion.get(), isEmpty = (q = this.queue).isEmpty())) {
                    return;
                }
                if (!isEmpty) {
                    int len = ps.length;
                    long maxRequested = Long.MAX_VALUE;
                    int cancelled = 0;
                    for (InnerSubscriber<T> ip : ps) {
                        long r = ip.requested.get();
                        if (r != Long.MIN_VALUE) {
                            maxRequested = Math.min(maxRequested, r - ip.emitted);
                            continue;
                        }
                        ++cancelled;
                    }
                    if (len == cancelled) {
                        T v;
                        term = this.failureOrCompletion.get();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            this.upstream.get().cancel();
                            term = ex;
                            this.failureOrCompletion.set(term);
                            v = null;
                        }
                        if (this.isEmptyOrCompleted(term, v == null)) {
                            return;
                        }
                        this.upstream.get().request(1L);
                        continue;
                    }
                    int d = 0;
                    while ((long)d < maxRequested) {
                        T v;
                        term = this.failureOrCompletion.get();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            this.upstream.get().cancel();
                            term = ex;
                            this.failureOrCompletion.set(term);
                            v = null;
                        }
                        boolean bl = isEmpty = v == null;
                        if (this.isEmptyOrCompleted(term, isEmpty)) {
                            return;
                        }
                        if (isEmpty) break;
                        T value = v;
                        boolean subscribersChanged = false;
                        for (InnerSubscriber<T> ip : ps) {
                            long ipr = ip.requested.get();
                            if (ipr != Long.MIN_VALUE) {
                                if (ipr != Long.MAX_VALUE) {
                                    ++ip.emitted;
                                }
                                ip.downstream.onNext(value);
                                continue;
                            }
                            subscribersChanged = true;
                        }
                        ++d;
                        InnerSubscriber<T>[] freshArray = subscribers.get();
                        if (!subscribersChanged && freshArray == ps) continue;
                        ps = freshArray;
                        if (d == 0) continue block4;
                        this.upstream.get().request(d);
                        continue block4;
                    }
                    if (d != 0) {
                        this.upstream.get().request(d);
                    }
                    if (maxRequested != 0L && !isEmpty) continue;
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                ps = subscribers.get();
            }
        }

        @Override
        public Context context() {
            return this.context;
        }
    }

    static final class InnerSubscriber<T>
    implements Flow.Subscription {
        private final AtomicLong requested = new AtomicLong();
        private final Flow.Subscriber<? super T> downstream;
        private final AtomicReference<PublishSubscriber<T>> parent = new AtomicReference();
        long emitted;

        InnerSubscriber(Flow.Subscriber<? super T> child) {
            this.downstream = child;
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                PublishSubscriber<T> p;
                long r = this.requested.get();
                if (r != Long.MIN_VALUE && r != Long.MAX_VALUE) {
                    Subscriptions.add(this.requested, n);
                }
                if ((p = this.parent.get()) != null) {
                    p.drain();
                }
            } else {
                PublishSubscriber<T> parent = this.parent.get();
                parent.failureOrCompletion.set(Subscriptions.getInvalidRequestException());
                parent.drain();
            }
        }

        @Override
        public void cancel() {
            PublishSubscriber<T> p;
            long requests = this.requested.get();
            if (requests != Long.MIN_VALUE && (requests = this.requested.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE && (p = this.parent.get()) != null) {
                p.remove(this);
                p.drain();
            }
        }
    }
}

