/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;

enum MDCEnabledContextStorage implements ContextStorage
{
    INSTANCE;

    private static final ContextStorage DEFAULT_CONTEXT_STORAGE;

    public Scope attach(Context toAttach) {
        final Context beforeAttach = this.current();
        OpenTelemetryUtil.setMDCData(toAttach, null);
        final Scope scope = DEFAULT_CONTEXT_STORAGE.attach(toAttach);
        return new Scope(){

            public void close() {
                if (beforeAttach == null) {
                    OpenTelemetryUtil.clearMDCData(null);
                } else {
                    OpenTelemetryUtil.setMDCData(beforeAttach, null);
                }
                scope.close();
            }
        };
    }

    public Context current() {
        return DEFAULT_CONTEXT_STORAGE.current();
    }

    static {
        DEFAULT_CONTEXT_STORAGE = ContextStorage.defaultStorage();
    }
}

