/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ExceptionMapping {
    final Map<String, ResourceExceptionMapper<? extends Throwable>> mappers = new HashMap<String, ResourceExceptionMapper<? extends Throwable>>();
    final Map<String, List<ResourceExceptionMapper<? extends Throwable>>> runtimeCheckMappers = new HashMap<String, List<ResourceExceptionMapper<? extends Throwable>>>();
    final List<Predicate<Throwable>> blockingProblemPredicates = new ArrayList<Predicate<Throwable>>();
    final List<Predicate<Throwable>> nonBlockingProblemPredicate = new ArrayList<Predicate<Throwable>>();
    final Set<String> unwrappedExceptions = new HashSet<String>();

    public void addBlockingProblem(Class<? extends Throwable> throwable) {
        this.blockingProblemPredicates.add(new ExceptionTypePredicate(throwable));
    }

    public void addBlockingProblem(Predicate<Throwable> predicate) {
        this.blockingProblemPredicates.add(predicate);
    }

    public void addNonBlockingProblem(Class<? extends Throwable> throwable) {
        this.nonBlockingProblemPredicate.add(new ExceptionTypePredicate(throwable));
    }

    public void addNonBlockingProblem(Predicate<Throwable> predicate) {
        this.nonBlockingProblemPredicate.add(predicate);
    }

    public void addUnwrappedException(String className) {
        this.unwrappedExceptions.add(className);
    }

    public Set<String> getUnwrappedExceptions() {
        return this.unwrappedExceptions;
    }

    public List<Predicate<Throwable>> getBlockingProblemPredicates() {
        return this.blockingProblemPredicates;
    }

    public List<Predicate<Throwable>> getNonBlockingProblemPredicate() {
        return this.nonBlockingProblemPredicate;
    }

    public <T extends Throwable> void addExceptionMapper(String exceptionClass, ResourceExceptionMapper<T> mapper) {
        ResourceExceptionMapper<? extends Throwable> existing = this.mappers.get(exceptionClass);
        if (existing != null) {
            if (existing.getPriority() < mapper.getPriority()) {
                return;
            }
            this.mappers.remove(exceptionClass);
            ArrayList<Object> list = new ArrayList<Object>(2);
            list.add(mapper);
            list.add(existing);
            this.runtimeCheckMappers.put(exceptionClass, list);
        } else {
            List<ResourceExceptionMapper<? extends Throwable>> list = this.runtimeCheckMappers.get(exceptionClass);
            if (list == null) {
                if (mapper.getDiscardAtRuntime() == null) {
                    this.mappers.put(exceptionClass, mapper);
                } else {
                    list = new ArrayList<ResourceExceptionMapper<? extends Throwable>>(1);
                    list.add(mapper);
                    this.runtimeCheckMappers.put(exceptionClass, list);
                }
            } else {
                list.add(mapper);
                Collections.sort(list);
            }
        }
    }

    public void initializeDefaultFactories(Function<String, BeanFactory<?>> factoryCreator) {
        for (ResourceExceptionMapper<? extends Throwable> resourceExceptionMapper : this.mappers.values()) {
            if (resourceExceptionMapper.getFactory() != null) continue;
            resourceExceptionMapper.setFactory(factoryCreator.apply(resourceExceptionMapper.getClassName()));
        }
        for (List list : this.runtimeCheckMappers.values()) {
            for (ResourceExceptionMapper resourceExceptionMapper : list) {
                if (resourceExceptionMapper.getFactory() != null) continue;
                resourceExceptionMapper.setFactory(factoryCreator.apply(resourceExceptionMapper.getClassName()));
            }
        }
    }

    public Map<String, ResourceExceptionMapper<? extends Throwable>> getMappers() {
        return this.mappers;
    }

    public Map<String, List<ResourceExceptionMapper<? extends Throwable>>> getRuntimeCheckMappers() {
        return this.runtimeCheckMappers;
    }

    public Map<String, ResourceExceptionMapper<? extends Throwable>> effectiveMappers() {
        if (this.runtimeCheckMappers.isEmpty()) {
            return this.mappers;
        }
        HashMap<String, ResourceExceptionMapper<? extends Throwable>> result = new HashMap<String, ResourceExceptionMapper<? extends Throwable>>();
        block0: for (Map.Entry<String, List<ResourceExceptionMapper<? extends Throwable>>> entry : this.runtimeCheckMappers.entrySet()) {
            String exceptionClass = entry.getKey();
            List<ResourceExceptionMapper<? extends Throwable>> list = entry.getValue();
            for (ResourceExceptionMapper<? extends Throwable> resourceExceptionMapper : list) {
                if (resourceExceptionMapper.getDiscardAtRuntime() == null) {
                    result.put(exceptionClass, resourceExceptionMapper);
                    continue block0;
                }
                if (((Boolean)resourceExceptionMapper.getDiscardAtRuntime().get()).booleanValue()) continue;
                result.put(exceptionClass, resourceExceptionMapper);
                continue block0;
            }
        }
        result.putAll(this.mappers);
        return result;
    }

    public void replaceDiscardAtRuntimeIfBeanIsUnavailable(Function<String, Supplier<Boolean>> function) {
        if (this.runtimeCheckMappers.isEmpty()) {
            return;
        }
        for (List<ResourceExceptionMapper<? extends Throwable>> list : this.runtimeCheckMappers.values()) {
            for (ResourceExceptionMapper<? extends Throwable> resourceExceptionMapper : list) {
                if (!(resourceExceptionMapper.getDiscardAtRuntime() instanceof ResourceExceptionMapper.DiscardAtRuntimeIfBeanIsUnavailable)) continue;
                ResourceExceptionMapper.DiscardAtRuntimeIfBeanIsUnavailable discardAtRuntimeIfBeanIsUnavailable = (ResourceExceptionMapper.DiscardAtRuntimeIfBeanIsUnavailable)resourceExceptionMapper.getDiscardAtRuntime();
                resourceExceptionMapper.setDiscardAtRuntime(function.apply(discardAtRuntimeIfBeanIsUnavailable.getBeanClass()));
            }
        }
    }

    public static class ExceptionTypePredicate
    implements Predicate<Throwable> {
        private Class<? extends Throwable> throwable;

        public ExceptionTypePredicate() {
        }

        public ExceptionTypePredicate(Class<? extends Throwable> throwable) {
            this.throwable = throwable;
        }

        public Class<? extends Throwable> getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Class<? extends Throwable> throwable) {
            this.throwable = throwable;
        }

        @Override
        public boolean test(Throwable t) {
            return t.getClass().equals(this.throwable);
        }
    }

    public static class ExceptionTypeAndMessageContainsPredicate
    implements Predicate<Throwable> {
        private Class<? extends Throwable> throwable;
        private String messagePart;

        public ExceptionTypeAndMessageContainsPredicate() {
        }

        public ExceptionTypeAndMessageContainsPredicate(Class<? extends Throwable> throwable, String messagePart) {
            this.throwable = throwable;
            this.messagePart = messagePart;
        }

        public Class<? extends Throwable> getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Class<? extends Throwable> throwable) {
            this.throwable = throwable;
        }

        public String getMessagePart() {
            return this.messagePart;
        }

        public void setMessagePart(String messagePart) {
            this.messagePart = messagePart;
        }

        @Override
        public boolean test(Throwable t) {
            return t.getClass().equals(this.throwable) && t.getMessage().contains(this.messagePart);
        }
    }
}

