/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DeprecatedMetadata {
    private final List<String> newOptionsKeys;
    private final String note;
    private final Set<String> deprecatedValues;

    private DeprecatedMetadata(List<String> newOptionsKeys, String note, Set<String> deprecatedValues) {
        this.newOptionsKeys = newOptionsKeys;
        this.note = note;
        this.deprecatedValues = deprecatedValues;
    }

    public static DeprecatedMetadata deprecateOption(String note, String ... newOptionsKeys) {
        return new DeprecatedMetadata(Arrays.asList(newOptionsKeys), note, Set.of());
    }

    public static DeprecatedMetadata deprecateValues(String note, String ... values) {
        return new DeprecatedMetadata(Collections.emptyList(), note, Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(values))));
    }

    public List<String> getNewOptionsKeys() {
        return this.newOptionsKeys;
    }

    public String getNote() {
        return this.note;
    }

    public Set<String> getDeprecatedValues() {
        return this.deprecatedValues;
    }
}

