/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.CustomAttribute;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.FieldElement;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AbstractDirectBuilder;
import io.github.dmlloyd.classfile.impl.AbstractElement;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.ClassFileImpl;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.TerminalFieldBuilder;
import io.github.dmlloyd.classfile.impl.Util;
import java.util.Objects;
import java.util.function.Consumer;

public final class DirectFieldBuilder
extends AbstractDirectBuilder<FieldModel>
implements TerminalFieldBuilder,
Util.Writable {
    private final Utf8Entry name;
    private final Utf8Entry desc;
    private int flags;

    public DirectFieldBuilder(SplitConstantPool constantPool, ClassFileImpl context, Utf8Entry name, Utf8Entry type, int flags, FieldModel original) {
        super(constantPool, context);
        this.setOriginal(original);
        this.name = Objects.requireNonNull(name);
        this.desc = Objects.requireNonNull(type);
        this.flags = flags;
    }

    @Override
    public FieldBuilder with(FieldElement element) {
        if (element instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)element);
            ae.writeTo(this);
        } else {
            this.writeAttribute((CustomAttribute)Objects.requireNonNull(element));
        }
        return this;
    }

    public DirectFieldBuilder run(Consumer<? super FieldBuilder> handler) {
        handler.accept(this);
        return this;
    }

    @Override
    public FieldBuilder withFlags(int flags) {
        this.setFlags(flags);
        return this;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        buf.writeU2U2U2(this.flags, buf.cpIndex(this.name), buf.cpIndex(this.desc));
        this.attributes.writeTo(buf);
    }
}

