/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.oracle.deployment;

import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.jdbc.oracle.runtime.OracleAgroalConnectionConfigurer;
import io.quarkus.jdbc.oracle.runtime.OracleServiceBindingConverter;
import io.quarkus.jdbc.oracle.runtime.RollbackOnConnectionClosePoolInterceptor;

public class OracleProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.JDBC_ORACLE);
    }

    @BuildStep
    void registerDriver(BuildProducer<JdbcDriverBuildItem> jdbcDriver) {
        jdbcDriver.produce((BuildItem)new JdbcDriverBuildItem("oracle", "oracle.jdbc.driver.OracleDriver", "oracle.jdbc.xa.client.OracleXADataSource"));
    }

    @BuildStep
    DevServicesDatasourceConfigurationHandlerBuildItem devDbHandler() {
        return DevServicesDatasourceConfigurationHandlerBuildItem.jdbc((String)"oracle");
    }

    @BuildStep
    void configureAgroalConnection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(OracleAgroalConnectionConfigurer.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(RollbackOnConnectionClosePoolInterceptor.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
        }
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{OracleServiceBindingConverter.class.getName()}));
        }
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("oracle"));
    }
}

