/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.GroupModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@ProtoTypeId(value=65581)
public class GroupMovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    @ProtoField(value=2)
    final String newParentId;
    @ProtoField(value=3)
    final String oldParentId;
    @ProtoField(value=4)
    final String realmId;

    private GroupMovedEvent(String groupId, String newParentId, String oldParentId, String realmId) {
        super(groupId);
        this.newParentId = newParentId;
        this.oldParentId = oldParentId;
        this.realmId = Objects.requireNonNull(realmId);
    }

    @ProtoFactory
    static GroupMovedEvent protoFactory(String id, String newParentId, String oldParentId, String realmId) {
        return new GroupMovedEvent(id, newParentId, oldParentId, realmId);
    }

    public static GroupMovedEvent create(GroupModel group, GroupModel toParent, String realmId) {
        return new GroupMovedEvent(group.getId(), group.getId(), toParent == null ? null : toParent.getId(), realmId);
    }

    public String toString() {
        return String.format("GroupMovedEvent [ realmId=%s, groupId=%s, newParentId=%s, oldParentId=%s ]", this.realmId, this.getId(), this.newParentId, this.oldParentId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
        realmCache.groupNameInvalidations(this.getId(), invalidations);
        if (this.newParentId != null) {
            invalidations.add(this.newParentId);
        }
        if (this.oldParentId != null) {
            invalidations.add(this.oldParentId);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupMovedEvent that = (GroupMovedEvent)o;
        return Objects.equals(this.newParentId, that.newParentId) && Objects.equals(this.oldParentId, that.oldParentId) && this.realmId.equals(that.realmId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.newParentId);
        result = 31 * result + Objects.hashCode(this.oldParentId);
        result = 31 * result + this.realmId.hashCode();
        return result;
    }
}

