/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.models.internal.AnnotationTargetSupport;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ModelsContext;

public abstract class AbstractJdkAnnotationTarget
implements AnnotationTargetSupport {
    private final Supplier<Annotation[]> annotationSupplier;
    private final ModelsContext modelContext;
    private Map<Class<? extends Annotation>, ? extends Annotation> usagesMap;

    public AbstractJdkAnnotationTarget(Supplier<Annotation[]> annotationSupplier, ModelsContext modelContext) {
        this.annotationSupplier = annotationSupplier;
        this.modelContext = modelContext;
    }

    public ModelsContext getModelContext() {
        return this.modelContext;
    }

    @Override
    public Map<Class<? extends Annotation>, ? extends Annotation> getUsageMap() {
        if (this.usagesMap == null) {
            this.usagesMap = this.buildUsagesMap();
        }
        return this.usagesMap;
    }

    private Map<Class<? extends Annotation>, ? extends Annotation> buildUsagesMap() {
        HashMap<Class<? extends Annotation>, Annotation> result = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : this.annotationSupplier.get()) {
            AnnotationDescriptor<? extends Annotation> descriptor = this.modelContext.getAnnotationDescriptorRegistry().getDescriptor(annotation.annotationType());
            result.put(annotation.annotationType(), descriptor.createUsage(annotation, this.modelContext));
        }
        return result;
    }

    @Override
    public void clearAnnotationUsages() {
        this.getUsageMap().clear();
    }

    @Override
    public <X extends Annotation> void addAnnotationUsage(X annotationUsage) {
        this.getUsageMap().put(annotationUsage.annotationType(), annotationUsage);
    }
}

