/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.classfilewriter.ClassFactory;
import org.jboss.invocation.proxy.reflection.DefaultReflectionMetadataSource;
import org.jboss.invocation.proxy.reflection.ReflectionMetadataSource;

public class ProxyConfiguration<T> {
    private ReflectionMetadataSource metadataSource = DefaultReflectionMetadataSource.INSTANCE;
    private String proxyName = null;
    private ClassLoader classLoader;
    private Class<T> superClass;
    private ProtectionDomain protectionDomain;
    private final List<Class<?>> additionalInterfaces = new ArrayList(0);
    private ClassFactory classFactory;

    public List<Class<?>> getAdditionalInterfaces() {
        return Collections.unmodifiableList(this.additionalInterfaces);
    }

    public ProxyConfiguration<T> addAdditionalInterface(Class<?> additionalInterface) {
        this.additionalInterfaces.add(additionalInterface);
        return this;
    }

    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    public ProxyConfiguration<T> setClassFactory(ClassFactory classFactory) {
        this.classFactory = classFactory;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ProxyConfiguration<T> setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ReflectionMetadataSource getMetadataSource() {
        return this.metadataSource;
    }

    public ProxyConfiguration<T> setMetadataSource(ReflectionMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
        return this;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public ProxyConfiguration<T> setProxyName(String proxyName) {
        this.proxyName = proxyName;
        return this;
    }

    public ProxyConfiguration<T> setProxyName(Package pkg, String simpleName) {
        this.proxyName = pkg.getName() + "." + simpleName;
        return this;
    }

    public Class<T> getSuperClass() {
        return this.superClass;
    }

    public ProxyConfiguration<T> setSuperClass(Class<T> superClass) {
        this.superClass = superClass;
        return this;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public ProxyConfiguration<T> setProtectionDomain(ProtectionDomain protectionDomain) {
        this.protectionDomain = protectionDomain;
        return this;
    }
}

