/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public abstract class AbstractCollectionInitializer<Data extends CollectionInitializerData>
extends AbstractInitializer<Data>
implements CollectionInitializer<Data> {
    protected final NavigablePath collectionPath;
    protected final PluralAttributeMapping collectionAttributeMapping;
    protected final @Nullable Type keyTypeForEqualsHashCode;
    protected final boolean isResultInitializer;
    protected final @Nullable InitializerParent<?> parent;
    protected final @Nullable EntityInitializer<InitializerData> owningEntityInitializer;
    protected final @Nullable DomainResultAssembler<?> collectionKeyResultAssembler;

    protected AbstractCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, InitializerParent<?> parent, @Nullable DomainResult<?> collectionKeyResult, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(creationState);
        this.collectionPath = collectionPath;
        this.collectionAttributeMapping = collectionAttributeMapping;
        this.keyTypeForEqualsHashCode = collectionAttributeMapping.getCollectionDescriptor().getKeyType().getTypeForEqualsHashCode();
        this.isResultInitializer = isResultInitializer;
        this.parent = parent;
        this.owningEntityInitializer = Initializer.findOwningEntityInitializer(parent);
        this.collectionKeyResultAssembler = collectionKeyResult == null ? null : collectionKeyResult.createResultAssembler(this, creationState);
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new CollectionInitializerData(rowProcessingState);
    }

    @Override
    public void resolveKey(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        ((InitializerData)data).setState(Initializer.State.KEY_RESOLVED);
        ((CollectionInitializerData)data).collectionKeyValue = null;
        if (this.collectionKeyResultAssembler != null) {
            Initializer<?> initializer = this.collectionKeyResultAssembler.getInitializer();
            RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
            if (initializer != null) {
                Object subData = initializer.getData(rowProcessingState);
                initializer.resolveKey(subData);
                if (((InitializerData)subData).getState() == Initializer.State.MISSING) {
                    this.setMissing(data);
                }
                return;
            }
            ((CollectionInitializerData)data).collectionKeyValue = this.collectionKeyResultAssembler.assemble(rowProcessingState);
            if (((CollectionInitializerData)data).collectionKeyValue == null) {
                this.setMissing(data);
            }
        }
    }

    @Override
    public void resolveState(Data data) {
        if (this.collectionKeyResultAssembler != null) {
            this.collectionKeyResultAssembler.resolveState(((InitializerData)data).getRowProcessingState());
        }
    }

    @Override
    public void resolveFromPreviousRow(Data data) {
        if (((InitializerData)data).getState() == Initializer.State.UNINITIALIZED) {
            if (((CollectionInitializerData)data).collectionKey == null) {
                this.setMissing(data);
            } else {
                ((InitializerData)data).setState(Initializer.State.RESOLVED);
            }
        }
    }

    protected void setMissing(Data data) {
        ((InitializerData)data).setState(Initializer.State.MISSING);
        ((CollectionInitializerData)data).collectionKey = null;
        ((CollectionInitializerData)data).collectionKeyValue = null;
        ((CollectionInitializerData)data).setCollectionInstance(null);
    }

    protected void resolveCollectionKey(Data data, boolean checkPreviousRow) {
        CollectionKey oldKey = ((CollectionInitializerData)data).collectionKey;
        PersistentCollection<?> oldCollectionInstance = ((CollectionInitializerData)data).getCollectionInstance();
        ((CollectionInitializerData)data).collectionKey = null;
        ((CollectionInitializerData)data).setCollectionInstance(null);
        if (((CollectionInitializerData)data).collectionKeyValue == null) {
            if (this.collectionKeyResultAssembler == null) {
                assert (this.owningEntityInitializer != null);
                ((CollectionInitializerData)data).collectionKeyValue = this.owningEntityInitializer.getEntityIdentifier(((InitializerData)data).getRowProcessingState());
            } else {
                ((CollectionInitializerData)data).collectionKeyValue = this.collectionKeyResultAssembler.assemble(((InitializerData)data).getRowProcessingState());
            }
            if (((CollectionInitializerData)data).collectionKeyValue == null) {
                ((InitializerData)data).setState(Initializer.State.MISSING);
                ((CollectionInitializerData)data).collectionKey = null;
                ((CollectionInitializerData)data).setCollectionInstance(null);
                return;
            }
        }
        CollectionPersister persister = this.collectionAttributeMapping.getCollectionDescriptor();
        if (checkPreviousRow && oldKey != null && this.areKeysEqual(oldKey.getKey(), ((CollectionInitializerData)data).collectionKeyValue)) {
            ((CollectionInitializerData)data).collectionKey = oldKey;
            ((CollectionInitializerData)data).setCollectionInstance(oldCollectionInstance);
            ((InitializerData)data).setState(oldCollectionInstance == null ? Initializer.State.MISSING : Initializer.State.RESOLVED);
        } else {
            ((CollectionInitializerData)data).collectionKey = new CollectionKey(persister, ((CollectionInitializerData)data).collectionKeyValue);
            ((InitializerData)data).setState(Initializer.State.KEY_RESOLVED);
        }
    }

    private boolean areKeysEqual(Object key1, Object key2) {
        return this.keyTypeForEqualsHashCode == null ? key1.equals(key2) : this.keyTypeForEqualsHashCode.isEqual(key1, key2);
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer;
        if (this.collectionKeyResultAssembler != null && (initializer = this.collectionKeyResultAssembler.getInitializer()) != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public @Nullable PersistentCollection<?> getCollectionInstance(Data data) {
        return ((InitializerData)data).getState() == Initializer.State.UNINITIALIZED || ((InitializerData)data).getState() == Initializer.State.MISSING ? null : ((CollectionInitializerData)data).getCollectionInstance();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.collectionPath;
    }

    public PluralAttributeMapping getCollectionAttributeMapping() {
        return this.collectionAttributeMapping;
    }

    @Override
    public PluralAttributeMapping getInitializedPart() {
        return this.getCollectionAttributeMapping();
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public boolean isPartOfKey() {
        return false;
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public boolean hasLazySubInitializers() {
        return true;
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    public static class CollectionInitializerData
    extends InitializerData {
        protected @Nullable Object collectionKeyValue;
        protected @Nullable CollectionKey collectionKey;

        public CollectionInitializerData(RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }

        public @Nullable PersistentCollection<?> getCollectionInstance() {
            return (PersistentCollection)this.getInstance();
        }

        public void setCollectionInstance(@Nullable PersistentCollection<?> collectionInstance) {
            this.setInstance(collectionInstance);
        }
    }
}

