/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.AbstractColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class OneToManyTableGroup
extends AbstractColumnReferenceQualifier
implements TableGroup,
PluralTableGroup {
    private final SessionFactoryImplementor sessionFactory;
    private final PluralAttributeMapping pluralAttributeMapping;
    private final TableGroup elementTableGroup;
    private TableGroup indexTableGroup;

    public OneToManyTableGroup(PluralAttributeMapping pluralAttributeMapping, TableGroup elementTableGroup, SessionFactoryImplementor sessionFactory) {
        this.pluralAttributeMapping = pluralAttributeMapping;
        this.elementTableGroup = elementTableGroup;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public PluralAttributeMapping getExpressionType() {
        return this.pluralAttributeMapping;
    }

    @Override
    public PluralAttributeMapping getModelPart() {
        return this.pluralAttributeMapping;
    }

    @Override
    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public TableGroup getElementTableGroup() {
        return this.elementTableGroup;
    }

    @Override
    public TableGroup getIndexTableGroup() {
        return this.indexTableGroup;
    }

    public void registerIndexTableGroup(TableGroupJoin indexTableGroupJoin) {
        this.registerIndexTableGroup(indexTableGroupJoin, true);
    }

    public void registerIndexTableGroup(TableGroupJoin indexTableGroupJoin, boolean nested) {
        assert (this.indexTableGroup == null);
        this.indexTableGroup = indexTableGroupJoin.getJoinedGroup();
        if (nested) {
            this.addNestedTableGroupJoin(indexTableGroupJoin);
        } else {
            this.addTableGroupJoin(indexTableGroupJoin);
        }
    }

    @Override
    public String getGroupAlias() {
        return this.elementTableGroup.getGroupAlias();
    }

    @Override
    public String getSourceAlias() {
        return this.elementTableGroup.getSourceAlias();
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.elementTableGroup.applyAffectedTableNames(nameCollector);
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.elementTableGroup.getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.elementTableGroup.getTableReferenceJoins();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.elementTableGroup.getNavigablePath().getParent();
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.elementTableGroup.getTableGroupJoins();
    }

    @Override
    public List<TableGroupJoin> getNestedTableGroupJoins() {
        return this.elementTableGroup.getNestedTableGroupJoins();
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.elementTableGroup.canUseInnerJoins();
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (join.getJoinedGroup() != this.elementTableGroup) {
            this.elementTableGroup.addTableGroupJoin(join);
        }
    }

    @Override
    public void prependTableGroupJoin(NavigablePath navigablePath, TableGroupJoin join) {
        if (join.getJoinedGroup() != this.elementTableGroup) {
            this.elementTableGroup.prependTableGroupJoin(navigablePath, join);
        }
    }

    @Override
    public void addNestedTableGroupJoin(TableGroupJoin join) {
        if (join.getJoinedGroup() != this.elementTableGroup) {
            this.elementTableGroup.addNestedTableGroupJoin(join);
        }
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        this.elementTableGroup.visitTableGroupJoins(consumer);
    }

    @Override
    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        this.elementTableGroup.visitNestedTableGroupJoins(consumer);
    }

    @Override
    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.elementTableGroup.createDomainResult(resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.elementTableGroup.applySqlSelections(creationState);
    }

    @Override
    public boolean isRealTableGroup() {
        return this.elementTableGroup.isRealTableGroup();
    }

    @Override
    public boolean isFetched() {
        return this.elementTableGroup.isFetched();
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        TableReference tableReference = this.elementTableGroup.getTableReference(navigablePath, tableExpression, resolve);
        if (tableReference != null || this.indexTableGroup == null || navigablePath != null && this.indexTableGroup.getNavigablePath().isParent(navigablePath)) {
            return tableReference;
        }
        return this.indexTableGroup.getTableReference(navigablePath, tableExpression, resolve);
    }
}

