/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.cte;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class CteTableGroup
extends AbstractTableGroup {
    private final NamedTableReference cteTableReference;
    private final Set<String> compatibleTableExpressions;

    public CteTableGroup(NamedTableReference cteTableReference) {
        this(false, new NavigablePath(cteTableReference.getTableExpression()), null, null, cteTableReference, Collections.emptySet());
    }

    public CteTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, SqlAliasBase sqlAliasBase, ModelPartContainer modelPartContainer, NamedTableReference cteTableReference, Set<String> compatibleTableExpressions) {
        super(canUseInnerJoins, navigablePath, modelPartContainer, cteTableReference.getIdentificationVariable(), sqlAliasBase, null);
        this.cteTableReference = cteTableReference;
        this.compatibleTableExpressions = compatibleTableExpressions;
    }

    @Override
    public String getGroupAlias() {
        return this.cteTableReference.getIdentificationVariable();
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        TableReference groupTableReference;
        if (this.compatibleTableExpressions.contains(tableExpression)) {
            return this.getPrimaryTableReference();
        }
        for (TableGroupJoin tableGroupJoin : this.getNestedTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        return null;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.cteTableReference.getTableExpression());
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.cteTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }
}

