/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;

@Incubating
public abstract class AbstractSqmJsonPathExpression<T>
extends SelfRenderingSqmFunction<T> {
    private @Nullable Map<String, SqmExpression<?>> passingExpressions;

    public AbstractSqmJsonPathExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<T> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
    }

    protected AbstractSqmJsonPathExpression(SqmFunctionDescriptor descriptor, FunctionRenderer renderer, List<? extends SqmTypedNode<?>> arguments, @Nullable ReturnableType<T> impliedResultType, @Nullable ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name, @Nullable Map<String, SqmExpression<?>> passingExpressions) {
        super(descriptor, renderer, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
        this.passingExpressions = passingExpressions;
    }

    public Map<String, SqmExpression<?>> getPassingExpressions() {
        return this.passingExpressions == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.passingExpressions);
    }

    protected void addPassingExpression(String identifier, SqmExpression<?> expression) {
        if (this.passingExpressions == null) {
            this.passingExpressions = new HashMap();
        }
        this.passingExpressions.put(identifier, expression);
    }

    protected Map<String, SqmExpression<?>> copyPassingExpressions(SqmCopyContext context) {
        if (this.passingExpressions == null) {
            return null;
        }
        HashMap copy = new HashMap(this.passingExpressions.size());
        for (Map.Entry<String, SqmExpression<?>> entry : this.passingExpressions.entrySet()) {
            copy.put(entry.getKey(), (SqmExpression<?>)entry.getValue().copy(context));
        }
        return copy;
    }

    protected @Nullable JsonPathPassingClause createJsonPathPassingClause(SqmToSqlAstConverter walker) {
        if (this.passingExpressions == null || this.passingExpressions.isEmpty()) {
            return null;
        }
        HashMap<String, Expression> converted = new HashMap<String, Expression>(this.passingExpressions.size());
        for (Map.Entry<String, SqmExpression<?>> entry : this.passingExpressions.entrySet()) {
            converted.put(entry.getKey(), (Expression)entry.getValue().accept(walker));
        }
        return new JsonPathPassingClause(converted);
    }

    protected void appendPassingExpressionHqlString(StringBuilder sb, SqmRenderContext context) {
        if (this.passingExpressions != null && !this.passingExpressions.isEmpty()) {
            sb.append(" passing ");
            for (Map.Entry<String, SqmExpression<?>> entry : this.passingExpressions.entrySet()) {
                entry.getValue().appendHqlString(sb, context);
                sb.append(" as ");
                QuotingHelper.appendDoubleQuoteEscapedString(sb, entry.getKey());
            }
        }
    }
}

