/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.util.function.Function;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.inline.InPredicateRestrictionProducer;
import org.hibernate.query.sqm.mutation.internal.inline.InlineDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.inline.InlineUpdateHandler;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.query.sqm.mutation.spi.MultiTableHandler;
import org.hibernate.query.sqm.mutation.spi.MultiTableHandlerBuildResult;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class InlineMutationStrategy
implements SqmMultiTableMutationStrategy {
    private final Function<SqmDeleteOrUpdateStatement<?>, MatchingIdRestrictionProducer> matchingIdsStrategy;

    public InlineMutationStrategy(Dialect dialect) {
        this(InlineMutationStrategy.determinePredicateProducer(dialect));
    }

    private static Function<SqmDeleteOrUpdateStatement<?>, MatchingIdRestrictionProducer> determinePredicateProducer(Dialect dialect) {
        return statement -> new InPredicateRestrictionProducer();
    }

    public InlineMutationStrategy(Function<SqmDeleteOrUpdateStatement<?>, MatchingIdRestrictionProducer> matchingIdsStrategy) {
        this.matchingIdsStrategy = matchingIdsStrategy;
    }

    @Override
    public MultiTableHandlerBuildResult buildHandler(SqmDeleteOrUpdateStatement<?> sqmStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        MultiTableHandler multiTableHandler;
        MutableObject<JdbcParameterBindings> firstJdbcParameterBindings = new MutableObject<JdbcParameterBindings>();
        if (sqmStatement instanceof SqmDeleteStatement) {
            SqmDeleteStatement sqmDelete = (SqmDeleteStatement)sqmStatement;
            multiTableHandler = this.buildHandler(sqmDelete, domainParameterXref, context, firstJdbcParameterBindings);
        } else {
            multiTableHandler = this.buildHandler((SqmUpdateStatement)sqmStatement, domainParameterXref, context, firstJdbcParameterBindings);
        }
        MultiTableHandler multiTableHandler2 = multiTableHandler;
        return new MultiTableHandlerBuildResult(multiTableHandler2, firstJdbcParameterBindings.get());
    }

    public MultiTableHandler buildHandler(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        return new InlineUpdateHandler(this.matchingIdsStrategy.apply(sqmUpdate), sqmUpdate, domainParameterXref, context, firstJdbcParameterBindingsConsumer);
    }

    public MultiTableHandler buildHandler(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        return new InlineDeleteHandler(this.matchingIdsStrategy.apply(sqmDelete), sqmDelete, domainParameterXref, context, firstJdbcParameterBindingsConsumer);
    }
}

