/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.util.Properties;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.UUIDJavaType;

@Deprecated(since="6.0")
public class UUIDGenerator
implements IdentifierGenerator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(UUIDGenerator.class);
    public static final String UUID_GEN_STRATEGY = "uuid_gen_strategy";
    public static final String UUID_GEN_STRATEGY_CLASS = "uuid_gen_strategy_class";
    private UUIDGenerationStrategy strategy;
    private UUIDJavaType.ValueTransformer valueTransformer;

    @Override
    public void configure(GeneratorCreationContext creationContext, Properties parameters) throws MappingException {
        Type type;
        String strategyClassName;
        this.strategy = (UUIDGenerationStrategy)parameters.get(UUID_GEN_STRATEGY);
        if (this.strategy == null && (strategyClassName = parameters.getProperty(UUID_GEN_STRATEGY_CLASS)) != null) {
            try {
                Class strategyClass = creationContext.getServiceRegistry().requireService(ClassLoaderService.class).classForName(strategyClassName);
                try {
                    this.strategy = (UUIDGenerationStrategy)strategyClass.newInstance();
                }
                catch (Exception e) {
                    LOG.unableToInstantiateUuidGenerationStrategy(e);
                }
            }
            catch (ClassLoadingException ignore) {
                LOG.unableToLocateUuidGenerationStrategy(strategyClassName);
            }
        }
        if (this.strategy == null) {
            this.strategy = StandardRandomStrategy.INSTANCE;
        }
        if (UUID.class.isAssignableFrom((type = creationContext.getType()).getReturnedClass())) {
            this.valueTransformer = UUIDJavaType.PassThroughTransformer.INSTANCE;
        } else if (String.class.isAssignableFrom(type.getReturnedClass())) {
            this.valueTransformer = UUIDJavaType.ToStringTransformer.INSTANCE;
        } else if (byte[].class.isAssignableFrom(type.getReturnedClass())) {
            this.valueTransformer = UUIDJavaType.ToBytesTransformer.INSTANCE;
        } else {
            throw new HibernateException("Unanticipated return type [" + type.getReturnedClassName() + "] for UUID conversion");
        }
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.valueTransformer.transform(this.strategy.generateUUID(session));
    }
}

