/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.NameIterator;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.function.Function;

public class QuarkusConfigBuilderCustomizer
implements SmallRyeConfigBuilderCustomizer {
    public static final String QUARKUS_PROFILE = "quarkus.profile";
    public static final String QUARKUS_CONFIG_LOCATIONS = "quarkus.config.locations";
    public static final String QUARKUS_CONFIG_PROFILE_PARENT = "quarkus.config.profile.parent";
    public static final String QUARKUS_CONFIG_MAPPING_VALIDATE_UNKNOWN = "quarkus.config.mapping.validate-unknown";
    public static final String QUARKUS_CONFIG_LOG_VALUES = "quarkus.config.log.values";

    public void configBuilder(SmallRyeConfigBuilder builder) {
        final LaunchMode launchMode = LaunchMode.current();
        builder.withDefaultValue(launchMode.getProfileKey(), launchMode.getDefaultProfile());
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor((Function)new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        return "smallrye.config.profile".equals(name) ? launchMode.getProfileKey() : name;
                    }
                });
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3190);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        if ("smallrye.config.locations".equals(name)) {
                            return QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_LOCATIONS;
                        }
                        if ("smallrye.config.profile.parent".equals(name)) {
                            return QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_PROFILE_PARENT;
                        }
                        if ("smallrye.config.mapping.validate-unknown".equals(name)) {
                            return QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_MAPPING_VALIDATE_UNKNOWN;
                        }
                        if ("smallrye.config.log.values".equals(name)) {
                            return QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_LOG_VALUES;
                        }
                        if (name.startsWith("%") && name.endsWith("smallrye.config.locations")) {
                            NameIterator ni = new NameIterator(name);
                            return ni.getNextSegment() + "." + QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_LOCATIONS;
                        }
                        if (name.startsWith("%") && name.endsWith("smallrye.config.profile.parent")) {
                            NameIterator ni = new NameIterator(name);
                            return ni.getNextSegment() + "." + QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_PROFILE_PARENT;
                        }
                        return name;
                    }
                }){

                    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
                        return context.iterateNames();
                    }
                };
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3195);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new FallbackConfigSourceInterceptor(new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        if (QuarkusConfigBuilderCustomizer.QUARKUS_PROFILE.equals(name)) {
                            return "smallrye.config.profile";
                        }
                        if (QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_LOCATIONS.equals(name)) {
                            return "smallrye.config.locations";
                        }
                        if (QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_PROFILE_PARENT.equals(name)) {
                            return "smallrye.config.profile.parent";
                        }
                        if (QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_MAPPING_VALIDATE_UNKNOWN.equals(name)) {
                            return "smallrye.config.mapping.validate-unknown";
                        }
                        if (QuarkusConfigBuilderCustomizer.QUARKUS_CONFIG_LOG_VALUES.equals(name)) {
                            return "smallrye.config.log.values";
                        }
                        return name;
                    }
                }){

                    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
                        return context.iterateNames();
                    }
                };
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        }});
        builder.withMappingIgnore("quarkus.**");
    }
}

