/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StreamsGroupTargetAssignmentMemberValue
implements ApiMessage {
    List<TaskIds> activeTasks;
    List<TaskIds> standbyTasks;
    List<TaskIds> warmupTasks;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("active_tasks", (Type)new CompactArrayOf((Type)TaskIds.SCHEMA_0), "Currently assigned active tasks for this streams client."), new Field("standby_tasks", (Type)new CompactArrayOf((Type)TaskIds.SCHEMA_0), "Currently assigned standby tasks for this streams client."), new Field("warmup_tasks", (Type)new CompactArrayOf((Type)TaskIds.SCHEMA_0), "Currently assigned warm-up tasks for this streams client."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public StreamsGroupTargetAssignmentMemberValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public StreamsGroupTargetAssignmentMemberValue() {
        this.activeTasks = new ArrayList<TaskIds>(0);
        this.standbyTasks = new ArrayList<TaskIds>(0);
        this.warmupTasks = new ArrayList<TaskIds>(0);
    }

    public short apiKey() {
        return 21;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version) {
        int i;
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field activeTasks was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TaskIds> newCollection = new ArrayList<TaskIds>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new TaskIds(_readable, _version));
        }
        this.activeTasks = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field standbyTasks was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new TaskIds(_readable, _version));
        }
        this.standbyTasks = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field warmupTasks was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new TaskIds(_readable, _version));
        }
        this.warmupTasks = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.activeTasks.size() + 1);
        for (TaskIds activeTasksElement : this.activeTasks) {
            activeTasksElement.write(_writable, _cache, _version);
        }
        _writable.writeUnsignedVarint(this.standbyTasks.size() + 1);
        for (TaskIds standbyTasksElement : this.standbyTasks) {
            standbyTasksElement.write(_writable, _cache, _version);
        }
        _writable.writeUnsignedVarint(this.warmupTasks.size() + 1);
        for (TaskIds warmupTasksElement : this.warmupTasks) {
            warmupTasksElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.activeTasks.size() + 1)));
        for (TaskIds activeTasksElement : this.activeTasks) {
            activeTasksElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.standbyTasks.size() + 1)));
        for (TaskIds standbyTasksElement : this.standbyTasks) {
            standbyTasksElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.warmupTasks.size() + 1)));
        for (TaskIds warmupTasksElement : this.warmupTasks) {
            warmupTasksElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupTargetAssignmentMemberValue)) {
            return false;
        }
        StreamsGroupTargetAssignmentMemberValue other = (StreamsGroupTargetAssignmentMemberValue)obj;
        if (this.activeTasks == null ? other.activeTasks != null : !this.activeTasks.equals(other.activeTasks)) {
            return false;
        }
        if (this.standbyTasks == null ? other.standbyTasks != null : !this.standbyTasks.equals(other.standbyTasks)) {
            return false;
        }
        if (this.warmupTasks == null ? other.warmupTasks != null : !this.warmupTasks.equals(other.warmupTasks)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.activeTasks == null ? 0 : this.activeTasks.hashCode());
        hashCode = 31 * hashCode + (this.standbyTasks == null ? 0 : this.standbyTasks.hashCode());
        hashCode = 31 * hashCode + (this.warmupTasks == null ? 0 : this.warmupTasks.hashCode());
        return hashCode;
    }

    public StreamsGroupTargetAssignmentMemberValue duplicate() {
        StreamsGroupTargetAssignmentMemberValue _duplicate = new StreamsGroupTargetAssignmentMemberValue();
        ArrayList<TaskIds> newActiveTasks = new ArrayList<TaskIds>(this.activeTasks.size());
        for (TaskIds taskIds : this.activeTasks) {
            newActiveTasks.add(taskIds.duplicate());
        }
        _duplicate.activeTasks = newActiveTasks;
        ArrayList<TaskIds> newStandbyTasks = new ArrayList<TaskIds>(this.standbyTasks.size());
        for (TaskIds _element : this.standbyTasks) {
            newStandbyTasks.add(_element.duplicate());
        }
        _duplicate.standbyTasks = newStandbyTasks;
        ArrayList<TaskIds> arrayList = new ArrayList<TaskIds>(this.warmupTasks.size());
        for (TaskIds _element : this.warmupTasks) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.warmupTasks = arrayList;
        return _duplicate;
    }

    public String toString() {
        return "StreamsGroupTargetAssignmentMemberValue(activeTasks=" + MessageUtil.deepToString(this.activeTasks.iterator()) + ", standbyTasks=" + MessageUtil.deepToString(this.standbyTasks.iterator()) + ", warmupTasks=" + MessageUtil.deepToString(this.warmupTasks.iterator()) + ")";
    }

    public List<TaskIds> activeTasks() {
        return this.activeTasks;
    }

    public List<TaskIds> standbyTasks() {
        return this.standbyTasks;
    }

    public List<TaskIds> warmupTasks() {
        return this.warmupTasks;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StreamsGroupTargetAssignmentMemberValue setActiveTasks(List<TaskIds> v) {
        this.activeTasks = v;
        return this;
    }

    public StreamsGroupTargetAssignmentMemberValue setStandbyTasks(List<TaskIds> v) {
        this.standbyTasks = v;
        return this;
    }

    public StreamsGroupTargetAssignmentMemberValue setWarmupTasks(List<TaskIds> v) {
        this.warmupTasks = v;
        return this;
    }

    public static class TaskIds
    implements Message {
        String subtopologyId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("subtopology_id", (Type)Type.COMPACT_STRING, "The subtopology ID."), new Field("partitions", (Type)new CompactArrayOf((Type)Type.INT32), "The partitions of the input topics processed by this member."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskIds(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskIds() {
            this.subtopologyId = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length);
            }
            this.subtopologyId = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.subtopologyId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.subtopologyId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskIds)) {
                return false;
            }
            TaskIds other = (TaskIds)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public TaskIds duplicate() {
            TaskIds _duplicate = new TaskIds();
            _duplicate.subtopologyId = this.subtopologyId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TaskIds(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskIds setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public TaskIds setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }
}

