/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.tools.GBC;

public class CheckGroup
extends TaggingPresetItem {
    public short columns = 1;
    public final List<Check> checks = new LinkedList<Check>();

    @Override
    public boolean addToPanel(JPanel p, TaggingPresetItemGuiSupport support) {
        int rows = (int)Math.ceil((double)this.checks.size() / (double)this.columns);
        JPanel panel = new JPanel(new GridLayout(rows, this.columns));
        int i = 0;
        for (Check check : this.checks) {
            check.addToPanel(panel, support);
            ++i;
        }
        while (i < rows * this.columns) {
            panel.add(new JLabel());
            ++i;
        }
        panel.applyComponentOrientation(support.getDefaultComponentOrientation());
        p.add((Component)panel, GBC.eol());
        return false;
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
        for (Check check : this.checks) {
            check.addCommands(changedTags);
        }
    }

    @Override
    public Boolean matches(Map<String, String> tags) {
        for (Check check : this.checks) {
            if (!Boolean.TRUE.equals(check.matches(tags))) continue;
            return Boolean.TRUE;
        }
        return null;
    }

    public String toString() {
        return "CheckGroup [columns=" + this.columns + "]";
    }
}

