/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.V3;
import org.jmol.api.JmolModulationSet;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Vectors;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;

public class VectorsRenderer
extends ShapeRenderer {
    private static final float arrowHeadOffset = -0.2f;
    private final Point3fi ptTemp = new Point3fi();
    private final P3 pointVectorStart = new P3();
    private final Point3fi pointVectorEnd = new Point3fi();
    private final P3 pointArrowHead = new P3();
    private final P3 screenVectorStart = new P3();
    private final P3 screenVectorEnd = new P3();
    private final P3 screenArrowHead = new P3();
    private final V3 headOffsetVector = new V3();
    private final P3 pTemp3 = new P3();
    private int diameter;
    private int headWidthPixels;
    private float vectorScale;
    private boolean vectorSymmetry;
    private float headScale;
    private boolean drawShaft;
    private Vibration vibTemp;
    private boolean vectorsCentered;
    private boolean standardVector = true;
    private boolean vibrationOn;
    private boolean drawCap;
    private boolean showModVecs;
    private int vectorTrail;
    private P3 ptTemp4;
    private P3 ptTemp2;

    @Override
    protected boolean render() {
        Atom atom;
        int i;
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return false;
        }
        short[] mads = vectors.mads;
        if (mads == null) {
            return false;
        }
        short[] colixes = vectors.colixes;
        boolean needTranslucent = false;
        this.vectorScale = this.vwr.getFloat(1648361473);
        this.vectorTrail = this.vwr.getInt(553648185);
        Atom[] atoms = this.ms.at;
        if (this.vectorScale < 0.0f) {
            float maxScale = 0.0f;
            i = this.ms.ac;
            while (--i >= 0) {
                float d;
                Vibration vib = this.ms.getVibration(i, false);
                if (vib == null || !(vib.magMoment > 0.0f) || !((d = vib.length()) > maxScale)) continue;
                maxScale = d;
            }
            this.vectorScale = maxScale > 0.0f ? (this.vectorScale /= -maxScale) : 1.0f;
        }
        this.vectorSymmetry = this.vwr.getBoolean(603979973);
        this.vectorsCentered = this.vwr.getBoolean(603979972);
        this.showModVecs = this.vwr.getBoolean(603979927);
        this.vibrationOn = this.vwr.tm.vibrationOn;
        this.headScale = -0.2f;
        boolean haveModulations = false;
        i = this.ms.ac;
        while (--i >= 0) {
            Vibration vib;
            atom = atoms[i];
            if (!this.isVisibleForMe(atom)) continue;
            JmolModulationSet mod = this.ms.getModulation(i);
            if (this.showModVecs && !haveModulations && mod != null) {
                haveModulations = true;
            }
            if ((vib = this.ms.getVibration(i, false)) == null || !this.transform(mads[i], atom, vib, mod)) continue;
            if (!this.g3d.setC(Shape.getColix(colixes, i, atom))) {
                needTranslucent = true;
                continue;
            }
            this.renderVector(atom, vib);
            if (!this.vectorSymmetry) continue;
            this.vectorScale = -this.vectorScale;
            this.headScale = -this.headScale;
            this.transform(mads[i], atom, vib, null);
            this.renderVector(atom, vib);
            this.vectorScale = -this.vectorScale;
            this.headScale = -this.headScale;
        }
        if (haveModulations) {
            i = this.ms.ac;
            while (--i >= 0) {
                JmolModulationSet mod;
                atom = atoms[i];
                if (!this.isVisibleForMe(atom) || (mod = this.ms.getModulation(i)) == null) continue;
                if (!this.g3d.setC(Shape.getColix(colixes, i, atom))) {
                    needTranslucent = true;
                    continue;
                }
                if (!this.transform(mads[i], atom, null, mod)) continue;
                this.renderVector(atom, null);
            }
        }
        return needTranslucent;
    }

    private boolean transform(short mad, Atom atom, Vibration vib, JmolModulationSet mod2) {
        boolean isSpin;
        boolean isMod = vib == null || vib.modDim >= 0;
        boolean bl = isSpin = !isMod && vib.modDim == -2;
        if (vib == null) {
            vib = (Vibration)((Object)mod2);
        }
        this.drawCap = true;
        if (!isMod) {
            float len = vib.length();
            if ((double)Math.abs(len * this.vectorScale) < 0.01) {
                return false;
            }
            this.standardVector = true;
            this.drawShaft = 0.1 + (double)Math.abs(this.headScale / len) < (double)Math.abs(this.vectorScale);
            this.headOffsetVector.setT(vib);
            this.headOffsetVector.scale(this.headScale / len);
        }
        this.ptTemp.setT(atom);
        JmolModulationSet mod = atom.getModulation();
        if (this.vibrationOn && mod != null) {
            this.vwr.tm.getVibrationPoint((Vibration)((Object)mod), this.ptTemp, 1.0f);
        }
        if (isMod) {
            this.standardVector = false;
            this.drawShaft = true;
            mod = (JmolModulationSet)((Object)vib);
            this.pointVectorStart.setT(this.ptTemp);
            this.pointVectorEnd.setT(this.ptTemp);
            if (mod.isEnabled()) {
                if (this.vibrationOn) {
                    this.vwr.tm.getVibrationPoint(vib, this.pointVectorEnd, Float.NaN);
                }
                mod.addTo(this.pointVectorStart, Float.NaN);
            } else {
                mod.addTo(this.pointVectorEnd, 1.0f);
            }
            this.headOffsetVector.sub2(this.pointVectorEnd, this.pointVectorStart);
            float len = this.headOffsetVector.length();
            this.drawCap = len + -0.2f > 0.001f;
            this.drawShaft = len > 0.01f;
            this.headOffsetVector.scale(this.headScale / this.headOffsetVector.length());
        } else if (this.vectorsCentered || isSpin) {
            this.standardVector = false;
            this.pointVectorEnd.scaleAdd2(0.5f * this.vectorScale, vib, this.ptTemp);
            if (this.vectorSymmetry) {
                this.pointVectorStart.setP(this.ptTemp);
            } else {
                this.pointVectorStart.scaleAdd2(-0.5f * this.vectorScale, vib, this.ptTemp);
            }
        } else {
            this.pointVectorEnd.scaleAdd2(this.vectorScale, vib, this.ptTemp);
            this.pointArrowHead.add2(this.pointVectorEnd, this.headOffsetVector);
            if (this.vibrationOn) {
                P3i screen = this.tm.transformPtVib(this.pointVectorEnd, vib);
                this.screenVectorEnd.set(screen.x, screen.y, screen.z);
                screen = this.tm.transformPtVib(this.pointArrowHead, vib);
                this.screenArrowHead.set(screen.x, screen.y, screen.z);
            } else {
                this.tm.transformPtScrT3(this.pointVectorEnd, this.screenVectorEnd);
                this.tm.transformPtScrT3(this.pointArrowHead, this.screenArrowHead);
            }
        }
        if (!this.standardVector) {
            this.tm.transformPtScrT3(this.pointVectorEnd, this.screenVectorEnd);
            this.tm.transformPtScrT3(this.pointVectorStart, this.screenVectorStart);
            if (this.drawCap) {
                this.pointArrowHead.add2(this.pointVectorEnd, this.headOffsetVector);
            } else {
                this.pointArrowHead.setT(this.pointVectorEnd);
            }
            this.tm.transformPtScrT3(this.pointArrowHead, this.screenArrowHead);
        }
        this.diameter = (int)(mad < 0 ? (float)(-mad) : (mad < 1 ? 1.0f : this.vwr.tm.scaleToScreen((int)this.screenVectorEnd.z, mad)));
        this.headWidthPixels = this.diameter << 1;
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        return true;
    }

    private void renderVector(Atom atom, Vibration vib) {
        if (vib != null && this.vectorTrail > 0) {
            if (this.ptTemp4 == null) {
                this.ptTemp4 = new P3();
                this.ptTemp2 = new P3();
            }
            int d = Math.max(1, this.diameter >> 2);
            P3[] pts = vib.addTracePt(this.vectorTrail, this.vibrationOn ? this.pointVectorEnd : null);
            this.tm.transformPtScrT3(atom, this.ptTemp4);
            if (pts != null) {
                P3 pt;
                int i = pts.length;
                int p = this.vectorTrail;
                while (--i >= 0 && (pt = pts[--p]) != null) {
                    this.tm.transformPtScrT3(pt, this.ptTemp2);
                    this.g3d.fillCylinderBits((byte)2, d, this.ptTemp4, this.ptTemp2);
                }
            }
        }
        if (this.drawShaft) {
            this.pTemp3.set(atom.sX, atom.sY, atom.sZ);
            if (this.standardVector) {
                this.g3d.fillCylinderBits((byte)2, this.diameter, this.pTemp3, this.screenArrowHead);
            } else {
                this.g3d.fillCylinderBits((byte)2, this.diameter, this.screenVectorStart, this.screenArrowHead);
            }
        }
        if (this.drawCap) {
            this.g3d.fillConeScreen3f((byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd, false);
        }
    }
}

