/* SPDX-License-Identifier: GPL-2.0 */
//
// ALSA SoC Texas Instruments TAS2x20/TAS2118 Audio Smart Amplifier
//
// Copyright (C) 2025 Texas Instruments Incorporated
// https://www.ti.com
//
// The TAS2x20/TAS2118 hda driver implements for one, two, or even multiple
// TAS2x20/TAS2118 chips.
//
// Author: Baojun Xu <baojun.xu@ti.com>
//

#ifndef __TAS2X20_TLV_H__
#define __TAS2X20_TLV_H__

#define TAS2X20_DVC_LEVEL		TASDEVICE_REG(0x0, 0x2, 0x0c)
#define TAS2X20_AMP_LEVEL		TASDEVICE_REG(0x0, 0x0, 0x07)

static const __maybe_unused DECLARE_TLV_DB_SCALE(tas2x20_dvc_tlv, 1650, 50, 0);
static const __maybe_unused DECLARE_TLV_DB_SCALE(tas2x20_amp_tlv, 2100, 50, 0);

/* pow(10, db/20) * pow(2,22) */
static const __maybe_unused unsigned char tas2x20_dvc_table[][4] = {
	{ 0X00, 0X00, 0X0D, 0X00 }, /* -110.0db */
	{ 0X00, 0X00, 0X0E, 0X00 }, /* -109.5db */
	{ 0X00, 0X00, 0X0E, 0X00 }, /* -109.0db */
	{ 0X00, 0X00, 0X0F, 0X00 }, /* -108.5db */
	{ 0X00, 0X00, 0X10, 0X00 }, /* -108.0db */
	{ 0X00, 0X00, 0X11, 0X00 }, /* -107.5db */
	{ 0X00, 0X00, 0X12, 0X00 }, /* -107.0db */
	{ 0X00, 0X00, 0X13, 0X00 }, /* -106.5db */
	{ 0X00, 0X00, 0X15, 0X00 }, /* -106.0db */
	{ 0X00, 0X00, 0X16, 0X00 }, /* -105.5db */
	{ 0X00, 0X00, 0X17, 0X00 }, /* -105.0db */
	{ 0X00, 0X00, 0X18, 0X00 }, /* -104.5db */
	{ 0X00, 0X00, 0X1A, 0X00 }, /* -104.0db */
	{ 0X00, 0X00, 0X1C, 0X00 }, /* -103.5db */
	{ 0X00, 0X00, 0X1D, 0X00 }, /* -103.0db */
	{ 0X00, 0X00, 0X1F, 0X00 }, /* -102.5db */
	{ 0X00, 0X00, 0X21, 0X00 }, /* -102.0db */
	{ 0X00, 0X00, 0X23, 0X00 }, /* -101.5db */
	{ 0X00, 0X00, 0X25, 0X00 }, /* -101.0db */
	{ 0X00, 0X00, 0X27, 0X00 }, /* -100.5db */
	{ 0X00, 0X00, 0X29, 0X00 }, /* -100.0db */
	{ 0X00, 0X00, 0X2C, 0X00 }, /* -99.5db */
	{ 0X00, 0X00, 0X2F, 0X00 }, /* -99.0db */
	{ 0X00, 0X00, 0X31, 0X00 }, /* -98.5db */
	{ 0X00, 0X00, 0X34, 0X00 }, /* -98.0db */
	{ 0X00, 0X00, 0X37, 0X00 }, /* -97.5db */
	{ 0X00, 0X00, 0X3B, 0X00 }, /* -97.0db */
	{ 0X00, 0X00, 0X3E, 0X00 }, /* -96.5db */
	{ 0X00, 0X00, 0X42, 0X00 }, /* -96.0db */
	{ 0X00, 0X00, 0X46, 0X00 }, /* -95.5db */
	{ 0X00, 0X00, 0X4A, 0X00 }, /* -95.0db */
	{ 0X00, 0X00, 0X4F, 0X00 }, /* -94.5db */
	{ 0X00, 0X00, 0X53, 0X00 }, /* -94.0db */
	{ 0X00, 0X00, 0X58, 0X00 }, /* -93.5db */
	{ 0X00, 0X00, 0X5D, 0X00 }, /* -93.0db */
	{ 0X00, 0X00, 0X63, 0X00 }, /* -92.5db */
	{ 0X00, 0X00, 0X69, 0X00 }, /* -92.0db */
	{ 0X00, 0X00, 0X6F, 0X00 }, /* -91.5db */
	{ 0X00, 0X00, 0X76, 0X00 }, /* -91.0db */
	{ 0X00, 0X00, 0X7D, 0X00 }, /* -90.5db */
	{ 0X00, 0X00, 0X84, 0X00 }, /* -90.0db */
	{ 0X00, 0X00, 0X8C, 0X00 }, /* -89.5db */
	{ 0X00, 0X00, 0X94, 0X00 }, /* -89.0db */
	{ 0X00, 0X00, 0X9D, 0X00 }, /* -88.5db */
	{ 0X00, 0X00, 0XA6, 0X00 }, /* -88.0db */
	{ 0X00, 0X00, 0XB0, 0X00 }, /* -87.5db */
	{ 0X00, 0X00, 0XBB, 0X00 }, /* -87.0db */
	{ 0X00, 0X00, 0XC6, 0X00 }, /* -86.5db */
	{ 0X00, 0X00, 0XD2, 0X00 }, /* -86.0db */
	{ 0X00, 0X00, 0XDE, 0X00 }, /* -85.5db */
	{ 0X00, 0X00, 0XEB, 0X00 }, /* -85.0db */
	{ 0X00, 0X00, 0XF9, 0X00 }, /* -84.5db */
	{ 0X00, 0X01, 0X08, 0X00 }, /* -84.0db */
	{ 0X00, 0X01, 0X18, 0X00 }, /* -83.5db */
	{ 0X00, 0X01, 0X28, 0X00 }, /* -83.0db */
	{ 0X00, 0X01, 0X3A, 0X00 }, /* -82.5db */
	{ 0X00, 0X01, 0X4D, 0X00 }, /* -82.0db */
	{ 0X00, 0X01, 0X60, 0X00 }, /* -81.5db */
	{ 0X00, 0X01, 0X75, 0X00 }, /* -81.0db */
	{ 0X00, 0X01, 0X8B, 0X00 }, /* -80.5db */
	{ 0X00, 0X01, 0XA3, 0X00 }, /* -80.0db */
	{ 0X00, 0X01, 0XBC, 0X00 }, /* -79.5db */
	{ 0X00, 0X01, 0XD6, 0X00 }, /* -79.0db */
	{ 0X00, 0X01, 0XF2, 0X00 }, /* -78.5db */
	{ 0X00, 0X02, 0X10, 0X00 }, /* -78.0db */
	{ 0X00, 0X02, 0X2F, 0X00 }, /* -77.5db */
	{ 0X00, 0X02, 0X50, 0X00 }, /* -77.0db */
	{ 0X00, 0X02, 0X73, 0X00 }, /* -76.5db */
	{ 0X00, 0X02, 0X98, 0X00 }, /* -76.0db */
	{ 0X00, 0X02, 0XC0, 0X00 }, /* -75.5db */
	{ 0X00, 0X02, 0XE9, 0X00 }, /* -75.0db */
	{ 0X00, 0X03, 0X16, 0X00 }, /* -74.5db */
	{ 0X00, 0X03, 0X44, 0X00 }, /* -74.0db */
	{ 0X00, 0X03, 0X76, 0X00 }, /* -73.5db */
	{ 0X00, 0X03, 0XAA, 0X00 }, /* -73.0db */
	{ 0X00, 0X03, 0XE2, 0X00 }, /* -72.5db */
	{ 0X00, 0X04, 0X1D, 0X00 }, /* -72.0db */
	{ 0X00, 0X04, 0X5B, 0X00 }, /* -71.5db */
	{ 0X00, 0X04, 0X9E, 0X00 }, /* -71.0db */
	{ 0X00, 0X04, 0XE4, 0X00 }, /* -70.5db */
	{ 0X00, 0X05, 0X2E, 0X00 }, /* -70.0db */
	{ 0X00, 0X05, 0X7C, 0X00 }, /* -69.5db */
	{ 0X00, 0X05, 0XD0, 0X00 }, /* -69.0db */
	{ 0X00, 0X06, 0X28, 0X00 }, /* -68.5db */
	{ 0X00, 0X06, 0X85, 0X00 }, /* -68.0db */
	{ 0X00, 0X06, 0XE8, 0X00 }, /* -67.5db */
	{ 0X00, 0X07, 0X51, 0X00 }, /* -67.0db */
	{ 0X00, 0X07, 0XC0, 0X00 }, /* -66.5db */
	{ 0X00, 0X08, 0X36, 0X00 }, /* -66.0db */
	{ 0X00, 0X08, 0XB2, 0X00 }, /* -65.5db */
	{ 0X00, 0X09, 0X36, 0X00 }, /* -65.0db */
	{ 0X00, 0X09, 0XC2, 0X00 }, /* -64.5db */
	{ 0X00, 0X0A, 0X56, 0X00 }, /* -64.0db */
	{ 0X00, 0X0A, 0XF3, 0X00 }, /* -63.5db */
	{ 0X00, 0X0B, 0X99, 0X00 }, /* -63.0db */
	{ 0X00, 0X0C, 0X49, 0X00 }, /* -62.5db */
	{ 0X00, 0X0D, 0X03, 0X00 }, /* -62.0db */
	{ 0X00, 0X0D, 0XC9, 0X00 }, /* -61.5db */
	{ 0X00, 0X0E, 0X9A, 0X00 }, /* -61.0db */
	{ 0X00, 0X0F, 0X77, 0X00 }, /* -60.5db */
	{ 0X00, 0X10, 0X62, 0X00 }, /* -60.0db */
	{ 0X00, 0X11, 0X5A, 0X00 }, /* -59.5db */
	{ 0X00, 0X12, 0X62, 0X00 }, /* -59.0db */
	{ 0X00, 0X13, 0X78, 0X00 }, /* -58.5db */
	{ 0X00, 0X14, 0XA0, 0X00 }, /* -58.0db */
	{ 0X00, 0X15, 0XD9, 0X00 }, /* -57.5db */
	{ 0X00, 0X17, 0X24, 0X00 }, /* -57.0db */
	{ 0X00, 0X18, 0X83, 0X00 }, /* -56.5db */
	{ 0X00, 0X19, 0XF7, 0X00 }, /* -56.0db */
	{ 0X00, 0X1B, 0X81, 0X00 }, /* -55.5db */
	{ 0X00, 0X1D, 0X22, 0X00 }, /* -55.0db */
	{ 0X00, 0X1E, 0XDC, 0X00 }, /* -54.5db */
	{ 0X00, 0X20, 0XB0, 0X00 }, /* -54.0db */
	{ 0X00, 0X22, 0XA0, 0X00 }, /* -53.5db */
	{ 0X00, 0X24, 0XAD, 0X00 }, /* -53.0db */
	{ 0X00, 0X26, 0XDA, 0X00 }, /* -52.5db */
	{ 0X00, 0X29, 0X27, 0X00 }, /* -52.0db */
	{ 0X00, 0X2B, 0X97, 0X00 }, /* -51.5db */
	{ 0X00, 0X2E, 0X2D, 0X00 }, /* -51.0db */
	{ 0X00, 0X30, 0XE9, 0X00 }, /* -50.5db */
	{ 0X00, 0X33, 0XCF, 0X00 }, /* -50.0db */
	{ 0X00, 0X36, 0XE1, 0X00 }, /* -49.5db */
	{ 0X00, 0X3A, 0X21, 0X00 }, /* -49.0db */
	{ 0X00, 0X3D, 0X93, 0X00 }, /* -48.5db */
	{ 0X00, 0X41, 0X39, 0X00 }, /* -48.0db */
	{ 0X00, 0X45, 0X17, 0X00 }, /* -47.5db */
	{ 0X00, 0X49, 0X2F, 0X00 }, /* -47.0db */
	{ 0X00, 0X4D, 0X85, 0X00 }, /* -46.5db */
	{ 0X00, 0X52, 0X1D, 0X00 }, /* -46.0db */
	{ 0X00, 0X56, 0XFA, 0X00 }, /* -45.5db */
	{ 0X00, 0X5C, 0X22, 0X00 }, /* -45.0db */
	{ 0X00, 0X61, 0X97, 0X00 }, /* -44.5db */
	{ 0X00, 0X67, 0X60, 0X00 }, /* -44.0db */
	{ 0X00, 0X6D, 0X80, 0X00 }, /* -43.5db */
	{ 0X00, 0X73, 0XFD, 0X00 }, /* -43.0db */
	{ 0X00, 0X7A, 0XDC, 0X00 }, /* -42.5db */
	{ 0X00, 0X82, 0X24, 0X00 }, /* -42.0db */
	{ 0X00, 0X89, 0XDA, 0X00 }, /* -41.5db */
	{ 0X00, 0X92, 0X05, 0X00 }, /* -41.0db */
	{ 0X00, 0X9A, 0XAC, 0X00 }, /* -40.5db */
	{ 0X00, 0XA3, 0XD7, 0X00 }, /* -40.0db */
	{ 0X00, 0XAD, 0X8C, 0X00 }, /* -39.5db */
	{ 0X00, 0XB7, 0XD4, 0X00 }, /* -39.0db */
	{ 0X00, 0XC2, 0XB9, 0X00 }, /* -38.5db */
	{ 0X00, 0XCE, 0X43, 0X00 }, /* -38.0db */
	{ 0X00, 0XDA, 0X7B, 0X00 }, /* -37.5db */
	{ 0X00, 0XE7, 0X6E, 0X00 }, /* -37.0db */
	{ 0X00, 0XF5, 0X24, 0X00 }, /* -36.5db */
	{ 0X01, 0X03, 0XAB, 0X00 }, /* -36.0db */
	{ 0X01, 0X13, 0X0E, 0X00 }, /* -35.5db */
	{ 0X01, 0X23, 0X5A, 0X00 }, /* -35.0db */
	{ 0X01, 0X34, 0X9D, 0X00 }, /* -34.5db */
	{ 0X01, 0X46, 0XE7, 0X00 }, /* -34.0db */
	{ 0X01, 0X5A, 0X46, 0X00 }, /* -33.5db */
	{ 0X01, 0X6E, 0XCA, 0X00 }, /* -33.0db */
	{ 0X01, 0X84, 0X86, 0X00 }, /* -32.5db */
	{ 0X01, 0X9B, 0X8C, 0X00 }, /* -32.0db */
	{ 0X01, 0XB3, 0XEE, 0X00 }, /* -31.5db */
	{ 0X01, 0XCD, 0XC3, 0X00 }, /* -31.0db */
	{ 0X01, 0XE9, 0X20, 0X00 }, /* -30.5db */
	{ 0X02, 0X06, 0X1B, 0X00 }, /* -30.0db */
	{ 0X02, 0X24, 0XCE, 0X00 }, /* -29.5db */
	{ 0X02, 0X45, 0X53, 0X00 }, /* -29.0db */
	{ 0X02, 0X67, 0XC5, 0X00 }, /* -28.5db */
	{ 0X02, 0X8C, 0X42, 0X00 }, /* -28.0db */
	{ 0X02, 0XB2, 0XE8, 0X00 }, /* -27.5db */
	{ 0X02, 0XDB, 0XD8, 0X00 }, /* -27.0db */
	{ 0X03, 0X07, 0X36, 0X00 }, /* -26.5db */
	{ 0X03, 0X35, 0X25, 0X00 }, /* -26.0db */
	{ 0X03, 0X65, 0XCD, 0X00 }, /* -25.5db */
	{ 0X03, 0X99, 0X57, 0X00 }, /* -25.0db */
	{ 0X03, 0XCF, 0XEE, 0X00 }, /* -24.5db */
	{ 0X04, 0X09, 0XC2, 0X00 }, /* -24.0db */
	{ 0X04, 0X47, 0X03, 0X00 }, /* -23.5db */
	{ 0X04, 0X87, 0XE5, 0X00 }, /* -23.0db */
	{ 0X04, 0XCC, 0XA0, 0X00 }, /* -22.5db */
	{ 0X05, 0X15, 0X6D, 0X00 }, /* -22.0db */
	{ 0X05, 0X62, 0X8A, 0X00 }, /* -21.5db */
	{ 0X05, 0XB4, 0X39, 0X00 }, /* -21.0db */
	{ 0X06, 0X0A, 0XBF, 0X00 }, /* -20.5db */
	{ 0X06, 0X66, 0X66, 0X00 }, /* -20.0db */
	{ 0X06, 0XC7, 0X7B, 0X00 }, /* -19.5db */
	{ 0X07, 0X2E, 0X50, 0X00 }, /* -19.0db */
	{ 0X07, 0X9B, 0X3D, 0X00 }, /* -18.5db */
	{ 0X08, 0X0E, 0X9F, 0X00 }, /* -18.0db */
	{ 0X08, 0X88, 0XD7, 0X00 }, /* -17.5db */
	{ 0X09, 0X0A, 0X4D, 0X00 }, /* -17.0db */
	{ 0X09, 0X93, 0X6E, 0X00 }, /* -16.5db */
	{ 0X0A, 0X24, 0XB0, 0X00 }, /* -16.0db */
	{ 0X0A, 0XBE, 0X8D, 0X00 }, /* -15.5db */
	{ 0X0B, 0X61, 0X88, 0X00 }, /* -15.0db */
	{ 0X0C, 0X0E, 0X2B, 0X00 }, /* -14.5db */
	{ 0X0C, 0XC5, 0X09, 0X00 }, /* -14.0db */
	{ 0X0D, 0X86, 0XBD, 0X00 }, /* -13.5db */
	{ 0X0E, 0X53, 0XEB, 0X00 }, /* -13.0db */
	{ 0X0F, 0X2D, 0X42, 0X00 }, /* -12.5db */
	{ 0X10, 0X13, 0X79, 0X00 }, /* -12.0db */
	{ 0X11, 0X07, 0X54, 0X00 }, /* -11.5db */
	{ 0X12, 0X09, 0XA3, 0X00 }, /* -11.0db */
	{ 0X13, 0X1B, 0X40, 0X00 }, /* -10.5db */
	{ 0X14, 0X3D, 0X13, 0X00 }, /* -10.0db */
	{ 0X15, 0X70, 0X12, 0X00 }, /* -9.5db */
	{ 0X16, 0XB5, 0X43, 0X00 }, /* -9.0db */
	{ 0X18, 0X0D, 0XB8, 0X00 }, /* -8.5db */
	{ 0X19, 0X7A, 0X96, 0X00 }, /* -8.0db */
	{ 0X1A, 0XFD, 0X13, 0X00 }, /* -7.5db */
	{ 0X1C, 0X96, 0X76, 0X00 }, /* -7.0db */
	{ 0X1E, 0X48, 0X1C, 0X00 }, /* -6.5db */
	{ 0X20, 0X13, 0X73, 0X00 }, /* -6.0db */
	{ 0X21, 0XFA, 0X02, 0X00 }, /* -5.5db */
	{ 0X23, 0XFD, 0X66, 0X00 }, /* -5.0db */
	{ 0X26, 0X1F, 0X54, 0X00 }, /* -4.5db */
	{ 0X28, 0X61, 0X9A, 0X00 }, /* -4.0db */
	{ 0X2A, 0XC6, 0X25, 0X00 }, /* -3.5db */
	{ 0X2D, 0X4E, 0XFB, 0X00 }, /* -3.0db */
	{ 0X2F, 0XFE, 0X44, 0X00 }, /* -2.5db */
	{ 0X32, 0XD6, 0X46, 0X00 }, /* -2.0db */
	{ 0X35, 0XD9, 0X6B, 0X00 }, /* -1.5db */
	{ 0X39, 0X0A, 0X41, 0X00 }, /* -1.0db */
	{ 0X3C, 0X6B, 0X7E, 0X00 }, /* -0.5db */
	{ 0X40, 0X00, 0X00, 0X00 }, /* 0.0db */
	{ 0X43, 0XCA, 0XD0, 0X00 }, /* 0.5db */
	{ 0X47, 0XCF, 0X26, 0X00 }, /* 1.0db */
	{ 0X4C, 0X10, 0X6B, 0X00 }, /* 1.5db */
	{ 0X50, 0X92, 0X3B, 0X00 }, /* 2.0db */
	{ 0X55, 0X58, 0X6A, 0X00 }, /* 2.5db */
	{ 0X5A, 0X67, 0X03, 0X00 }, /* 3.0db */
	{ 0X5F, 0XC2, 0X53, 0X00 }, /* 3.5db */
	{ 0X65, 0X6E, 0XE3, 0X00 }, /* 4.0db */
	{ 0X6B, 0X71, 0X86, 0X00 }, /* 4.5db */
	{ 0X71, 0XCF, 0X54, 0X00 }, /* 5.0db */
	{ 0X78, 0X8D, 0XB4, 0X00 }, /* 5.5db */
	{ 0X7F, 0XB2, 0X61, 0X00 }, /* 6.0db */
};
#endif
