"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatrixError = void 0;
/**
 * Represents an HTTP error from the Matrix server.
 * @category Error handling
 */
class MatrixError extends Error {
    body;
    statusCode;
    /**
     * The Matrix error code
     */
    errcode;
    /**
     * Optional human-readable error message.
     */
    error;
    /**
     * If rate limited, the time in milliseconds to wait before retrying the request
     */
    retryAfterMs;
    /**
     * Creates a new Matrix Error
     * @param body The error body.
     * @param statusCode The HTTP status code.
     */
    constructor(body, statusCode) {
        super();
        this.body = body;
        this.statusCode = statusCode;
        this.errcode = body.errcode;
        this.error = body.error;
        this.retryAfterMs = body.retry_after_ms;
    }
    /**
     * Developer-friendly error message.
     */
    get message() {
        return `${this.errcode}: ${this.error}`;
    }
}
exports.MatrixError = MatrixError;
//# sourceMappingURL=MatrixError.js.map