# -*- coding: utf-8 -*-

"""
***************************************************************************
    __init__.py
    ---------------------
    Date                 : May 2014
    Copyright            : (C) 2014 by Nathan Woodrow
    Email                : woodrow dot nathan at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Nathan Woodrow'
__date__ = 'May 2014'
__copyright__ = '(C) 2014, Nathan Woodrow'

from qgis.PyQt import QtCore

from qgis._analysis import *

# preserve API compatibility following QgsExifTools moved to core
from qgis.core import QgsExifTools
# preserve API compatibility as QgsAlignRaster.Item moved to QgsAlignRasterData.RasterItem
from qgis.core import QgsAlignRasterData

from qgis.core import Qgis
QgsAlignRaster.Item = QgsAlignRasterData.RasterItem

QgsAlignRaster.ResampleAlg = Qgis.GdalResampleAlgorithm
# monkey patching scoped based enum
QgsAlignRaster.RA_NearestNeighbour = Qgis.GdalResampleAlgorithm.RA_NearestNeighbour
QgsAlignRaster.RA_NearestNeighbour.is_monkey_patched = True
QgsAlignRaster.RA_NearestNeighbour.__doc__ = "Nearest neighbour (select on one input pixel)"
QgsAlignRaster.RA_Bilinear = Qgis.GdalResampleAlgorithm.RA_Bilinear
QgsAlignRaster.RA_Bilinear.is_monkey_patched = True
QgsAlignRaster.RA_Bilinear.__doc__ = "Bilinear (2x2 kernel)"
QgsAlignRaster.RA_Cubic = Qgis.GdalResampleAlgorithm.RA_Cubic
QgsAlignRaster.RA_Cubic.is_monkey_patched = True
QgsAlignRaster.RA_Cubic.__doc__ = "Cubic Convolution Approximation (4x4 kernel)"
QgsAlignRaster.RA_CubicSpline = Qgis.GdalResampleAlgorithm.RA_CubicSpline
QgsAlignRaster.RA_CubicSpline.is_monkey_patched = True
QgsAlignRaster.RA_CubicSpline.__doc__ = "Cubic B-Spline Approximation (4x4 kernel)"
QgsAlignRaster.RA_Lanczos = Qgis.GdalResampleAlgorithm.RA_Lanczos
QgsAlignRaster.RA_Lanczos.is_monkey_patched = True
QgsAlignRaster.RA_Lanczos.__doc__ = "Lanczos windowed sinc interpolation (6x6 kernel)"
QgsAlignRaster.RA_Average = Qgis.GdalResampleAlgorithm.RA_Average
QgsAlignRaster.RA_Average.is_monkey_patched = True
QgsAlignRaster.RA_Average.__doc__ = "Average (computes the average of all non-NODATA contributing pixels)"
QgsAlignRaster.RA_Mode = Qgis.GdalResampleAlgorithm.RA_Mode
QgsAlignRaster.RA_Mode.is_monkey_patched = True
QgsAlignRaster.RA_Mode.__doc__ = "Mode (selects the value which appears most often of all the sampled points)"
QgsAlignRaster.RA_Max = Qgis.GdalResampleAlgorithm.RA_Max
QgsAlignRaster.RA_Max.is_monkey_patched = True
QgsAlignRaster.RA_Max.__doc__ = "Maximum (selects the maximum of all non-NODATA contributing pixels)"
QgsAlignRaster.RA_Min = Qgis.GdalResampleAlgorithm.RA_Min
QgsAlignRaster.RA_Min.is_monkey_patched = True
QgsAlignRaster.RA_Min.__doc__ = "Minimum (selects the minimum of all non-NODATA contributing pixels)"
QgsAlignRaster.RA_Median = Qgis.GdalResampleAlgorithm.RA_Median
QgsAlignRaster.RA_Median.is_monkey_patched = True
QgsAlignRaster.RA_Median.__doc__ = "Median (selects the median of all non-NODATA contributing pixels)"
QgsAlignRaster.RA_Q1 = Qgis.GdalResampleAlgorithm.RA_Q1
QgsAlignRaster.RA_Q1.is_monkey_patched = True
QgsAlignRaster.RA_Q1.__doc__ = "First quartile (selects the first quartile of all non-NODATA contributing pixels)"
QgsAlignRaster.RA_Q3 = Qgis.GdalResampleAlgorithm.RA_Q3
QgsAlignRaster.RA_Q3.is_monkey_patched = True
QgsAlignRaster.RA_Q3.__doc__ = "Third quartile (selects the third quartile of all non-NODATA contributing pixels)"
Qgis.GdalResampleAlgorithm.__doc__ = "Resampling algorithm to be used (equivalent to GDAL's enum GDALResampleAlg)\n\n.. note::\n\n   RA_Max, RA_Min, RA_Median, RA_Q1 and RA_Q3 are available on GDAL >= 2.0 builds only\n\n.. versionadded:: 3.34\n\n" + '* ``RA_NearestNeighbour``: ' + Qgis.GdalResampleAlgorithm.RA_NearestNeighbour.__doc__ + '\n' + '* ``RA_Bilinear``: ' + Qgis.GdalResampleAlgorithm.RA_Bilinear.__doc__ + '\n' + '* ``RA_Cubic``: ' + Qgis.GdalResampleAlgorithm.RA_Cubic.__doc__ + '\n' + '* ``RA_CubicSpline``: ' + Qgis.GdalResampleAlgorithm.RA_CubicSpline.__doc__ + '\n' + '* ``RA_Lanczos``: ' + Qgis.GdalResampleAlgorithm.RA_Lanczos.__doc__ + '\n' + '* ``RA_Average``: ' + Qgis.GdalResampleAlgorithm.RA_Average.__doc__ + '\n' + '* ``RA_Mode``: ' + Qgis.GdalResampleAlgorithm.RA_Mode.__doc__ + '\n' + '* ``RA_Max``: ' + Qgis.GdalResampleAlgorithm.RA_Max.__doc__ + '\n' + '* ``RA_Min``: ' + Qgis.GdalResampleAlgorithm.RA_Min.__doc__ + '\n' + '* ``RA_Median``: ' + Qgis.GdalResampleAlgorithm.RA_Median.__doc__ + '\n' + '* ``RA_Q1``: ' + Qgis.GdalResampleAlgorithm.RA_Q1.__doc__ + '\n' + '* ``RA_Q3``: ' + Qgis.GdalResampleAlgorithm.RA_Q3.__doc__
# --
Qgis.GdalResampleAlgorithm.baseClass = Qgis
"""
This folder is completed using sipify.pl script
It is not aimed to be manually edited
"""
# The following has been generated automatically from src/analysis/georeferencing/qgsgcppoint.h
# monkey patching scoped based enum
QgsGcpPoint.PointType.Source.__doc__ = "Source point"
QgsGcpPoint.PointType.Destination.__doc__ = "Destination point"
QgsGcpPoint.PointType.__doc__ = "Coordinate point types\n\n" + '* ``Source``: ' + QgsGcpPoint.PointType.Source.__doc__ + '\n' + '* ``Destination``: ' + QgsGcpPoint.PointType.Destination.__doc__
# --
# The following has been generated automatically from src/analysis/georeferencing/qgsgcptransformer.h
# monkey patching scoped based enum
QgsGcpTransformerInterface.TransformMethod.Linear.__doc__ = "Linear transform"
QgsGcpTransformerInterface.TransformMethod.Helmert.__doc__ = "Helmert transform"
QgsGcpTransformerInterface.TransformMethod.PolynomialOrder1.__doc__ = "Polynomial order 1"
QgsGcpTransformerInterface.TransformMethod.PolynomialOrder2.__doc__ = "Polyonmial order 2"
QgsGcpTransformerInterface.TransformMethod.PolynomialOrder3.__doc__ = "Polynomial order"
QgsGcpTransformerInterface.TransformMethod.ThinPlateSpline.__doc__ = "Thin plate splines"
QgsGcpTransformerInterface.TransformMethod.Projective.__doc__ = "Projective"
QgsGcpTransformerInterface.TransformMethod.InvalidTransform.__doc__ = "Invalid transform"
QgsGcpTransformerInterface.TransformMethod.__doc__ = "Available transformation methods.\n\n" + '* ``Linear``: ' + QgsGcpTransformerInterface.TransformMethod.Linear.__doc__ + '\n' + '* ``Helmert``: ' + QgsGcpTransformerInterface.TransformMethod.Helmert.__doc__ + '\n' + '* ``PolynomialOrder1``: ' + QgsGcpTransformerInterface.TransformMethod.PolynomialOrder1.__doc__ + '\n' + '* ``PolynomialOrder2``: ' + QgsGcpTransformerInterface.TransformMethod.PolynomialOrder2.__doc__ + '\n' + '* ``PolynomialOrder3``: ' + QgsGcpTransformerInterface.TransformMethod.PolynomialOrder3.__doc__ + '\n' + '* ``ThinPlateSpline``: ' + QgsGcpTransformerInterface.TransformMethod.ThinPlateSpline.__doc__ + '\n' + '* ``Projective``: ' + QgsGcpTransformerInterface.TransformMethod.Projective.__doc__ + '\n' + '* ``InvalidTransform``: ' + QgsGcpTransformerInterface.TransformMethod.InvalidTransform.__doc__
# --
QgsGcpTransformerInterface.TransformMethod.baseClass = QgsGcpTransformerInterface
# The following has been generated automatically from src/analysis/vector/geometry_checker/qgsgeometrycheck.h
QgsGeometryCheck.Flags.baseClass = QgsGeometryCheck
Flags = QgsGeometryCheck  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/analysis/georeferencing/qgsvectorwarper.h
# monkey patching scoped based enum
QgsVectorWarperTask.Result.Success.__doc__ = "Warping completed successfully"
QgsVectorWarperTask.Result.Canceled.__doc__ = "Task was canceled before completion"
QgsVectorWarperTask.Result.Error.__doc__ = "An error occurred while warping"
QgsVectorWarperTask.Result.__doc__ = "Task results\n\n" + '* ``Success``: ' + QgsVectorWarperTask.Result.Success.__doc__ + '\n' + '* ``Canceled``: ' + QgsVectorWarperTask.Result.Canceled.__doc__ + '\n' + '* ``Error``: ' + QgsVectorWarperTask.Result.Error.__doc__
# --
