# RTCP

This documentation describes how RTCP packets are processed in mediasoup.

Being a SFU, some received RTCP packets are locally consumed and others are ignored.

This document also describes which RTCP packets are locally generated by mediasoup.

mediasoup does not forward feedback information from a remote RTP receiver, which could incur in the remote sender modifying the transmition rate in a way that it would affect the reception quality for the overall participants in a router (i.e. limiting the remote RTP sender transmition rate).


### Sender Reports

mediasoup locally generates the Sender Reports of the streams it sends and processes the Sender Reports is receives from producer endpoints.

### Receiver Reports

mediasoup locally generates the Receiver Reports of the streams it receives and consumes the Receiver Reports from every remote RTP receivers.

The combination of Sender and Receiver Reports are used to determine the quality of each link. Information that is available at the JavaScript API level in order to determine the quality of each participant in the router.

### SDES

SDES information is locally consumed.

### BYE

This information is ignored.

### APP

This information is ignored.

### XR

Currently not implemented (ignored). The same logic should be applied as to Receiver Reports.

## RTP Feedback

### NACK

Received NACK requests are locally consumed. The solicited RTP packets are re-sent to the remote RTP receiver that requested them.

mediasoup locally generate NACK requests for remote senders.

### TMMBR / TMMBN

```
RFC 5104:
A receiver, translator, or mixer uses the Temporary Maximum Media
Stream Bit Rate Request (TMMBR, "timber") to request a sender to
limit the maximum bit rate for a media stream (see section 2.2) to,
or below, the provided value.
```

This information is ignored.

As for now, we do not limit the bit rate for the media streams as we are relying on locally generated reception reports (RR) to make the remote RTP senders adjust their transmition rates given such values.

### RTCP-SR-REQ

```
RFC 6051:
This memo outlines how RTP sessions are synchronised, and discusses
how rapidly such synchronisation can occur.  We show that most RTP
sessions can be synchronised immediately, but that the use of video
switching multipoint conference units (MCUs) or large source-specific
multicast (SSM) groups can greatly increase the synchronisation
delay.  This increase in delay can be unacceptable to some
applications that use layered and/or multi-description codecs.
```

This information is ignored.

### RAMS

This information is ignored.

### TLLEI

This information is ignored. In future it could be useful to acknowledge remote RTP receivers when mediasoup generates NACK request in order to avoid them sending them, which could generate the so called "feedback storm" or "NACK storm".

```
RFC 6642:
The RTCP TPLR message can be used by the intermediaries to
inform the receiver that the sender of the RTCP TPLR has received
reports that the indicated packets were lost and ask the receiver not
to send feedback to it regarding these packets.
```

### RTCP-ECN-FB

This information is ignored.

### PAUSE-RESUME

This information is ignored (and not even implemented in any RTP/WebRTC endpoint).

### Transport-wide Congestion Control (TCC)

Planned for v3.

## PS Feedback

### PLI

This information is locally consumed and generates a PLI request to the corresponding RTP sender.

Also it is locally sent when required. This is: a new participant joins the conference for a fast rendering by the rest of participants.

### SLI

This information is ignored.

### RPSI

This information is ignored.

### FIR

This information is locally consumed and generates a PLI request to the corresponding RTP sender.

### TSTR/TSTN

This information is ignored.

```
RFC 5104:
The Temporal-Spatial Trade-off Request (TSTR) instructs the video
encoder to change its trade-off between temporal and spatial
resolution.  Index values from 0 to 31 indicate monotonically a
desire for higher frame rate.
```

### VBCM

This information is ignored.

### PSLEI

Same applicability as **TLLEI**.

### AFB

This information is ignored except for the REMB messages, which is locally consumed.

### REMB

This information is locally consumed to perform sender side bandwidth estimation.

REMB RTCP is generated locally based on the remote bitrate estimation.


## Mediasoup internal behaviour for each type of RTCP

### Generic RTCP

|           | SR | RR | SDES | BYE | APP |
| --------- | -- | -- | ---- | --- | --- |
| Consumer  |  G |  C |      |     |     |
| Producer  |  C |  G |  C   |  I  |  I  |

### RTP Feedback RTCP

|           | NACK | TMMBR | TMMBN | TLLEI | ECN-FB | PAUSE-RESUME | TCC |
| --------- | ---- | ----- | ----- | ----- | ------ | ------------ | --- |
| Consumer  |   C  |   I   |   I   |   I   |    I   |       I      |     |
| Producer  |   G  |       |   I   |   I   |        |              |     |

## PS Feedback RTCP

|           | PLI | SLI | RPSI | FIR | TSTR | TSTN | VBCM | PSLI | AFB | REMB |
| --------- | --- | --- | ---- | --- | ---- | ---- | ---- | ---- | --- | ---- |
| Consumer  |  C  |  I  |  I   |  C  |  I   |      |  I   |      |  I  |  C   |
| Producer  |  G  |     |      |     |      |  I   |      |   I  |     |      |
| Transport |     |     |      |     |      |      |      |      |     |  G   |


( ): Does not apply.

(I): Ignore.

(C): Consume locally.

(B): Bypass.

(G): Generate locally.
