ITK Release 4.10
================

New Features

------------------------------------------------------------------------

-   Wrapping improvements

<!-- -->

-   -   ITK\_USE\_64BITS\_IDS supported on Windows
    -   Faster builds (CastXML calls and build targets reduced by half)
    -   Faster runtime loading and smaller binary size due to hidden
        symbol visibility
    -   Wrapping with BUILD\_SHARED\_LIBS disabled is supported
    -   Do not link to libpython when possible
    -   Filter types do not need to be specified when “Input=inputImage”
        is specified in the constructor
    -   Improved wrapping class coverage
    -   Visual Studio 2015 Update 2 Supported
    -   GCC 6.1 supported

<!-- -->

-   New Remote Module
    -   TwoProjectionRegistration
        -   2D-3D registration designed for radiotherapy
        -   <http://hdl.handle.net/10380/3245>

<!-- -->

-   Core Improvements
    -   Data and build tool downloads now over HTTPS
    -   Extended constexpr usage with ITK\_CONSTEXPR and
        ITKCONSTEXPR\_FUNC macros
    -   ITK\_USE\_64BITS\_IDS, required to process 4GB+ images on
        Windows, now enabled by default
    -   VNL updated and modernized
    -   CMake configuration major modernization
    -   vcl has been removed in favor of the standard libraries
    -   vnl\_math\_ function avoided in favor of std:: and itk::Math
    -   VNL had suppressed integer data conversion warnings on Visual
        Studio (C4257); this suppression has been removed and all
        warnings addressed
    -   Various improvements for building a module externally against an
        ITK build tree
    -   CMAKE\_POSITION\_INDEPENDENT\_CODE is enabled by default
    -   Improved EXERCISE\_BASIC\_OBJECT\_METHODS testing macro

<!-- -->

-   Filtering Improvements
    -   RGB pixel support added to itk::ImageToVTKImageFilter
    -   itk::Box\* filters moved out of the Review module
    -   itk::GaussianDerivativeOperator moved out of the Review module
    -   MaskLabel is deprecated in N4BiasFieldCorrectionFilter in favor
        any non-zero pixel

<!-- -->

-   Registration Improvements
    -   Fixed and moving masks added to the v4 registration methods

<!-- -->

-   Documentation Improvements
    -   Updates to the Software Guide, Doxygen, Wiki and Sphinx Examples
    -   New examples on to convert between ITK and VTK
    -   New example on how to perform vector image registration
    -   The ITK Software Guide describes how to add a third-party
        dependency to a module

<!-- -->

-   Third Party Library Updates
    -   pygccxml updated to v1.7.3
    -   GDCM updated to the release branch latest
    -   VNL updated to latest upstream
    -   MINC updated to the latest upstream
    -   SWIG updated to v3.0.8
    -   PCRE update to v8.38

Changes from v4.10rc02..v4.10.0

------------------------------------------------------------------------

Bradley Lowekamp (3):

`     COMP: Address uninitialized warning of size`\
`     COMP: Devirtualize private methods to prevent instantiation`\
`     COMP: Use well defined ZeroValue for unused initial value.`

Hans Johnson (1):

`     BUG: try_compile needs to have CMAKE_CXX_STANDARD passed`

Hyun Jae Kang (1):

`     COMP: Fix unexpected data-cast results of itkCastImageFilter`

Jon Haitz Legarreta (1):

`     BUG: Fix OpenCV-2.4.9 camera empty image issue.`

Matthew McCormick (13):

`     COMP: Bump CastXML for GCC 6.1 support.`\
`     STYLE: Improvements to HardConnectedComponentsImageFilter.`\
`     ENH: Add baseline for itkHardConnectedComponentImageFilterTest.`\
`     STYLE: Improvements for itkHardConnectedComponentImageFilterTest`\
`     COMP: HardConnectedComponentImageFilter autological constant out of range`\
`     DOC: Sphinx examples update to 2016-05-22.`\
`     DOC: Wiki examples update to 2016-05-22.`\
`     COMP: MSVC result of 32-bit shift implicitly converted to 64 bits`\
`     BUG: Disable building the netlib example.`\
`     ENH: Add FloatAddULP`\
`     BUG: Decrement index in BSplineTransform by ULPs.`\
`     BUG: Adjust index decrement in BSplineTransform`\
`     BUG: Remove VNL README left over from subtree merge.`

Sumedha Singla (1):

`     ENH: WhatModulesITK was not finding modules on Windows`

Changes from v4.10rc01..v4.10rc02

------------------------------------------------------------------------

Davis Vigneault (1):

`     BUG: Improve error checking and testing for ConnectedRegionsMesh`

Hyun Jae Kang (2):

`     BUG: Address the issue of `“`Missing`` ``Delete`”` within SwapZeroCornerToIRP.`\
`     COMP: Fixed Mac OSX wrapping configuration warning`

Matthew McCormick (6):

`     BUG: The ImageFileReader internal pipeline methods should be protected.`\
`     BUG: Use new VNL include directory variables.`\
`     COMP: Add missing NeighborhoodAccessor methods to PhasedArray3D image.`\
`     BUG: Adjust itk.org ExternalData URL.`\
`     COMP: Do not use target_include_directories with CMake 2.8.11.2.`\
`     BUG: Address missing shared_ptr for VS9`

Changes from v4.9.0..v4.10rc01

------------------------------------------------------------------------

Alvaro Sanchez (1):

`     STYLE: moved itkKappaSigmaThresholdImageFilter/Calculator from Nonunit/Review`

Andrey Fedorov (2):

`     BUG: Add missing itk_expat_mangle.h install target`\
`     BUG: fix typo in file name`

Bill Hoffman (2):

`     COMP: fix shared build on Windows when Review is on.`\
`     COMP: work around for VS 2015 optimizer bug causing test failures.`

Bill Lorensen (6):

`     ENH: Bump version for style fixups.`\
`     ENH: Bump wiki examples version, new remote module process`\
`     ENH: Bump wiki examples version, new remote module process`\
`     STYLE: SuperClass should be Superclass`\
`     COMP: Resolve clang linkage issue`\
`     BUG: Valgrind detected an invalid read`

Bradley Lowekamp (21):

`     BUG: Compilation problem with GCC 4.1 and explicit instantiation`\
`     ENH: Update Insight Journal handle links to https`\
`     ENH: Adding const qualifier to results`\
`     BUG: Adding missing const qualifier for GetConfusionMatrix method`\
`     BUG: Use Set/GetMacros, fix const correctness and PrintSelf.`\
`     ENH: added inlined Zero and one values for integer NumericTraits`\
`     ENH: Use constexpr for floating point NumericTraits`\
`     ENH: Make NumericTraits functions constexpr for intrinsic`\
`     BUG: Add definition of static constexpr NumericTrait members`\
`     BUG: Declared static constexpr members need to be defined as constexpr`\
`     ENH: ITK_CONSTEXPR_FUNC implies inline`\
`     BUG: Addressing VS10 and VS11 NumericTraits linkage issue`\
`     BUG: Use LargestPossible region for BSpline domain`\
`     BUG: Remove errant file`\
`     COMP: Address warning about this usage in initializer list`\
`     ENH: Prefer ZeroValue function over variable`\
`     STYLE: Use consistent path for try_compiles binary directory`\
`     BUG: Don't use `“`=`”` in cmake variable name`\
`     ENH: Test address of NumericTraits One and Zero constexpr`\
`     ENH: Use ITK_USE_64BITS_IDS for windows 64 by default`\
`     ENH: Enable run-time dependency on Python library`

Davis Vigneault (4):

`     ENH: Update itkFileTools to allow std::string arguments.`\
`     ENH: Add Floored and Truncated Modulus to VNL`\
`     ENH: Add Ternary Operator Image Filter`\
`     STYLE: Prefer static cast`

Dženan Zukić (1):

`     ENH: CovariantVector's Normalize returns the norm.`

Francois Budin (6):

`     PERF: Simplify itkTemplate New() input type identification.`\
`     ENH: Avoid template type specification for image reader in Python wrapping`\
`     BUG: Missing IOPixelType strings in ImageIOBase`\
`     BUG: Wrapping intermediate files were not automatically updated`\
`     ENH: Reduce number of dependencies for XML files generated for wrapping`\
`     BUG: GCC is limited when calling overloaded base class functions`

GCC-XML Upstream (1):

`     ENH: pygccxml v1.7.3 (reduced)`

GDCM Upstream (1):

`     GDCM 2015-09-02 (1efe9e28)`

Hans Johnson (27):

`     COMP: Static analysis warning`\
`     COMP: Incorrect delete found by static analysis`\
`     PERF:  Avoid temporary std:vector copying.`\
`     COMP: Provide VXL backward compatible includes`\
`     COMP: ITK requires legacy methods`\
`     ENH: Need propagate ITK_LIBRARY_PROPERTIES`\
`     ENH: Added UpdateFromUpstream.sh for VNL`\
`     ENH: Manual copy from vxl/master`\
`     STYLE: vnl_math_[min|max] -> std::[min|max]`\
`     STYLE: Text files should end with a newline`\
`     COMP: Prefer C++11 constexpr when possible`\
`     COMP: Prefer C++11 constexpr when possible`\
`     ENH: Simplify std:: math function definitions`\
`     COMP: Error in constexpr usage`\
`     COMP: Add const to previous const variables`\
`     COMP: SizeValueType can has different definition for itkArray`\
`     ENH: Added utility for modernizing vcl_ to std::`\
`     ENH: Reference vnl_math.h constants directly`\
`     ENH: Avoid using vnl_math_ functions`\
`     COMP: Missing symbol for itkStaticConstMacro`\
`     COMP: Function override missing in BioCell`\
`     ENH: Convert vcl_ to std::`\
`     BUG: Windows vcl_snprintf failures addressed`\
`     COMP: Disabmiguate function calls to SetData`\
`     ENH: Provided static code API for external applications`\
`     COMP: Remove possible type conversion warnings`\
`     ENH: Merge GDCM release branch`

Hyun Jae Kang (25):

`     COMP: Fixed the compiler error of ITKCommon2TestDriver on OSX 10.6`\
`     BUG: Fixed the runtime crash of VideoSourceTest on OSX 10.6`\
`     BUG: Fixed the runtime crash of itkTimeProbeTest2`\
`     BUG: Fixed the runtime crash of ITKFastMarchingTestDriver's tests on OSX 10.6`\
`     BUG: Fixed the runtime crash of ITKReviewTestDriver on OSX 10.6`\
`     COMP: Fixed the data conversion warning messages of itkResourceProbe`\
`     BUG: Fixed the runtime crash of itkLabelOverlapMeasuresImageFilterTest`\
`     BUG: Fixed the runtime crash of ITKStatisticsTestDriver tests on OSX 10.6`\
`     BUG: Fixed the runtime crash of itkMRIBiasFieldCorrectionFilterTest`\
`     BUG: Fixed the runtime crash of itkBinaryShapeOpeningImageFilterTest1`\
`     BUG: Fixed the runtime crash of vnl_test_complex on OSX 10.6`\
`     BUG: Fixed the runtime crash of vnl_test_numeric_traits`\
`     BUG: Fixed the runtime crash of test_pow_log on OSX 10.6`\
`     BUG: Exclude a test code of ITKLabelMapTestDriver on OSX 10.6`\
`     BUG: Fixed the failed test case of itkSTLThreadTest on OS X 10.8`\
`     COMP: Update KWStyle to utilize the latest boost library`\
`     COMP: Fixed the compiler error of ITK on Mingw-w64`\
`     COMP: Temporarily suppress the warning messages of data-conversion on VS14`\
`     COMP: Put back the disappeared option of `“`BUILD`` ``EXAMPLES`”`.`\
`     BUG: Fix segmentation faults on mingw-W64 x86_64.`\
`     BUG: Fix the failed test of itkCastImageFilterTest on mingw-w64 compiler.`\
`     COMP: Fixed the cmake configuration for ITK_WRAP_DOC`\
`     COMP: Fixed the warning messages on VS14.`\
`     COMP: Add a missing head file at itkNumericTraitsStdVector.h`\
`     COMP: Fix the wraning message of data-conversion`

Jean-Christophe Fillion-Robin (4):

`     COMP: ITKExternalModule: Support building module without test directory.`\
`     STYLE: Facilitate maintenance of CastXML generator refactoring CMakeLists`\
`     COMP: Allow use of multiple `“`ITK`` ``external`` ``modules`”` in the same project.`\
`     STYLE: UseITK: Document static registration of ITK IO factories. See #3393`

Jon Haitz Legarreta (7):

`     COMP: Delete unused variable compiler warning.`\
`     ENH: Refactored itkBioCellTest`\
`     ENH: Exercise non-tested itk::Math methods.`\
`     ENH: Improve MersenneTwister class and test.`\
`     ENH: Improve itkFEMLoadPoint coverage.`\
`     ENH: Improve itkVersion class code coverage.`\
`     ENH: Perform class name checks in test macro`

KWSys Robot (1):

`     KWSys 2016-03-09 (36d8666f)`

Lucas Gandel (9):

`     ENH: Implement GetNumberOfParameter() in ImageToSpatialObjectMetric`\
`     COMP: Enable wrapping of multiple `“`ITK`` ``external`` ``modules`”` in the same project`\
`     COMP: Fix CASTXML_EXECUTABLE value for multiple external module`\
`     COMP: Fix external module testing`\
`     COMP: Fix git protocol setup`\
`     ENH: Conditionally add testing for External Modules`\
`     BUG: Fix call to std::max() with different variable types`

Manuel Grizonnet (1):

`     COMP: add ITKCommon_EXPORT to fix link issues with external applications`

Matthew McCormick (73):

`     ENH: Add TwoProjectionRegistration Remote Module.`\
`     ENH: Allow ITKVideoBridgeOpenCV to be built externally.`\
`     COMP: Add export specification for itk::ResourceProbe.`\
`     ENH: Do not force shared libraries when wrapping.`\
`     BUG: BUILD_TESTING should be not advanced.`\
`     ENH: Bump ITK version to 4.10.0.`\
`     DOC: Correct ITKImageNoise description spelling.`\
`     ENH: Wrap FFTNormalizedCorrelationImageFilter.`\
`     BUG: Remove Azure ExternalData resource.`\
`     BUG: ExternalData downloads from midas3.kitware.com only supports https.`\
`     BUG: Update ExternalData resource.`\
`     BUG: slicer.kitware.com/midas3/ ExternalData will not support http.`\
`     ENH: Add ITK_CUSTOM_LIBRARY_SUFFIX variable.`\
`     ENH: Wrap PipelineMonitorImageFilter.`\
`     BUG: Update MIDAS url for https in archive testing data script.`\
`     ENH: Wrap std::vector< itk::ImageRegion >.`\
`     BUG: Fix wrapping build with DEFAULT_MODULES OFF.`\
`     ENH: Add RGB pixel support to ImageToVTKImageFilter.`\
`     ENH: Add RGB and vector pixel type wrapping for ImageToVTKImageFilter.`\
`     STYLE: Use PixelType and ImageType in Python tests.`\
`     ENH: Avoid template type specification in Python wrapping.`\
`     COMP: Do not use has_key in itkTemplate New.`\
`     DOC: Emphasize that push access is not required to contribute patches.`\
`     ENH: Download SWIG and PCRE from midas3.kitware.com.`\
`     COMP: Ignore build warning from KWStyle's boost.`\
`     BUG: Remove Azure ExternalData resource.`\
`     BUG: ExternalData downloads from midas3.kitware.com only supports https.`\
`     BUG: slicer.kitware.com/midas3/ ExternalData will not support http.`\
`     ENH: Update the VNL README-ITK.txt subtree commit revision.`\
`     BUG: Mark VXL internal CMake variables as advanced.`\
`     BUG: Run itk_module_target on itknetlib.`\
`     DOC: Direct patches for VXL upstream to the GitHub repository.`\
`     BUG: Run itk_module_target on itknetlib.`\
`     COMP: Account for removal of vcl_* from upstream VXL.`\
`     COMP: Remove itkTypeMacro from BioCellHelper.`\
`     COMP: Convert itkBioCellTest arguments from double to int.`\
`     COMP: Turn off BUILD_DOCUMENTATION for VNL.`\
`     BUG: Install VXL config files to backwards-compatible locations.`\
`     ENH: Remove vcl_complex from the wrapping.`\
`     BUG: Install vnl_export.h and vnl_algo_export.h to previous locations.`\
`     BUG: midas3.kitware.com only supports the https protocol.`\
`     BUG: ImageIOBase SetDimensions should take SizeValueType.`\
`     ENH: Add wrapping for ImagePCAShapeModelEstimator.`\
`     COMP: Do not specify COMPONENTS with find_package(VTK.`\
`     DOC: Fix FFTW warning grammar.`\
`     COMP: Build against system HDF5 1.8.16.`\
`     ENH: Set a default CMAKE_BUILD_TYPE when building a module externally`\
`     COMP: Make initial HDF5 discovery of 1.8.16 quiet.`\
`     ENH: Use hidden symbol visibility for the CPython extension modules.`\
`     ENH: Turn on CMAKE_POSITION_INDEPENDENT_CODE by default.`\
`     BUG: FEMLoadPoint uninitialized value in the constructor.`\
`     BUG: Fix wrapping of complex types in VNL.`\
`     ENH: Bump CMakeLists.txt version 4.9.1.`\
`     COMP: Address ITKCommon Python submodule order.`\
`     BUG: Extend ExternalData_TIMEOUT_ABSOLUTE to 900 seconds.`\
`     BUG: Do not run KWStyle Git config on a release tarball.`\
`     COMP: Ambiguous RGBPixel access in CustomColormapFunction.`\
`     BUG: Prevent division by zero in PhasedArray3DSpecialCoordinatesImage.`\
`     BUG: Initialize azimuth and elevation to pi/2 in PhasedArray3D.`\
`     BUG: Increase MaskLabel backwards compatibility in N4 bias correction.`\
`     ENH: Deprecate MaskLabel in N4BiasFieldCorrectionImageFilter.`\
`     COMP: Update CastXML to support Visual Studio 2015 Update 2.`\
`     COMP: Do not set wrapping library visibility with static builds.`\
`     COMP: Update CastXML to support Visual Studio 2015 Update 2.`\
`     COMP: Broaden the KWStyle warning exception.`\
`     COMP: Update KWStyle version.`\
`     BUG: Do not use the same output file in N4BiasField Test 2,3.`\
`     COMP: Expand EXERCISE_BASIC_OBJECT_METHODS for other GCC versions.`\
`     ENH: Update Cuberille Remote to 2015-05-01.`\
`     ENH: Enable registration of the IOOpenSlide module through CMake.`\
`     ENH: Update itk.org URL's for HTTPS support.`\
`     BUG: Use CastXML built against LLVM with LLVM_ENABLE_TERMINFO OFF.`\
`     BUG: Fix Python wrapping on Windows when ITK_USE_64BIT_IDS is ON.`

Michka Popoff (12):

`     ENH: Use importlib for python 3.4 instead of imp`\
`     ENH: Update to Swig 3.0.8`\
`     ENH: Update PCRE to version 8.38`\
`     ENH: Wrap RayCastInterpolateImageFunction`\
`     ENH: Wrap RayCastInterpolateImageFunction`\
`     COMP: Remove debug output after vcl_complex removal from wrapping`\
`     ENH: Consolidate .idx file generation with swig .i generation.`\
`     ENH: Update UpdatepygccxmlFromUpstream.sh script`\
`     COMP: Set CastXML path and name for pygccxml 1.7.3`\
`     COMP: Fix RayCastInterpolateImageFunction wrapping for image dim 2`\
`     ENH: Use argparse instead of optparse in igenerator.py`\
`     ENH: Use https URL for OS X castxml binary (for consistency)`

Nick Tustison (2):

`     ENH:  Add fixed/moving masking in reg. methods.`\
`     ENH:  Making the mask usage consistent with ITK.`

Pablo Hernandez-Cerdan (1):

`     COMP: Fix warn in FFTW about delete [].`

Sean McBride (18):

`     COMP: Made script OS X compatible`\
`     COMP: mark GDCM GetSeriesHelper() method as deprecated`\
`     BUG: update script to fetch GDCM from its release-2-4 branch instead of master`\
`     DOC: Updated comment to reflect new GDCM version`\
`     COMP: Fixed recently introduced build error with deprecated GDCM method`\
`     BUG: Fixed invalid memory access found by ASan`\
`     COMP: Fixed clang warning about macro expansion giving defined`\
`     COMP: Fixed minor dashboards warnings and typos.`\
`     COMP: Fixed a bunch of clang -Wunreachable-code-break warnings`\
`     COMP: fixed some dashboard warnings (dead code, false positive)`\
`     BUG: Fixed off-by-1 error found by ASan`\
`     COMP: Fixed clang -Wcomma warning`\
`     COMP: Introduce ITK_FALLTHROUGH, to suppress switch fall through warnings`\
`     COMP: Fixed -Wwritable-strings warnings`\
`     COMP: Fixed remaining -Wcomma warnings`\
`     ENH: switch gdcm to release branch, not release-2-4`\
`     COMP: Hack HDF5 to build under ASan & UBSan`\
`     COMP: fixed clang -Wdeprecated-writable-strings warning`

Shawn Waldon (1):

`     STYLE: move itkGaussianDerivativeOperator`

Sujin Philip (1):

`     STYLE: Move itkBox* Filters`

Sumedha Singla (3):

`     ENH: Issue: ITK#3363 Replaced assignment in SetParameters function.`\
`     ENH: Remove unnecessary const_cast`\
`     BUG: Fixed the test itkHDF5ImageIOTest`

VXL Maintainers (9):

`     VNL 2015-11-22 (ea1d60fb)`\
`     VNL 2016-03-02 (cb31149e)`\
`     VNL 2016-03-13 (ae34f0fc)`\
`     VNL 2016-03-15 (751698ab)`\
`     VNL 2016-03-19 (df10fefa)`\
`     VNL 2016-03-25 (f0040231)`\
`     VNL 2016-03-30 (88f50849)`\
`     VNL 2016-04-22 (0ed18124)`\
`     VNL 2016-04-26 (6b168535)`

Vladimir S. FONOV (3):

`     MINC 2015-12-17 (dcb93a5f)`\
`     MINC 2016-01-30 (783bca38)`\
`     MINC 2016-02-24 (8632513e)`

Ziv Yaniv (1):

`     BUG: Interpretation of the Euler angles ZYX or ZXY was not exported.`

ITK Sphinx Examples Changelog

------------------------------------------------------------------------

Dženan Zukić (1):

`     ENH: Default is current directory. Avoid usage of the class SeriesHelper.`

Matt McCormick (19):

`     BUG: Do not depend on the VTK/OpenCV build when system provided.`\
`     ENH: Add ConvertAnitkImageTovtkImageData example.`\
`     ENH: Bump VTK's superbuild version to 7.0.0.`\
`     STYLE: CMake style updates to AddOffsetToIndex/CMakeLists.txt`\
`     ENH: Updates to CreateNewExample.py.in`\
`     ENH: Add ConvertvtkImageDataToAnitkImage example.`\
`     ENH: Update sphinx-bootstrap-theme to v0.4.8`\
`     ENH: Add Python version of StreamAPipeline.`\
`     ENH: Add ConvertAnRGBitkImageTovtkImageData`\
`     ENH: Add a PACE progress bar.`\
`     ENH: Add more Python content to CreateNewExample.py.`\
`     ENH: Add ConvertRGBvtkImageDataToAnitkImage`\
`     BUG: Disable Create3DVolume Python baseline test.`\
`     ENH: Add PerformRegistrationOnVectorImages.`\
`     ENH: Update itk.org URL's for HTTPS support.`\
`     COMP: Use itk::IndexValueType for subdomain index.`\
`     COMP: Bump OpenCV to 3.1.0.`\
`     BUG: Fix superbuild dependencies.`\
`     ENH: Bump ITK to v4.10.0.`

ITK Software Guide Changelog

------------------------------------------------------------------------

Matt McCormick (6):

`     DOC: Correct spelling in the wrapping description.`\
`     BUG: ExternalData servers now use https.`\
`     ENH: Update itk.org URL's for HTTPS support.`\
`     DOC: Adding wrapper .dll's to PATH on Windows is no longer necessary.`\
`     DOC: Document how to add a third-party dependency to a module.`\
`     ENH: Bump ITK ExternalProject to v4.10.0`
