/* do not edit automatically generated by mc from PCSymBuild.  */
/* PCSymBuild.mod pass C symbol creation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _PCSymBuild_C

#include "GPCSymBuild.h"
#   include "GStorage.h"
#   include "GNameKey.h"
#   include "GStrIO.h"
#   include "GNumberIO.h"
#   include "GM2Debug.h"
#   include "GM2Error.h"
#   include "GM2MetaError.h"
#   include "GM2LexBuf.h"
#   include "GM2Reserved.h"
#   include "GM2Const.h"
#   include "GIndexing.h"
#   include "GM2Quads.h"
#   include "GM2Options.h"
#   include "GStdIO.h"
#   include "GM2System.h"
#   include "GM2Base.h"
#   include "GSymbolTable.h"
#   include "GM2Batch.h"
#   include "GM2Comp.h"
#   include "GM2StackAddress.h"
#   include "GM2StackWord.h"

#   define Debugging false
typedef struct PCSymBuild_eDes_r PCSymBuild_eDes;

typedef struct PCSymBuild_eLeaf_r PCSymBuild_eLeaf;

typedef struct PCSymBuild_eUnary_r PCSymBuild_eUnary;

typedef struct PCSymBuild_eBinary_r PCSymBuild_eBinary;

typedef struct PCSymBuild_eExpr_r PCSymBuild_eExpr;

typedef struct PCSymBuild_eFunction_r PCSymBuild_eFunction;

typedef struct PCSymBuild_eConvert_r PCSymBuild_eConvert;

typedef struct PCSymBuild_eNode_r PCSymBuild_eNode;

typedef PCSymBuild_eNode *PCSymBuild_exprNode;

typedef enum {PCSymBuild_leaf, PCSymBuild_unary, PCSymBuild_binary, PCSymBuild_designator, PCSymBuild_expr, PCSymBuild_convert, PCSymBuild_function} PCSymBuild_tagType;

struct PCSymBuild_eDes_r {
                           unsigned int type;
                           M2Const_constType meta;
                           unsigned int sym;
                           PCSymBuild_exprNode left;
                         };

struct PCSymBuild_eLeaf_r {
                            unsigned int type;
                            M2Const_constType meta;
                            unsigned int sym;
                          };

struct PCSymBuild_eUnary_r {
                             unsigned int type;
                             M2Const_constType meta;
                             PCSymBuild_exprNode left;
                             NameKey_Name op;
                           };

struct PCSymBuild_eBinary_r {
                              unsigned int type;
                              M2Const_constType meta;
                              PCSymBuild_exprNode left;
                              PCSymBuild_exprNode right;
                              NameKey_Name op;
                            };

struct PCSymBuild_eExpr_r {
                            unsigned int type;
                            M2Const_constType meta;
                            PCSymBuild_exprNode left;
                          };

struct PCSymBuild_eFunction_r {
                                unsigned int type;
                                M2Const_constType meta;
                                unsigned int func;
                                PCSymBuild_exprNode first;
                                PCSymBuild_exprNode second;
                                bool third;
                              };

struct PCSymBuild_eConvert_r {
                               unsigned int type;
                               M2Const_constType meta;
                               PCSymBuild_exprNode totype;
                               PCSymBuild_exprNode expr;
                             };

struct PCSymBuild_eNode_r {
                            PCSymBuild_tagType tag;  /* case tag */
                            union {
                                    PCSymBuild_eDes edes;
                                    PCSymBuild_eLeaf eleaf;
                                    PCSymBuild_eUnary eunary;
                                    PCSymBuild_eBinary ebinary;
                                    PCSymBuild_eExpr eexpr;
                                    PCSymBuild_eFunction efunction;
                                    PCSymBuild_eConvert econvert;
                                  };
                          };

static M2StackAddress_StackOfAddress exprStack;
static Indexing_Index constList;
static unsigned int constToken;
static M2StackWord_StackOfWord desStack;
static bool inDesignator;

/*
   CheckNotVar - checks to see that the top of stack is not a variable.
*/

extern "C" void PCSymBuild_CheckNotVar (unsigned int tok);
extern "C" void PCSymBuild_PCStartBuildDefModule (void);
extern "C" void PCSymBuild_PCEndBuildDefModule (void);
extern "C" void PCSymBuild_PCStartBuildImpModule (void);
extern "C" void PCSymBuild_PCEndBuildImpModule (void);
extern "C" void PCSymBuild_PCStartBuildProgModule (void);
extern "C" void PCSymBuild_PCEndBuildProgModule (void);
extern "C" void PCSymBuild_PCStartBuildInnerModule (void);
extern "C" void PCSymBuild_PCEndBuildInnerModule (void);
extern "C" void PCSymBuild_PCBuildProcedureHeading (void);
extern "C" void PCSymBuild_PCStartBuildProcedure (void);
extern "C" void PCSymBuild_PCEndBuildProcedure (void);
extern "C" void PCSymBuild_PCEndBuildForward (void);
extern "C" void PCSymBuild_PCBuildImportOuterModule (void);
extern "C" void PCSymBuild_PCBuildImportInnerModule (void);

/*
   BuildNulName - Pushes a NulKey onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulKey     |
                                           |------------|
*/

extern "C" void PCSymBuild_BuildNulName (void);

/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->                                      <- Ptr
                +------------+        +------------+
                | Name       |        | Sym        |
                |------------+        |------------|
*/

extern "C" void PCSymBuild_BuildConst (void);

/*
   StartDesConst -
*/

extern "C" void PCSymBuild_StartDesConst (void);

/*
   EndDesConst -
*/

extern "C" void PCSymBuild_EndDesConst (void);

/*
   BuildRelationConst - builds a relationship binary operation.
*/

extern "C" void PCSymBuild_BuildRelationConst (void);

/*
   BuildUnaryConst - builds a unary operator node.
*/

extern "C" void PCSymBuild_BuildUnaryConst (void);

/*
   BuildBinaryConst - builds a binary operator node.
*/

extern "C" void PCSymBuild_BuildBinaryConst (void);

/*
   PushConstFunctionType -
*/

extern "C" void PCSymBuild_PushConstFunctionType (void);

/*
   PushIntegerType -
*/

extern "C" void PCSymBuild_PushIntegerType (void);

/*
   PushRType -
*/

extern "C" void PCSymBuild_PushRType (void);

/*
   PushStringType -
*/

extern "C" void PCSymBuild_PushStringType (void);

/*
   SkipConst - returns an alias to constant, sym, if one exists.
               Otherwise sym is returned.
*/

extern "C" unsigned int PCSymBuild_SkipConst (unsigned int sym);

/*
   PushConstType - pushes a constant to the expression stack.
*/

extern "C" void PCSymBuild_PushConstType (void);

/*
   PushConstAttributeType -
*/

extern "C" void PCSymBuild_PushConstAttributeType (void);

/*
   PushConstAttributePairType -
*/

extern "C" void PCSymBuild_PushConstAttributePairType (void);

/*
   PushConstructorCastType -
*/

extern "C" void PCSymBuild_PushConstructorCastType (void);

/*
   PushInConstructor -
*/

extern "C" void PCSymBuild_PushInConstructor (void);

/*
   PopInConstructor -
*/

extern "C" void PCSymBuild_PopInConstructor (void);

/*
   ResolveConstTypes - resolves the types of all designator declared constants.
*/

extern "C" void PCSymBuild_ResolveConstTypes (void);

/*
   GetSkippedType -
*/

static unsigned int GetSkippedType (unsigned int sym);

/*
   InitDesExpr -
*/

static void InitDesExpr (unsigned int des);

/*
   DebugNode -
*/

static void DebugNode (PCSymBuild_exprNode d);

/*
   DebugDes -
*/

static void DebugDes (PCSymBuild_exprNode d);

/*
   DebugSym -
*/

static void DebugSym (unsigned int sym);

/*
   DebugMeta -
*/

static void DebugMeta (M2Const_constType m);

/*
   DebugType -
*/

static void DebugType (unsigned int type);

/*
   DebugExpr -
*/

static void DebugExpr (PCSymBuild_exprNode e);

/*
   DebugFunction -
*/

static void DebugFunction (PCSymBuild_exprNode f);

/*
   DebugConvert -
*/

static void DebugConvert (PCSymBuild_exprNode f);

/*
   DebugLeaf -
*/

static void DebugLeaf (PCSymBuild_exprNode l);

/*
   DebugUnary -
*/

static void DebugUnary (PCSymBuild_exprNode l);

/*
   DebugBinary -
*/

static void DebugBinary (PCSymBuild_exprNode l);

/*
   DebugOp -
*/

static void DebugOp (NameKey_Name op);

/*
   fixupProcedureType - creates a proctype from a procedure.
*/

static unsigned int fixupProcedureType (unsigned int p);

/*
   InitFunction -
*/

static void InitFunction (M2Const_constType m, unsigned int p, unsigned int t, PCSymBuild_exprNode f, PCSymBuild_exprNode s, bool more);

/*
   InitConvert -
*/

static void InitConvert (M2Const_constType m, unsigned int t, PCSymBuild_exprNode to, PCSymBuild_exprNode e);

/*
   InitLeaf -
*/

static void InitLeaf (M2Const_constType m, unsigned int s, unsigned int t);

/*
   InitProcedure -
*/

static void InitProcedure (unsigned int s);

/*
   InitCharType -
*/

static void InitCharType (unsigned int s);

/*
   InitZType -
*/

static void InitZType (unsigned int s);

/*
   InitRType -
*/

static void InitRType (unsigned int s);

/*
   InitUnknown -
*/

static void InitUnknown (unsigned int s);

/*
   InitBooleanType -
*/

static void InitBooleanType (unsigned int s);

/*
   TypeToMeta -
*/

static M2Const_constType TypeToMeta (unsigned int type);

/*
   buildConstFunction - we are only concerned about resolving the return type of
                        a function, so we can ignore all parameters - except
                        the first one in the case of VAL(type, foo)
                        and the type of bar in MIN (bar) and MAX (bar).
                        buildConstFunction uses a unary exprNode to represent
                        a function.
*/

static void buildConstFunction (unsigned int func, unsigned int n);

/*
   ErrorConstFunction - generate an error message at functok using func in the
                        error message providing it is not NulSym.
*/

static void ErrorConstFunction (unsigned int func, unsigned int functok);

/*
   InitBinary -
*/

static void InitBinary (M2Const_constType m, unsigned int t, NameKey_Name o);

/*
   InitUnary -
*/

static void InitUnary (M2Const_constType m, unsigned int t, NameKey_Name o);

/*
   isTypeResolved -
*/

static bool isTypeResolved (PCSymBuild_exprNode e);

/*
   getEtype -
*/

static unsigned int getEtype (PCSymBuild_exprNode e);

/*
   getEmeta -
*/

static M2Const_constType getEmeta (PCSymBuild_exprNode e);

/*
   assignTM -
*/

static void assignTM (unsigned int *td, M2Const_constType *md, unsigned int te, M2Const_constType me);

/*
   assignType -
*/

static void assignType (PCSymBuild_exprNode d, PCSymBuild_exprNode e);

/*
   deduceTypes - works out the type and metatype given, l, and, r.
*/

static void deduceTypes (unsigned int *t, M2Const_constType *m, PCSymBuild_exprNode l, PCSymBuild_exprNode r, NameKey_Name op);

/*
   WalkConvert -
*/

static bool WalkConvert (PCSymBuild_exprNode e);

/*
   WalkFunctionParam -
*/

static bool WalkFunctionParam (unsigned int func, PCSymBuild_exprNode e);

/*
   WalkFunction -
*/

static bool WalkFunction (PCSymBuild_exprNode e);

/*
   doWalkNode -
*/

static bool doWalkNode (PCSymBuild_exprNode e);

/*
   WalkLeaf -
*/

static bool WalkLeaf (PCSymBuild_exprNode e);

/*
   WalkUnary -
*/

static bool WalkUnary (PCSymBuild_exprNode e);

/*
   WalkBinary -
*/

static bool WalkBinary (PCSymBuild_exprNode e);

/*
   WalkExpr -
*/

static bool WalkExpr (PCSymBuild_exprNode e);

/*
   doWalkDesExpr - returns TRUE if the expression trees, d, or, e, are changed.
*/

static bool doWalkDesExpr (PCSymBuild_exprNode d, PCSymBuild_exprNode e);

/*
   doWalkDes - return TRUE if expression, e, is changed.
*/

static bool doWalkDes (PCSymBuild_exprNode d);

/*
   findConstDes -
*/

static PCSymBuild_exprNode findConstDes (unsigned int sym);

/*
   WalkDes - return TRUE if expression, e, is changed.
*/

static bool WalkDes (PCSymBuild_exprNode d);

/*
   WalkConsts - walk over the constant trees and return TRUE if any tree was changed.
                (As a result of a type resolution).
*/

static bool WalkConsts (void);

/*
   DebugNodes -
*/

static void DebugNodes (void);

/*
   findAlias -
*/

static unsigned int findAlias (unsigned int sym, PCSymBuild_exprNode e);

/*
   CheckConsts -
*/

static void CheckConsts (void);

/*
   Init -
*/

static void Init (void);


/*
   GetSkippedType -
*/

static unsigned int GetSkippedType (unsigned int sym)
{
  return SymbolTable_SkipType (SymbolTable_GetType (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitDesExpr -
*/

static void InitDesExpr (unsigned int des)
{
  PCSymBuild_exprNode e;

  Storage_ALLOCATE ((void **) &e, sizeof (PCSymBuild_eNode));
  e->tag = PCSymBuild_designator;
  switch (e->tag)
    {
      case PCSymBuild_designator:
        e->edes.type = SymbolTable_NulSym;
        e->edes.meta = M2Const_unknown;
        e->tag = PCSymBuild_designator;
        e->edes.sym = des;
        e->edes.left = NULL;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting designator", 20);
        break;
    }
  M2StackAddress_PushAddress (exprStack, reinterpret_cast <void *> (e));
}


/*
   DebugNode -
*/

static void DebugNode (PCSymBuild_exprNode d)
{
  if (Debugging && (d != NULL))
    {
      switch (d->tag)
        {
          case PCSymBuild_designator:
            DebugDes (d);
            break;

          case PCSymBuild_expr:
            DebugExpr (d);
            break;

          case PCSymBuild_leaf:
            DebugLeaf (d);
            break;

          case PCSymBuild_unary:
            DebugUnary (d);
            break;

          case PCSymBuild_binary:
            DebugBinary (d);
            break;

          case PCSymBuild_function:
            DebugFunction (d);
            break;

          case PCSymBuild_convert:
            DebugConvert (d);
            break;


          default:
            CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
            __builtin_unreachable ();
        }
    }
}


/*
   DebugDes -
*/

static void DebugDes (PCSymBuild_exprNode d)
{
  DebugSym (d->edes.sym);
  StdIO_Write (':');
  DebugMeta (d->edes.meta);
  StdIO_Write (':');
  DebugType (d->edes.type);
  StrIO_WriteString ((const char *) " = ", 3);
  DebugNode (d->edes.left);
  StrIO_WriteLn ();
}


/*
   DebugSym -
*/

static void DebugSym (unsigned int sym)
{
  NameKey_Name n;

  n = SymbolTable_GetSymName (sym);
  if (n != NameKey_NulName)
    {
      NameKey_WriteKey (n);
    }
  StdIO_Write (':');
  NumberIO_WriteCard (sym, 0);
}


/*
   DebugMeta -
*/

static void DebugMeta (M2Const_constType m)
{
  switch (m)
    {
      case M2Const_unknown:
        StrIO_WriteString ((const char *) "unknown", 7);
        break;

      case M2Const_set:
        StrIO_WriteString ((const char *) "set", 3);
        break;

      case M2Const_str:
        StrIO_WriteString ((const char *) "str", 3);
        break;

      case M2Const_constructor:
        StrIO_WriteString ((const char *) "constructor", 11);
        break;

      case M2Const_array:
        StrIO_WriteString ((const char *) "array", 5);
        break;

      case M2Const_cast:
        StrIO_WriteString ((const char *) "cast", 4);
        break;

      case M2Const_boolean:
        StrIO_WriteString ((const char *) "boolean", 7);
        break;

      case M2Const_ztype:
        StrIO_WriteString ((const char *) "ztype", 5);
        break;

      case M2Const_rtype:
        StrIO_WriteString ((const char *) "rtype", 5);
        break;

      case M2Const_ctype:
        StrIO_WriteString ((const char *) "ctype", 5);
        break;

      case M2Const_procedure:
        StrIO_WriteString ((const char *) "procedure", 9);
        break;

      case M2Const_char:
        StrIO_WriteString ((const char *) "ctype", 5);
        break;


      default:
        CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
        __builtin_unreachable ();
    }
}


/*
   DebugType -
*/

static void DebugType (unsigned int type)
{
  NameKey_Name n;

  StrIO_WriteString ((const char *) "[type:", 6);
  if (type == SymbolTable_NulSym)
    {
      StrIO_WriteString ((const char *) "<nulsym>", 8);
    }
  else
    {
      n = SymbolTable_GetSymName (type);
      if (n != SymbolTable_NulSym)
        {
          NameKey_WriteKey (n);
        }
      StdIO_Write (':');
      NumberIO_WriteCard (type, 0);
    }
  StdIO_Write (']');
}


/*
   DebugExpr -
*/

static void DebugExpr (PCSymBuild_exprNode e)
{
  StrIO_WriteString ((const char *) "expr (", 6);
  DebugType (e->eexpr.type);
  StdIO_Write (':');
  DebugMeta (e->eexpr.meta);
  StdIO_Write (' ');
  DebugNode (e->eexpr.left);
  StrIO_WriteString ((const char *) ") ", 2);
}


/*
   DebugFunction -
*/

static void DebugFunction (PCSymBuild_exprNode f)
{
  NameKey_WriteKey (SymbolTable_GetSymName (f->efunction.func));
  StdIO_Write ('(');
  if (f->efunction.first != NULL)
    {
      DebugNode (f->efunction.first);
      if (f->efunction.second != NULL)
        {
          StrIO_WriteString ((const char *) ", ", 2);
          DebugNode (f->efunction.second);
          if (f->efunction.third)
            {
              StrIO_WriteString ((const char *) ", ...", 5);
            }
        }
    }
  StdIO_Write (')');
}


/*
   DebugConvert -
*/

static void DebugConvert (PCSymBuild_exprNode f)
{
  DebugNode (f->econvert.totype);
  StdIO_Write ('(');
  DebugNode (f->econvert.expr);
  StdIO_Write (')');
}


/*
   DebugLeaf -
*/

static void DebugLeaf (PCSymBuild_exprNode l)
{
  StrIO_WriteString ((const char *) "leaf (", 6);
  DebugType (l->eleaf.type);
  StdIO_Write (':');
  DebugMeta (l->eleaf.meta);
  StdIO_Write (':');
  DebugSym (l->eleaf.sym);
  StrIO_WriteString ((const char *) ") ", 2);
}


/*
   DebugUnary -
*/

static void DebugUnary (PCSymBuild_exprNode l)
{
  StrIO_WriteString ((const char *) "unary (", 7);
  DebugType (l->eunary.type);
  StdIO_Write (':');
  DebugMeta (l->eunary.meta);
  StdIO_Write (' ');
  DebugOp (l->eunary.op);
  StdIO_Write (' ');
  DebugNode (l->eunary.left);
  StrIO_WriteString ((const char *) ") ", 2);
}


/*
   DebugBinary -
*/

static void DebugBinary (PCSymBuild_exprNode l)
{
  StrIO_WriteString ((const char *) "unary (", 7);
  DebugType (l->ebinary.type);
  StdIO_Write (':');
  DebugMeta (l->ebinary.meta);
  StdIO_Write (' ');
  DebugNode (l->ebinary.left);
  DebugOp (l->ebinary.op);
  StdIO_Write (' ');
  DebugNode (l->ebinary.right);
  StrIO_WriteString ((const char *) ") ", 2);
}


/*
   DebugOp -
*/

static void DebugOp (NameKey_Name op)
{
  NameKey_WriteKey (op);
}


/*
   fixupProcedureType - creates a proctype from a procedure.
*/

static unsigned int fixupProcedureType (unsigned int p)
{
  unsigned int tok;
  unsigned int par;
  unsigned int t;
  unsigned int n;
  unsigned int i;

  if (SymbolTable_IsProcedure (p))
    {
      tok = M2LexBuf_GetTokenNo ();
      t = SymbolTable_MakeProcType (tok, SymbolTable_CheckAnonymous (NameKey_NulName));
      i = 1;
      n = SymbolTable_NoOfParamAny (p);
      while (i <= n)
        {
          par = SymbolTable_GetParam (p, i);
          if (SymbolTable_IsParameterVar (par))
            {
              SymbolTable_PutProcTypeVarParam (tok, t, SymbolTable_GetType (par), SymbolTable_IsParameterUnbounded (par));
            }
          else
            {
              SymbolTable_PutProcTypeParam (tok, t, SymbolTable_GetType (par), SymbolTable_IsParameterUnbounded (par));
            }
          i += 1;
        }
      if ((SymbolTable_GetType (p)) != SymbolTable_NulSym)
        {
          SymbolTable_PutFunction (tok, t, SymbolTable_ProperProcedure, SymbolTable_GetType (p));
        }
      return t;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting a procedure", 21);
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitFunction -
*/

static void InitFunction (M2Const_constType m, unsigned int p, unsigned int t, PCSymBuild_exprNode f, PCSymBuild_exprNode s, bool more)
{
  PCSymBuild_exprNode n;

  Storage_ALLOCATE ((void **) &n, sizeof (PCSymBuild_eNode));
  n->tag = PCSymBuild_function;
  switch (n->tag)
    {
      case PCSymBuild_function:
        n->efunction.meta = m;
        n->efunction.type = t;
        n->efunction.func = p;
        n->efunction.first = f;
        n->efunction.second = s;
        n->efunction.third = more;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting function", 18);
        break;
    }
  M2StackAddress_PushAddress (exprStack, reinterpret_cast <void *> (n));
}


/*
   InitConvert -
*/

static void InitConvert (M2Const_constType m, unsigned int t, PCSymBuild_exprNode to, PCSymBuild_exprNode e)
{
  PCSymBuild_exprNode n;

  Storage_ALLOCATE ((void **) &n, sizeof (PCSymBuild_eNode));
  n->tag = PCSymBuild_convert;
  switch (n->tag)
    {
      case PCSymBuild_convert:
        n->econvert.type = t;
        n->econvert.meta = m;
        n->econvert.totype = to;
        n->econvert.expr = e;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting convert", 17);
        break;
    }
  M2StackAddress_PushAddress (exprStack, reinterpret_cast <void *> (n));
}


/*
   InitLeaf -
*/

static void InitLeaf (M2Const_constType m, unsigned int s, unsigned int t)
{
  PCSymBuild_exprNode l;

  Storage_ALLOCATE ((void **) &l, sizeof (PCSymBuild_eNode));
  l->tag = PCSymBuild_leaf;
  switch (l->tag)
    {
      case PCSymBuild_leaf:
        l->eleaf.type = t;
        l->eleaf.meta = m;
        l->eleaf.sym = s;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting leaf", 14);
        break;
    }
  M2StackAddress_PushAddress (exprStack, reinterpret_cast <void *> (l));
}


/*
   InitProcedure -
*/

static void InitProcedure (unsigned int s)
{
  InitLeaf (M2Const_procedure, s, fixupProcedureType (s));
}


/*
   InitCharType -
*/

static void InitCharType (unsigned int s)
{
  InitLeaf (M2Const_char, s, M2Base_Char);
}


/*
   InitZType -
*/

static void InitZType (unsigned int s)
{
  InitLeaf (M2Const_ztype, s, M2Base_ZType);
}


/*
   InitRType -
*/

static void InitRType (unsigned int s)
{
  InitLeaf (M2Const_rtype, s, M2Base_RType);
}


/*
   InitUnknown -
*/

static void InitUnknown (unsigned int s)
{
  InitLeaf (M2Const_unknown, s, SymbolTable_NulSym);
}


/*
   InitBooleanType -
*/

static void InitBooleanType (unsigned int s)
{
  InitLeaf (M2Const_boolean, s, M2Base_Boolean);
}


/*
   TypeToMeta -
*/

static M2Const_constType TypeToMeta (unsigned int type)
{
  if (type == M2Base_Char)
    {
      return M2Const_char;
    }
  else if (type == M2Base_Boolean)
    {
      /* avoid dangling else.  */
      return M2Const_boolean;
    }
  else if (M2Base_IsRealType (type))
    {
      /* avoid dangling else.  */
      return M2Const_rtype;
    }
  else if (M2Base_IsComplexType (type))
    {
      /* avoid dangling else.  */
      return M2Const_ctype;
    }
  else if (M2Base_IsOrdinalType (type))
    {
      /* avoid dangling else.  */
      return M2Const_ztype;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Const_unknown;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   buildConstFunction - we are only concerned about resolving the return type of
                        a function, so we can ignore all parameters - except
                        the first one in the case of VAL(type, foo)
                        and the type of bar in MIN (bar) and MAX (bar).
                        buildConstFunction uses a unary exprNode to represent
                        a function.
*/

static void buildConstFunction (unsigned int func, unsigned int n)
{
  unsigned int i;
  PCSymBuild_exprNode first;
  PCSymBuild_exprNode second;

  first = NULL;
  second = NULL;
  if (n == 1)
    {
      first = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
    }
  else if (n >= 2)
    {
      /* avoid dangling else.  */
      i = n;
      while (i > 2)
        {
          second = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
          Storage_DEALLOCATE ((void **) &second, sizeof (PCSymBuild_eNode));
          i -= 1;
        }
      second = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
      first = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
    }
  if ((func == M2Base_Val) || (func == M2System_Cast))
    {
      InitConvert (M2Const_cast, SymbolTable_NulSym, first, second);
    }
  else if ((func == M2Base_Max) || (func == M2Base_Min))
    {
      /* avoid dangling else.  */
      InitFunction (M2Const_unknown, func, SymbolTable_NulSym, first, second, false);
    }
  else
    {
      /* avoid dangling else.  */
      InitFunction (TypeToMeta (GetSkippedType (func)), func, GetSkippedType (func), first, second, n > 2);
    }
}


/*
   ErrorConstFunction - generate an error message at functok using func in the
                        error message providing it is not NulSym.
*/

static void ErrorConstFunction (unsigned int func, unsigned int functok)
{
  if (func == SymbolTable_NulSym)
    {
      if (M2Options_Iso)
        {
          M2Error_ErrorFormat0 (M2Error_NewError (functok), (const char *) "the only functions permissible in a constant expression are: CAP, CAST, CHR, CMPLX, FLOAT, HIGH, IM, LENGTH, MAX, MIN, ODD, ORD, RE, SIZE, TSIZE, TRUNC, VAL and gcc builtins", 173);
        }
      else
        {
          M2Error_ErrorFormat0 (M2Error_NewError (functok), (const char *) "the only functions permissible in a constant expression are: CAP, CHR, FLOAT, HIGH, MAX, MIN, ODD, ORD, SIZE, TSIZE, TRUNC, VAL and gcc builtins", 144);
        }
    }
  else
    {
      if (M2Options_Iso)
        {
          M2MetaError_MetaErrorT1 (functok, (const char *) "the only functions permissible in a constant expression are: CAP, CAST, CHR, CMPLX, FLOAT, HIGH, IM, LENGTH, MAX, MIN, ODD, ORD, RE, SIZE, TSIZE, TRUNC, VAL and gcc builtins, but not {%1Ead}", 190, func);
        }
      else
        {
          M2MetaError_MetaErrorT1 (functok, (const char *) "the only functions permissible in a constant expression are: CAP, CHR, FLOAT, HIGH, MAX, MIN, ODD, ORD, SIZE, TSIZE, TRUNC, VAL and gcc builtins, but not {%1Ead}", 161, func);
        }
    }
}


/*
   InitBinary -
*/

static void InitBinary (M2Const_constType m, unsigned int t, NameKey_Name o)
{
  PCSymBuild_exprNode l;
  PCSymBuild_exprNode r;
  PCSymBuild_exprNode b;

  r = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
  l = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
  Storage_ALLOCATE ((void **) &b, sizeof (PCSymBuild_eNode));
  b->tag = PCSymBuild_binary;
  switch (b->tag)
    {
      case PCSymBuild_binary:
        b->ebinary.meta = m;
        b->ebinary.type = t;
        b->ebinary.left = l;
        b->ebinary.right = r;
        b->ebinary.op = o;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting binary", 16);
        break;
    }
  M2StackAddress_PushAddress (exprStack, reinterpret_cast <void *> (b));
}


/*
   InitUnary -
*/

static void InitUnary (M2Const_constType m, unsigned int t, NameKey_Name o)
{
  PCSymBuild_exprNode l;
  PCSymBuild_exprNode b;

  l = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
  Storage_ALLOCATE ((void **) &b, sizeof (PCSymBuild_eNode));
  b->tag = PCSymBuild_unary;
  switch (b->tag)
    {
      case PCSymBuild_unary:
        b->eunary.meta = m;
        b->eunary.type = t;
        b->eunary.left = l;
        b->eunary.op = o;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting unary", 15);
        break;
    }
  M2StackAddress_PushAddress (exprStack, reinterpret_cast <void *> (b));
}


/*
   isTypeResolved -
*/

static bool isTypeResolved (PCSymBuild_exprNode e)
{
  switch (e->tag)
    {
      case PCSymBuild_leaf:
        return (e->eleaf.type != SymbolTable_NulSym) || (e->eleaf.meta == M2Const_str);
        break;

      case PCSymBuild_unary:
        return (e->eunary.type != SymbolTable_NulSym) || (e->eunary.meta == M2Const_str);
        break;

      case PCSymBuild_binary:
        return (e->ebinary.type != SymbolTable_NulSym) || (e->ebinary.meta == M2Const_str);
        break;

      case PCSymBuild_designator:
        return (e->edes.type != SymbolTable_NulSym) || (e->edes.meta == M2Const_str);
        break;

      case PCSymBuild_expr:
        return (e->eexpr.type != SymbolTable_NulSym) || (e->eexpr.meta == M2Const_str);
        break;

      case PCSymBuild_convert:
        return (e->econvert.type != SymbolTable_NulSym) || (e->econvert.meta == M2Const_str);
        break;

      case PCSymBuild_function:
        return (e->efunction.type != SymbolTable_NulSym) || (e->efunction.meta == M2Const_str);
        break;


      default:
        CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
        __builtin_unreachable ();
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   getEtype -
*/

static unsigned int getEtype (PCSymBuild_exprNode e)
{
  switch (e->tag)
    {
      case PCSymBuild_leaf:
        return e->eleaf.type;
        break;

      case PCSymBuild_unary:
        return e->eunary.type;
        break;

      case PCSymBuild_binary:
        return e->ebinary.type;
        break;

      case PCSymBuild_designator:
        return e->edes.type;
        break;

      case PCSymBuild_expr:
        return e->eexpr.type;
        break;

      case PCSymBuild_convert:
        return e->econvert.type;
        break;

      case PCSymBuild_function:
        return e->efunction.type;
        break;


      default:
        CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
        __builtin_unreachable ();
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   getEmeta -
*/

static M2Const_constType getEmeta (PCSymBuild_exprNode e)
{
  switch (e->tag)
    {
      case PCSymBuild_leaf:
        return e->eleaf.meta;
        break;

      case PCSymBuild_unary:
        return e->eunary.meta;
        break;

      case PCSymBuild_binary:
        return e->ebinary.meta;
        break;

      case PCSymBuild_designator:
        return e->edes.meta;
        break;

      case PCSymBuild_expr:
        return e->eexpr.meta;
        break;

      case PCSymBuild_convert:
        return e->econvert.meta;
        break;

      case PCSymBuild_function:
        return e->efunction.meta;
        break;


      default:
        CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
        __builtin_unreachable ();
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   assignTM -
*/

static void assignTM (unsigned int *td, M2Const_constType *md, unsigned int te, M2Const_constType me)
{
  (*md) = me;
  (*td) = te;
}


/*
   assignType -
*/

static void assignType (PCSymBuild_exprNode d, PCSymBuild_exprNode e)
{
  unsigned int t;
  M2Const_constType m;

  m = getEmeta (e);
  t = getEtype (e);
  switch (d->tag)
    {
      case PCSymBuild_leaf:
        assignTM (&d->eleaf.type, &d->eleaf.meta, t, m);
        break;

      case PCSymBuild_unary:
        assignTM (&d->eunary.type, &d->eunary.meta, t, m);
        break;

      case PCSymBuild_binary:
        assignTM (&d->ebinary.type, &d->ebinary.meta, t, m);
        break;

      case PCSymBuild_designator:
        assignTM (&d->edes.type, &d->edes.meta, t, m);
        break;

      case PCSymBuild_expr:
        assignTM (&d->eexpr.type, &d->eexpr.meta, t, m);
        break;

      case PCSymBuild_convert:
        assignTM (&d->econvert.type, &d->econvert.meta, t, m);
        break;

      case PCSymBuild_function:
        assignTM (&d->efunction.type, &d->efunction.meta, t, m);
        break;


      default:
        CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
        __builtin_unreachable ();
    }
}


/*
   deduceTypes - works out the type and metatype given, l, and, r.
*/

static void deduceTypes (unsigned int *t, M2Const_constType *m, PCSymBuild_exprNode l, PCSymBuild_exprNode r, NameKey_Name op)
{
  if (r == NULL)
    {
      /* function or cast  */
      (*t) = getEtype (l);
      (*m) = getEmeta (l);
    }
  else if ((((((((((((op == M2Reserved_EqualTok) || (op == M2Reserved_HashTok)) || (op == M2Reserved_LessGreaterTok)) || (op == M2Reserved_LessTok)) || (op == M2Reserved_LessEqualTok)) || (op == M2Reserved_GreaterTok)) || (op == M2Reserved_GreaterEqualTok)) || (op == M2Reserved_InTok)) || (op == M2Reserved_OrTok)) || (op == M2Reserved_AndTok)) || (op == M2Reserved_NotTok)) || (op == M2Reserved_AmbersandTok))
    {
      /* avoid dangling else.  */
      (*t) = M2Base_Boolean;
      (*m) = M2Const_boolean;
    }
  else if (((((((op == M2Reserved_PlusTok) || (op == M2Reserved_MinusTok)) || (op == M2Reserved_TimesTok)) || (op == M2Reserved_ModTok)) || (op == M2Reserved_DivTok)) || (op == M2Reserved_RemTok)) || (op == M2Reserved_DivideTok))
    {
      /* avoid dangling else.  */
      (*t) = M2Base_MixTypes (getEtype (l), getEtype (r), constToken);
      (*m) = getEmeta (l);
      if ((*m) == M2Const_unknown)
        {
          (*m) = getEmeta (r);
        }
      else if (((getEmeta (r)) != M2Const_unknown) && ((*m) != (getEmeta (r))))
        {
          /* avoid dangling else.  */
          M2Error_ErrorFormat0 (M2Error_NewError (constToken), (const char *) "the operands to a binary constant expression have different types", 65);
        }
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "unexpected operator", 19);
    }
}


/*
   WalkConvert -
*/

static bool WalkConvert (PCSymBuild_exprNode e)
{
  if (isTypeResolved (e))
    {
      return false;
    }
  else
    {
      if (isTypeResolved (e->econvert.totype))
        {
          assignType (e, e->econvert.totype);
          return true;
        }
      return doWalkNode (e->econvert.totype);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkFunctionParam -
*/

static bool WalkFunctionParam (unsigned int func, PCSymBuild_exprNode e)
{
  if (isTypeResolved (e))
    {
      return false;
    }
  else
    {
      if (e->tag == PCSymBuild_leaf)
        {
          if ((e->eleaf.sym != SymbolTable_NulSym) && (e->eleaf.type == SymbolTable_NulSym))
            {
              if ((func == M2Base_Min) || (func == M2Base_Max))
                {
                  if ((SymbolTable_IsSet (e->eleaf.sym)) || ((SymbolTable_IsType (e->eleaf.sym)) && (SymbolTable_IsSet (SymbolTable_SkipType (e->eleaf.sym)))))
                    {
                      e->eleaf.type = SymbolTable_GetType (SymbolTable_SkipType (e->eleaf.sym));
                    }
                  else
                    {
                      /* sym is the type required for MAX, MIN and VAL.  */
                      e->eleaf.type = e->eleaf.sym;
                    }
                }
              else
                {
                  M2Debug_Assert (func == M2Base_Val);
                  e->eleaf.type = e->eleaf.sym;
                }
              e->eleaf.meta = TypeToMeta (e->eleaf.sym);
              return true;
            }
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkFunction -
*/

static bool WalkFunction (PCSymBuild_exprNode e)
{
  if (isTypeResolved (e))
    {
      return false;
    }
  else
    {
      if (((e->efunction.func == M2Base_Max) || (e->efunction.func == M2Base_Min)) || (e->efunction.func == M2Base_Val))
        {
          if (isTypeResolved (e->efunction.first))
            {
              if ((getEmeta (e->efunction.first)) == M2Const_str)
                {
                  M2MetaError_MetaError1 ((const char *) "a string parameter cannot be passed to function {%1Dad}", 55, e->efunction.func);
                  return false;
                }
              e->efunction.type = getEtype (e->efunction.first);
              return true;
            }
          return WalkFunctionParam (e->efunction.func, e->efunction.first);
        }
      else
        {
          M2MetaError_MetaError1 ((const char *) "not expecting this function inside a constant expression {%1Dad}", 64, e->efunction.func);
        }
      return true;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doWalkNode -
*/

static bool doWalkNode (PCSymBuild_exprNode e)
{
  switch (e->tag)
    {
      case PCSymBuild_expr:
        return WalkExpr (e);
        break;

      case PCSymBuild_leaf:
        return WalkLeaf (e);
        break;

      case PCSymBuild_unary:
        return WalkUnary (e);
        break;

      case PCSymBuild_binary:
        return WalkBinary (e);
        break;

      case PCSymBuild_convert:
        return WalkConvert (e);
        break;

      case PCSymBuild_function:
        return WalkFunction (e);
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected tag value", 20);
        break;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkLeaf -
*/

static bool WalkLeaf (PCSymBuild_exprNode e)
{
  PCSymBuild_exprNode c;

  if (isTypeResolved (e))
    {
      return false;
    }
  else
    {
      if ((SymbolTable_IsConst (e->eleaf.sym)) && ((SymbolTable_GetType (e->eleaf.sym)) != SymbolTable_NulSym))
        {
          e->eleaf.type = GetSkippedType (e->eleaf.sym);
          return true;
        }
      if (SymbolTable_IsAModula2Type (e->eleaf.sym))
        {
          e->eleaf.type = e->eleaf.sym;
          return true;
        }
      c = findConstDes (e->eleaf.sym);
      if ((c != NULL) && (isTypeResolved (c)))
        {
          assignType (e, c);
          return true;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkUnary -
*/

static bool WalkUnary (PCSymBuild_exprNode e)
{
  if (isTypeResolved (e))
    {
      return false;
    }
  else
    {
      if (isTypeResolved (e->eunary.left))
        {
          deduceTypes (&e->eunary.type, &e->eunary.meta, e->eunary.left, e->eunary.left, e->eunary.op);
          return true;
        }
      return doWalkNode (e->eunary.left);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkBinary -
*/

static bool WalkBinary (PCSymBuild_exprNode e)
{
  bool changed;

  if (isTypeResolved (e))
    {
      return false;
    }
  else
    {
      if ((isTypeResolved (e->ebinary.left)) && (isTypeResolved (e->ebinary.right)))
        {
          deduceTypes (&e->ebinary.type, &e->ebinary.meta, e->ebinary.left, e->ebinary.right, e->ebinary.op);
          return true;
        }
      changed = doWalkNode (e->ebinary.left);
      return (doWalkNode (e->ebinary.right)) || changed;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkExpr -
*/

static bool WalkExpr (PCSymBuild_exprNode e)
{
  if (isTypeResolved (e))
    {
      return false;
    }
  else
    {
      if (isTypeResolved (e->eexpr.left))
        {
          assignType (e, e->eexpr.left);
          return true;
        }
      return doWalkNode (e->eexpr.left);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doWalkDesExpr - returns TRUE if the expression trees, d, or, e, are changed.
*/

static bool doWalkDesExpr (PCSymBuild_exprNode d, PCSymBuild_exprNode e)
{
  if (isTypeResolved (e))
    {
      d->edes.type = getEtype (e);
      if (d->edes.type == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          d->edes.meta = getEmeta (e);
          if (d->edes.meta == M2Const_str)
            {}  /* empty.  */
          /* PutConstString(sym, getString(e))  */
        }
      else
        {
          SymbolTable_PutConst (d->edes.sym, d->edes.type);
        }
      return true;
    }
  return doWalkNode (e);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doWalkDes - return TRUE if expression, e, is changed.
*/

static bool doWalkDes (PCSymBuild_exprNode d)
{
  if (isTypeResolved (d))
    {
      return false;
    }
  else
    {
      switch (d->tag)
        {
          case PCSymBuild_designator:
            constToken = SymbolTable_GetDeclaredMod (d->edes.sym);
            return doWalkDesExpr (d, d->edes.left);
            break;


          default:
            M2Error_InternalError ((const char *) "unexpected tag value", 20);
            break;
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
  __builtin_unreachable ();
}


/*
   findConstDes -
*/

static PCSymBuild_exprNode findConstDes (unsigned int sym)
{
  unsigned int i;
  PCSymBuild_exprNode e;

  i = 1;
  while (i <= (Indexing_HighIndice (constList)))
    {
      e = static_cast<PCSymBuild_exprNode> (Indexing_GetIndice (constList, i));
      switch (e->tag)
        {
          case PCSymBuild_designator:
            if (e->edes.sym == sym)
              {
                return e;
              }
            break;


          default:
            break;
        }
      i += 1;
    }
  return NULL;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkDes - return TRUE if expression, e, is changed.
*/

static bool WalkDes (PCSymBuild_exprNode d)
{
  if (d == NULL)
    {
      return false;
    }
  else
    {
      if (Debugging)
        {
          DebugDes (d);
        }
      return doWalkDes (d);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WalkConsts - walk over the constant trees and return TRUE if any tree was changed.
                (As a result of a type resolution).
*/

static bool WalkConsts (void)
{
  bool changed;
  unsigned int i;

  changed = false;
  i = 1;
  while (i <= (Indexing_HighIndice (constList)))
    {
      if (WalkDes (reinterpret_cast <PCSymBuild_exprNode> (Indexing_GetIndice (constList, i))))
        {
          changed = true;
        }
      i += 1;
    }
  return changed;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DebugNodes -
*/

static void DebugNodes (void)
{
  unsigned int i;

  i = 1;
  while (i <= (Indexing_HighIndice (constList)))
    {
      if (isTypeResolved (reinterpret_cast <PCSymBuild_exprNode> (Indexing_GetIndice (constList, i))))
        {
          StrIO_WriteString ((const char *) "resolved ", 9);
        }
      else
        {
          StrIO_WriteString ((const char *) "unresolved ", 11);
        }
      DebugNode (reinterpret_cast <PCSymBuild_exprNode> (Indexing_GetIndice (constList, i)));
      StrIO_WriteLn ();
      i += 1;
    }
}


/*
   findAlias -
*/

static unsigned int findAlias (unsigned int sym, PCSymBuild_exprNode e)
{
  switch (e->tag)
    {
      case PCSymBuild_designator:
        return findAlias (sym, e->edes.left);
        break;

      case PCSymBuild_leaf:
        return e->eleaf.sym;
        break;

      case PCSymBuild_expr:
        return findAlias (sym, e->eexpr.left);
        break;

      case PCSymBuild_unary:
      case PCSymBuild_binary:
        return sym;
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this tag value", 28);
        break;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/PCSymBuild.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CheckConsts -
*/

static void CheckConsts (void)
{
  unsigned int i;
  PCSymBuild_exprNode e;

  i = 1;
  while (i <= (Indexing_HighIndice (constList)))
    {
      e = static_cast<PCSymBuild_exprNode> (Indexing_GetIndice (constList, i));
      if (! (isTypeResolved (e)))
        {
          switch (e->tag)
            {
              case PCSymBuild_designator:
                M2MetaError_MetaError1 ((const char *) "the type of the constant declaration {%1Dad} cannot be determined", 65, e->edes.sym);
                break;


              default:
                break;
            }
        }
      i += 1;
    }
}


/*
   Init -
*/

static void Init (void)
{
  exprStack = M2StackAddress_InitStackAddress ();
  constList = Indexing_InitIndex (1);
  desStack = M2StackWord_InitStackWord ();
  inDesignator = false;
}


/*
   CheckNotVar - checks to see that the top of stack is not a variable.
*/

extern "C" void PCSymBuild_CheckNotVar (unsigned int tok)
{
  unsigned int const_;

  const_ = static_cast<unsigned int> (M2Quads_OperandT (1));
  if ((const_ != SymbolTable_NulSym) && (SymbolTable_IsVar (const_)))
    {
      M2MetaError_MetaErrorT1 (tok, (const char *) "not expecting a variable {%Aad} as a term in a constant expression", 66, const_);
    }
}

extern "C" void PCSymBuild_PCStartBuildDefModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* 
   StartBuildDefinitionModule - Creates a definition module and starts
                                a new scope.

                                The Stack is expected:

                                Entry                 Exit

                         Ptr ->                                     <- Ptr
                                +------------+        +-----------+
                                | NameStart  |        | NameStart |
                                |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tok);
  ModuleSym = M2Batch_MakeDefinitionSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (SymbolTable_IsDefImp (ModuleSym));
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  M2Quads_PushT (name);
  M2Error_EnterDefinitionScope (name);
}

extern "C" void PCSymBuild_PCEndBuildDefModule (void)
{
  unsigned int NameStart;
  unsigned int NameEnd;

  /* 
   EndBuildDefinitionModule - Destroys the definition module scope and
                              checks for correct name.

                              The Stack is expected:

                              Entry                 Exit

                       Ptr ->
                              +------------+        +-----------+
                              | NameEnd    |        |           |
                              |------------|        |-----------|
                              | NameStart  |        |           | <- Ptr
                              |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      M2Error_WriteFormat2 ((const char *) "inconsistent definition module was named (%a) and concluded as (%a)", 67, (const unsigned char *) &NameStart, (sizeof (NameStart)-1), (const unsigned char *) &NameEnd, (sizeof (NameEnd)-1));
    }
  M2Error_LeaveErrorScope ();
}

extern "C" void PCSymBuild_PCStartBuildImpModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* 
   StartBuildImplementationModule - Creates an implementation module and starts
                                    a new scope.

                                    The Stack is expected:

                                    Entry                 Exit

                             Ptr ->                                     <- Ptr
                                    +------------+        +-----------+
                                    | NameStart  |        | NameStart |
                                    |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tok);
  ModuleSym = M2Batch_MakeImplementationSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (SymbolTable_IsDefImp (ModuleSym));
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  M2Quads_PushTtok (name, tok);
  M2Error_EnterImplementationScope (name);
}

extern "C" void PCSymBuild_PCEndBuildImpModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildImplementationModule - Destroys the implementation module scope and
                                  checks for correct name.

                                  The Stack is expected:

                                  Entry                 Exit

                           Ptr ->
                                  +------------+        +-----------+
                                  | NameEnd    |        |           |
                                  |------------|        |-----------|
                                  | NameStart  |        |           | <- Ptr
                                  |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      /* we dont issue an error based around incorrect module names as this is done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in PC, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  M2Error_LeaveErrorScope ();
}

extern "C" void PCSymBuild_PCStartBuildProgModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* WriteString('StartBuildProgramModule') ; WriteLn ;  */
  M2Quads_PopTtok (&name, &tok);
  ModuleSym = M2Batch_MakeProgramSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  /* WriteString('MODULE - ') ; WriteKey(GetSymName(ModuleSym)) ; WriteLn ;  */
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (M2Comp_CompilingProgramModule ());
  M2Debug_Assert (! (SymbolTable_IsDefImp (ModuleSym)));
  M2Quads_PushTtok (name, tok);
  M2Error_EnterProgramScope (name);
}

extern "C" void PCSymBuild_PCEndBuildProgModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildProgramModule - Destroys the program module scope and
                           checks for correct name.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->
                           +------------+        +-----------+
                           | NameEnd    |        |           |
                           |------------|        |-----------|
                           | NameStart  |        |           | <- Ptr
                           |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingProgramModule ());
  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      /* we dont issue an error based around incorrect module names this would be done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in PC, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  M2Error_LeaveErrorScope ();
}

extern "C" void PCSymBuild_PCStartBuildInnerModule (void)
{
  NameKey_Name name;
  unsigned int tok;
  unsigned int ModuleSym;

  /* 
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tok);
  ModuleSym = SymbolTable_RequestSym (tok, name);
  M2Debug_Assert (SymbolTable_IsModule (ModuleSym));
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (! (SymbolTable_IsDefImp (ModuleSym)));
  SymbolTable_SetCurrentModule (ModuleSym);
  M2Quads_PushTtok (name, tok);
  M2Error_EnterModuleScope (name);
}

extern "C" void PCSymBuild_PCEndBuildInnerModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
  */
  SymbolTable_CheckForUnknownInModule ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&NameStart);
  if (NameStart != NameEnd)
    {
      /* we dont issue an error based around incorrect module names this would be done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in PC, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  SymbolTable_SetCurrentModule (SymbolTable_GetModuleScope (SymbolTable_GetCurrentModule ()));
  M2Error_LeaveErrorScope ();
}

extern "C" void PCSymBuild_PCBuildProcedureHeading (void)
{
  unsigned int ProcSym;
  NameKey_Name NameStart;

  /* 
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |
                           |------------|
                           | NameStart  |
                           |------------|
                                                       Empty

  */
  if (M2Comp_CompilingDefinitionModule ())
    {
      M2Quads_PopT (&ProcSym);
      M2Quads_PopT (&NameStart);
      SymbolTable_EndScope ();
    }
}

extern "C" void PCSymBuild_PCStartBuildProcedure (void)
{
  NameKey_Name name;
  unsigned int ProcSym;
  unsigned int tok;

  /* 
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
  */
  M2Quads_PopTtok (&name, &tok);
  M2Quads_PushTtok (name, tok);  /* Name saved for the EndBuildProcedure name check  */
  ProcSym = SymbolTable_RequestSym (tok, name);  /* Name saved for the EndBuildProcedure name check  */
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  M2Quads_PushTtok (ProcSym, tok);
  SymbolTable_StartScope (ProcSym);
  M2Error_EnterProcedureScope (name);
}

extern "C" void PCSymBuild_PCEndBuildProcedure (void)
{
  unsigned int ProcSym;
  NameKey_Name NameEnd;
  NameKey_Name NameStart;

  /* 
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:

                       (Procedure Not Defined in definition module)

                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
  */
  M2Quads_PopT (&NameEnd);
  M2Quads_PopT (&ProcSym);
  M2Quads_PopT (&NameStart);
  if (NameEnd != NameStart)
    {
      /* we dont issue an error based around incorrect module names this would be done in P1 and P2.
         If we get here then something has gone wrong with our error recovery in PC, so we bail out.
  */
      M2Error_WriteFormat0 ((const char *) "too many errors in pass 3", 25);
      M2Error_FlushErrors ();
    }
  SymbolTable_EndScope ();
  M2Error_LeaveErrorScope ();
}

extern "C" void PCSymBuild_PCEndBuildForward (void)
{
  /* 
   EndBuildForward - Ends building a forward declaration.

                     The Stack:

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | ProcSym    |
                     |------------|
                     | NameStart  |
                     |------------|
                                           Empty
  */
  M2Quads_PopN (2);
}

extern "C" void PCSymBuild_PCBuildImportOuterModule (void)
{
  unsigned int Sym;
  unsigned int ModSym;
  unsigned int i;
  unsigned int n;

  /* 
   BuildImportOuterModule - Builds imported identifiers into an outer module
                            from a definition module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                            Exit

                            All above stack discarded
  */
  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) != M2Reserved_ImportTok)
    {
      /* Ident List contains list of objects imported from ModSym  */
      ModSym = M2Batch_LookupModule (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
      i = 1;
      while (i <= n)
        {
          Sym = SymbolTable_GetExported (M2Quads_OperandTok (i), ModSym, M2Quads_OperandT (i));
          SymbolTable_CheckForEnumerationInCurrentModule (Sym);
          i += 1;
        }
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}

extern "C" void PCSymBuild_PCBuildImportInnerModule (void)
{
  unsigned int Sym;
  unsigned int ModSym;
  unsigned int n;
  unsigned int i;

  /* 
   BuildImportInnerModule - Builds imported identifiers into an inner module
                            from the last level of module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;

                            Exit

                            All above stack discarded
  */
  M2Quads_PopT (&n);  /* i   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) == M2Reserved_ImportTok)
    {
      /* Ident List contains list of objects  */
      i = 1;
      while (i <= n)
        {
          Sym = SymbolTable_GetFromOuterModule (M2Quads_OperandTok (i), M2Quads_OperandT (i));
          SymbolTable_CheckForEnumerationInCurrentModule (Sym);
          i += 1;
        }
    }
  else
    {
      /* Ident List contains list of objects imported from ModSym  */
      ModSym = M2Batch_LookupOuterModule (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
      i = 1;
      while (i <= n)
        {
          Sym = SymbolTable_GetExported (M2Quads_OperandTok (i), ModSym, M2Quads_OperandT (i));
          SymbolTable_CheckForEnumerationInCurrentModule (Sym);
          i += 1;
        }
    }
  M2Quads_PopN (n+1);  /* Clear Stack  */
}


/*
   BuildNulName - Pushes a NulKey onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulKey     |
                                           |------------|
*/

extern "C" void PCSymBuild_BuildNulName (void)
{
  M2Quads_PushT (static_cast<unsigned int> (NameKey_NulName));
}


/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->                                      <- Ptr
                +------------+        +------------+
                | Name       |        | Sym        |
                |------------+        |------------|
*/

extern "C" void PCSymBuild_BuildConst (void)
{
  NameKey_Name name;
  unsigned int tok;
  unsigned int Sym;

  M2Quads_PopTtok (&name, &tok);
  Sym = SymbolTable_RequestSym (tok, name);
  M2Quads_PushTtok (Sym, tok);
}


/*
   StartDesConst -
*/

extern "C" void PCSymBuild_StartDesConst (void)
{
  NameKey_Name name;
  unsigned int tok;

  inDesignator = true;
  exprStack = M2StackAddress_KillStackAddress (exprStack);
  exprStack = M2StackAddress_InitStackAddress ();
  M2Quads_PopTtok (&name, &tok);
  InitDesExpr (SymbolTable_RequestSym (tok, name));
}


/*
   EndDesConst -
*/

extern "C" void PCSymBuild_EndDesConst (void)
{
  PCSymBuild_exprNode d;
  PCSymBuild_exprNode e;

  e = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
  d = static_cast<PCSymBuild_exprNode> (M2StackAddress_PopAddress (exprStack));
  M2Debug_Assert (d->tag == PCSymBuild_designator);
  d->edes.left = e;
  Indexing_IncludeIndiceIntoIndex (constList, reinterpret_cast <void *> (d));
  inDesignator = false;
}


/*
   BuildRelationConst - builds a relationship binary operation.
*/

extern "C" void PCSymBuild_BuildRelationConst (void)
{
  NameKey_Name op;

  M2Quads_PopT (&op);
  if (inDesignator)
    {
      InitBinary (M2Const_boolean, M2Base_Boolean, op);
    }
}


/*
   BuildUnaryConst - builds a unary operator node.
*/

extern "C" void PCSymBuild_BuildUnaryConst (void)
{
  NameKey_Name op;

  M2Quads_PopT (&op);
  if (inDesignator)
    {
      InitUnary (M2Const_unknown, SymbolTable_NulSym, op);
    }
}


/*
   BuildBinaryConst - builds a binary operator node.
*/

extern "C" void PCSymBuild_BuildBinaryConst (void)
{
  NameKey_Name op;

  M2Quads_PopT (&op);
  if (inDesignator)
    {
      InitBinary (M2Const_unknown, SymbolTable_NulSym, op);
    }
}


/*
   PushConstFunctionType -
*/

extern "C" void PCSymBuild_PushConstFunctionType (void)
{
  unsigned int functok;
  unsigned int func;
  unsigned int n;

  M2Quads_PopT (&n);
  M2Quads_PopTtok (&func, &functok);
  if (inDesignator)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (func == SymbolTable_NulSym)
        {
          ErrorConstFunction (func, functok);
        }
      else if ((func != M2Base_Convert) && (((M2Base_IsPseudoBaseFunction (func)) || (M2System_IsPseudoSystemFunctionConstExpression (func))) || ((SymbolTable_IsProcedure (func)) && (SymbolTable_IsProcedureBuiltin (func)))))
        {
          /* avoid dangling else.  */
          buildConstFunction (func, n);
        }
      else if (SymbolTable_IsAModula2Type (func))
        {
          /* avoid dangling else.  */
          if (n == 1)
            {
              /* the top element on the expression stack is the first and only parameter to the cast  */
              InitUnary (M2Const_cast, func, SymbolTable_GetSymName (func));
            }
          else
            {
              M2Error_WriteFormat0 ((const char *) "a constant type conversion can only have one argument", 53);
            }
        }
      else
        {
          /* avoid dangling else.  */
          ErrorConstFunction (func, functok);
        }
    }
  M2Quads_PushTtok (func, functok);
}


/*
   PushIntegerType -
*/

extern "C" void PCSymBuild_PushIntegerType (void)
{
  unsigned int sym;
  M2Const_constType m;

  M2Quads_PopT (&sym);
  if (inDesignator)
    {
      m = TypeToMeta (GetSkippedType (sym));
      if (m == M2Const_char)
        {
          InitCharType (sym);
        }
      else
        {
          InitZType (sym);
        }
    }
}


/*
   PushRType -
*/

extern "C" void PCSymBuild_PushRType (void)
{
  unsigned int sym;

  M2Quads_PopT (&sym);
  if (inDesignator)
    {
      InitRType (sym);
    }
}


/*
   PushStringType -
*/

extern "C" void PCSymBuild_PushStringType (void)
{
  unsigned int sym;

  M2Quads_PopT (&sym);
  if (inDesignator)
    {
      InitLeaf (M2Const_str, sym, SymbolTable_NulSym);
    }
}


/*
   SkipConst - returns an alias to constant, sym, if one exists.
               Otherwise sym is returned.
*/

extern "C" unsigned int PCSymBuild_SkipConst (unsigned int sym)
{
  unsigned int i;
  PCSymBuild_exprNode e;

  i = 1;
  while (i <= (Indexing_HighIndice (constList)))
    {
      e = static_cast<PCSymBuild_exprNode> (Indexing_GetIndice (constList, i));
      if ((e->tag == PCSymBuild_designator) && (e->edes.sym == sym))
        {
          return findAlias (sym, e);
        }
      i += 1;
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushConstType - pushes a constant to the expression stack.
*/

extern "C" void PCSymBuild_PushConstType (void)
{
  unsigned int c;

  M2Quads_PopT (&c);
  M2Quads_PushT (c);
  if (inDesignator)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (c == SymbolTable_NulSym)
        {
          M2Error_WriteFormat0 ((const char *) "module or symbol in qualident is not known", 42);
          M2Error_FlushErrors ();
          InitUnknown (c);
        }
      else if (SymbolTable_IsProcedure (c))
        {
          /* avoid dangling else.  */
          InitProcedure (c);
        }
      else if ((GetSkippedType (c)) == M2Base_RType)
        {
          /* avoid dangling else.  */
          InitRType (c);
        }
      else if ((GetSkippedType (c)) == M2Base_ZType)
        {
          /* avoid dangling else.  */
          InitZType (c);
        }
      else if ((GetSkippedType (c)) == M2Base_Boolean)
        {
          /* avoid dangling else.  */
          InitBooleanType (c);
        }
      else
        {
          /* avoid dangling else.  */
          InitUnknown (c);
        }
    }
}


/*
   PushConstAttributeType -
*/

extern "C" void PCSymBuild_PushConstAttributeType (void)
{
  NameKey_Name n;

  M2Quads_PopT (&n);
  M2Quads_PushT (n);
  InitZType (SymbolTable_NulSym);
  if ((((n == (NameKey_MakeKey ((const char *) "BITS_PER_UNIT", 13))) || (n == (NameKey_MakeKey ((const char *) "BITS_PER_WORD", 13)))) || (n == (NameKey_MakeKey ((const char *) "BITS_PER_CHAR", 13)))) || (n == (NameKey_MakeKey ((const char *) "UNITS_PER_WORD", 14))))
    {}  /* empty.  */
  else
    {
      /* all ok  */
      M2Error_WriteFormat1 ((const char *) "unknown constant attribute value '%a'", 37, (const unsigned char *) &n, (sizeof (n)-1));
    }
}


/*
   PushConstAttributePairType -
*/

extern "C" void PCSymBuild_PushConstAttributePairType (void)
{
  NameKey_Name q;
  NameKey_Name n;

  M2Quads_PopT (&n);
  M2Quads_PopT (&q);
  M2Quads_PushT (q);
  M2Quads_PushT (n);
  if ((((((((n == (NameKey_MakeKey ((const char *) "IEC559", 6))) || (n == (NameKey_MakeKey ((const char *) "LIA1", 4)))) || (n == (NameKey_MakeKey ((const char *) "IEEE", 4)))) || (n == (NameKey_MakeKey ((const char *) "ISO", 3)))) || (n == (NameKey_MakeKey ((const char *) "rounds", 6)))) || (n == (NameKey_MakeKey ((const char *) "gUnderflow", 10)))) || (n == (NameKey_MakeKey ((const char *) "exception", 9)))) || (n == (NameKey_MakeKey ((const char *) "extend", 6))))
    {
      InitBooleanType (SymbolTable_NulSym);
    }
  else if (((((n == (NameKey_MakeKey ((const char *) "radix", 5))) || (n == (NameKey_MakeKey ((const char *) "places", 6)))) || (n == (NameKey_MakeKey ((const char *) "expoMin", 7)))) || (n == (NameKey_MakeKey ((const char *) "expoMax", 7)))) || (n == (NameKey_MakeKey ((const char *) "nModes", 6))))
    {
      /* avoid dangling else.  */
      InitZType (SymbolTable_NulSym);
    }
  else if ((n == (NameKey_MakeKey ((const char *) "large", 5))) || (n == (NameKey_MakeKey ((const char *) "small", 5))))
    {
      /* avoid dangling else.  */
      InitRType (SymbolTable_NulSym);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_WriteFormat1 ((const char *) "unknown constant attribute value '%a'", 37, (const unsigned char *) &n, (sizeof (n)-1));
      InitUnknown (SymbolTable_NulSym);
    }
}


/*
   PushConstructorCastType -
*/

extern "C" void PCSymBuild_PushConstructorCastType (void)
{
  if (inDesignator)
    {
      InitConvert (M2Const_cast, M2Quads_OperandT (1), NULL, NULL);
    }
}


/*
   PushInConstructor -
*/

extern "C" void PCSymBuild_PushInConstructor (void)
{
  M2StackWord_PushWord (desStack, static_cast<unsigned int> (inDesignator));
  inDesignator = false;
}


/*
   PopInConstructor -
*/

extern "C" void PCSymBuild_PopInConstructor (void)
{
  inDesignator = static_cast<bool> (M2StackWord_PopWord (desStack));
}


/*
   ResolveConstTypes - resolves the types of all designator declared constants.
*/

extern "C" void PCSymBuild_ResolveConstTypes (void)
{
  if (Debugging)
    {
      StrIO_WriteString ((const char *) "initially", 9);
      StrIO_WriteLn ();
      DebugNodes ();
    }
  while (WalkConsts ())
    {
      if (Debugging)
        {
          StrIO_WriteString ((const char *) "iteration", 9);
          StrIO_WriteLn ();
          DebugNodes ();
        }
    }
  if (Debugging)
    {
      StrIO_WriteString ((const char *) "finally", 7);
      StrIO_WriteLn ();
      DebugNodes ();
    }
  CheckConsts ();
}

extern "C" void _M2_PCSymBuild_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_PCSymBuild_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
