/* do not edit automatically generated by mc from M2LexBuf.  */
/* M2LexBuf.mod provides a buffer for m2.lex.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2LexBuf_C

#include "GM2LexBuf.h"
#   include "Gm2flex.h"
#   include "GFIO.h"
#   include "Glibc.h"
#   include "GSYSTEM.h"
#   include "GStorage.h"
#   include "GDynamicStrings.h"
#   include "GFormatStrings.h"
#   include "GNameKey.h"
#   include "GM2Reserved.h"
#   include "GM2Printf.h"
#   include "GM2Debug.h"
#   include "GNumberIO.h"
#   include "Ggcctypes.h"
#   include "Gm2linemap.h"
#   include "GM2Emit.h"
#   include "GM2Error.h"
#   include "GM2MetaError.h"
#   include "GM2Options.h"
#   include "GM2LangDump.h"
#   include "GIndexing.h"
#   include "GM2RTS.h"

#   define M2LexBuf_UnknownTokenNo 0
#   define M2LexBuf_BuiltinTokenNo 1
#   define Tracing false
#   define Debugging false
#   define DebugRecover false
#   define BadTokenNo 32579
#   define InitialSourceToken 2
typedef struct M2LexBuf__T1_r M2LexBuf__T1;

typedef M2LexBuf__T1 *M2LexBuf_SourceList;

typedef struct M2LexBuf__T2_r M2LexBuf__T2;

typedef M2LexBuf__T2 *M2LexBuf_TokenDesc;

struct M2LexBuf__T1_r {
                        M2LexBuf_SourceList left;
                        M2LexBuf_SourceList right;
                        DynamicStrings_String name;
                        unsigned int line;
                        unsigned int col;
                      };

struct M2LexBuf__T2_r {
                        M2Reserved_toktype token;
                        NameKey_Name str;
                        int int_;
                        unsigned int line;
                        unsigned int col;
                        M2LexBuf_SourceList file;
                        location_t loc;
                        Indexing_Index insert;
                      };

static M2LexBuf_SourceList CurrentSource;
static bool UseBufferedTokens;
static bool CurrentUsed;
static Indexing_Index ListOfTokens;
static unsigned int CurrentTokNo;
static unsigned int InsertionIndex;
static bool SeenEof;
static unsigned int indent;

/*
   OpenSource - Attempts to open the source file, s.
                The success of the operation is returned.
*/

extern "C" bool M2LexBuf_OpenSource (DynamicStrings_String s);

/*
   CloseSource - closes the current open file.
*/

extern "C" void M2LexBuf_CloseSource (void);

/*
   ReInitialize - re-initialize the all the data structures.
*/

extern "C" void M2LexBuf_ReInitialize (void);

/*
   ResetForNewPass - reset the buffer pointers to the beginning ready for
                     a new pass
*/

extern "C" void M2LexBuf_ResetForNewPass (void);

/*
   GetToken - gets the next token into currenttoken.
*/

extern "C" void M2LexBuf_GetToken (void);

/*
   InsertToken - inserts a symbol token infront of the current token
                 ready for the next pass.
*/

extern "C" void M2LexBuf_InsertToken (M2Reserved_toktype token);

/*
   InsertTokenAndRewind - inserts a symbol token infront of the current token
                          and then moves the token stream back onto the inserted
                          token.
*/

extern "C" void M2LexBuf_InsertTokenAndRewind (M2Reserved_toktype token);

/*
   GetPreviousTokenLineNo - returns the line number of the previous token.
*/

extern "C" unsigned int M2LexBuf_GetPreviousTokenLineNo (void);

/*
   GetLineNo - returns the current line number where the symbol occurs in
               the source file.
*/

extern "C" unsigned int M2LexBuf_GetLineNo (void);

/*
   GetTokenNo - returns the current token number.
*/

extern "C" unsigned int M2LexBuf_GetTokenNo (void);

/*
   GetTokenName - returns the token name given the tokenno.
*/

extern "C" NameKey_Name M2LexBuf_GetTokenName (unsigned int tokenno);

/*
   TokenToLineNo - returns the line number of the current file for the
                   tokenno. The depth refers to the include depth.
                   A depth of 0 is the current file, depth of 1 is the file
                   which included the current file. Zero is returned if the
                   depth exceeds the file nesting level.
*/

extern "C" unsigned int M2LexBuf_TokenToLineNo (unsigned int tokenno, unsigned int depth);

/*
   GetColumnNo - returns the current column where the symbol occurs in
                 the source file.
*/

extern "C" unsigned int M2LexBuf_GetColumnNo (void);

/*
   TokenToColumnNo - returns the column number of the current file for the
                     tokenno. The depth refers to the include depth.
                     A depth of 0 is the current file, depth of 1 is the file
                     which included the current file. Zero is returned if the
                     depth exceeds the file nesting level.
*/

extern "C" unsigned int M2LexBuf_TokenToColumnNo (unsigned int tokenno, unsigned int depth);

/*
   TokenToLocation - returns the location_t corresponding to tokenno.
*/

extern "C" location_t M2LexBuf_TokenToLocation (unsigned int tokenno);

/*
   FindFileNameFromToken - returns the complete FileName for the appropriate
                           source file yields the token number, TokenNo.
                           The, Depth, indicates the include level: 0..n
                           Level 0 is the current. NIL is returned if n+1
                           is requested.
*/

extern "C" DynamicStrings_String M2LexBuf_FindFileNameFromToken (unsigned int tokenno, unsigned int depth);

/*
   GetFileName - returns a String defining the current file.
*/

extern "C" DynamicStrings_String M2LexBuf_GetFileName (void);

/*
   MakeVirtualTok - providing caret, left, right are associated with a source file
                    and exist on the same src line then
                    create and return a new tokenno which is created from
                    tokenno left and right.  Otherwise return caret.
                    If caret is UnknownTokenNo then it is replaced with left or right
                    in sequence to avoid an UnknownTokenNo.
*/

extern "C" unsigned int M2LexBuf_MakeVirtualTok (unsigned int caret, unsigned int left, unsigned int right);

/*
   MakeVirtual2Tok - creates and return a new tokenno which is created from
                     two tokens left and right.  It tries to avoid UnknownTokenNo
                     and will fall back to left or right if necessary.
*/

extern "C" unsigned int M2LexBuf_MakeVirtual2Tok (unsigned int left, unsigned int right);

/*
   AddTok - adds a token to the buffer.
*/

extern "C" void M2LexBuf_AddTok (M2Reserved_toktype t);

/*
   AddTokCharStar - adds a token to the buffer and an additional string, s.
                    A copy of string, s, is made.
*/

extern "C" void M2LexBuf_AddTokCharStar (M2Reserved_toktype t, void * s);

/*
   AddTokInteger - adds a token and an integer to the buffer.
*/

extern "C" void M2LexBuf_AddTokInteger (M2Reserved_toktype t, int i);

/*
   SetFile - sets the current filename to, filename.
*/

extern "C" void M2LexBuf_SetFile (void * filename);

/*
   PushFile - indicates that, filename, has just been included.
*/

extern "C" void M2LexBuf_PushFile (void * filename);

/*
   PopFile - indicates that we are returning to, filename, having finished
             an include.
*/

extern "C" void M2LexBuf_PopFile (void * filename);

/*
   PrintTokenNo - displays token and the location of the token.
*/

extern "C" void M2LexBuf_PrintTokenNo (unsigned int tokenno);

/*
   DisplayToken - display the token name using printf0 no newline is emitted.
*/

extern "C" void M2LexBuf_DisplayToken (M2Reserved_toktype tok);

/*
   DumpTokens - displays all tokens.
*/

extern "C" void M2LexBuf_DumpTokens (void);
static void stop (void);

/*
   InitTokenDesc - returns a TokenDesc filled in with the parameters and
                   the insert field set to NIL.
*/

static M2LexBuf_TokenDesc InitTokenDesc (M2Reserved_toktype token, NameKey_Name str, int int_, unsigned int line, unsigned int col, M2LexBuf_SourceList file, location_t loc);

/*
   DeleteTokenDesc - delete tokdesc and any sub indices.
*/

static void DeleteTokenDesc (M2LexBuf_TokenDesc tokdesc);

/*
   Append - appends tokdesc to the end of the list defined by index.
*/

static void Append (Indexing_Index index, M2LexBuf_TokenDesc tokdesc);

/*
   InitTokenList - creates an empty token list, which starts the first source token
                   at position 2.  This allows position 0 to be used for the unknown
                   location and position 1 for the builtin token.
*/

static void InitTokenList (void);

/*
   Init - initializes the token list and source list.
*/

static void Init (void);

/*
   AddTo - adds a new element to the end of SourceList, CurrentSource.
*/

static void AddTo (M2LexBuf_SourceList l);

/*
   SubFrom - subtracts, l, from the source list.
*/

static void SubFrom (M2LexBuf_SourceList l);

/*
   NewElement - returns a new SourceList
*/

static M2LexBuf_SourceList NewElement (void * s);

/*
   NewList - initializes an empty list with the classic dummy header element.
*/

static M2LexBuf_SourceList NewList (void);

/*
   CheckIfNeedToDuplicate - checks to see whether the CurrentSource has
                            been used, if it has then duplicate the list.
*/

static void CheckIfNeedToDuplicate (void);

/*
   KillList - kills the SourceList providing that it has not been used.
*/

static void KillList (void);

/*
   DumpToken -
*/

static void DumpToken (M2LexBuf_TokenDesc tokdesc);

/*
   CopyOutCurrent - copies the token in buffer[index][insertion] into
                    then current token global variables.
*/

static void CopyOutCurrent (Indexing_Index buffer, unsigned int index, unsigned int insertion);

/*
   UpdateToken - update the global current token variables from buffer[index]
                 using inserted tokens if directed by InsertionIndex.
*/

static void UpdateToken (Indexing_Index buffer, unsigned int index);

/*
   GetTokenFiltered - providing that we have not already seen an eof for this source
                      file call m2flex.GetToken and GetToken if requested.
*/

static void GetTokenFiltered (bool callGetToken);

/*
   AppendInsertToken -
*/

static void AppendInsertToken (Indexing_Index index, M2LexBuf_TokenDesc tokdesc);

/*
   DupTok - duplicate tokdesc and replaces the token field with token.
*/

static M2LexBuf_TokenDesc DupTok (M2LexBuf_TokenDesc tokdesc, M2Reserved_toktype token);

/*
   AddTokToList - adds a token to a dynamic list.
*/

static void AddTokToList (M2Reserved_toktype token, NameKey_Name str, int int_, unsigned int line, unsigned int col, M2LexBuf_SourceList file, location_t location);

/*
   IsLastTokenEof - returns TRUE if the last token was an eoftok
*/

static bool IsLastTokenEof (void);

/*
   isSrcToken - returns TRUE if tokenno is associated with
                program source code.
*/

static bool isSrcToken (unsigned int tokenno);

/*
   tprintf0 -
*/

static void tprintf0 (const char *format_, unsigned int _format_high);

/*
   tprintf1 -
*/

static void tprintf1 (const char *format_, unsigned int _format_high, DynamicStrings_String str);

static void stop (void)
{
}


/*
   InitTokenDesc - returns a TokenDesc filled in with the parameters and
                   the insert field set to NIL.
*/

static M2LexBuf_TokenDesc InitTokenDesc (M2Reserved_toktype token, NameKey_Name str, int int_, unsigned int line, unsigned int col, M2LexBuf_SourceList file, location_t loc)
{
  M2LexBuf_TokenDesc tokdesc;

  Storage_ALLOCATE ((void **) &tokdesc, sizeof (M2LexBuf__T2));
  tokdesc->token = token;
  tokdesc->str = str;
  tokdesc->int_ = int_;
  tokdesc->line = line;
  tokdesc->col = col;
  tokdesc->file = file;
  tokdesc->loc = loc;
  tokdesc->insert = static_cast<Indexing_Index> (NULL);
  return tokdesc;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeleteTokenDesc - delete tokdesc and any sub indices.
*/

static void DeleteTokenDesc (M2LexBuf_TokenDesc tokdesc)
{
  if (tokdesc->insert != NULL)
    {
      Indexing_ForeachIndiceInIndexDo (tokdesc->insert, (Indexing_IndexProcedure) {(Indexing_IndexProcedure_t) DeleteTokenDesc});
    }
  Storage_DEALLOCATE ((void **) &tokdesc, sizeof (M2LexBuf__T2));
}


/*
   Append - appends tokdesc to the end of the list defined by index.
*/

static void Append (Indexing_Index index, M2LexBuf_TokenDesc tokdesc)
{
  if (Indexing_IsEmpty (index))
    {
      Indexing_PutIndice (index, Indexing_LowIndice (index), reinterpret_cast <void *> (tokdesc));
    }
  else
    {
      Indexing_PutIndice (index, (Indexing_HighIndice (index))+1, reinterpret_cast <void *> (tokdesc));
    }
}


/*
   InitTokenList - creates an empty token list, which starts the first source token
                   at position 2.  This allows position 0 to be used for the unknown
                   location and position 1 for the builtin token.
*/

static void InitTokenList (void)
{
  /* 65K elements in the array and when it becomes full it will grow to 1M, 16M etc elements.  */
  ListOfTokens = Indexing_InitIndexTuned (0, (1024*1024) / 16, 16);
  Append (ListOfTokens, InitTokenDesc (M2Reserved_eoftok, NameKey_NulName, 0, 0, 0, NULL, M2Emit_UnknownLocation ()));
  Append (ListOfTokens, InitTokenDesc (M2Reserved_eoftok, NameKey_NulName, 0, 0, 0, NULL, M2Emit_BuiltinsLocation ()));
}


/*
   Init - initializes the token list and source list.
*/

static void Init (void)
{
  SeenEof = false;
  InsertionIndex = 0;
  M2LexBuf_currenttoken = M2Reserved_eoftok;
  CurrentTokNo = InitialSourceToken;
  CurrentSource = NULL;
  UseBufferedTokens = false;
  InitTokenList ();
}


/*
   AddTo - adds a new element to the end of SourceList, CurrentSource.
*/

static void AddTo (M2LexBuf_SourceList l)
{
  l->right = CurrentSource;
  l->left = CurrentSource->left;
  CurrentSource->left->right = l;
  CurrentSource->left = l;
  l->left->line = m2flex_GetLineNo ();
  l->left->col = m2flex_GetColumnNo ();
}


/*
   SubFrom - subtracts, l, from the source list.
*/

static void SubFrom (M2LexBuf_SourceList l)
{
  l->left->right = l->right;
  l->right->left = l->left;
}


/*
   NewElement - returns a new SourceList
*/

static M2LexBuf_SourceList NewElement (void * s)
{
  M2LexBuf_SourceList l;

  Storage_ALLOCATE ((void **) &l, sizeof (M2LexBuf__T1));
  if (l == NULL)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
  else
    {
      l->name = DynamicStrings_InitStringCharStar (s);
      l->left = NULL;
      l->right = NULL;
    }
  return l;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NewList - initializes an empty list with the classic dummy header element.
*/

static M2LexBuf_SourceList NewList (void)
{
  M2LexBuf_SourceList l;

  Storage_ALLOCATE ((void **) &l, sizeof (M2LexBuf__T1));
  l->left = l;
  l->right = l;
  l->name = static_cast<DynamicStrings_String> (NULL);
  return l;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckIfNeedToDuplicate - checks to see whether the CurrentSource has
                            been used, if it has then duplicate the list.
*/

static void CheckIfNeedToDuplicate (void)
{
  M2LexBuf_SourceList l;
  M2LexBuf_SourceList h;

  if (CurrentUsed)
    {
      l = CurrentSource->right;
      h = CurrentSource;
      CurrentSource = NewList ();
      while (l != h)
        {
          AddTo (NewElement (reinterpret_cast <void *> (l->name)));
          l = l->right;
        }
    }
}


/*
   KillList - kills the SourceList providing that it has not been used.
*/

static void KillList (void)
{
  M2LexBuf_SourceList l;
  M2LexBuf_SourceList k;

  if (! CurrentUsed && (CurrentSource != NULL))
    {
      l = CurrentSource;
      do {
        k = l;
        l = l->right;
        Storage_DEALLOCATE ((void **) &k, sizeof (M2LexBuf__T1));
      } while (! (l == CurrentSource));
    }
}


/*
   DumpToken -
*/

static void DumpToken (M2LexBuf_TokenDesc tokdesc)
{
  unsigned int n;

  n = indent;
  while (n > 0)
    {
      M2Printf_printf0 ((const char *) " ", 1);
      n -= 1;
    }
  M2LexBuf_DisplayToken (tokdesc->token);
  if (tokdesc->str != NameKey_NulName)
    {
      M2Printf_printf1 ((const char *) " %a", 3, (const unsigned char *) &tokdesc->str, (sizeof (tokdesc->str)-1));
    }
  if (tokdesc->insert != NULL)
    {
      M2Printf_printf0 ((const char *) "inserted error recovery tokens\\n", 32);
      indent += 2;
      Indexing_ForeachIndiceInIndexDo (tokdesc->insert, (Indexing_IndexProcedure) {(Indexing_IndexProcedure_t) DumpToken});
      indent -= 2;
    }
}


/*
   CopyOutCurrent - copies the token in buffer[index][insertion] into
                    then current token global variables.
*/

static void CopyOutCurrent (Indexing_Index buffer, unsigned int index, unsigned int insertion)
{
  M2LexBuf_TokenDesc tokdesc;

  tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (buffer, index));
  if (insertion != 0)
    {
      tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (tokdesc->insert, insertion));
    }
  M2LexBuf_currenttoken = tokdesc->token;
  M2LexBuf_currentstring = NameKey_KeyToCharStar (tokdesc->str);
  M2LexBuf_currentcolumn = tokdesc->col;
  M2LexBuf_currentinteger = tokdesc->int_;
}


/*
   UpdateToken - update the global current token variables from buffer[index]
                 using inserted tokens if directed by InsertionIndex.
*/

static void UpdateToken (Indexing_Index buffer, unsigned int index)
{
  M2LexBuf_TokenDesc tokdesc;

  tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (buffer, index));
  if (InsertionIndex > 0)
    {
      /* avoid dangling else.  */
      /* We have an inserted token to use.  */
      M2Debug_Assert (tokdesc->insert != NULL);
      CopyOutCurrent (buffer, index, InsertionIndex);
      /* Move InsertionIndex to the next position.  */
      InsertionIndex += 1;
      if (InsertionIndex > (Indexing_HighIndice (tokdesc->insert)))
        {
          /* We are done consuming the inserted tokens, so move
            onto the next original source token.  */
          InsertionIndex = 0;
          CurrentTokNo += 1;
        }
    }
  else if ((tokdesc->insert != NULL) && (InsertionIndex == 0))
    {
      /* avoid dangling else.  */
      /* This source token has extra tokens appended after it by the error recovery.
         Set the index ready for the next UpdateToken which will read the extra
         tokens.  */
      InsertionIndex = 1;
      /* However this call must read the original token.  */
      CopyOutCurrent (buffer, index, 0);
    }
  else
    {
      /* avoid dangling else.  */
      CopyOutCurrent (buffer, index, 0);
      /* Move onto the next original source token.  */
      CurrentTokNo += 1;
    }
}


/*
   GetTokenFiltered - providing that we have not already seen an eof for this source
                      file call m2flex.GetToken and GetToken if requested.
*/

static void GetTokenFiltered (bool callGetToken)
{
  if (SeenEof)
    {
      M2LexBuf_currenttoken = M2Reserved_eoftok;
    }
  else
    {
      /* Call the lexical phase to place a new token into the last bucket.  */
      m2flex_GetToken ();
      if (callGetToken)
        {
          M2LexBuf_GetToken ();
        }
    }
}


/*
   AppendInsertToken -
*/

static void AppendInsertToken (Indexing_Index index, M2LexBuf_TokenDesc tokdesc)
{
  if (Indexing_IsEmpty (index))
    {
      Indexing_PutIndice (index, Indexing_LowIndice (index), reinterpret_cast <void *> (tokdesc));
    }
  else
    {
      Indexing_PutIndice (index, (Indexing_HighIndice (index))+1, reinterpret_cast <void *> (tokdesc));
    }
}


/*
   DupTok - duplicate tokdesc and replaces the token field with token.
*/

static M2LexBuf_TokenDesc DupTok (M2LexBuf_TokenDesc tokdesc, M2Reserved_toktype token)
{
  M2LexBuf_TokenDesc dup;

  Storage_ALLOCATE ((void **) &dup, sizeof (M2LexBuf__T2));
  M2Debug_Assert (dup != NULL);
  (*dup) = (*tokdesc);
  dup->token = token;
  return dup;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddTokToList - adds a token to a dynamic list.
*/

static void AddTokToList (M2Reserved_toktype token, NameKey_Name str, int int_, unsigned int line, unsigned int col, M2LexBuf_SourceList file, location_t location)
{
  Append (ListOfTokens, InitTokenDesc (token, str, int_, line, col, file, location));
}


/*
   IsLastTokenEof - returns TRUE if the last token was an eoftok
*/

static bool IsLastTokenEof (void)
{
  M2LexBuf_TokenDesc tokdesc;

  if (Indexing_IsEmpty (ListOfTokens))
    {
      return false;
    }
  else
    {
      tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, Indexing_HighIndice (ListOfTokens)));
      return tokdesc->token == M2Reserved_eoftok;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isSrcToken - returns TRUE if tokenno is associated with
                program source code.
*/

static bool isSrcToken (unsigned int tokenno)
{
  return (tokenno != M2LexBuf_UnknownTokenNo) && (tokenno != M2LexBuf_BuiltinTokenNo);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   tprintf0 -
*/

static void tprintf0 (const char *format_, unsigned int _format_high)
{
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  if (Tracing)
    {
      M2Printf_printf0 ((const char *) format, _format_high);
    }
}


/*
   tprintf1 -
*/

static void tprintf1 (const char *format_, unsigned int _format_high, DynamicStrings_String str)
{
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  if (Tracing)
    {
      M2Printf_printf1 ((const char *) format, _format_high, (const unsigned char *) &str, (sizeof (str)-1));
    }
}


/*
   OpenSource - Attempts to open the source file, s.
                The success of the operation is returned.
*/

extern "C" bool M2LexBuf_OpenSource (DynamicStrings_String s)
{
  tprintf1 ((const char *) "OpenSource (%s)\\n", 17, s);
  SeenEof = false;
  if (UseBufferedTokens)
    {
      M2LexBuf_GetToken ();
      return true;
    }
  else
    {
      if (m2flex_OpenSource (DynamicStrings_string (s)))
        {
          M2LexBuf_SetFile (DynamicStrings_string (s));
          M2LexBuf_GetToken ();
          if (IsLastTokenEof ())
            {
              M2MetaError_MetaErrorT0 (M2LexBuf_GetTokenNo (), (const char *) "source file is empty", 20);
            }
          return true;
        }
      else
        {
          return false;
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CloseSource - closes the current open file.
*/

extern "C" void M2LexBuf_CloseSource (void)
{
  tprintf0 ((const char *) "CloseSource\\n", 13);
  if (UseBufferedTokens)
    {
      while (M2LexBuf_currenttoken != M2Reserved_eoftok)
        {
          M2LexBuf_GetToken ();
        }
    }
  /* a subsequent call to m2flex.OpenSource will really close the file  */
}


/*
   ReInitialize - re-initialize the all the data structures.
*/

extern "C" void M2LexBuf_ReInitialize (void)
{
  Indexing_ForeachIndiceInIndexDo (ListOfTokens, (Indexing_IndexProcedure) {(Indexing_IndexProcedure_t) DeleteTokenDesc});
  CurrentUsed = false;
  KillList ();
  Init ();
}


/*
   ResetForNewPass - reset the buffer pointers to the beginning ready for
                     a new pass
*/

extern "C" void M2LexBuf_ResetForNewPass (void)
{
  InsertionIndex = 0;
  CurrentTokNo = InitialSourceToken;
  UseBufferedTokens = true;
}


/*
   GetToken - gets the next token into currenttoken.
*/

extern "C" void M2LexBuf_GetToken (void)
{
  typedef struct GetToken__T3_a GetToken__T3;

  struct GetToken__T3_a { char array[20+1]; };
  GetToken__T3 buf;

  if (UseBufferedTokens)
    {
      /* avoid dangling else.  */
      UpdateToken (ListOfTokens, CurrentTokNo);
      if (M2Options_GetDebugTraceToken ())
        {
          NumberIO_CardToStr (CurrentTokNo, 0, (char *) &buf.array[0], 20);
          FIO_WriteString (M2LangDump_GetDumpFile (), (const char *) "token: ", 7);
          FIO_WriteString (M2LangDump_GetDumpFile (), (const char *) &buf.array[0], 20);
          FIO_WriteLine (M2LangDump_GetDumpFile ());
        }
    }
  else
    {
      if (! (Indexing_InBounds (ListOfTokens, CurrentTokNo)))
        {
          GetTokenFiltered (false);
        }
      UpdateToken (ListOfTokens, CurrentTokNo);
      if (M2Options_GetDebugTraceToken ())
        {
          NumberIO_CardToStr (CurrentTokNo, 0, (char *) &buf.array[0], 20);
          m2flex_M2Error (&buf);
        }
    }
}


/*
   InsertToken - inserts a symbol token infront of the current token
                 ready for the next pass.
*/

extern "C" void M2LexBuf_InsertToken (M2Reserved_toktype token)
{
  unsigned int prev;
  M2LexBuf_TokenDesc tokdesc;

  M2Debug_Assert (ListOfTokens != NULL);
  M2Debug_Assert (! (Indexing_IsEmpty (ListOfTokens)));
  prev = (M2LexBuf_GetTokenNo ())-1;
  tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, prev));
  if (tokdesc->insert == NULL)
    {
      tokdesc->insert = Indexing_InitIndex (1);
    }
  AppendInsertToken (tokdesc->insert, DupTok (tokdesc, token));
}


/*
   InsertTokenAndRewind - inserts a symbol token infront of the current token
                          and then moves the token stream back onto the inserted
                          token.
*/

extern "C" void M2LexBuf_InsertTokenAndRewind (M2Reserved_toktype token)
{
  unsigned int position;
  M2LexBuf_TokenDesc tokdesc;

  if ((M2LexBuf_GetTokenNo ()) > 0)
    {
      M2LexBuf_InsertToken (token);
      position = CurrentTokNo-2;
      tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, position));
      if (tokdesc->insert == NULL)
        {
          tokdesc->insert = Indexing_InitIndex (1);
        }
      AppendInsertToken (tokdesc->insert, DupTok (tokdesc, token));
      InsertionIndex = Indexing_HighIndice (tokdesc->insert);
      CurrentTokNo -= 2;
      M2LexBuf_GetToken ();
    }
}


/*
   GetPreviousTokenLineNo - returns the line number of the previous token.
*/

extern "C" unsigned int M2LexBuf_GetPreviousTokenLineNo (void)
{
  return M2LexBuf_GetLineNo ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLineNo - returns the current line number where the symbol occurs in
               the source file.
*/

extern "C" unsigned int M2LexBuf_GetLineNo (void)
{
  if (CurrentTokNo == 0)
    {
      return 0;
    }
  else
    {
      return M2LexBuf_TokenToLineNo (M2LexBuf_GetTokenNo (), 0);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTokenNo - returns the current token number.
*/

extern "C" unsigned int M2LexBuf_GetTokenNo (void)
{
  if (CurrentTokNo == 0)
    {
      return 0;
    }
  else
    {
      return CurrentTokNo-1;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTokenName - returns the token name given the tokenno.
*/

extern "C" NameKey_Name M2LexBuf_GetTokenName (unsigned int tokenno)
{
  M2LexBuf_TokenDesc tokdesc;
  NameKey_Name name;

  if (Indexing_InBounds (ListOfTokens, tokenno))
    {
      tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, tokenno));
      name = M2Reserved_tokToTok (tokdesc->token);
      if (name == NameKey_NulName)
        {
          return tokdesc->str;
        }
      else
        {
          return name;
        }
    }
  return NameKey_NulName;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TokenToLineNo - returns the line number of the current file for the
                   tokenno. The depth refers to the include depth.
                   A depth of 0 is the current file, depth of 1 is the file
                   which included the current file. Zero is returned if the
                   depth exceeds the file nesting level.
*/

extern "C" unsigned int M2LexBuf_TokenToLineNo (unsigned int tokenno, unsigned int depth)
{
  M2LexBuf_TokenDesc tokdesc;
  M2LexBuf_SourceList level;

  if ((tokenno != M2LexBuf_UnknownTokenNo) && (tokenno != M2LexBuf_BuiltinTokenNo))
    {
      if (Indexing_InBounds (ListOfTokens, tokenno))
        {
          tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, tokenno));
          if (depth == 0)
            {
              return tokdesc->line;
            }
          else
            {
              level = tokdesc->file->left;
              while (depth > 0)
                {
                  level = level->left;
                  if (level == tokdesc->file->left)
                    {
                      return 0;
                    }
                  depth -= 1;
                }
              return level->line;
            }
        }
    }
  return 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetColumnNo - returns the current column where the symbol occurs in
                 the source file.
*/

extern "C" unsigned int M2LexBuf_GetColumnNo (void)
{
  if (CurrentTokNo == 0)
    {
      return 0;
    }
  else
    {
      return M2LexBuf_TokenToColumnNo (M2LexBuf_GetTokenNo (), 0);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TokenToColumnNo - returns the column number of the current file for the
                     tokenno. The depth refers to the include depth.
                     A depth of 0 is the current file, depth of 1 is the file
                     which included the current file. Zero is returned if the
                     depth exceeds the file nesting level.
*/

extern "C" unsigned int M2LexBuf_TokenToColumnNo (unsigned int tokenno, unsigned int depth)
{
  M2LexBuf_TokenDesc tokdesc;
  M2LexBuf_SourceList level;

  if ((tokenno != M2LexBuf_UnknownTokenNo) && (tokenno != M2LexBuf_BuiltinTokenNo))
    {
      if (Indexing_InBounds (ListOfTokens, tokenno))
        {
          tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, tokenno));
          if (depth == 0)
            {
              return tokdesc->col;
            }
          else
            {
              level = tokdesc->file->left;
              while (depth > 0)
                {
                  level = level->left;
                  if (level == tokdesc->file->left)
                    {
                      return 0;
                    }
                  depth -= 1;
                }
              return level->col;
            }
        }
    }
  return 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TokenToLocation - returns the location_t corresponding to tokenno.
*/

extern "C" location_t M2LexBuf_TokenToLocation (unsigned int tokenno)
{
  M2LexBuf_TokenDesc tokdesc;

  if (tokenno == M2LexBuf_UnknownTokenNo)
    {
      return M2Emit_UnknownLocation ();
    }
  else if (tokenno == M2LexBuf_BuiltinTokenNo)
    {
      /* avoid dangling else.  */
      return M2Emit_BuiltinsLocation ();
    }
  else if (Indexing_InBounds (ListOfTokens, tokenno))
    {
      /* avoid dangling else.  */
      tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, tokenno));
      return tokdesc->loc;
    }
  return M2Emit_UnknownLocation ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FindFileNameFromToken - returns the complete FileName for the appropriate
                           source file yields the token number, TokenNo.
                           The, Depth, indicates the include level: 0..n
                           Level 0 is the current. NIL is returned if n+1
                           is requested.
*/

extern "C" DynamicStrings_String M2LexBuf_FindFileNameFromToken (unsigned int tokenno, unsigned int depth)
{
  M2LexBuf_TokenDesc tokdesc;
  M2LexBuf_SourceList level;

  if ((tokenno != M2LexBuf_UnknownTokenNo) && (tokenno != M2LexBuf_BuiltinTokenNo))
    {
      if (Indexing_InBounds (ListOfTokens, tokenno))
        {
          tokdesc = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, tokenno));
          level = tokdesc->file->left;
          while (depth > 0)
            {
              level = level->left;
              if (level == tokdesc->file->left)
                {
                  return static_cast<DynamicStrings_String> (NULL);
                }
              depth -= 1;
            }
          return level->name;
        }
    }
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFileName - returns a String defining the current file.
*/

extern "C" DynamicStrings_String M2LexBuf_GetFileName (void)
{
  return M2LexBuf_FindFileNameFromToken (M2LexBuf_GetTokenNo (), 0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeVirtualTok - providing caret, left, right are associated with a source file
                    and exist on the same src line then
                    create and return a new tokenno which is created from
                    tokenno left and right.  Otherwise return caret.
                    If caret is UnknownTokenNo then it is replaced with left or right
                    in sequence to avoid an UnknownTokenNo.
*/

extern "C" unsigned int M2LexBuf_MakeVirtualTok (unsigned int caret, unsigned int left, unsigned int right)
{
  M2LexBuf_TokenDesc descLeft;
  M2LexBuf_TokenDesc descRight;
  location_t lc;
  location_t ll;
  location_t lr;

  if (caret == M2LexBuf_UnknownTokenNo)
    {
      caret = left;
    }
  if (caret == M2LexBuf_UnknownTokenNo)
    {
      caret = right;
    }
  if (((isSrcToken (caret)) && (isSrcToken (left))) && (isSrcToken (right)))
    {
      lc = M2LexBuf_TokenToLocation (caret);
      ll = M2LexBuf_TokenToLocation (left);
      lr = M2LexBuf_TokenToLocation (right);
      if ((Indexing_InBounds (ListOfTokens, left)) && (Indexing_InBounds (ListOfTokens, right)))
        {
          descLeft = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, left));
          descRight = static_cast<M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, right));
          if ((descLeft->line == descRight->line) && (descLeft->file == descRight->file))
            {
              /* On the same line, create a new token and location.  */
              AddTokToList (M2Reserved_virtualrangetok, NameKey_NulName, 0, descLeft->line, descLeft->col, descLeft->file, m2linemap_GetLocationBinary (lc, ll, lr));
              caret = Indexing_HighIndice (ListOfTokens);
            }
        }
    }
  if (caret == BadTokenNo)
    {
      stop ();
    }
  return caret;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeVirtual2Tok - creates and return a new tokenno which is created from
                     two tokens left and right.  It tries to avoid UnknownTokenNo
                     and will fall back to left or right if necessary.
*/

extern "C" unsigned int M2LexBuf_MakeVirtual2Tok (unsigned int left, unsigned int right)
{
  if (left == M2LexBuf_UnknownTokenNo)
    {
      left = right;
    }
  else if (right == M2LexBuf_UnknownTokenNo)
    {
      /* avoid dangling else.  */
      right = left;
    }
  return M2LexBuf_MakeVirtualTok (left, left, right);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddTok - adds a token to the buffer.
*/

extern "C" void M2LexBuf_AddTok (M2Reserved_toktype t)
{
  DynamicStrings_String s;

  if (Tracing)
    {
      M2Printf_printf0 ((const char *) " m2.flex -> AddTok ", 19);
      M2LexBuf_DisplayToken (t);
      M2Printf_printf0 ((const char *) "\\n", 2);
    }
  if ((t == M2Reserved_eoftok) && SeenEof)
    {
      /* avoid dangling else.  */
      if (Debugging)
        {
          M2Printf_printf0 ((const char *) "extra eoftok ignored as buffer already contains eoftok\\n", 56);
        }
    }
  else
    {
      if (Debugging)
        {
          M2Printf_printf0 ((const char *) "adding token: ", 14);
          M2LexBuf_DisplayToken (t);
          M2Printf_printf0 ((const char *) "\\n", 2);
        }
      AddTokToList (t, NameKey_NulName, 0, m2flex_GetLineNo (), m2flex_GetColumnNo (), CurrentSource, m2flex_GetLocation ());
      CurrentUsed = true;
      if (Debugging)
        {
          /* display each token as a warning.  */
          s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (M2LexBuf_GetTokenName (M2LexBuf_GetTokenNo ())));
          M2Error_WarnStringAt (s, M2LexBuf_GetTokenNo ());
        }
      if (t == M2Reserved_eoftok)
        {
          SeenEof = true;
        }
    }
}


/*
   AddTokCharStar - adds a token to the buffer and an additional string, s.
                    A copy of string, s, is made.
*/

extern "C" void M2LexBuf_AddTokCharStar (M2Reserved_toktype t, void * s)
{
  DynamicStrings_String str;

  M2Debug_Assert (t != M2Reserved_eoftok);
  if (Tracing)
    {
      M2Printf_printf0 ((const char *) " m2.flex -> AddTokCharStar ", 27);
      M2LexBuf_DisplayToken (t);
      str = DynamicStrings_InitStringCharStar (s);
      M2Printf_printf1 ((const char *) " %s\\n", 5, (const unsigned char *) &str, (sizeof (str)-1));
      str = DynamicStrings_KillString (str);
    }
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "AddTokCharStar: ", 16);
      M2LexBuf_DisplayToken (t);
      M2Printf_printf0 ((const char *) "\\n", 2);
    }
  AddTokToList (t, NameKey_makekey (s), 0, m2flex_GetLineNo (), m2flex_GetColumnNo (), CurrentSource, m2flex_GetLocation ());
  CurrentUsed = true;
}


/*
   AddTokInteger - adds a token and an integer to the buffer.
*/

extern "C" void M2LexBuf_AddTokInteger (M2Reserved_toktype t, int i)
{
  DynamicStrings_String s;
  unsigned int c;
  unsigned int l;

  M2Debug_Assert (t != M2Reserved_eoftok);
  if (Tracing)
    {
      M2Printf_printf0 ((const char *) " m2.flex -> AddTokInteger ", 26);
      M2LexBuf_DisplayToken (t);
      M2Printf_printf1 ((const char *) " %d\\n", 5, (const unsigned char *) &i, (sizeof (i)-1));
    }
  l = m2flex_GetLineNo ();
  c = m2flex_GetColumnNo ();
  s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%d", 2)), (const unsigned char *) &i, (sizeof (i)-1));
  AddTokToList (t, NameKey_makekey (DynamicStrings_string (s)), i, l, c, CurrentSource, m2flex_GetLocation ());
  s = DynamicStrings_KillString (s);
  CurrentUsed = true;
}


/*
   SetFile - sets the current filename to, filename.
*/

extern "C" void M2LexBuf_SetFile (void * filename)
{
  KillList ();
  CurrentUsed = false;
  CurrentSource = NewList ();
  AddTo (NewElement (filename));
}


/*
   PushFile - indicates that, filename, has just been included.
*/

extern "C" void M2LexBuf_PushFile (void * filename)
{
  M2LexBuf_SourceList l;

  CheckIfNeedToDuplicate ();
  AddTo (NewElement (filename));
  if (Debugging)
    {
      if (CurrentSource->right != CurrentSource)
        {
          l = CurrentSource;
          do {
            M2Printf_printf3 ((const char *) "name = %s, line = %d, col = %d\\n", 32, (const unsigned char *) &l->name, (sizeof (l->name)-1), (const unsigned char *) &l->line, (sizeof (l->line)-1), (const unsigned char *) &l->col, (sizeof (l->col)-1));
            l = l->right;
          } while (! (l == CurrentSource));
        }
    }
}


/*
   PopFile - indicates that we are returning to, filename, having finished
             an include.
*/

extern "C" void M2LexBuf_PopFile (void * filename)
{
  M2LexBuf_SourceList l;

  CheckIfNeedToDuplicate ();
  if ((CurrentSource != NULL) && (CurrentSource->left != CurrentSource))
    {
      /* avoid dangling else.  */
      l = CurrentSource->left;  /* last element  */
      SubFrom (l);  /* last element  */
      Storage_DEALLOCATE ((void **) &l, sizeof (M2LexBuf__T1));
      if ((CurrentSource->left != CurrentSource) && (! (DynamicStrings_Equal (CurrentSource->name, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (filename))))))
        {}  /* empty.  */
      /* mismatch in source file names after preprocessing files  */
    }
  /* source file list is empty, cannot pop an include..  */
}


/*
   PrintTokenNo - displays token and the location of the token.
*/

extern "C" void M2LexBuf_PrintTokenNo (unsigned int tokenno)
{
  DynamicStrings_String s;

  M2Printf_printf1 ((const char *) "tokenno = %d, ", 14, (const unsigned char *) &tokenno, (sizeof (tokenno)-1));
  s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (M2LexBuf_GetTokenName (tokenno)));
  M2Printf_printf1 ((const char *) "%s\\n", 4, (const unsigned char *) &s, (sizeof (s)-1));
  s = DynamicStrings_KillString (s);
}


/*
   DisplayToken - display the token name using printf0 no newline is emitted.
*/

extern "C" void M2LexBuf_DisplayToken (M2Reserved_toktype tok)
{
  switch (tok)
    {
      case M2Reserved_eoftok:
        M2Printf_printf0 ((const char *) "eoftok", 6);
        break;

      case M2Reserved_plustok:
        M2Printf_printf0 ((const char *) "plustok", 7);
        break;

      case M2Reserved_minustok:
        M2Printf_printf0 ((const char *) "minustok", 8);
        break;

      case M2Reserved_timestok:
        M2Printf_printf0 ((const char *) "timestok", 8);
        break;

      case M2Reserved_dividetok:
        M2Printf_printf0 ((const char *) "dividetok", 9);
        break;

      case M2Reserved_becomestok:
        M2Printf_printf0 ((const char *) "becomestok", 10);
        break;

      case M2Reserved_ambersandtok:
        M2Printf_printf0 ((const char *) "ambersandtok", 12);
        break;

      case M2Reserved_periodtok:
        M2Printf_printf0 ((const char *) "periodtok", 9);
        break;

      case M2Reserved_commatok:
        M2Printf_printf0 ((const char *) "commatok", 8);
        break;

      case M2Reserved_semicolontok:
        M2Printf_printf0 ((const char *) "semicolontok", 12);
        break;

      case M2Reserved_lparatok:
        M2Printf_printf0 ((const char *) "lparatok", 8);
        break;

      case M2Reserved_rparatok:
        M2Printf_printf0 ((const char *) "rparatok", 8);
        break;

      case M2Reserved_lsbratok:
        M2Printf_printf0 ((const char *) "lsbratok", 8);
        break;

      case M2Reserved_rsbratok:
        M2Printf_printf0 ((const char *) "rsbratok", 8);
        break;

      case M2Reserved_lcbratok:
        M2Printf_printf0 ((const char *) "lcbratok", 8);
        break;

      case M2Reserved_rcbratok:
        M2Printf_printf0 ((const char *) "rcbratok", 8);
        break;

      case M2Reserved_uparrowtok:
        M2Printf_printf0 ((const char *) "uparrowtok", 10);
        break;

      case M2Reserved_singlequotetok:
        M2Printf_printf0 ((const char *) "singlequotetok", 14);
        break;

      case M2Reserved_equaltok:
        M2Printf_printf0 ((const char *) "equaltok", 8);
        break;

      case M2Reserved_hashtok:
        M2Printf_printf0 ((const char *) "hashtok", 7);
        break;

      case M2Reserved_lesstok:
        M2Printf_printf0 ((const char *) "lesstok", 7);
        break;

      case M2Reserved_greatertok:
        M2Printf_printf0 ((const char *) "greatertok", 10);
        break;

      case M2Reserved_lessgreatertok:
        M2Printf_printf0 ((const char *) "lessgreatertok", 14);
        break;

      case M2Reserved_lessequaltok:
        M2Printf_printf0 ((const char *) "lessequaltok", 12);
        break;

      case M2Reserved_greaterequaltok:
        M2Printf_printf0 ((const char *) "greaterequaltok", 15);
        break;

      case M2Reserved_periodperiodtok:
        M2Printf_printf0 ((const char *) "periodperiodtok", 15);
        break;

      case M2Reserved_colontok:
        M2Printf_printf0 ((const char *) "colontok", 8);
        break;

      case M2Reserved_doublequotestok:
        M2Printf_printf0 ((const char *) "doublequotestok", 15);
        break;

      case M2Reserved_bartok:
        M2Printf_printf0 ((const char *) "bartok", 6);
        break;

      case M2Reserved_andtok:
        M2Printf_printf0 ((const char *) "andtok", 6);
        break;

      case M2Reserved_arraytok:
        M2Printf_printf0 ((const char *) "arraytok", 8);
        break;

      case M2Reserved_begintok:
        M2Printf_printf0 ((const char *) "begintok", 8);
        break;

      case M2Reserved_bytok:
        M2Printf_printf0 ((const char *) "bytok", 5);
        break;

      case M2Reserved_casetok:
        M2Printf_printf0 ((const char *) "casetok", 7);
        break;

      case M2Reserved_consttok:
        M2Printf_printf0 ((const char *) "consttok", 8);
        break;

      case M2Reserved_definitiontok:
        M2Printf_printf0 ((const char *) "definitiontok", 13);
        break;

      case M2Reserved_divtok:
        M2Printf_printf0 ((const char *) "divtok", 6);
        break;

      case M2Reserved_dotok:
        M2Printf_printf0 ((const char *) "dotok", 5);
        break;

      case M2Reserved_elsetok:
        M2Printf_printf0 ((const char *) "elsetok", 7);
        break;

      case M2Reserved_elsiftok:
        M2Printf_printf0 ((const char *) "elsiftok", 8);
        break;

      case M2Reserved_endtok:
        M2Printf_printf0 ((const char *) "endtok", 6);
        break;

      case M2Reserved_exittok:
        M2Printf_printf0 ((const char *) "exittok", 7);
        break;

      case M2Reserved_exporttok:
        M2Printf_printf0 ((const char *) "exporttok", 9);
        break;

      case M2Reserved_fortok:
        M2Printf_printf0 ((const char *) "fortok", 6);
        break;

      case M2Reserved_fromtok:
        M2Printf_printf0 ((const char *) "fromtok", 7);
        break;

      case M2Reserved_iftok:
        M2Printf_printf0 ((const char *) "iftok", 5);
        break;

      case M2Reserved_implementationtok:
        M2Printf_printf0 ((const char *) "implementationtok", 17);
        break;

      case M2Reserved_importtok:
        M2Printf_printf0 ((const char *) "importtok", 9);
        break;

      case M2Reserved_intok:
        M2Printf_printf0 ((const char *) "intok", 5);
        break;

      case M2Reserved_looptok:
        M2Printf_printf0 ((const char *) "looptok", 7);
        break;

      case M2Reserved_modtok:
        M2Printf_printf0 ((const char *) "modtok", 6);
        break;

      case M2Reserved_moduletok:
        M2Printf_printf0 ((const char *) "moduletok", 9);
        break;

      case M2Reserved_nottok:
        M2Printf_printf0 ((const char *) "nottok", 6);
        break;

      case M2Reserved_oftok:
        M2Printf_printf0 ((const char *) "oftok", 5);
        break;

      case M2Reserved_ortok:
        M2Printf_printf0 ((const char *) "ortok", 5);
        break;

      case M2Reserved_pointertok:
        M2Printf_printf0 ((const char *) "pointertok", 10);
        break;

      case M2Reserved_proceduretok:
        M2Printf_printf0 ((const char *) "proceduretok", 12);
        break;

      case M2Reserved_qualifiedtok:
        M2Printf_printf0 ((const char *) "qualifiedtok", 12);
        break;

      case M2Reserved_unqualifiedtok:
        M2Printf_printf0 ((const char *) "unqualifiedtok", 14);
        break;

      case M2Reserved_recordtok:
        M2Printf_printf0 ((const char *) "recordtok", 9);
        break;

      case M2Reserved_repeattok:
        M2Printf_printf0 ((const char *) "repeattok", 9);
        break;

      case M2Reserved_returntok:
        M2Printf_printf0 ((const char *) "returntok", 9);
        break;

      case M2Reserved_settok:
        M2Printf_printf0 ((const char *) "settok", 6);
        break;

      case M2Reserved_thentok:
        M2Printf_printf0 ((const char *) "thentok", 7);
        break;

      case M2Reserved_totok:
        M2Printf_printf0 ((const char *) "totok", 5);
        break;

      case M2Reserved_typetok:
        M2Printf_printf0 ((const char *) "typetok", 7);
        break;

      case M2Reserved_untiltok:
        M2Printf_printf0 ((const char *) "untiltok", 8);
        break;

      case M2Reserved_vartok:
        M2Printf_printf0 ((const char *) "vartok", 6);
        break;

      case M2Reserved_whiletok:
        M2Printf_printf0 ((const char *) "whiletok", 8);
        break;

      case M2Reserved_withtok:
        M2Printf_printf0 ((const char *) "withtok", 7);
        break;

      case M2Reserved_asmtok:
        M2Printf_printf0 ((const char *) "asmtok", 6);
        break;

      case M2Reserved_volatiletok:
        M2Printf_printf0 ((const char *) "volatiletok", 11);
        break;

      case M2Reserved_periodperiodperiodtok:
        M2Printf_printf0 ((const char *) "periodperiodperiodtok", 21);
        break;

      case M2Reserved_datetok:
        M2Printf_printf0 ((const char *) "datetok", 7);
        break;

      case M2Reserved_linetok:
        M2Printf_printf0 ((const char *) "linetok", 7);
        break;

      case M2Reserved_filetok:
        M2Printf_printf0 ((const char *) "filetok", 7);
        break;

      case M2Reserved_integertok:
        M2Printf_printf0 ((const char *) "integertok", 10);
        break;

      case M2Reserved_identtok:
        M2Printf_printf0 ((const char *) "identtok", 8);
        break;

      case M2Reserved_realtok:
        M2Printf_printf0 ((const char *) "realtok", 7);
        break;

      case M2Reserved_stringtok:
        M2Printf_printf0 ((const char *) "stringtok", 9);
        break;


      default:
        break;
    }
}


/*
   DumpTokens - displays all tokens.
*/

extern "C" void M2LexBuf_DumpTokens (void)
{
  unsigned int high;
  unsigned int ind;

  if (Indexing_IsEmpty (ListOfTokens))
    {
      M2Printf_printf0 ((const char *) "The token buffer is empty\\n", 27);
    }
  else
    {
      ind = Indexing_LowIndice (ListOfTokens);
      high = Indexing_HighIndice (ListOfTokens);
      while (ind <= high)
        {
          M2Printf_printf1 ((const char *) "%5d ", 4, (const unsigned char *) &ind, (sizeof (ind)-1));
          DumpToken (reinterpret_cast <M2LexBuf_TokenDesc> (Indexing_GetIndice (ListOfTokens, ind)));
          ind += 1;
        }
    }
}

extern "C" void _M2_M2LexBuf_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2LexBuf_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
