/* do not edit automatically generated by mc from M2Error.  */
/* M2Error.mod error reporting interface.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Error_C

#include "GM2Error.h"
#   include "GNameKey.h"
#   include "GDynamicStrings.h"
#   include "GFIO.h"
#   include "GStrLib.h"
#   include "GFormatStrings.h"
#   include "GM2LexBuf.h"
#   include "GStorage.h"
#   include "GM2Printf.h"
#   include "GM2Options.h"
#   include "GM2RTS.h"
#   include "GSYSTEM.h"
#   include "GM2Emit.h"
#   include "GM2StackAddress.h"
#   include "GIndexing.h"
#   include "GM2Debug.h"
#   include "GM2Pass.h"
#   include "GSymbolTable.h"
#   include "GM2ColorString.h"

#   define Debugging true
#   define DebugTrace false
#   define DebugError false
typedef struct M2Error__T1_r M2Error__T1;

typedef struct M2Error__T2_r M2Error__T2;

typedef enum {M2Error_noscope, M2Error_definition, M2Error_implementation, M2Error_program, M2Error_module, M2Error_procedure} M2Error_KindScope;

typedef M2Error__T1 *M2Error_Error__opaque;

typedef M2Error__T2 *M2Error_ErrorScope__opaque;

struct M2Error__T1_r {
                       M2Error_Error__opaque parent;
                       M2Error_Error__opaque child;
                       M2Error_Error__opaque next;
                       bool note;
                       bool fatal;
                       DynamicStrings_String s;
                       unsigned int token;
                       bool color;
                       M2Error_ErrorScope__opaque scope;
                     };

struct M2Error__T2_r {
                       M2Error_KindScope scopeKind;
                       NameKey_Name scopeName;
                       unsigned int symbol;
                     };

static M2Error_Error__opaque head;
static bool InInternal;
static M2Error_ErrorScope__opaque lastScope;
static unsigned int scopeIndex;
static Indexing_Index scopeArray;
static M2Error_ErrorScope__opaque currentScope;
static M2StackAddress_StackOfAddress scopeStack;

/*
   InternalError - displays an internal error message together with the compiler source
                   file and line number.
                   This function is not buffered and is used when the compiler is about
                   to give up.
*/

extern "C" void M2Error_InternalError (const char *message_, unsigned int _message_high) __attribute__ ((noreturn));

/*
   WriteFormat0 - displays the source module and line together
                  with the encapsulated format string.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat0 (const char *a_, unsigned int _a_high);

/*
   WriteFormat1 - displays the source module and line together
                  with the encapsulated format string.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high);

/*
   WriteFormat2 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat2 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high);

/*
   WriteFormat3 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat3 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high);

/*
   NewError - creates and returns a new error handle.
*/

extern "C" M2Error_Error M2Error_NewError (unsigned int AtTokenNo);

/*
   NewWarning - creates and returns a new error handle suitable for a warning.
                A warning will not stop compilation.
*/

extern "C" M2Error_Error M2Error_NewWarning (unsigned int AtTokenNo);

/*
   NewNote - creates and returns a new error handle suitable for a note.
             A note will not stop compilation.
*/

extern "C" M2Error_Error M2Error_NewNote (unsigned int AtTokenNo);

/*
   ChainError - creates and returns a new error handle, this new error
                is associated with, e, and is chained onto the end of, e.
                If, e, is NIL then the result to NewError is returned.
*/

extern "C" M2Error_Error M2Error_ChainError (unsigned int AtTokenNo, M2Error_Error e);

/*
   MoveError - repositions an error, e, to token, AtTokenNo, and returns, e.
*/

extern "C" M2Error_Error M2Error_MoveError (M2Error_Error e, unsigned int AtTokenNo);

/*
   SetColor - informs the error module that this error will have had colors
              assigned to it.  If an error is issued without colors assigned
              then the default colors will be assigned to the legacy error
              messages.
*/

extern "C" M2Error_Error M2Error_SetColor (M2Error_Error e);
extern "C" void M2Error_ErrorFormat0 (M2Error_Error e, const char *a_, unsigned int _a_high);
extern "C" void M2Error_ErrorFormat1 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high);
extern "C" void M2Error_ErrorFormat2 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high);
extern "C" void M2Error_ErrorFormat3 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high);
extern "C" void M2Error_ErrorString (M2Error_Error e, DynamicStrings_String str);

/*
   ErrorStringAt - given an error string, s, it places this
                   string at token position, tok.
                   The string is consumed.
*/

extern "C" void M2Error_ErrorStringAt (DynamicStrings_String s, unsigned int tok);

/*
   ErrorStringAt2 - given an error string, s, it places this
                    string at token positions, tok1 and tok2, respectively.
                    The string is consumed.
*/

extern "C" void M2Error_ErrorStringAt2 (DynamicStrings_String s, unsigned int tok1, unsigned int tok2);

/*
   ErrorStringsAt2 - given error strings, s1, and, s2, it places these
                     strings at token positions, tok1 and tok2, respectively.
                     Both strings are consumed.
*/

extern "C" void M2Error_ErrorStringsAt2 (DynamicStrings_String s1, DynamicStrings_String s2, unsigned int tok1, unsigned int tok2);

/*
   WarnStringAt - given an error string, s, it places this
                  string at token position, tok.
                  The string is consumed.
*/

extern "C" void M2Error_WarnStringAt (DynamicStrings_String s, unsigned int tok);

/*
   WarnStringAt2 - given an warning string, s, it places this
                   string at token positions, tok1 and tok2, respectively.
                   The string is consumed.
*/

extern "C" void M2Error_WarnStringAt2 (DynamicStrings_String s, unsigned int tok1, unsigned int tok2);

/*
   WarnStringsAt2 - given warning strings, s1, and, s2, it places these
                    strings at token positions, tok1 and tok2, respectively.
                    Both strings are consumed.
*/

extern "C" void M2Error_WarnStringsAt2 (DynamicStrings_String s1, DynamicStrings_String s2, unsigned int tok1, unsigned int tok2);

/*
   WarnFormat0 - displays the source module and line together
                 with the encapsulated format string.
                 Used for simple warning messages tied to the current token.
*/

extern "C" void M2Error_WarnFormat0 (const char *a_, unsigned int _a_high);

/*
   WarnFormat1 - displays the source module and line together
                 with the encapsulated format string.
                 Used for simple warning messages tied to the current token.
*/

extern "C" void M2Error_WarnFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high);

/*
   FlushErrors - switches the output channel to the error channel
                 and then writes out all errors.
*/

extern "C" void M2Error_FlushErrors (void);

/*
   FlushWarnings - switches the output channel to the error channel
                   and then writes out all warnings.
                   If an error is present the compilation is terminated,
                   if warnings only were emitted then compilation will
                   continue.
*/

extern "C" void M2Error_FlushWarnings (void);

/*
   ErrorAbort0 - aborts compiling, it flushes all warnings and errors before aborting.
*/

extern "C" void M2Error_ErrorAbort0 (const char *a_, unsigned int _a_high) __attribute__ ((noreturn));

/*
   AnnounceScope - return the error string s with a scope description prepended
                   assuming that scope has changed.
*/

extern "C" DynamicStrings_String M2Error_AnnounceScope (M2Error_Error e, DynamicStrings_String message);

/*
   EnterImplementationScope - signifies to the error routines that the front end
                              has started to compile implementation module scopeName.
*/

extern "C" void M2Error_EnterImplementationScope (NameKey_Name scopename);

/*
   EnterProgramScope - signifies to the error routines that the front end
                       has started to compile program module scopeName.
*/

extern "C" void M2Error_EnterProgramScope (NameKey_Name scopename);

/*
   EnterModuleScope - signifies to the error routines that the front end
                      has started to compile an inner module scopeName.
*/

extern "C" void M2Error_EnterModuleScope (NameKey_Name scopename);

/*
   EnterDefinitionScope - signifies to the error routines that the front end
                          has started to compile definition module scopeName.
*/

extern "C" void M2Error_EnterDefinitionScope (NameKey_Name scopename);

/*
   EnterProcedureScope - signifies to the error routines that the front end
                         has started to compile definition module scopeName.
*/

extern "C" void M2Error_EnterProcedureScope (NameKey_Name scopename);

/*
   DepthScope - returns the depth of the scope stack.
*/

extern "C" unsigned int M2Error_DepthScope (void);

/*
   GetAnnounceScope - return message with the error scope attached to message.
                      filename and message are treated as read only by this
                      procedure function.
*/

extern "C" DynamicStrings_String M2Error_GetAnnounceScope (DynamicStrings_String filename, DynamicStrings_String message);

/*
   DefaultProgramModule - sets up an unnamed program scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultProgramModule (void);

/*
   DefaultImplementationModule - sets up an unnamed implementation
                                 scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultImplementationModule (void);

/*
   DefaultDefinitionModule - sets up an unnamed definition
                             scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultDefinitionModule (void);

/*
   DefaultInnerModule - sets up an unnamed inner
                        scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultInnerModule (void);

/*
   DefaultProcedure - sets up an unnamed procedure
                      scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultProcedure (void);

/*
   EnterErrorScope - pushes the currentScope and sets currentScope to scope.
*/

extern "C" void M2Error_EnterErrorScope (M2Error_ErrorScope scope);

/*
   LeaveErrorScope - leave the current scope and pop into the previous one.
*/

extern "C" void M2Error_LeaveErrorScope (void);

/*
   GetCurrentErrorScope - returns currentScope.
*/

extern "C" M2Error_ErrorScope M2Error_GetCurrentErrorScope (void);

/*
   ResetErrorScope - should be called at the start of each pass to
                     reset the error scope index.
*/

extern "C" void M2Error_ResetErrorScope (void);

/*
   Cast - casts a := b
*/

static void Cast (unsigned char *a, unsigned int _a_high, const unsigned char *b_, unsigned int _b_high);
static bool TranslateNameToCharStar (char *a, unsigned int _a_high, unsigned int n);

/*
   DoFormat1 -
*/

static DynamicStrings_String DoFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high);

/*
   DoFormat2 -
*/

static DynamicStrings_String DoFormat2 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high);

/*
   WriteFormat2 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

static DynamicStrings_String DoFormat3 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high);

/*
   Init - initializes the error list.
*/

static void Init (void);

/*
   CheckIncludes - generates a sequence of error messages which determine the relevant
                   included file and line number.
                   For example:

                   gcc a.c
                   In file included from b.h:1,
                                    from a.c:1:
                   c.h:1: parse error before `and'

                   where a.c is: #include "b.h"
                         b.h is: #include "c.h"
                         c.h is: and this and that

                   we attempt to follow the error messages that gcc issues.
*/

static void CheckIncludes (unsigned int token, unsigned int depth);

/*
   FlushAll - flushes all errors in list, e.
*/

static bool FlushAll (M2Error_Error__opaque e, bool FatalStatus);

/*
   IsErrorScopeNul - returns TRUE if es is NIL or it has a NulName.
*/

static bool IsErrorScopeNul (M2Error_ErrorScope__opaque es);

/*
   IsSameScope - return TRUE if a and b refer to the same scope.
*/

static bool IsSameScope (M2Error_ErrorScope__opaque a, M2Error_ErrorScope__opaque b);

/*
   newErrorScope - create an ErrorScope of kindScope and return the object.
                   It is also added the a dynamic array.
*/

static M2Error_ErrorScope__opaque newErrorScope (M2Error_KindScope kind);


/*
   Cast - casts a := b
*/

static void Cast (unsigned char *a, unsigned int _a_high, const unsigned char *b_, unsigned int _b_high)
{
  unsigned int i;
  unsigned char b[_b_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (b, b_, _b_high+1);

  if (_a_high == _b_high)
    {
      for (i=0; i<=_a_high; i++)
        {
          const_cast<unsigned char *>(a)[i] = b[i];
        }
    }
}

static bool TranslateNameToCharStar (char *a, unsigned int _a_high, unsigned int n)
{
  unsigned int argno;
  unsigned int i;
  unsigned int h;

  /* 
   TranslateNameToString - takes a format specification string, a, and
                           if they consist of of %a then this is translated
                           into a String and %a is replaced by %s.
  */
  argno = 1;
  i = 0;
  h = StrLib_StrLen ((const char *) a, _a_high);
  while (i < h)
    {
      if ((a[i] == '%') && ((i+1) < h))
        {
          if ((a[i+1] == 'a') && (argno == n))
            {
              const_cast<char *>(a)[i+1] = 's';
              return true;
            }
          argno += 1;
          if (argno > n)
            {
              /* all done  */
              return false;
            }
        }
      i += 1;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoFormat1 -
*/

static DynamicStrings_String DoFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high)
{
  DynamicStrings_String s;
  NameKey_Name n;
  char a[_a_high+1];
  unsigned char w[_w_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w, w_, _w_high+1);

  n = NameKey_NulName;
  if (TranslateNameToCharStar ((char *) a, _a_high, 1))
    {
      Cast ((unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) w, _w_high);
      s = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (n)));
      s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) &s, (sizeof (s)-1));
    }
  else
    {
      s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) w, _w_high);
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoFormat2 -
*/

static DynamicStrings_String DoFormat2 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high)
{
  NameKey_Name n;
  DynamicStrings_String s;
  DynamicStrings_String s1;
  DynamicStrings_String s2;
  unsigned int b;
  char a[_a_high+1];
  unsigned char w1[_w1_high+1];
  unsigned char w2[_w2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w1, w1_, _w1_high+1);
  memcpy (w2, w2_, _w2_high+1);

  b = (unsigned int) 0;
  n = NameKey_NulName;
  if (TranslateNameToCharStar ((char *) a, _a_high, 1))
    {
      Cast ((unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) w1, _w1_high);
      s1 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (n)));
      b |= (1 << (1 ));
    }
  if (TranslateNameToCharStar ((char *) a, _a_high, 2))
    {
      Cast ((unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) w2, _w2_high);
      s2 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (n)));
      b |= (1 << (2 ));
    }
  switch (b)
    {
      case (unsigned int) 0:
        s = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) w1, _w1_high, (const unsigned char *) w2, _w2_high);
        break;

      case (unsigned int) ((1 << (1))):
        s = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) w2, _w2_high);
        break;

      case (unsigned int) ((1 << (2))):
        s = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) w1, _w1_high, (const unsigned char *) &s2, (sizeof (s2)-1));
        break;

      case (unsigned int) ((1 << (1)) | (1 << (2))):
        s = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) &s2, (sizeof (s2)-1));
        break;


      default:
        M2RTS_HALT (-1);
        __builtin_unreachable ();
        break;
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WriteFormat2 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

static DynamicStrings_String DoFormat3 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high)
{
  NameKey_Name n;
  DynamicStrings_String s;
  DynamicStrings_String s1;
  DynamicStrings_String s2;
  DynamicStrings_String s3;
  unsigned int b;
  char a[_a_high+1];
  unsigned char w1[_w1_high+1];
  unsigned char w2[_w2_high+1];
  unsigned char w3[_w3_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w1, w1_, _w1_high+1);
  memcpy (w2, w2_, _w2_high+1);
  memcpy (w3, w3_, _w3_high+1);

  b = (unsigned int) 0;
  n = NameKey_NulName;
  if (TranslateNameToCharStar ((char *) a, _a_high, 1))
    {
      Cast ((unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) w1, _w1_high);
      s1 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (n)));
      b |= (1 << (1 ));
    }
  if (TranslateNameToCharStar ((char *) a, _a_high, 2))
    {
      Cast ((unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) w2, _w2_high);
      s2 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (n)));
      b |= (1 << (2 ));
    }
  if (TranslateNameToCharStar ((char *) a, _a_high, 3))
    {
      Cast ((unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) w3, _w3_high);
      s3 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (n)));
      b |= (1 << (3 ));
    }
  switch (b)
    {
      case (unsigned int) 0:
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) w1, _w1_high, (const unsigned char *) w2, _w2_high, (const unsigned char *) w3, _w3_high);
        break;

      case (unsigned int) ((1 << (1))):
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) w2, _w2_high, (const unsigned char *) w3, _w3_high);
        break;

      case (unsigned int) ((1 << (2))):
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) w1, _w1_high, (const unsigned char *) &s2, (sizeof (s2)-1), (const unsigned char *) w3, _w3_high);
        break;

      case (unsigned int) ((1 << (1)) | (1 << (2))):
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) &s2, (sizeof (s2)-1), (const unsigned char *) w3, _w3_high);
        break;

      case (unsigned int) ((1 << (3))):
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) w1, _w1_high, (const unsigned char *) w2, _w2_high, (const unsigned char *) &s3, (sizeof (s3)-1));
        break;

      case (unsigned int) ((1 << (1)) | (1 << (3))):
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) w2, _w2_high, (const unsigned char *) &s3, (sizeof (s3)-1));
        break;

      case (unsigned int) ((1 << (2)) | (1 << (3))):
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) w1, _w1_high, (const unsigned char *) &s2, (sizeof (s2)-1), (const unsigned char *) &s3, (sizeof (s3)-1));
        break;

      case (unsigned int) ((1 << (1)) | (1 << (2)) | (1 << (3))):
        s = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) &s2, (sizeof (s2)-1), (const unsigned char *) &s3, (sizeof (s3)-1));
        break;


      default:
        M2RTS_HALT (-1);
        __builtin_unreachable ();
        break;
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Init - initializes the error list.
*/

static void Init (void)
{
  head = static_cast<M2Error_Error__opaque> (NULL);
  InInternal = false;
  scopeStack = M2StackAddress_InitStackAddress ();
  scopeArray = Indexing_InitIndex (1);
  currentScope = static_cast<M2Error_ErrorScope__opaque> (NULL);
  scopeIndex = 0;
}


/*
   CheckIncludes - generates a sequence of error messages which determine the relevant
                   included file and line number.
                   For example:

                   gcc a.c
                   In file included from b.h:1,
                                    from a.c:1:
                   c.h:1: parse error before `and'

                   where a.c is: #include "b.h"
                         b.h is: #include "c.h"
                         c.h is: and this and that

                   we attempt to follow the error messages that gcc issues.
*/

static void CheckIncludes (unsigned int token, unsigned int depth)
{
  DynamicStrings_String included;
  unsigned int lineno;

  included = M2LexBuf_FindFileNameFromToken (token, depth+1);
  if (included != NULL)
    {
      lineno = M2LexBuf_TokenToLineNo (token, depth+1);
      if (depth == 0)
        {
          M2Printf_printf2 ((const char *) "In file included from %s:%d", 27, (const unsigned char *) &included, (sizeof (included)-1), (const unsigned char *) &lineno, (sizeof (lineno)-1));
        }
      else
        {
          M2Printf_printf2 ((const char *) "                 from %s:%d", 27, (const unsigned char *) &included, (sizeof (included)-1), (const unsigned char *) &lineno, (sizeof (lineno)-1));
        }
      if ((M2LexBuf_FindFileNameFromToken (token, depth+2)) == NULL)
        {
          M2Printf_printf0 ((const char *) ":\\n", 3);
        }
      else
        {
          M2Printf_printf0 ((const char *) ",\\n", 3);
        }
      CheckIncludes (token, depth+1);
    }
}


/*
   FlushAll - flushes all errors in list, e.
*/

static bool FlushAll (M2Error_Error__opaque e, bool FatalStatus)
{
  M2Error_Error__opaque f;
  bool written;

  written = false;
  if (e != NULL)
    {
      do {
        if ((FatalStatus == e->fatal) && (e->s != NULL))
          {
            currentScope = e->scope;
            CheckIncludes (e->token, 0);
            M2Emit_EmitError (e->fatal, e->note, e->token, M2Error_AnnounceScope (static_cast<M2Error_Error> (e), e->s));
            if ((e->child != NULL) && (FlushAll (e->child, FatalStatus)))
              {}  /* empty.  */
            e->s = static_cast<DynamicStrings_String> (NULL);
            written = true;
          }
        f = e;
        e = e->next;
        if (! Debugging)
          {
            f->s = DynamicStrings_KillString (f->s);
            Storage_DEALLOCATE ((void **) &f, sizeof (M2Error__T1));
          }
      } while (! (e == NULL));
    }
  return written;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsErrorScopeNul - returns TRUE if es is NIL or it has a NulName.
*/

static bool IsErrorScopeNul (M2Error_ErrorScope__opaque es)
{
  return (es == NULL) || (es->scopeName == NameKey_NulName);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSameScope - return TRUE if a and b refer to the same scope.
*/

static bool IsSameScope (M2Error_ErrorScope__opaque a, M2Error_ErrorScope__opaque b)
{
  if (a == b)
    {
      return true;
    }
  else if ((a == NULL) || (b == NULL))
    {
      /* avoid dangling else.  */
      return false;
    }
  else
    {
      /* avoid dangling else.  */
      /* this does not compare the symbol field.  */
      return (a->scopeKind == b->scopeKind) && (a->scopeName == b->scopeName);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   newErrorScope - create an ErrorScope of kindScope and return the object.
                   It is also added the a dynamic array.
*/

static M2Error_ErrorScope__opaque newErrorScope (M2Error_KindScope kind)
{
  M2Error_ErrorScope__opaque es;
  unsigned int c;

  if (M2Pass_IsPass0 ())
    {
      /* avoid dangling else.  */
      Storage_ALLOCATE ((void **) &es, sizeof (M2Error__T2));
      es->scopeKind = kind;
      es->scopeName = NameKey_NulName;
      es->symbol = SymbolTable_NulSym;
      Indexing_PutIndice (scopeArray, (Indexing_HighIndice (scopeArray))+1, reinterpret_cast <void *> (es));
      if (DebugError)
        {
          c = Indexing_HighIndice (scopeArray);
          M2Printf_printf2 ((const char *) "pass 0:  %d  %d\\n", 17, (const unsigned char *) &c, (sizeof (c)-1), (const unsigned char *) &kind, (sizeof (kind)-1));
        }
    }
  else
    {
      scopeIndex += 1;
      es = static_cast<M2Error_ErrorScope__opaque> (Indexing_GetIndice (scopeArray, scopeIndex));
      if (DebugError)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (M2Pass_IsPass1 ())
            {
              M2Printf_printf3 ((const char *) "pass 1:  %d  %d  %d\\n", 21, (const unsigned char *) &scopeIndex, (sizeof (scopeIndex)-1), (const unsigned char *) &es->scopeKind, (sizeof (es->scopeKind)-1), (const unsigned char *) &kind, (sizeof (kind)-1));
            }
          else
            {
              M2Printf_printf3 ((const char *) "pass 2:  %d  %d  %d\\n", 21, (const unsigned char *) &scopeIndex, (sizeof (scopeIndex)-1), (const unsigned char *) &es->scopeKind, (sizeof (es->scopeKind)-1), (const unsigned char *) &kind, (sizeof (kind)-1));
            }
        }
      M2Debug_Assert (es->scopeKind == kind);
    }
  return es;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InternalError - displays an internal error message together with the compiler source
                   file and line number.
                   This function is not buffered and is used when the compiler is about
                   to give up.
*/

extern "C" void M2Error_InternalError (const char *message_, unsigned int _message_high)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  if (! InInternal)
    {
      InInternal = true;
      M2Error_FlushErrors ();
    }
  M2Emit_InternalError ((const char *) message, _message_high);
  M2RTS_HALT (-1);
  __builtin_unreachable ();
}


/*
   WriteFormat0 - displays the source module and line together
                  with the encapsulated format string.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat0 (const char *a_, unsigned int _a_high)
{
  M2Error_Error__opaque e;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (M2LexBuf_GetTokenNo ()));
  e->s = FormatStrings_Sprintf0 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)));
}


/*
   WriteFormat1 - displays the source module and line together
                  with the encapsulated format string.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high)
{
  M2Error_Error__opaque e;
  char a[_a_high+1];
  unsigned char w[_w_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w, w_, _w_high+1);

  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (M2LexBuf_GetTokenNo ()));
  e->s = DoFormat1 ((const char *) a, _a_high, (const unsigned char *) w, _w_high);
}


/*
   WriteFormat2 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat2 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high)
{
  M2Error_Error__opaque e;
  char a[_a_high+1];
  unsigned char w1[_w1_high+1];
  unsigned char w2[_w2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w1, w1_, _w1_high+1);
  memcpy (w2, w2_, _w2_high+1);

  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (M2LexBuf_GetTokenNo ()));
  e->s = DoFormat2 ((const char *) a, _a_high, (const unsigned char *) w1, _w1_high, (const unsigned char *) w2, _w2_high);
}


/*
   WriteFormat3 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

extern "C" void M2Error_WriteFormat3 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high)
{
  M2Error_Error__opaque e;
  char a[_a_high+1];
  unsigned char w1[_w1_high+1];
  unsigned char w2[_w2_high+1];
  unsigned char w3[_w3_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w1, w1_, _w1_high+1);
  memcpy (w2, w2_, _w2_high+1);
  memcpy (w3, w3_, _w3_high+1);

  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (M2LexBuf_GetTokenNo ()));
  e->s = DoFormat3 ((const char *) a, _a_high, (const unsigned char *) w1, _w1_high, (const unsigned char *) w2, _w2_high, (const unsigned char *) w3, _w3_high);
}


/*
   NewError - creates and returns a new error handle.
*/

extern "C" M2Error_Error M2Error_NewError (unsigned int AtTokenNo)
{
  M2Error_Error__opaque e;
  M2Error_Error__opaque f;

  if (AtTokenNo == M2LexBuf_UnknownTokenNo)
    {}  /* empty.  */
  /* This could be used as a useful debugging hook as the front end
         has forgotten the token no.  */
  Storage_ALLOCATE ((void **) &e, sizeof (M2Error__T1));
  e->s = static_cast<DynamicStrings_String> (NULL);
  e->token = AtTokenNo;
  e->next = static_cast<M2Error_Error__opaque> (NULL);
  e->parent = static_cast<M2Error_Error__opaque> (NULL);
  e->child = static_cast<M2Error_Error__opaque> (NULL);
  e->note = false;
  e->fatal = true;
  e->color = false;
  /* Assert (scopeKind # noscope) ;  */
  e->scope = currentScope;
  if ((head == NULL) || (head->token > AtTokenNo))
    {
      e->next = head;
      head = e;
    }
  else
    {
      f = head;
      while ((f->next != NULL) && (f->next->token < AtTokenNo))
        {
          f = f->next;
        }
      e->next = f->next;
      f->next = e;
    }
  return static_cast<M2Error_Error> (e);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NewWarning - creates and returns a new error handle suitable for a warning.
                A warning will not stop compilation.
*/

extern "C" M2Error_Error M2Error_NewWarning (unsigned int AtTokenNo)
{
  M2Error_Error__opaque e;

  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (AtTokenNo));
  e->fatal = false;
  e->note = false;
  return static_cast<M2Error_Error> (e);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NewNote - creates and returns a new error handle suitable for a note.
             A note will not stop compilation.
*/

extern "C" M2Error_Error M2Error_NewNote (unsigned int AtTokenNo)
{
  M2Error_Error__opaque e;

  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (AtTokenNo));
  e->fatal = false;
  e->note = true;
  return static_cast<M2Error_Error> (e);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ChainError - creates and returns a new error handle, this new error
                is associated with, e, and is chained onto the end of, e.
                If, e, is NIL then the result to NewError is returned.
*/

extern "C" M2Error_Error M2Error_ChainError (unsigned int AtTokenNo, M2Error_Error e)
{
  M2Error_Error__opaque f;

  if (e == NULL)
    {
      return M2Error_NewError (AtTokenNo);
    }
  else
    {
      Storage_ALLOCATE ((void **) &f, sizeof (M2Error__T1));
      f->s = static_cast<DynamicStrings_String> (NULL);
      f->token = AtTokenNo;
      f->next = static_cast<M2Error_Error__opaque> (e)->child;
      f->parent = static_cast<M2Error_Error__opaque> (e);
      f->child = static_cast<M2Error_Error__opaque> (NULL);
      f->fatal = static_cast<M2Error_Error__opaque> (e)->fatal;
      f->scope = static_cast<M2Error_Error__opaque> (e)->scope;
      static_cast<M2Error_Error__opaque> (e)->child = f;
    }
  return static_cast<M2Error_Error> (f);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MoveError - repositions an error, e, to token, AtTokenNo, and returns, e.
*/

extern "C" M2Error_Error M2Error_MoveError (M2Error_Error e, unsigned int AtTokenNo)
{
  if (e != NULL)
    {
      static_cast<M2Error_Error__opaque> (e)->token = AtTokenNo;
    }
  return e;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetColor - informs the error module that this error will have had colors
              assigned to it.  If an error is issued without colors assigned
              then the default colors will be assigned to the legacy error
              messages.
*/

extern "C" M2Error_Error M2Error_SetColor (M2Error_Error e)
{
  static_cast<M2Error_Error__opaque> (e)->color = true;
  return e;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void M2Error_ErrorFormat0 (M2Error_Error e, const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  /* 
   ErrorFormat routines provide a printf capability for the error handle.
  */
  if (static_cast<M2Error_Error__opaque> (e)->s == NULL)
    {
      static_cast<M2Error_Error__opaque> (e)->s = FormatStrings_Sprintf0 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)));
    }
  else
    {
      static_cast<M2Error_Error__opaque> (e)->s = DynamicStrings_ConCat (static_cast<M2Error_Error__opaque> (e)->s, DynamicStrings_Mark (FormatStrings_Sprintf0 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)))));
    }
}

extern "C" void M2Error_ErrorFormat1 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high)
{
  DynamicStrings_String s1;
  char a[_a_high+1];
  unsigned char w[_w_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w, w_, _w_high+1);

  s1 = DoFormat1 ((const char *) a, _a_high, (const unsigned char *) w, _w_high);
  if (static_cast<M2Error_Error__opaque> (e)->s == NULL)
    {
      static_cast<M2Error_Error__opaque> (e)->s = s1;
    }
  else
    {
      static_cast<M2Error_Error__opaque> (e)->s = DynamicStrings_ConCat (static_cast<M2Error_Error__opaque> (e)->s, DynamicStrings_Mark (s1));
    }
}

extern "C" void M2Error_ErrorFormat2 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high)
{
  DynamicStrings_String s1;
  char a[_a_high+1];
  unsigned char w1[_w1_high+1];
  unsigned char w2[_w2_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w1, w1_, _w1_high+1);
  memcpy (w2, w2_, _w2_high+1);

  s1 = DoFormat2 ((const char *) a, _a_high, (const unsigned char *) w1, _w1_high, (const unsigned char *) w2, _w2_high);
  if (static_cast<M2Error_Error__opaque> (e)->s == NULL)
    {
      static_cast<M2Error_Error__opaque> (e)->s = s1;
    }
  else
    {
      static_cast<M2Error_Error__opaque> (e)->s = DynamicStrings_ConCat (static_cast<M2Error_Error__opaque> (e)->s, DynamicStrings_Mark (s1));
    }
}

extern "C" void M2Error_ErrorFormat3 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high)
{
  DynamicStrings_String s1;
  char a[_a_high+1];
  unsigned char w1[_w1_high+1];
  unsigned char w2[_w2_high+1];
  unsigned char w3[_w3_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w1, w1_, _w1_high+1);
  memcpy (w2, w2_, _w2_high+1);
  memcpy (w3, w3_, _w3_high+1);

  s1 = DoFormat3 ((const char *) a, _a_high, (const unsigned char *) w1, _w1_high, (const unsigned char *) w2, _w2_high, (const unsigned char *) w3, _w3_high);
  if (static_cast<M2Error_Error__opaque> (e)->s == NULL)
    {
      static_cast<M2Error_Error__opaque> (e)->s = s1;
    }
  else
    {
      static_cast<M2Error_Error__opaque> (e)->s = DynamicStrings_ConCat (static_cast<M2Error_Error__opaque> (e)->s, DynamicStrings_Mark (s1));
    }
}

extern "C" void M2Error_ErrorString (M2Error_Error e, DynamicStrings_String str)
{
  static_cast<M2Error_Error__opaque> (e)->s = str;
}


/*
   ErrorStringAt - given an error string, s, it places this
                   string at token position, tok.
                   The string is consumed.
*/

extern "C" void M2Error_ErrorStringAt (DynamicStrings_String s, unsigned int tok)
{
  M2Error_Error__opaque e;

  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (tok));
  M2Error_ErrorString (static_cast<M2Error_Error> (e), s);
}


/*
   ErrorStringAt2 - given an error string, s, it places this
                    string at token positions, tok1 and tok2, respectively.
                    The string is consumed.
*/

extern "C" void M2Error_ErrorStringAt2 (DynamicStrings_String s, unsigned int tok1, unsigned int tok2)
{
  M2Error_ErrorStringsAt2 (s, s, tok1, tok2);
}


/*
   ErrorStringsAt2 - given error strings, s1, and, s2, it places these
                     strings at token positions, tok1 and tok2, respectively.
                     Both strings are consumed.
*/

extern "C" void M2Error_ErrorStringsAt2 (DynamicStrings_String s1, DynamicStrings_String s2, unsigned int tok1, unsigned int tok2)
{
  M2Error_Error__opaque e;

  if (s1 == s2)
    {
      s2 = DynamicStrings_Dup (s1);
    }
  e = static_cast<M2Error_Error__opaque> (M2Error_NewError (tok1));
  M2Error_ErrorString (static_cast<M2Error_Error> (e), s1);
  M2Error_ErrorString (M2Error_ChainError (tok2, static_cast<M2Error_Error> (e)), s2);
}


/*
   WarnStringAt - given an error string, s, it places this
                  string at token position, tok.
                  The string is consumed.
*/

extern "C" void M2Error_WarnStringAt (DynamicStrings_String s, unsigned int tok)
{
  M2Error_Error__opaque e;

  e = static_cast<M2Error_Error__opaque> (M2Error_NewWarning (tok));
  M2Error_ErrorString (static_cast<M2Error_Error> (e), s);
}


/*
   WarnStringAt2 - given an warning string, s, it places this
                   string at token positions, tok1 and tok2, respectively.
                   The string is consumed.
*/

extern "C" void M2Error_WarnStringAt2 (DynamicStrings_String s, unsigned int tok1, unsigned int tok2)
{
  M2Error_WarnStringsAt2 (s, s, tok1, tok2);
}


/*
   WarnStringsAt2 - given warning strings, s1, and, s2, it places these
                    strings at token positions, tok1 and tok2, respectively.
                    Both strings are consumed.
*/

extern "C" void M2Error_WarnStringsAt2 (DynamicStrings_String s1, DynamicStrings_String s2, unsigned int tok1, unsigned int tok2)
{
  M2Error_Error__opaque e;

  if (s1 == s2)
    {
      s2 = DynamicStrings_Dup (s1);
    }
  e = static_cast<M2Error_Error__opaque> (M2Error_NewWarning (tok1));
  M2Error_ErrorString (static_cast<M2Error_Error> (e), s1);
  M2Error_ErrorString (M2Error_ChainError (tok2, static_cast<M2Error_Error> (e)), s2);
}


/*
   WarnFormat0 - displays the source module and line together
                 with the encapsulated format string.
                 Used for simple warning messages tied to the current token.
*/

extern "C" void M2Error_WarnFormat0 (const char *a_, unsigned int _a_high)
{
  M2Error_Error__opaque e;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  e = static_cast<M2Error_Error__opaque> (M2Error_NewWarning (M2LexBuf_GetTokenNo ()));
  e->s = FormatStrings_Sprintf0 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)));
}


/*
   WarnFormat1 - displays the source module and line together
                 with the encapsulated format string.
                 Used for simple warning messages tied to the current token.
*/

extern "C" void M2Error_WarnFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high)
{
  M2Error_Error__opaque e;
  char a[_a_high+1];
  unsigned char w[_w_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);
  memcpy (w, w_, _w_high+1);

  e = static_cast<M2Error_Error__opaque> (M2Error_NewWarning (M2LexBuf_GetTokenNo ()));
  e->s = DoFormat1 ((const char *) a, _a_high, (const unsigned char *) w, _w_high);
}


/*
   FlushErrors - switches the output channel to the error channel
                 and then writes out all errors.
*/

extern "C" void M2Error_FlushErrors (void)
{
  if (DebugTrace)
    {
      M2Printf_printf0 ((const char *) "\\nFlushing all errors\\n", 23);
      M2Printf_printf0 ((const char *) "===================\\n", 21);
    }
  if (FlushAll (head, true))
    {
      M2RTS_ExitOnHalt (1);
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
}


/*
   FlushWarnings - switches the output channel to the error channel
                   and then writes out all warnings.
                   If an error is present the compilation is terminated,
                   if warnings only were emitted then compilation will
                   continue.
*/

extern "C" void M2Error_FlushWarnings (void)
{
  if (FlushAll (head, false))
    {}  /* empty.  */
}


/*
   ErrorAbort0 - aborts compiling, it flushes all warnings and errors before aborting.
*/

extern "C" void M2Error_ErrorAbort0 (const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  M2Error_FlushWarnings ();
  if (! (StrLib_StrEqual ((const char *) a, _a_high, (const char *) "", 0)))
    {
      M2Error_WriteFormat0 ((const char *) a, _a_high);
    }
  if (! (FlushAll (head, true)))
    {
      M2Error_WriteFormat0 ((const char *) "unidentified error", 18);
      if (FlushAll (head, true))
        {}  /* empty.  */
    }
  M2RTS_ExitOnHalt (1);
  M2RTS_HALT (-1);
  __builtin_unreachable ();
}


/*
   AnnounceScope - return the error string s with a scope description prepended
                   assuming that scope has changed.
*/

extern "C" DynamicStrings_String M2Error_AnnounceScope (M2Error_Error e, DynamicStrings_String message)
{
  if (! (IsSameScope (lastScope, static_cast<M2Error_Error__opaque> (e)->scope)))
    {
      lastScope = static_cast<M2Error_Error__opaque> (e)->scope;
      if (IsErrorScopeNul (lastScope))
        {
          return DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "no scope active: ", 17), message);
        }
      else
        {
          M2Debug_Assert ((static_cast<M2Error_Error__opaque> (e)->scope != NULL) && (static_cast<M2Error_Error__opaque> (e)->scope->scopeKind != M2Error_noscope));
          /* filename := FindFileNameFromToken (e^.token, 0) ;  */
          message = M2Error_GetAnnounceScope (static_cast<DynamicStrings_String> (NULL), message);
        }
    }
  return message;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   EnterImplementationScope - signifies to the error routines that the front end
                              has started to compile implementation module scopeName.
*/

extern "C" void M2Error_EnterImplementationScope (NameKey_Name scopename)
{
  M2Debug_Assert (currentScope != NULL);
  M2Debug_Assert (currentScope->scopeKind == M2Error_implementation);
  if (currentScope->scopeName == NameKey_NulName)
    {
      if (DebugError)
        {
          M2Printf_printf1 ((const char *) "seen implementation: %a\\n", 25, (const unsigned char *) &scopename, (sizeof (scopename)-1));
        }
      currentScope->scopeName = scopename;
    }
}


/*
   EnterProgramScope - signifies to the error routines that the front end
                       has started to compile program module scopeName.
*/

extern "C" void M2Error_EnterProgramScope (NameKey_Name scopename)
{
  M2Debug_Assert (currentScope != NULL);
  M2Debug_Assert (currentScope->scopeKind == M2Error_program);
  if (currentScope->scopeName == NameKey_NulName)
    {
      if (DebugError)
        {
          M2Printf_printf1 ((const char *) "seen program: %a\\n", 18, (const unsigned char *) &scopename, (sizeof (scopename)-1));
        }
      currentScope->scopeName = scopename;
    }
}


/*
   EnterModuleScope - signifies to the error routines that the front end
                      has started to compile an inner module scopeName.
*/

extern "C" void M2Error_EnterModuleScope (NameKey_Name scopename)
{
  M2Debug_Assert (currentScope != NULL);
  M2Debug_Assert (currentScope->scopeKind == M2Error_module);
  if (currentScope->scopeName == NameKey_NulName)
    {
      if (DebugError)
        {
          M2Printf_printf1 ((const char *) "seen module: %a\\n", 17, (const unsigned char *) &scopename, (sizeof (scopename)-1));
        }
      currentScope->scopeName = scopename;
    }
}


/*
   EnterDefinitionScope - signifies to the error routines that the front end
                          has started to compile definition module scopeName.
*/

extern "C" void M2Error_EnterDefinitionScope (NameKey_Name scopename)
{
  M2Debug_Assert (currentScope != NULL);
  M2Debug_Assert (currentScope->scopeKind == M2Error_definition);
  if (currentScope->scopeName == NameKey_NulName)
    {
      if (DebugError)
        {
          M2Printf_printf1 ((const char *) "seen definition: %a\\n", 21, (const unsigned char *) &scopename, (sizeof (scopename)-1));
        }
      currentScope->scopeName = scopename;
    }
}


/*
   EnterProcedureScope - signifies to the error routines that the front end
                         has started to compile definition module scopeName.
*/

extern "C" void M2Error_EnterProcedureScope (NameKey_Name scopename)
{
  M2Debug_Assert (currentScope != NULL);
  M2Debug_Assert (currentScope->scopeKind == M2Error_procedure);
  if (currentScope->scopeName == NameKey_NulName)
    {
      if (DebugError)
        {
          M2Printf_printf1 ((const char *) "seen procedure: %a\\n", 20, (const unsigned char *) &scopename, (sizeof (scopename)-1));
        }
      currentScope->scopeName = scopename;
    }
}


/*
   DepthScope - returns the depth of the scope stack.
*/

extern "C" unsigned int M2Error_DepthScope (void)
{
  return M2StackAddress_NoOfItemsInStackAddress (scopeStack);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetAnnounceScope - return message with the error scope attached to message.
                      filename and message are treated as read only by this
                      procedure function.
*/

extern "C" DynamicStrings_String M2Error_GetAnnounceScope (DynamicStrings_String filename, DynamicStrings_String message)
{
  DynamicStrings_String pre;
  DynamicStrings_String fmt;
  DynamicStrings_String desc;
  DynamicStrings_String quoted;

  if (filename == NULL)
    {
      pre = DynamicStrings_InitString ((const char *) "", 0);
    }
  else
    {
      pre = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%s: ", 4)), (const unsigned char *) &filename, (sizeof (filename)-1));
    }
  if (! (IsErrorScopeNul (currentScope)))
    {
      quoted = DynamicStrings_InitString ((const char *) "", 0);
      quoted = M2ColorString_quoteOpen (quoted);
      quoted = DynamicStrings_ConCat (quoted, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (currentScope->scopeName))));
      quoted = M2ColorString_quoteClose (quoted);
    }
  if (currentScope == NULL)
    {
      desc = DynamicStrings_InitString ((const char *) "no scope active", 15);
    }
  else
    {
      switch (currentScope->scopeKind)
        {
          case M2Error_definition:
            desc = DynamicStrings_InitString ((const char *) "In definition module", 20);
            break;

          case M2Error_implementation:
            desc = DynamicStrings_InitString ((const char *) "In implementation module", 24);
            break;

          case M2Error_program:
            desc = DynamicStrings_InitString ((const char *) "In program module", 17);
            break;

          case M2Error_module:
            desc = DynamicStrings_InitString ((const char *) "In inner module", 15);
            break;

          case M2Error_procedure:
            desc = DynamicStrings_InitString ((const char *) "In procedure", 12);
            break;

          case M2Error_noscope:
            desc = DynamicStrings_InitString ((const char *) "Unknown scope", 13);
            break;


          default:
            CaseException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2Error.def", 20, 1);
            __builtin_unreachable ();
        }
    }
  fmt = DynamicStrings_ConCat (pre, DynamicStrings_Mark (desc));
  if (IsErrorScopeNul (currentScope))
    {
      fmt = DynamicStrings_ConCat (fmt, FormatStrings_Sprintf0 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ": ", 2))));
    }
  else
    {
      fmt = DynamicStrings_ConCat (fmt, FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " %s: ", 5)), (const unsigned char *) &quoted, (sizeof (quoted)-1)));
    }
  return DynamicStrings_ConCat (fmt, message);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DefaultProgramModule - sets up an unnamed program scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultProgramModule (void)
{
  M2StackAddress_PushAddress (scopeStack, reinterpret_cast <void *> (currentScope));
  currentScope = newErrorScope (M2Error_program);
}


/*
   DefaultImplementationModule - sets up an unnamed implementation
                                 scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultImplementationModule (void)
{
  M2StackAddress_PushAddress (scopeStack, reinterpret_cast <void *> (currentScope));
  currentScope = newErrorScope (M2Error_implementation);
}


/*
   DefaultDefinitionModule - sets up an unnamed definition
                             scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultDefinitionModule (void)
{
  M2StackAddress_PushAddress (scopeStack, reinterpret_cast <void *> (currentScope));
  currentScope = newErrorScope (M2Error_definition);
}


/*
   DefaultInnerModule - sets up an unnamed inner
                        scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultInnerModule (void)
{
  M2StackAddress_PushAddress (scopeStack, reinterpret_cast <void *> (currentScope));
  currentScope = newErrorScope (M2Error_module);
}


/*
   DefaultProcedure - sets up an unnamed procedure
                      scope before the Ident is seen.
*/

extern "C" void M2Error_DefaultProcedure (void)
{
  M2StackAddress_PushAddress (scopeStack, reinterpret_cast <void *> (currentScope));
  currentScope = newErrorScope (M2Error_procedure);
}


/*
   EnterErrorScope - pushes the currentScope and sets currentScope to scope.
*/

extern "C" void M2Error_EnterErrorScope (M2Error_ErrorScope scope)
{
  M2StackAddress_PushAddress (scopeStack, reinterpret_cast <void *> (currentScope));
  currentScope = static_cast<M2Error_ErrorScope__opaque> (scope);
}


/*
   LeaveErrorScope - leave the current scope and pop into the previous one.
*/

extern "C" void M2Error_LeaveErrorScope (void)
{
  currentScope = static_cast<M2Error_ErrorScope__opaque> (M2StackAddress_PopAddress (scopeStack));
}


/*
   GetCurrentErrorScope - returns currentScope.
*/

extern "C" M2Error_ErrorScope M2Error_GetCurrentErrorScope (void)
{
  return static_cast<M2Error_ErrorScope> (currentScope);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ResetErrorScope - should be called at the start of each pass to
                     reset the error scope index.
*/

extern "C" void M2Error_ResetErrorScope (void)
{
  scopeIndex = 0;
}

extern "C" void _M2_M2Error_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2Error_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
