/* do not edit automatically generated by mc from M2DebugStack.  */
/* M2DebugStack.mod display parameter stack.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2DebugStack_C

#include "GM2DebugStack.h"
#   include "GDynamicStrings.h"
#   include "GSymbolTable.h"
#   include "GStringConvert.h"
#   include "GNameKey.h"
#   include "GFIO.h"
#   include "GSFIO.h"
#   include "GM2Error.h"
#   include "GM2Printf.h"

typedef struct M2DebugStack_ProcedureWord_p M2DebugStack_ProcedureWord;

typedef struct M2DebugStack_ProcedureString_p M2DebugStack_ProcedureString;

#   define Debugging false
static M2DebugStack_ProcedureWord OperandTok;
static M2DebugStack_ProcedureWord OperandT;
static M2DebugStack_ProcedureWord OperandF;
static M2DebugStack_ProcedureWord OperandA;
static M2DebugStack_ProcedureWord OperandD;
static M2DebugStack_ProcedureWord OperandRW;
static M2DebugStack_ProcedureString OperandAnno;

/*
   DebugStack - displays the stack.
*/

extern "C" void M2DebugStack_DebugStack (unsigned int amount, M2DebugStack_ProcedureWord opt, M2DebugStack_ProcedureWord opf, M2DebugStack_ProcedureWord opa, M2DebugStack_ProcedureWord opd, M2DebugStack_ProcedureWord oprw, M2DebugStack_ProcedureWord optk, M2DebugStack_ProcedureString opanno);

/*
   x - checks to see that a=b.
*/

static DynamicStrings_String x (DynamicStrings_String a, DynamicStrings_String b);

/*
   IsWhite - returns TRUE if, ch, is a space.
*/

static bool IsWhite (char ch);

/*
   ConCatWord - joins sentances, a, b, together.
*/

static DynamicStrings_String ConCatWord (DynamicStrings_String a, DynamicStrings_String b);

/*
   symDesc -
*/

static DynamicStrings_String symDesc (unsigned int sym, DynamicStrings_String o);

/*
   Output - output string, s, to Stdout.  It also disposes of the string, s.
*/

static void Output (DynamicStrings_String s);

/*
   GetComment -
*/

static int GetComment (DynamicStrings_String s);

/*
   doName - concatenate namekey, o, to, p.
*/

static DynamicStrings_String doName (DynamicStrings_String p, unsigned int o);

/*
   doSymName - concatenate symbol, o, name to, p.
*/

static DynamicStrings_String doSymName (DynamicStrings_String p, unsigned int o);

/*
   doNumber - convert, o, to a cardinal and increment the length, l,
              by the number of characters required to represent, o.
*/

static DynamicStrings_String doNumber (DynamicStrings_String p, unsigned int o);

/*
   doSymbol - handles a symbol indicated by, o.
*/

static DynamicStrings_String doSymbol (DynamicStrings_String p, unsigned int o);

/*
   doOperand -
*/

static DynamicStrings_String doOperand (DynamicStrings_String p, DynamicStrings_String s, int *i, int e, unsigned int o);

/*
   doPercent -
*/

static DynamicStrings_String doPercent (DynamicStrings_String o, DynamicStrings_String s, int *i, int e, unsigned int n);

/*
   doNameLength - increment, l, by the ascii length of string determined by, o.
*/

static void doNameLength (unsigned int *l, unsigned int o);

/*
   doSymNameLength - increment, l, by the ascii length of symbol, o.
*/

static void doSymNameLength (unsigned int *l, unsigned int o);

/*
   doNumberLength - convert, o, to a cardinal and increment the length, l,
                    by the number of characters required to represent, o.
*/

static void doNumberLength (unsigned int *l, unsigned int o);

/*
   doSymbolLength - handles a symbol indicated by, o.
*/

static void doSymbolLength (unsigned int *l, unsigned int o);

/*
   doOperandLength -
*/

static void doOperandLength (DynamicStrings_String s, int *i, int e, unsigned int *l, unsigned int o);

/*
   doPercentLength -
*/

static void doPercentLength (DynamicStrings_String s, int *i, int e, unsigned int *l, unsigned int n);

/*
   doFieldLength - compute the string length given in annotation
                   at position, n, on the stack between characters
                   b and e.

                   The string description between: b..e can contain any
                   of these patterns:

                   %a           ascii name key.
                   %s           symbol number.
                   %d           decimal cardinal number.
                   |            indicates the next field.
*/

static unsigned int doFieldLength (int b, int e, unsigned int n);

/*
   stop -
*/

static void stop (void);

/*
   doMaxCard - returns the maximum of two CARDINALs.
*/

static unsigned int doMaxCard (unsigned int a, unsigned int b);

/*
   GetAnnotationFieldLength -
*/

static unsigned int GetAnnotationFieldLength (unsigned int n, unsigned int f);

/*
   GetAnnotationLength -
*/

static unsigned int GetAnnotationLength (unsigned int n, unsigned int f);

/*
   GetFieldLength - returns the number of characters used in field, f,
                    at position, n, on the stack.
*/

static unsigned int GetFieldLength (unsigned int n, unsigned int f);

/*
   GetMaxFieldAnno - returns the maximum number of characters required
                     by either the annotation or field, f, at position, n,
                     on the stack.
*/

static unsigned int GetMaxFieldAnno (unsigned int n, unsigned int f);

/*
   GetStackFieldLengths - assigns, tn, and, fn, with the
                          maximum field width values.
*/

static void GetStackFieldLengths (unsigned int *tn, unsigned int *fn, unsigned int *tk, unsigned int amount);

/*
   DisplayRow -
*/

static void DisplayRow (unsigned int tn, unsigned int fn, unsigned int tk, bool initOrFinal);

/*
   SkipToField -
*/

static int SkipToField (DynamicStrings_String s, unsigned int n);

/*
   Pad - padds out string, s, to paddedLength characters.
*/

static DynamicStrings_String Pad (DynamicStrings_String o, unsigned int paddedLength);

/*
   doField - compute the string length given in annotation
             at position, n, on the stack between characters
             b and e.

             The string description between: b..e can contain any
             of these patterns:

             %a           ascii name key.
             %s           symbol number.
             %d           decimal cardinal number.
             |            indicates the next field.
*/

static DynamicStrings_String doField (DynamicStrings_String s, unsigned int n, unsigned int f, unsigned int l);

/*
   doAnnotation -
*/

static DynamicStrings_String doAnnotation (DynamicStrings_String s, unsigned int n, unsigned int field, unsigned int width);

/*
   DisplayFields -
*/

static void DisplayFields (unsigned int n, unsigned int tn, unsigned int fn, unsigned int tk);


/*
   x - checks to see that a=b.
*/

static DynamicStrings_String x (DynamicStrings_String a, DynamicStrings_String b)
{
  if (a != b)
    {
      M2Error_InternalError ((const char *) "different string returned", 25);
    }
  return a;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsWhite - returns TRUE if, ch, is a space.
*/

static bool IsWhite (char ch)
{
  return ch == ' ';
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConCatWord - joins sentances, a, b, together.
*/

static DynamicStrings_String ConCatWord (DynamicStrings_String a, DynamicStrings_String b)
{
  if (((DynamicStrings_Length (a)) == 1) && ((DynamicStrings_char (a, 0)) == 'a'))
    {
      a = x (a, DynamicStrings_ConCatChar (a, 'n'));
    }
  else if ((((DynamicStrings_Length (a)) > 1) && ((DynamicStrings_char (a, -1)) == 'a')) && (IsWhite (DynamicStrings_char (a, -2))))
    {
      /* avoid dangling else.  */
      a = x (a, DynamicStrings_ConCatChar (a, 'n'));
    }
  if (((DynamicStrings_Length (a)) > 0) && (! (IsWhite (DynamicStrings_char (a, -1)))))
    {
      a = x (a, DynamicStrings_ConCatChar (a, ' '));
    }
  return x (a, DynamicStrings_ConCat (a, b));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   symDesc -
*/

static DynamicStrings_String symDesc (unsigned int sym, DynamicStrings_String o)
{
  if (sym == SymbolTable_NulSym)
    {
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "NulSym", 6)));
    }
  else if (SymbolTable_IsConstLit (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "constant literal", 16)));
    }
  else if (SymbolTable_IsConstSet (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "constant set", 12)));
    }
  else if (SymbolTable_IsConstructor (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "constructor", 11)));
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "constant", 8)));
    }
  else if (SymbolTable_IsArray (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "array", 5)));
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "variable", 8)));
    }
  else if (SymbolTable_IsEnumeration (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "enumeration type", 16)));
    }
  else if (SymbolTable_IsFieldEnumeration (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "enumeration field", 17)));
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "unbounded parameter", 19)));
    }
  else if (SymbolTable_IsProcType (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "procedure type", 14)));
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "procedure", 9)));
    }
  else if (SymbolTable_IsPointer (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "pointer", 7)));
    }
  else if (SymbolTable_IsParameter (sym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsParameterVar (sym))
        {
          return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "var parameter", 13)));
        }
      else
        {
          return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "parameter", 9)));
        }
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "type", 4)));
    }
  else if (SymbolTable_IsRecord (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "record", 6)));
    }
  else if (SymbolTable_IsRecordField (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "record field", 12)));
    }
  else if (SymbolTable_IsVarient (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "varient record", 14)));
    }
  else if (SymbolTable_IsModule (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "module", 6)));
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "definition or implementation module", 35)));
    }
  else if (SymbolTable_IsSet (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "set", 3)));
    }
  else if (SymbolTable_IsSubrange (sym))
    {
      /* avoid dangling else.  */
      return ConCatWord (o, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "subrange", 8)));
    }
  else
    {
      /* avoid dangling else.  */
      return o;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Output - output string, s, to Stdout.  It also disposes of the string, s.
*/

static void Output (DynamicStrings_String s)
{
  s = SFIO_WriteS (FIO_StdOut, s);
  s = DynamicStrings_KillString (s);
}


/*
   GetComment -
*/

static int GetComment (DynamicStrings_String s)
{
  int c;

  c = DynamicStrings_Index (s, '|', 0);
  while (c >= 0)
    {
      c += 1;
      if (c >= ((int ) (DynamicStrings_Length (s))))
        {
          return -1;
        }
      else if ((DynamicStrings_char (s, c)) == '|')
        {
          /* avoid dangling else.  */
          return c+1;
        }
      c = DynamicStrings_Index (s, '|', static_cast<unsigned int> (c));
    }
  return -1;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doName - concatenate namekey, o, to, p.
*/

static DynamicStrings_String doName (DynamicStrings_String p, unsigned int o)
{
  return DynamicStrings_ConCat (p, DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (o)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doSymName - concatenate symbol, o, name to, p.
*/

static DynamicStrings_String doSymName (DynamicStrings_String p, unsigned int o)
{
  return DynamicStrings_ConCat (p, DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (o))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doNumber - convert, o, to a cardinal and increment the length, l,
              by the number of characters required to represent, o.
*/

static DynamicStrings_String doNumber (DynamicStrings_String p, unsigned int o)
{
  return DynamicStrings_ConCat (p, StringConvert_CardinalToString ((unsigned int ) (o), 0, ' ', 10, true));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doSymbol - handles a symbol indicated by, o.
*/

static DynamicStrings_String doSymbol (DynamicStrings_String p, unsigned int o)
{
  return symDesc (o, p);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doOperand -
*/

static DynamicStrings_String doOperand (DynamicStrings_String p, DynamicStrings_String s, int *i, int e, unsigned int o)
{
  (*i) += 1;
  if ((*i) < e)
    {
      switch (DynamicStrings_char (s, (*i)))
        {
          case 's':
            (*i) += 1;  /* symbol number  */
            return doSymbol (p, o);
            break;

          case 'd':
            (*i) += 1;  /* decimal number  */
            return doNumber (p, o);
            break;

          case 'a':
            (*i) += 1;  /* symbol name key  */
            return doSymName (p, o);
            break;

          case 'n':
            (*i) += 1;  /* ascii name key  */
            return doName (p, o);
            break;


          default:
            M2Error_InternalError ((const char *) "incorrect format specifier expecting one of 's', 'd' or 'a'", 59);
            break;
        }
    }
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doPercent -
*/

static DynamicStrings_String doPercent (DynamicStrings_String o, DynamicStrings_String s, int *i, int e, unsigned int n)
{
  (*i) += 1;
  if ((*i) < e)
    {
      switch (DynamicStrings_char (s, (*i)))
        {
          case '1':
            return doOperand (o, s, i, e, (unsigned int ) ((*OperandT.proc) (n)));
            break;

          case '2':
            return doOperand (o, s, i, e, (unsigned int ) ((*OperandF.proc) (n)));
            break;

          case '3':
            return doOperand (o, s, i, e, (unsigned int ) ((*OperandTok.proc) (n)));
            break;


          default:
            M2Error_InternalError ((const char *) "unrecognised format specifier - expecting 1, 2 or 3 after the %", 63);
            break;
        }
    }
  M2Error_InternalError ((const char *) "end of field found before format specifier - expecting 1, 2 or 3 after the %", 76);
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2DebugStack.def", 20, 1);
  __builtin_unreachable ();
}


/*
   doNameLength - increment, l, by the ascii length of string determined by, o.
*/

static void doNameLength (unsigned int *l, unsigned int o)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (o));
  (*l) += DynamicStrings_Length (s);
  s = DynamicStrings_KillString (s);
}


/*
   doSymNameLength - increment, l, by the ascii length of symbol, o.
*/

static void doSymNameLength (unsigned int *l, unsigned int o)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (o)));
  (*l) += DynamicStrings_Length (s);
  s = DynamicStrings_KillString (s);
}


/*
   doNumberLength - convert, o, to a cardinal and increment the length, l,
                    by the number of characters required to represent, o.
*/

static void doNumberLength (unsigned int *l, unsigned int o)
{
  DynamicStrings_String s;

  s = StringConvert_CardinalToString ((unsigned int ) (o), 0, ' ', 10, true);
  (*l) += DynamicStrings_Length (s);
  s = DynamicStrings_KillString (s);
}


/*
   doSymbolLength - handles a symbol indicated by, o.
*/

static void doSymbolLength (unsigned int *l, unsigned int o)
{
  DynamicStrings_String s;

  s = symDesc (o, DynamicStrings_InitString ((const char *) "", 0));
  (*l) += DynamicStrings_Length (s);
  s = DynamicStrings_KillString (s);
}


/*
   doOperandLength -
*/

static void doOperandLength (DynamicStrings_String s, int *i, int e, unsigned int *l, unsigned int o)
{
  (*i) += 1;
  if ((*i) < e)
    {
      switch (DynamicStrings_char (s, (*i)))
        {
          case 's':
            (*i) += 1;  /* symbol number  */
            doSymbolLength (l, o);
            break;

          case 'd':
            (*i) += 1;  /* decimal number  */
            doNumberLength (l, o);
            break;

          case 'a':
            (*i) += 1;  /* ascii name key  */
            doSymNameLength (l, o);
            break;

          case 'n':
            (*i) += 1;  /* ascii name key  */
            doNameLength (l, o);
            break;


          default:
            M2Error_InternalError ((const char *) "incorrect format specifier expecting one of 's', 'd' or 'a'", 59);
            break;
        }
    }
}


/*
   doPercentLength -
*/

static void doPercentLength (DynamicStrings_String s, int *i, int e, unsigned int *l, unsigned int n)
{
  (*i) += 1;
  if ((*i) < e)
    {
      switch (DynamicStrings_char (s, (*i)))
        {
          case '1':
            doOperandLength (s, i, e, l, (unsigned int ) ((*OperandT.proc) (n)));
            break;

          case '2':
            doOperandLength (s, i, e, l, (unsigned int ) ((*OperandF.proc) (n)));
            break;

          case '3':
            doOperandLength (s, i, e, l, (unsigned int ) ((*OperandTok.proc) (n)));
            break;


          default:
            M2Error_InternalError ((const char *) "unrecognised format specifier - expecting 1, 2 or 3 after the %", 63);
            break;
        }
    }
}


/*
   doFieldLength - compute the string length given in annotation
                   at position, n, on the stack between characters
                   b and e.

                   The string description between: b..e can contain any
                   of these patterns:

                   %a           ascii name key.
                   %s           symbol number.
                   %d           decimal cardinal number.
                   |            indicates the next field.
*/

static unsigned int doFieldLength (int b, int e, unsigned int n)
{
  unsigned int l;
  int i;
  DynamicStrings_String s;

  if (b == -1)
    {
      return 0;
    }
  s = static_cast<DynamicStrings_String> ((*OperandAnno.proc) (n));
  if (e == -1)
    {
      e = DynamicStrings_Length (s);
    }
  l = 0;
  i = b;
  while (i < e)
    {
      switch (DynamicStrings_char (s, i))
        {
          case '|':
            return l;
            break;

          case '%':
            doPercentLength (s, &i, e, &l, n);
            break;


          default:
            l += 1;
            break;
        }
      i += 1;
    }
  return l;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   stop -
*/

static void stop (void)
{
}


/*
   doMaxCard - returns the maximum of two CARDINALs.
*/

static unsigned int doMaxCard (unsigned int a, unsigned int b)
{
  if ((a > 100) || (b > 100))
    {
      stop ();
    }
  if (a > b)
    {
      return a;
    }
  else
    {
      return b;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetAnnotationFieldLength -
*/

static unsigned int GetAnnotationFieldLength (unsigned int n, unsigned int f)
{
  int c;
  int e;

  c = GetComment ((DynamicStrings_String) ((*OperandAnno.proc) (n)));
  if (c > 0)
    {
      if (Debugging)
        {
          M2Printf_printf0 ((const char *) "full anno is: ", 14);
          Output (DynamicStrings_Dup ((DynamicStrings_String) ((*OperandAnno.proc) (n))));
          M2Printf_printf0 ((const char *) "\\n", 2);
          M2Printf_printf0 ((const char *) "comment field is: ", 18);
          Output (DynamicStrings_Slice ((DynamicStrings_String) ((*OperandAnno.proc) (n)), c, 0));
          M2Printf_printf0 ((const char *) "\\n", 2);
        }
      e = DynamicStrings_Index ((DynamicStrings_String) ((*OperandAnno.proc) (n)), '|', static_cast<unsigned int> (c));
      if (f == 0)
        {
          return doFieldLength (c, e, n);
        }
      else
        {
          if (e >= 0)
            {
              e += 1;
            }
          return doFieldLength (e, -1, n);
        }
    }
  else
    {
      return 0;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetAnnotationLength -
*/

static unsigned int GetAnnotationLength (unsigned int n, unsigned int f)
{
  unsigned int l;

  if (((*OperandAnno.proc) (n)) == NULL)
    {
      l = 0;
      if (f == 0)
        {
          doNumberLength (&l, (unsigned int ) ((*OperandT.proc) (n)));
        }
      else
        {
          doNumberLength (&l, (unsigned int ) ((*OperandF.proc) (n)));
        }
      return l;
    }
  else
    {
      return GetAnnotationFieldLength (n, f);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFieldLength - returns the number of characters used in field, f,
                    at position, n, on the stack.
*/

static unsigned int GetFieldLength (unsigned int n, unsigned int f)
{
  int c;
  int b;
  int e;

  c = GetComment ((DynamicStrings_String) ((*OperandAnno.proc) (n)));
  if (c > 1)
    {
      e = c-2;
    }
  else
    {
      e = DynamicStrings_Length ((DynamicStrings_String) ((*OperandAnno.proc) (n)));
    }
  if (f == 0)
    {
      b = 0;
    }
  else
    {
      b = DynamicStrings_Index ((DynamicStrings_String) ((*OperandAnno.proc) (n)), '|', 0);
      if (b == -1)
        {
          return 0;
        }
      else
        {
          b += 1;
        }
    }
  return doFieldLength (b, e, n);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetMaxFieldAnno - returns the maximum number of characters required
                     by either the annotation or field, f, at position, n,
                     on the stack.
*/

static unsigned int GetMaxFieldAnno (unsigned int n, unsigned int f)
{
  return doMaxCard (GetAnnotationLength (n, f), GetFieldLength (n, f));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetStackFieldLengths - assigns, tn, and, fn, with the
                          maximum field width values.
*/

static void GetStackFieldLengths (unsigned int *tn, unsigned int *fn, unsigned int *tk, unsigned int amount)
{
  unsigned int i;

  i = 1;
  (*tn) = 0;
  (*fn) = 0;
  (*tk) = 0;
  while (i <= amount)
    {
      (*tn) = doMaxCard ((*tn), GetMaxFieldAnno (i, 0));
      (*fn) = doMaxCard ((*fn), GetMaxFieldAnno (i, 1));
      (*tk) = doMaxCard ((*tk), GetMaxFieldAnno (i, 2));
      i += 1;
    }
}


/*
   DisplayRow -
*/

static void DisplayRow (unsigned int tn, unsigned int fn, unsigned int tk, bool initOrFinal)
{
  unsigned int i;

  M2Printf_printf0 ((const char *) "+-", 2);
  for (i=1; i<=tn; i++)
    {
      M2Printf_printf0 ((const char *) "-", 1);
    }
  if ((fn == 0) && (tk == 0))
    {
      if (initOrFinal)
        {
          M2Printf_printf0 ((const char *) "-+-", 3);
        }
      else
        {
          M2Printf_printf0 ((const char *) "-|-", 3);
        }
    }
  else
    {
      if (initOrFinal)
        {
          M2Printf_printf0 ((const char *) "-+-", 3);
        }
      else
        {
          M2Printf_printf0 ((const char *) "-|-", 3);
        }
      if (fn != 0)
        {
          for (i=1; i<=fn; i++)
            {
              M2Printf_printf0 ((const char *) "-", 1);
            }
        }
      if (initOrFinal)
        {
          M2Printf_printf0 ((const char *) "-+-", 3);
        }
      else
        {
          M2Printf_printf0 ((const char *) "-|-", 3);
        }
      if (tk != 0)
        {
          for (i=1; i<=tk; i++)
            {
              M2Printf_printf0 ((const char *) "-", 1);
            }
          M2Printf_printf0 ((const char *) "-+\\n", 4);
        }
    }
}


/*
   SkipToField -
*/

static int SkipToField (DynamicStrings_String s, unsigned int n)
{
  int i;
  int h;

  i = 0;
  h = DynamicStrings_Length (s);
  while ((n > 0) && (i < h))
    {
      if ((DynamicStrings_Index (s, '|', static_cast<unsigned int> (i))) > 0)
        {
          n -= 1;
          if ((i < h) && ((DynamicStrings_char (s, i+1)) == '|'))
            {
              /* comment seen, no field available  */
              return -1;
            }
          i = DynamicStrings_Index (s, '|', static_cast<unsigned int> (i));
        }
      else
        {
          return -1;
        }
      i += 1;
    }
  if (i == h)
    {
      i = -1;
    }
  return i;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Pad - padds out string, s, to paddedLength characters.
*/

static DynamicStrings_String Pad (DynamicStrings_String o, unsigned int paddedLength)
{
  unsigned int i;

  i = DynamicStrings_Length (o);
  if (i < paddedLength)
    {
      do {
        o = DynamicStrings_ConCatChar (o, ' ');
        i += 1;
      } while (! (i == paddedLength));
    }
  return o;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doField - compute the string length given in annotation
             at position, n, on the stack between characters
             b and e.

             The string description between: b..e can contain any
             of these patterns:

             %a           ascii name key.
             %s           symbol number.
             %d           decimal cardinal number.
             |            indicates the next field.
*/

static DynamicStrings_String doField (DynamicStrings_String s, unsigned int n, unsigned int f, unsigned int l)
{
  int h;
  int i;
  int j;
  DynamicStrings_String o;

  h = DynamicStrings_Length (s);
  i = SkipToField (s, f);
  o = DynamicStrings_InitString ((const char *) "", 0);
  if (i >= 0)
    {
      j = SkipToField (s, f+1);
      if (j == -1)
        {
          j = h;
        }
      while (i < h)
        {
          switch (DynamicStrings_char (s, i))
            {
              case '|':
                i = h;
                break;

              case '%':
                o = doPercent (o, s, &i, h, n);
                break;


              default:
                o = DynamicStrings_ConCatChar (o, DynamicStrings_char (s, i));
                i += 1;
                break;
            }
        }
    }
  o = Pad (o, l);
  return o;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doAnnotation -
*/

static DynamicStrings_String doAnnotation (DynamicStrings_String s, unsigned int n, unsigned int field, unsigned int width)
{
  int c;
  DynamicStrings_String cf;
  DynamicStrings_String o;

  c = GetComment (s);
  if (c >= 0)
    {
      cf = DynamicStrings_Slice (s, c, 0);
      o = doField (cf, n, field, width);
      cf = DynamicStrings_KillString (cf);
      return o;
    }
  else
    {
      return DynamicStrings_InitString ((const char *) "", 0);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DisplayFields -
*/

static void DisplayFields (unsigned int n, unsigned int tn, unsigned int fn, unsigned int tk)
{
  DynamicStrings_String s;
  unsigned int t;
  unsigned int f;
  unsigned int k;

  s = static_cast<DynamicStrings_String> ((*OperandAnno.proc) (n));
  if (s == NULL)
    {
      t = static_cast<unsigned int> ((*OperandT.proc) (n));
      f = static_cast<unsigned int> ((*OperandF.proc) (n));
      k = static_cast<unsigned int> ((*OperandTok.proc) (n));
      M2Printf_printf0 ((const char *) "| ", 2);
      Output (Pad (StringConvert_CardinalToString ((unsigned int ) (t), 0, ' ', 10, true), tn));
      M2Printf_printf0 ((const char *) " | ", 3);
      Output (Pad (StringConvert_CardinalToString ((unsigned int ) (f), 0, ' ', 10, true), fn));
      M2Printf_printf0 ((const char *) " | ", 3);
      Output (Pad (StringConvert_CardinalToString ((unsigned int ) (k), 0, ' ', 10, true), tk));
      M2Printf_printf0 ((const char *) " |\\n", 4);
    }
  else
    {
      if (tn > 0)
        {
          M2Printf_printf0 ((const char *) "| ", 2);
          Output (doField (s, n, 0, tn));
        }
      if (fn > 0)
        {
          M2Printf_printf0 ((const char *) " | ", 3);
          Output (doField (s, n, 1, fn));
        }
      if (tk > 0)
        {
          M2Printf_printf0 ((const char *) " | ", 3);
          Output (doField (s, n, 2, tk));
        }
      M2Printf_printf0 ((const char *) " |\\n", 4);
      if (tn > 0)
        {
          M2Printf_printf0 ((const char *) "| ", 2);
          Output (doAnnotation (s, n, 0, tn));
        }
      if (fn > 0)
        {
          M2Printf_printf0 ((const char *) " | ", 3);
          Output (doAnnotation (s, n, 1, fn));
        }
      if (tk > 0)
        {
          M2Printf_printf0 ((const char *) " | ", 3);
          Output (doAnnotation (s, n, 2, tk));
        }
      M2Printf_printf0 ((const char *) " |\\n", 4);
    }
}


/*
   DebugStack - displays the stack.
*/

extern "C" void M2DebugStack_DebugStack (unsigned int amount, M2DebugStack_ProcedureWord opt, M2DebugStack_ProcedureWord opf, M2DebugStack_ProcedureWord opa, M2DebugStack_ProcedureWord opd, M2DebugStack_ProcedureWord oprw, M2DebugStack_ProcedureWord optk, M2DebugStack_ProcedureString opanno)
{
  unsigned int i;
  unsigned int tn;
  unsigned int fn;
  unsigned int tk;

  OperandT = opt;
  OperandF = opf;
  OperandA = opa;
  OperandD = opd;
  OperandRW = oprw;
  OperandAnno = opanno;
  OperandTok = optk;
  GetStackFieldLengths (&tn, &fn, &tk, amount);
  i = 1;
  while (i <= amount)
    {
      if (i == 1)
        {
          DisplayRow (tn, fn, tk, true);
        }
      DisplayFields (i, tn, fn, tk);
      DisplayRow (tn, fn, tk, i == amount);
      i += 1;
    }
}

extern "C" void _M2_M2DebugStack_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2DebugStack_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
