/* do not edit automatically generated by mc from M2StackWord.  */
/* M2StackWord.def provides a generic stack for WORD sized objects.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2StackWord_H)
#   define _M2StackWord_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"

#   if defined (_M2StackWord_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2StackWord_StackOfWord_D)
#  define M2StackWord_StackOfWord_D
   typedef void *M2StackWord_StackOfWord;
#endif


/*
   InitStackWord - creates and returns a new stack.
*/

EXTERN M2StackWord_StackOfWord M2StackWord_InitStackWord (void);

/*
   KillStackWord - destroys a stack, returning NIL.
*/

EXTERN M2StackWord_StackOfWord M2StackWord_KillStackWord (M2StackWord_StackOfWord s);

/*
   PushWord - pushes a word, w, onto, s.
*/

EXTERN void M2StackWord_PushWord (M2StackWord_StackOfWord s, unsigned int w);

/*
   PopWord - pops an element from stack, s.
*/

EXTERN unsigned int M2StackWord_PopWord (M2StackWord_StackOfWord s);

/*
   IsEmptyWord - returns TRUE if stack, s, is empty.
*/

EXTERN bool M2StackWord_IsEmptyWord (M2StackWord_StackOfWord s);

/*
   PeepWord - returns the element at, n, items below in the stack.
              Top of stack can be seen via Peep(s, 1)
*/

EXTERN unsigned int M2StackWord_PeepWord (M2StackWord_StackOfWord s, unsigned int n);

/*
   ReduceWord - reduce the stack by n elements.
*/

EXTERN void M2StackWord_ReduceWord (M2StackWord_StackOfWord s, unsigned int n);

/*
   RemoveTop - throw away the top element of the stack.
*/

EXTERN void M2StackWord_RemoveTop (M2StackWord_StackOfWord s);

/*
   NoOfItemsInStackWord - returns the number of items held in the stack, s.
*/

EXTERN unsigned int M2StackWord_NoOfItemsInStackWord (M2StackWord_StackOfWord s);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
