/* do not edit automatically generated by mc from M2Graph.  */
/* M2Graph.def maintains the dependancy graph depth.

Copyright (C) 2022-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Graph_H)
#   define _M2Graph_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GLists.h"

#   if defined (_M2Graph_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2Graph_Graph_D)
#  define M2Graph_Graph_D
   typedef void *M2Graph_Graph;
#endif


/*
   InitGraph - creates and returns an empty graph.
*/

EXTERN M2Graph_Graph M2Graph_InitGraph (void);

/*
   KillGraph - deletes graph and all nodes.
*/

EXTERN void M2Graph_KillGraph (M2Graph_Graph *g);

/*
   AddDependent - adds moduleSym <- dependSym into the graph.
*/

EXTERN void M2Graph_AddDependent (M2Graph_Graph graph, unsigned int moduleSym, unsigned int dependSym);

/*
   SortGraph - returns a List containing the sorted graph.
*/

EXTERN Lists_List M2Graph_SortGraph (M2Graph_Graph g, unsigned int topModule);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
