/* do not edit automatically generated by mc from M2Error.  */
/* M2Error.def error reporting interface.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Error_H)
#   define _M2Error_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "GDynamicStrings.h"
#   include "GNameKey.h"

#   if defined (_M2Error_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2Error_Error_D)
#  define M2Error_Error_D
   typedef void *M2Error_Error;
#endif

#if !defined (M2Error_ErrorScope_D)
#  define M2Error_ErrorScope_D
   typedef void *M2Error_ErrorScope;
#endif


/*
   InternalError - displays an internal error message together with the compiler source
                   file and line number.
                   This function is not buffered and is used when the compiler is about
                   to give up.
*/

EXTERN void M2Error_InternalError (const char *message_, unsigned int _message_high) __attribute__ ((noreturn));

/*
   WriteFormat0 - displays the source module and line together
                  with the encapsulated format string.
                  Used for simple error messages tied to the current token.
*/

EXTERN void M2Error_WriteFormat0 (const char *a_, unsigned int _a_high);

/*
   WriteFormat1 - displays the source module and line together
                  with the encapsulated format string.
                  Used for simple error messages tied to the current token.
*/

EXTERN void M2Error_WriteFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high);

/*
   WriteFormat2 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

EXTERN void M2Error_WriteFormat2 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high);

/*
   WriteFormat3 - displays the module and line together with the encapsulated
                  format strings.
                  Used for simple error messages tied to the current token.
*/

EXTERN void M2Error_WriteFormat3 (const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high);

/*
   NewError - creates and returns a new error handle.
*/

EXTERN M2Error_Error M2Error_NewError (unsigned int AtTokenNo);

/*
   NewWarning - creates and returns a new error handle suitable for a warning.
                A warning will not stop compilation.
*/

EXTERN M2Error_Error M2Error_NewWarning (unsigned int AtTokenNo);

/*
   NewNote - creates and returns a new error handle suitable for a note.
             A note will not stop compilation.
*/

EXTERN M2Error_Error M2Error_NewNote (unsigned int AtTokenNo);

/*
   ChainError - creates and returns a new error handle, this new error
                is associated with, e, and is chained onto the end of, e.
*/

EXTERN M2Error_Error M2Error_ChainError (unsigned int AtTokenNo, M2Error_Error e);

/*
   MoveError - repositions an error, e, to token, AtTokenNo, and returns, e.
*/

EXTERN M2Error_Error M2Error_MoveError (M2Error_Error e, unsigned int AtTokenNo);

/*
   SetColor - informs the error module that this error will have had colors
              assigned to it.  If an error is issued without colors assigned
              then the default colors will be assigned to the legacy error
              messages.
*/

EXTERN M2Error_Error M2Error_SetColor (M2Error_Error e);
EXTERN void M2Error_ErrorFormat0 (M2Error_Error e, const char *a_, unsigned int _a_high);
EXTERN void M2Error_ErrorFormat1 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high);
EXTERN void M2Error_ErrorFormat2 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high);
EXTERN void M2Error_ErrorFormat3 (M2Error_Error e, const char *a_, unsigned int _a_high, const unsigned char *w1_, unsigned int _w1_high, const unsigned char *w2_, unsigned int _w2_high, const unsigned char *w3_, unsigned int _w3_high);
EXTERN void M2Error_ErrorString (M2Error_Error e, DynamicStrings_String str);
EXTERN void M2Error_ErrorStringAt (DynamicStrings_String s, unsigned int tok);
EXTERN void M2Error_ErrorStringAt2 (DynamicStrings_String s, unsigned int tok1, unsigned int tok2);
EXTERN void M2Error_ErrorStringsAt2 (DynamicStrings_String s1, DynamicStrings_String s2, unsigned int tok1, unsigned int tok2);
EXTERN void M2Error_WarnStringAt (DynamicStrings_String s, unsigned int tok);
EXTERN void M2Error_WarnStringAt2 (DynamicStrings_String s, unsigned int tok1, unsigned int tok2);
EXTERN void M2Error_WarnStringsAt2 (DynamicStrings_String s1, DynamicStrings_String s2, unsigned int tok1, unsigned int tok2);

/*
   WarnFormat0 - displays the source module and line together
                 with the encapsulated format string.
                 Used for simple warning messages tied to the current token.
*/

EXTERN void M2Error_WarnFormat0 (const char *a_, unsigned int _a_high);

/*
   WarnFormat1 - displays the source module and line together
                 with the encapsulated format string.
                 Used for simple warning messages tied to the current token.
*/

EXTERN void M2Error_WarnFormat1 (const char *a_, unsigned int _a_high, const unsigned char *w_, unsigned int _w_high);

/*
   FlushErrors - switches the output channel to the error channel
                 and then writes out all errors.
                 If an error is present the compilation is terminated.
                 All warnings are ignored.
*/

EXTERN void M2Error_FlushErrors (void);

/*
   FlushWarnings - switches the output channel to the error channel
                   and then writes out all warnings.
                   If an error is present the compilation is terminated,
                   if warnings only were emitted then compilation will
                   continue.
*/

EXTERN void M2Error_FlushWarnings (void);

/*
   ErrorAbort0 - aborts compiling, it flushes all warnings and errors before aborting.
*/

EXTERN void M2Error_ErrorAbort0 (const char *a_, unsigned int _a_high) __attribute__ ((noreturn));

/*
   AnnounceScope - return the error string message with a scope description prepended
                   assuming that scope has changed.
*/

EXTERN DynamicStrings_String M2Error_AnnounceScope (M2Error_Error e, DynamicStrings_String message);

/*
   EnterImplementationScope - signifies to the error routines that the front end
                              has started to compile implementation module scopeName.
*/

EXTERN void M2Error_EnterImplementationScope (NameKey_Name scopename);

/*
   EnterProgramScope - signifies to the error routines that the front end
                       has started to compile program module scopeName.
*/

EXTERN void M2Error_EnterProgramScope (NameKey_Name scopename);

/*
   EnterModuleScope - signifies to the error routines that the front end
                      has started to compile an inner module scopeName.
*/

EXTERN void M2Error_EnterModuleScope (NameKey_Name scopename);

/*
   EnterDefinitionScope - signifies to the error routines that the front end
                          has started to compile definition module scopeName.
*/

EXTERN void M2Error_EnterDefinitionScope (NameKey_Name scopename);

/*
   EnterProcedureScope - signifies to the error routines that the front end
                         has started to compile definition module scopeName.
*/

EXTERN void M2Error_EnterProcedureScope (NameKey_Name scopename);

/*
   DepthScope - returns the depth of the scope stack.
*/

EXTERN unsigned int M2Error_DepthScope (void);

/*
   GetAnnounceScope - return message with the error scope attached to message.
                      filename and message are treated as read only by this
                      procedure function.
*/

EXTERN DynamicStrings_String M2Error_GetAnnounceScope (DynamicStrings_String filename, DynamicStrings_String message);

/*
   DefaultProgramModule - sets up an unnamed program scope before the Ident is seen.
*/

EXTERN void M2Error_DefaultProgramModule (void);

/*
   DefaultImplementationModule - sets up an unnamed implementation
                                 scope before the Ident is seen.
*/

EXTERN void M2Error_DefaultImplementationModule (void);

/*
   DefaultDefinitionModule - sets up an unnamed definition
                             scope before the Ident is seen.
*/

EXTERN void M2Error_DefaultDefinitionModule (void);

/*
   DefaultInnerModule - sets up an unnamed inner
                        scope before the Ident is seen.
*/

EXTERN void M2Error_DefaultInnerModule (void);

/*
   DefaultProcedure - sets up an unnamed procedure
                      scope before the Ident is seen.
*/

EXTERN void M2Error_DefaultProcedure (void);

/*
   EnterErrorScope - pushes the currentScope and sets currentScope to scope.
*/

EXTERN void M2Error_EnterErrorScope (M2Error_ErrorScope scope);

/*
   LeaveErrorScope - leave the current scope and pop into the previous one.
*/

EXTERN void M2Error_LeaveErrorScope (void);

/*
   GetCurrentErrorScope - returns currentScope.
*/

EXTERN M2Error_ErrorScope M2Error_GetCurrentErrorScope (void);

/*
   ResetErrorScope - should be called at the start of each pass to
                     reset the error scope index.
*/

EXTERN void M2Error_ResetErrorScope (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
