with Ada.Unchecked_Conversion;
with Atree; use Atree; use Atree.Atree_Private_Part;
with Einfo.Utils; use Einfo.Utils;

package body Einfo.Entities is

   --  This package is automatically generated.

   pragma Style_Checks ("M200");
   function Cast is new Ada.Unchecked_Conversion (Flag, Field_Size_1_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_1_Bit, Flag);
   function Cast is new Ada.Unchecked_Conversion (Node_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Node_Id);
   function Cast is new Ada.Unchecked_Conversion (List_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, List_Id);
   function Cast is new Ada.Unchecked_Conversion (Elist_Id, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Elist_Id);
   function Cast is new Ada.Unchecked_Conversion (Uint, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Uint);
   function Cast is new Ada.Unchecked_Conversion (Ureal, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Ureal);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_8_Bit, Entity_Kind);
   function Cast is new Ada.Unchecked_Conversion (Convention_Id, Field_Size_8_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_8_Bit, Convention_Id);
   function Cast is new Ada.Unchecked_Conversion (Component_Alignment_Kind, Field_Size_2_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_2_Bit, Component_Alignment_Kind);
   function Cast is new Ada.Unchecked_Conversion (Mechanism_Type, Field_Size_32_Bit);
   function Cast is new Ada.Unchecked_Conversion (Field_Size_32_Bit, Mechanism_Type);

   --  Getters and setters for fields

   function Ekind (N : Entity_Id) return Entity_Kind is
      --  4  8-bit fields per 32-bit slot.
      --  Offset 1 = 0 slots + 1 fields in slot.

      Off : constant := 1;
      F_Size : constant := 8;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_8_Bit :=
        Field_Size_8_Bit (Shift_Right (S, V) and Mask);
      Val : constant Entity_Kind := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Ekind;

   function Basic_Convention (N : Entity_Id) return Convention_Id is
      --  4  8-bit fields per 32-bit slot.
      --  Offset 32 = 8 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 8;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_8_Bit :=
        Field_Size_8_Bit (Shift_Right (S, V) and Mask);
      Val : constant Convention_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Basic_Convention;

   procedure Set_Basic_Convention (N : Entity_Id; Val : Convention_Id) is
      --  4  8-bit fields per 32-bit slot.
      --  Offset 32 = 8 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 8;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_8_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Basic_Convention;

   function Abstract_States (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Abstract_States;

   procedure Set_Abstract_States (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Abstract_States;

   function Accept_Address (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 55 = 55 slots + 0 fields in slot.

      Off : constant := 55;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Accept_Address;

   procedure Set_Accept_Address (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 55 = 55 slots + 0 fields in slot.

      Off : constant := 55;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Accept_Address;

   function Access_Disp_Table (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Access_Disp_Table;

   procedure Set_Access_Disp_Table (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Access_Disp_Table;

   function Access_Disp_Table_Elab_Flag (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Access_Disp_Table_Elab_Flag;

   procedure Set_Access_Disp_Table_Elab_Flag (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Access_Disp_Table_Elab_Flag;

   function Access_Subprogram_Wrapper (N : E_Subprogram_Type_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Access_Subprogram_Wrapper;

   procedure Set_Access_Subprogram_Wrapper (N : E_Subprogram_Type_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Access_Subprogram_Wrapper;

   function Activation_Record_Component (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 26 = 26 slots + 0 fields in slot.

      Off : constant := 26;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Activation_Record_Component;

   procedure Set_Activation_Record_Component (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 26 = 26 slots + 0 fields in slot.

      Off : constant := 26;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Activation_Record_Component;

   function Actual_Subtype (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 27 = 27 slots + 0 fields in slot.

      Off : constant := 27;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Actual_Subtype;

   procedure Set_Actual_Subtype (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 27 = 27 slots + 0 fields in slot.

      Off : constant := 27;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Actual_Subtype;

   function Address_Taken (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 29 = 0 slots + 29 fields in slot.

      Off : constant := 29;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Address_Taken;

   procedure Set_Address_Taken (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 29 = 0 slots + 29 fields in slot.

      Off : constant := 29;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Address_Taken;

   function Alignment (N : Entity_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 21 = 21 slots + 0 fields in slot.

      Off : constant := 21;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Alignment;

   procedure Set_Alignment (N : Entity_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 21 = 21 slots + 0 fields in slot.

      Off : constant := 21;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Alignment;

   function Anonymous_Collections (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Anonymous_Collections;

   procedure Set_Anonymous_Collections (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Anonymous_Collections;

   function Anonymous_Designated_Type (N : E_Variable_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Anonymous_Designated_Type;

   procedure Set_Anonymous_Designated_Type (N : E_Variable_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Anonymous_Designated_Type;

   function Anonymous_Object (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Anonymous_Object;

   procedure Set_Anonymous_Object (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Anonymous_Object;

   function Associated_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 9 = 9 slots + 0 fields in slot.

      Off : constant := 9;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Associated_Entity;

   procedure Set_Associated_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 9 = 9 slots + 0 fields in slot.

      Off : constant := 9;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Associated_Entity;

   function Associated_Formal_Package (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Associated_Formal_Package;

   procedure Set_Associated_Formal_Package (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Associated_Formal_Package;

   function Associated_Node_For_Itype (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Associated_Node_For_Itype;

   procedure Set_Associated_Node_For_Itype (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Associated_Node_For_Itype;

   function Associated_Storage_Pool (N : Access_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Root_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Associated_Storage_Pool;

   procedure Set_Associated_Storage_Pool (N : Access_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Associated_Storage_Pool;

   function Barrier_Function (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Barrier_Function;

   procedure Set_Barrier_Function (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Barrier_Function;

   function BIP_Initialization_Call (N : Constant_Or_Variable_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 38 = 38 slots + 0 fields in slot.

      Off : constant := 38;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end BIP_Initialization_Call;

   procedure Set_BIP_Initialization_Call (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 38 = 38 slots + 0 fields in slot.

      Off : constant := 38;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_BIP_Initialization_Call;

   function Block_Node (N : E_Block_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Block_Node;

   procedure Set_Block_Node (N : E_Block_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Block_Node;

   function Body_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Body_Entity;

   procedure Set_Body_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Body_Entity;

   function Body_Needed_For_Inlining (N : E_Package_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Body_Needed_For_Inlining;

   procedure Set_Body_Needed_For_Inlining (N : E_Package_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Body_Needed_For_Inlining;

   function Body_Needed_For_SAL (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Body_Needed_For_SAL;

   procedure Set_Body_Needed_For_SAL (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Body_Needed_For_SAL;

   function Body_References (N : E_Abstract_State_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Body_References;

   procedure Set_Body_References (N : E_Abstract_State_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Body_References;

   function C_Pass_By_Copy (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 978 = 30 slots + 18 fields in slot.

      Off : constant := 978;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end C_Pass_By_Copy;

   procedure Set_C_Pass_By_Copy (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 978 = 30 slots + 18 fields in slot.

      Off : constant := 978;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_C_Pass_By_Copy;

   function Can_Never_Be_Null (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Can_Never_Be_Null;

   procedure Set_Can_Never_Be_Null (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 30 = 0 slots + 30 fields in slot.

      Off : constant := 30;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Can_Never_Be_Null;

   function Can_Use_Internal_Rep (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 928 = 29 slots + 0 fields in slot.

      Off : constant := 928;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Ekind (Base_Type (N)) in Access_Subprogram_Kind);
      return Val;
   end Can_Use_Internal_Rep;

   procedure Set_Can_Use_Internal_Rep (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 928 = 29 slots + 0 fields in slot.

      Off : constant := 928;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Ekind (Base_Type (N)) in Access_Subprogram_Kind);
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Can_Use_Internal_Rep;

   function Checks_May_Be_Suppressed (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Checks_May_Be_Suppressed;

   procedure Set_Checks_May_Be_Suppressed (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 31 = 0 slots + 31 fields in slot.

      Off : constant := 31;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Checks_May_Be_Suppressed;

   function Class_Postconditions (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Class_Postconditions;

   procedure Set_Class_Postconditions (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Class_Postconditions;

   function Class_Preconditions (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Class_Preconditions;

   procedure Set_Class_Preconditions (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Class_Preconditions;

   function Class_Preconditions_Subprogram (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Class_Preconditions_Subprogram;

   procedure Set_Class_Preconditions_Subprogram (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Class_Preconditions_Subprogram;

   function Class_Wide_Equivalent_Type (N : Type_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Class_Wide_Equivalent_Type;

   procedure Set_Class_Wide_Equivalent_Type (N : Type_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Class_Wide_Equivalent_Type;

   function Class_Wide_Type (N : Type_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Class_Wide_Type;

   procedure Set_Class_Wide_Type (N : Type_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Class_Wide_Type;

   function Cloned_Subtype (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Cloned_Subtype;

   procedure Set_Cloned_Subtype (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Cloned_Subtype;

   function Component_Alignment (N : Entity_Id) return Component_Alignment_Kind is
      --  16  2-bit fields per 32-bit slot.
      --  Offset 487 = 30 slots + 7 fields in slot.

      Off : constant := 487;
      F_Size : constant := 2;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_2_Bit :=
        Field_Size_2_Bit (Shift_Right (S, V) and Mask);
      Val : constant Component_Alignment_Kind := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Alignment;

   procedure Set_Component_Alignment (N : Entity_Id; Val : Component_Alignment_Kind) is
      --  16  2-bit fields per 32-bit slot.
      --  Offset 487 = 30 slots + 7 fields in slot.

      Off : constant := 487;
      F_Size : constant := 2;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_2_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Component_Alignment;

   function Component_Bit_Offset (N : Record_Field_Kind_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 21 = 21 slots + 0 fields in slot.

      Off : constant := 21;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Bit_Offset;

   procedure Set_Component_Bit_Offset (N : Record_Field_Kind_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 21 = 21 slots + 0 fields in slot.

      Off : constant := 21;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Component_Bit_Offset;

   function Component_Clause (N : Record_Field_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Clause;

   procedure Set_Component_Clause (N : Record_Field_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Component_Clause;

   function Component_Size (N : Array_Kind_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Size;

   procedure Set_Component_Size (N : Array_Kind_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Component_Size;

   function Component_Type (N : Array_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Component_Type;

   procedure Set_Component_Type (N : Array_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Component_Type;

   function Contract (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Contract;

   procedure Set_Contract (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Contract;

   function Contract_Wrapper (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Contract_Wrapper;

   procedure Set_Contract_Wrapper (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Contract_Wrapper;

   function Corresponding_Concurrent_Type (N : E_Record_Type_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Concurrent_Type;

   procedure Set_Corresponding_Concurrent_Type (N : E_Record_Type_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Concurrent_Type;

   function Corresponding_Discriminant (N : E_Discriminant_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Discriminant;

   procedure Set_Corresponding_Discriminant (N : E_Discriminant_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Discriminant;

   function Corresponding_Equality (N : E_Function_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (not Comes_From_Source (N) and then Chars (N) = Name_Op_Ne);
      return Val;
   end Corresponding_Equality;

   procedure Set_Corresponding_Equality (N : E_Function_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (not Comes_From_Source (N) and then Chars (N) = Name_Op_Ne);
      S := Slot (Raw);
   end Set_Corresponding_Equality;

   function Corresponding_Record_Component (N : Record_Field_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Record_Component;

   procedure Set_Corresponding_Record_Component (N : Record_Field_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Record_Component;

   function Corresponding_Record_Type (N : Concurrent_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Record_Type;

   procedure Set_Corresponding_Record_Type (N : Concurrent_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Record_Type;

   function Corresponding_Remote_Type (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Corresponding_Remote_Type;

   procedure Set_Corresponding_Remote_Type (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Corresponding_Remote_Type;

   function CR_Discriminant (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 51 = 51 slots + 0 fields in slot.

      Off : constant := 51;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end CR_Discriminant;

   procedure Set_CR_Discriminant (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 51 = 51 slots + 0 fields in slot.

      Off : constant := 51;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_CR_Discriminant;

   function Current_Use_Clause (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 23 = 23 slots + 0 fields in slot.

      Off : constant := 23;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Current_Use_Clause;

   procedure Set_Current_Use_Clause (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 23 = 23 slots + 0 fields in slot.

      Off : constant := 23;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Current_Use_Clause;

   function Current_Value (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 23 = 23 slots + 0 fields in slot.

      Off : constant := 23;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Current_Value;

   procedure Set_Current_Value (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 23 = 23 slots + 0 fields in slot.

      Off : constant := 23;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Current_Value;

   function Debug_Info_Off (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 264 = 8 slots + 8 fields in slot.

      Off : constant := 264;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Debug_Info_Off;

   procedure Set_Debug_Info_Off (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 264 = 8 slots + 8 fields in slot.

      Off : constant := 264;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Debug_Info_Off;

   function Debug_Renaming_Link (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Debug_Renaming_Link;

   procedure Set_Debug_Renaming_Link (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Debug_Renaming_Link;

   function Default_Aspect_Component_Value (N : Array_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Aspect_Component_Value;

   procedure Set_Default_Aspect_Component_Value (N : Array_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Default_Aspect_Component_Value;

   function Default_Aspect_Value (N : Scalar_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Aspect_Value;

   procedure Set_Default_Aspect_Value (N : Scalar_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Default_Aspect_Value;

   function Default_Expr_Function (N : Formal_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Expr_Function;

   procedure Set_Default_Expr_Function (N : Formal_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Default_Expr_Function;

   function Default_Expressions_Processed (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 265 = 8 slots + 9 fields in slot.

      Off : constant := 265;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Expressions_Processed;

   procedure Set_Default_Expressions_Processed (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 265 = 8 slots + 9 fields in slot.

      Off : constant := 265;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Default_Expressions_Processed;

   function Default_Value (N : Formal_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Default_Value;

   procedure Set_Default_Value (N : Formal_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Default_Value;

   function Delay_Cleanups (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 266 = 8 slots + 10 fields in slot.

      Off : constant := 266;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Delay_Cleanups;

   procedure Set_Delay_Cleanups (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 266 = 8 slots + 10 fields in slot.

      Off : constant := 266;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Delay_Cleanups;

   function Delta_Value (N : Fixed_Point_Kind_Id) return Ureal is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Ureal := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Delta_Value;

   procedure Set_Delta_Value (N : Fixed_Point_Kind_Id; Val : Ureal) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Delta_Value;

   function Dependent_Instances (N : E_Package_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Generic_Instance (N));
      return Val;
   end Dependent_Instances;

   procedure Set_Dependent_Instances (N : E_Package_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Generic_Instance (N));
      S := Slot (Raw);
   end Set_Dependent_Instances;

   function Depends_On_Private (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 267 = 8 slots + 11 fields in slot.

      Off : constant := 267;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Depends_On_Private;

   procedure Set_Depends_On_Private (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 267 = 8 slots + 11 fields in slot.

      Off : constant := 267;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Depends_On_Private;

   function Derived_Type_Link (N : Type_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Derived_Type_Link;

   procedure Set_Derived_Type_Link (N : Type_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Derived_Type_Link;

   function Digits_Value (N : Entity_Id) return Upos is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Upos := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Digits_Value;

   procedure Set_Digits_Value (N : Entity_Id; Val : Upos) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Digits_Value;

   function Predicated_Parent (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Predicated_Parent;

   procedure Set_Predicated_Parent (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Predicated_Parent;

   function Predicates_Ignored (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 929 = 29 slots + 1 fields in slot.

      Off : constant := 929;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Predicates_Ignored;

   procedure Set_Predicates_Ignored (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 929 = 29 slots + 1 fields in slot.

      Off : constant := 929;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Predicates_Ignored;

   function Direct_Primitive_Operations (N : Type_Kind_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 38 = 38 slots + 0 fields in slot.

      Off : constant := 38;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Direct_Primitive_Operations;

   procedure Set_Direct_Primitive_Operations (N : Type_Kind_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 38 = 38 slots + 0 fields in slot.

      Off : constant := 38;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Direct_Primitive_Operations;

   function Directly_Designated_Type (N : Access_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Directly_Designated_Type;

   procedure Set_Directly_Designated_Type (N : Access_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Directly_Designated_Type;

   function Disable_Controlled (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 268 = 8 slots + 12 fields in slot.

      Off : constant := 268;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Disable_Controlled;

   procedure Set_Disable_Controlled (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 268 = 8 slots + 12 fields in slot.

      Off : constant := 268;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Disable_Controlled;

   function Discard_Names (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 269 = 8 slots + 13 fields in slot.

      Off : constant := 269;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discard_Names;

   procedure Set_Discard_Names (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 269 = 8 slots + 13 fields in slot.

      Off : constant := 269;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Discard_Names;

   function Discriminal (N : E_Discriminant_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discriminal;

   procedure Set_Discriminal (N : E_Discriminant_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Discriminal;

   function Discriminal_Link (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discriminal_Link;

   procedure Set_Discriminal_Link (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Discriminal_Link;

   function Discriminant_Checking_Func (N : E_Component_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discriminant_Checking_Func;

   procedure Set_Discriminant_Checking_Func (N : E_Component_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Discriminant_Checking_Func;

   function Discriminant_Constraint (N : Composite_Kind_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Has_Discriminants (N) or else Is_Constrained (N));
      return Val;
   end Discriminant_Constraint;

   procedure Set_Discriminant_Constraint (N : Composite_Kind_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Discriminant_Constraint;

   function Discriminant_Default_Value (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discriminant_Default_Value;

   procedure Set_Discriminant_Default_Value (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Discriminant_Default_Value;

   function Discriminant_Number (N : Entity_Id) return Upos is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 52 = 52 slots + 0 fields in slot.

      Off : constant := 52;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Upos := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Discriminant_Number;

   procedure Set_Discriminant_Number (N : Entity_Id; Val : Upos) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 52 = 52 slots + 0 fields in slot.

      Off : constant := 52;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Discriminant_Number;

   function Dispatch_Table_Wrappers (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Dispatch_Table_Wrappers;

   procedure Set_Dispatch_Table_Wrappers (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Dispatch_Table_Wrappers;

   function Dynamic_Call_Helper (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Dynamic_Call_Helper;

   procedure Set_Dynamic_Call_Helper (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Dynamic_Call_Helper;

   function DT_Entry_Count (N : E_Component_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Tag (N));
      return Val;
   end DT_Entry_Count;

   procedure Set_DT_Entry_Count (N : E_Component_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Tag (N));
      S := Slot (Raw);
   end Set_DT_Entry_Count;

   function DT_Offset_To_Top_Func (N : E_Component_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 30 = 30 slots + 0 fields in slot.

      Off : constant := 30;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Tag (N));
      return Val;
   end DT_Offset_To_Top_Func;

   procedure Set_DT_Offset_To_Top_Func (N : E_Component_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 30 = 30 slots + 0 fields in slot.

      Off : constant := 30;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Tag (N));
      S := Slot (Raw);
   end Set_DT_Offset_To_Top_Func;

   function DT_Position (N : Entity_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 55 = 55 slots + 0 fields in slot.

      Off : constant := 55;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Present (DTC_Entity (N)));
      return Val;
   end DT_Position;

   procedure Set_DT_Position (N : Entity_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 55 = 55 slots + 0 fields in slot.

      Off : constant := 55;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_DT_Position;

   function DTC_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 56 = 56 slots + 0 fields in slot.

      Off : constant := 56;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end DTC_Entity;

   procedure Set_DTC_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 56 = 56 slots + 0 fields in slot.

      Off : constant := 56;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_DTC_Entity;

   function Elaborate_Body_Desirable (N : E_Package_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 541 = 16 slots + 29 fields in slot.

      Off : constant := 541;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elaborate_Body_Desirable;

   procedure Set_Elaborate_Body_Desirable (N : E_Package_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 541 = 16 slots + 29 fields in slot.

      Off : constant := 541;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Elaborate_Body_Desirable;

   function Elaboration_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 21 = 21 slots + 0 fields in slot.

      Off : constant := 21;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elaboration_Entity;

   procedure Set_Elaboration_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 21 = 21 slots + 0 fields in slot.

      Off : constant := 21;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Elaboration_Entity;

   function Elaboration_Entity_Required (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Elaboration_Entity_Required;

   procedure Set_Elaboration_Entity_Required (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Elaboration_Entity_Required;

   function Encapsulating_State (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Encapsulating_State;

   procedure Set_Encapsulating_State (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Encapsulating_State;

   function Enclosing_Scope (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 53 = 53 slots + 0 fields in slot.

      Off : constant := 53;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Enclosing_Scope;

   procedure Set_Enclosing_Scope (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 53 = 53 slots + 0 fields in slot.

      Off : constant := 53;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Enclosing_Scope;

   function Entry_Accepted (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Accepted;

   procedure Set_Entry_Accepted (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Entry_Accepted;

   function Entry_Bodies_Array (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 56 = 56 slots + 0 fields in slot.

      Off : constant := 56;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Has_Entries (N));
      return Val;
   end Entry_Bodies_Array;

   procedure Set_Entry_Bodies_Array (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 56 = 56 slots + 0 fields in slot.

      Off : constant := 56;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Has_Entries (N));
      S := Slot (Raw);
   end Set_Entry_Bodies_Array;

   function Entry_Cancel_Parameter (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Cancel_Parameter;

   procedure Set_Entry_Cancel_Parameter (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Entry_Cancel_Parameter;

   function Entry_Component (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 30 = 30 slots + 0 fields in slot.

      Off : constant := 30;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Component;

   procedure Set_Entry_Component (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 30 = 30 slots + 0 fields in slot.

      Off : constant := 30;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Entry_Component;

   function Entry_Formal (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Formal;

   procedure Set_Entry_Formal (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Entry_Formal;

   function Entry_Index_Constant (N : E_Entry_Index_Parameter_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 18 = 18 slots + 0 fields in slot.

      Off : constant := 18;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Index_Constant;

   procedure Set_Entry_Index_Constant (N : E_Entry_Index_Parameter_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 18 = 18 slots + 0 fields in slot.

      Off : constant := 18;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Entry_Index_Constant;

   function Entry_Max_Queue_Lengths_Array (N : E_Protected_Type_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Max_Queue_Lengths_Array;

   procedure Set_Entry_Max_Queue_Lengths_Array (N : E_Protected_Type_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Entry_Max_Queue_Lengths_Array;

   function Entry_Parameters_Type (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Entry_Parameters_Type;

   procedure Set_Entry_Parameters_Type (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Entry_Parameters_Type;

   function Enum_Pos_To_Rep (N : E_Enumeration_Type_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Enum_Pos_To_Rep;

   procedure Set_Enum_Pos_To_Rep (N : E_Enumeration_Type_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Enum_Pos_To_Rep;

   function Enumeration_Pos (N : E_Enumeration_Literal_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Enumeration_Pos;

   procedure Set_Enumeration_Pos (N : E_Enumeration_Literal_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Enumeration_Pos;

   function Enumeration_Rep (N : E_Enumeration_Literal_Id) return Valid_Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Valid_Uint := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Enumeration_Rep;

   procedure Set_Enumeration_Rep (N : E_Enumeration_Literal_Id; Val : Valid_Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Enumeration_Rep;

   function Enumeration_Rep_Expr (N : E_Enumeration_Literal_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Enumeration_Rep_Expr;

   procedure Set_Enumeration_Rep_Expr (N : E_Enumeration_Literal_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 25 = 25 slots + 0 fields in slot.

      Off : constant := 25;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Enumeration_Rep_Expr;

   function Equivalent_Type (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Equivalent_Type;

   procedure Set_Equivalent_Type (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Equivalent_Type;

   function Esize (N : Entity_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Esize;

   procedure Set_Esize (N : Entity_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Esize;

   function Extra_Accessibility (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Extra_Accessibility;

   procedure Set_Extra_Accessibility (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Extra_Accessibility;

   function Extra_Accessibility_Of_Result (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Extra_Accessibility_Of_Result;

   procedure Set_Extra_Accessibility_Of_Result (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Extra_Accessibility_Of_Result;

   function Extra_Constrained (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Extra_Constrained;

   procedure Set_Extra_Constrained (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Extra_Constrained;

   function Extra_Formal (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Extra_Formal;

   procedure Set_Extra_Formal (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Extra_Formal;

   function Extra_Formals (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Extra_Formals;

   procedure Set_Extra_Formals (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Extra_Formals;

   function Finalization_Collection (N : Access_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Root_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Finalization_Collection;

   procedure Set_Finalization_Collection (N : Access_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Finalization_Collection;

   function Finalization_Master_Node (N : Allocatable_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Finalization_Master_Node;

   procedure Set_Finalization_Master_Node (N : Allocatable_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Finalization_Master_Node;

   function Finalize_Storage_Only (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 930 = 29 slots + 2 fields in slot.

      Off : constant := 930;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Finalize_Storage_Only;

   procedure Set_Finalize_Storage_Only (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 930 = 29 slots + 2 fields in slot.

      Off : constant := 930;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Finalize_Storage_Only;

   function Finalizer (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Finalizer;

   procedure Set_Finalizer (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Finalizer;

   function First_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 26 = 26 slots + 0 fields in slot.

      Off : constant := 26;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Entity;

   procedure Set_First_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 26 = 26 slots + 0 fields in slot.

      Off : constant := 26;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Entity;

   function First_Exit_Statement (N : E_Loop_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Exit_Statement;

   procedure Set_First_Exit_Statement (N : E_Loop_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 19 = 19 slots + 0 fields in slot.

      Off : constant := 19;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Exit_Statement;

   function First_Index (N : Array_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Index;

   procedure Set_First_Index (N : Array_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Index;

   function First_Literal (N : Enumeration_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Literal;

   procedure Set_First_Literal (N : Enumeration_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Literal;

   function First_Private_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Private_Entity;

   procedure Set_First_Private_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Private_Entity;

   function First_Rep_Item (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 10 = 10 slots + 0 fields in slot.

      Off : constant := 10;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end First_Rep_Item;

   procedure Set_First_Rep_Item (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 10 = 10 slots + 0 fields in slot.

      Off : constant := 10;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_First_Rep_Item;

   function Freeze_Node (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 11 = 11 slots + 0 fields in slot.

      Off : constant := 11;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Freeze_Node;

   procedure Set_Freeze_Node (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 11 = 11 slots + 0 fields in slot.

      Off : constant := 11;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Freeze_Node;

   function From_Limited_With (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end From_Limited_With;

   procedure Set_From_Limited_With (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 17 = 0 slots + 17 fields in slot.

      Off : constant := 17;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_From_Limited_With;

   function Full_View (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Full_View;

   procedure Set_Full_View (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Full_View;

   function Generic_Homonym (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 54 = 54 slots + 0 fields in slot.

      Off : constant := 54;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Generic_Homonym;

   procedure Set_Generic_Homonym (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 54 = 54 slots + 0 fields in slot.

      Off : constant := 54;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Generic_Homonym;

   function Generic_Renamings (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 39 = 39 slots + 0 fields in slot.

      Off : constant := 39;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Generic_Renamings;

   procedure Set_Generic_Renamings (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 39 = 39 slots + 0 fields in slot.

      Off : constant := 39;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Generic_Renamings;

   function Handler_Records (N : Entity_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 38 = 38 slots + 0 fields in slot.

      Off : constant := 38;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Handler_Records;

   procedure Set_Handler_Records (N : Entity_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 38 = 38 slots + 0 fields in slot.

      Off : constant := 38;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Handler_Records;

   function Has_Aliased_Components (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 270 = 8 slots + 14 fields in slot.

      Off : constant := 270;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Aliased_Components;

   procedure Set_Has_Aliased_Components (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 270 = 8 slots + 14 fields in slot.

      Off : constant := 270;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Aliased_Components;

   function Has_Alignment_Clause (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 271 = 8 slots + 15 fields in slot.

      Off : constant := 271;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Alignment_Clause;

   procedure Set_Has_Alignment_Clause (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 271 = 8 slots + 15 fields in slot.

      Off : constant := 271;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Alignment_Clause;

   function Has_All_Calls_Remote (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 272 = 8 slots + 16 fields in slot.

      Off : constant := 272;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_All_Calls_Remote;

   procedure Set_Has_All_Calls_Remote (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 272 = 8 slots + 16 fields in slot.

      Off : constant := 272;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_All_Calls_Remote;

   function Has_Atomic_Components (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 273 = 8 slots + 17 fields in slot.

      Off : constant := 273;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Atomic_Components;

   procedure Set_Has_Atomic_Components (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 273 = 8 slots + 17 fields in slot.

      Off : constant := 273;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Atomic_Components;

   function Has_Biased_Representation (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 274 = 8 slots + 18 fields in slot.

      Off : constant := 274;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Biased_Representation;

   procedure Set_Has_Biased_Representation (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 274 = 8 slots + 18 fields in slot.

      Off : constant := 274;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Biased_Representation;

   function Has_Completion (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 275 = 8 slots + 19 fields in slot.

      Off : constant := 275;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Completion;

   procedure Set_Has_Completion (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 275 = 8 slots + 19 fields in slot.

      Off : constant := 275;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Completion;

   function Has_Completion_In_Body (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 931 = 29 slots + 3 fields in slot.

      Off : constant := 931;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Completion_In_Body;

   procedure Set_Has_Completion_In_Body (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 931 = 29 slots + 3 fields in slot.

      Off : constant := 931;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Completion_In_Body;

   function Has_Complex_Representation (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 979 = 30 slots + 19 fields in slot.

      Off : constant := 979;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Complex_Representation;

   procedure Set_Has_Complex_Representation (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 979 = 30 slots + 19 fields in slot.

      Off : constant := 979;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Complex_Representation;

   function Has_Component_Size_Clause (N : Array_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 978 = 30 slots + 18 fields in slot.

      Off : constant := 978;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Component_Size_Clause;

   procedure Set_Has_Component_Size_Clause (N : Array_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 978 = 30 slots + 18 fields in slot.

      Off : constant := 978;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Component_Size_Clause;

   function Has_Constrained_Partial_View (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 932 = 29 slots + 4 fields in slot.

      Off : constant := 932;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Constrained_Partial_View;

   procedure Set_Has_Constrained_Partial_View (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 932 = 29 slots + 4 fields in slot.

      Off : constant := 932;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Constrained_Partial_View;

   function Has_Contiguous_Rep (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 276 = 8 slots + 20 fields in slot.

      Off : constant := 276;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Contiguous_Rep;

   procedure Set_Has_Contiguous_Rep (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 276 = 8 slots + 20 fields in slot.

      Off : constant := 276;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Contiguous_Rep;

   function Has_Controlled_Component (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 277 = 8 slots + 21 fields in slot.

      Off : constant := 277;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Controlled_Component;

   procedure Set_Has_Controlled_Component (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 277 = 8 slots + 21 fields in slot.

      Off : constant := 277;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Controlled_Component;

   function Has_Controlling_Result (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 278 = 8 slots + 22 fields in slot.

      Off : constant := 278;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Controlling_Result;

   procedure Set_Has_Controlling_Result (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 278 = 8 slots + 22 fields in slot.

      Off : constant := 278;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Controlling_Result;

   function Has_Convention_Pragma (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 279 = 8 slots + 23 fields in slot.

      Off : constant := 279;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Convention_Pragma;

   procedure Set_Has_Convention_Pragma (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 279 = 8 slots + 23 fields in slot.

      Off : constant := 279;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Convention_Pragma;

   function Has_Default_Aspect (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 280 = 8 slots + 24 fields in slot.

      Off : constant := 280;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Default_Aspect;

   procedure Set_Has_Default_Aspect (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 280 = 8 slots + 24 fields in slot.

      Off : constant := 280;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Default_Aspect;

   function Has_Delayed_Aspects (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 281 = 8 slots + 25 fields in slot.

      Off : constant := 281;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Delayed_Aspects;

   procedure Set_Has_Delayed_Aspects (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 281 = 8 slots + 25 fields in slot.

      Off : constant := 281;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Delayed_Aspects;

   function Has_Delayed_Freeze (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 282 = 8 slots + 26 fields in slot.

      Off : constant := 282;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Delayed_Freeze;

   procedure Set_Has_Delayed_Freeze (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 282 = 8 slots + 26 fields in slot.

      Off : constant := 282;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Delayed_Freeze;

   function Has_Delayed_Rep_Aspects (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 283 = 8 slots + 27 fields in slot.

      Off : constant := 283;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Delayed_Rep_Aspects;

   procedure Set_Has_Delayed_Rep_Aspects (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 283 = 8 slots + 27 fields in slot.

      Off : constant := 283;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Delayed_Rep_Aspects;

   function Has_Discriminants (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 933 = 29 slots + 5 fields in slot.

      Off : constant := 933;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Discriminants;

   procedure Set_Has_Discriminants (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 933 = 29 slots + 5 fields in slot.

      Off : constant := 933;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Discriminants;

   function Has_Dispatch_Table (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 934 = 29 slots + 6 fields in slot.

      Off : constant := 934;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Tagged_Type (N));
      return Val;
   end Has_Dispatch_Table;

   procedure Set_Has_Dispatch_Table (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 934 = 29 slots + 6 fields in slot.

      Off : constant := 934;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Tagged_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Dispatch_Table;

   function Has_Dynamic_Predicate_Aspect (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 935 = 29 slots + 7 fields in slot.

      Off : constant := 935;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Dynamic_Predicate_Aspect;

   procedure Set_Has_Dynamic_Predicate_Aspect (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 935 = 29 slots + 7 fields in slot.

      Off : constant := 935;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Dynamic_Predicate_Aspect;

   function Has_Enumeration_Rep_Clause (N : Enumeration_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Enumeration_Rep_Clause;

   procedure Set_Has_Enumeration_Rep_Clause (N : Enumeration_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Enumeration_Rep_Clause;

   function Has_Exit (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 284 = 8 slots + 28 fields in slot.

      Off : constant := 284;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Exit;

   procedure Set_Has_Exit (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 284 = 8 slots + 28 fields in slot.

      Off : constant := 284;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Exit;

   function Has_Expanded_Contract (N : Subprogram_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 741 = 23 slots + 5 fields in slot.

      Off : constant := 741;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Expanded_Contract;

   procedure Set_Has_Expanded_Contract (N : Subprogram_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 741 = 23 slots + 5 fields in slot.

      Off : constant := 741;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Expanded_Contract;

   function Has_First_Controlling_Parameter_Aspect (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 936 = 29 slots + 8 fields in slot.

      Off : constant := 936;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Tagged_Type (N) or else Is_Concurrent_Type (N) or else Is_Concurrent_Record_Type (N));
      return Val;
   end Has_First_Controlling_Parameter_Aspect;

   procedure Set_Has_First_Controlling_Parameter_Aspect (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 936 = 29 slots + 8 fields in slot.

      Off : constant := 936;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Tagged_Type (N) or else Is_Concurrent_Type (N) or else Is_Concurrent_Record_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_First_Controlling_Parameter_Aspect;

   function Has_Forward_Instantiation (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 285 = 8 slots + 29 fields in slot.

      Off : constant := 285;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Forward_Instantiation;

   procedure Set_Has_Forward_Instantiation (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 285 = 8 slots + 29 fields in slot.

      Off : constant := 285;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Forward_Instantiation;

   function Has_Fully_Qualified_Name (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 286 = 8 slots + 30 fields in slot.

      Off : constant := 286;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Fully_Qualified_Name;

   procedure Set_Has_Fully_Qualified_Name (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 286 = 8 slots + 30 fields in slot.

      Off : constant := 286;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Fully_Qualified_Name;

   function Has_Ghost_Predicate_Aspect (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 937 = 29 slots + 9 fields in slot.

      Off : constant := 937;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Ghost_Predicate_Aspect;

   procedure Set_Has_Ghost_Predicate_Aspect (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 937 = 29 slots + 9 fields in slot.

      Off : constant := 937;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Ghost_Predicate_Aspect;

   function Has_Gigi_Rep_Item (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 287 = 8 slots + 31 fields in slot.

      Off : constant := 287;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Gigi_Rep_Item;

   procedure Set_Has_Gigi_Rep_Item (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 287 = 8 slots + 31 fields in slot.

      Off : constant := 287;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Gigi_Rep_Item;

   function Has_Homonym (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 384 = 12 slots + 0 fields in slot.

      Off : constant := 384;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Homonym;

   procedure Set_Has_Homonym (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 384 = 12 slots + 0 fields in slot.

      Off : constant := 384;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Homonym;

   function Has_Implicit_Dereference (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 385 = 12 slots + 1 fields in slot.

      Off : constant := 385;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Implicit_Dereference;

   procedure Set_Has_Implicit_Dereference (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 385 = 12 slots + 1 fields in slot.

      Off : constant := 385;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Implicit_Dereference;

   function Has_Independent_Components (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 386 = 12 slots + 2 fields in slot.

      Off : constant := 386;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Independent_Components;

   procedure Set_Has_Independent_Components (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 386 = 12 slots + 2 fields in slot.

      Off : constant := 386;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Independent_Components;

   function Has_Inheritable_Invariants (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 938 = 29 slots + 10 fields in slot.

      Off : constant := 938;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Inheritable_Invariants;

   procedure Set_Has_Inheritable_Invariants (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 938 = 29 slots + 10 fields in slot.

      Off : constant := 938;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Inheritable_Invariants;

   function Has_Inherited_DIC (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 939 = 29 slots + 11 fields in slot.

      Off : constant := 939;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Inherited_DIC;

   procedure Set_Has_Inherited_DIC (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 939 = 29 slots + 11 fields in slot.

      Off : constant := 939;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Inherited_DIC;

   function Has_Inherited_Invariants (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 940 = 29 slots + 12 fields in slot.

      Off : constant := 940;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Inherited_Invariants;

   procedure Set_Has_Inherited_Invariants (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 940 = 29 slots + 12 fields in slot.

      Off : constant := 940;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Inherited_Invariants;

   function Has_Initial_Value (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Initial_Value;

   procedure Set_Has_Initial_Value (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Initial_Value;

   function Has_Loop_Entry_Attributes (N : E_Loop_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Loop_Entry_Attributes;

   procedure Set_Has_Loop_Entry_Attributes (N : E_Loop_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Loop_Entry_Attributes;

   function Has_Machine_Radix_Clause (N : Decimal_Fixed_Point_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Machine_Radix_Clause;

   procedure Set_Has_Machine_Radix_Clause (N : Decimal_Fixed_Point_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Machine_Radix_Clause;

   function Has_Master_Entity (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 387 = 12 slots + 3 fields in slot.

      Off : constant := 387;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Master_Entity;

   procedure Set_Has_Master_Entity (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 387 = 12 slots + 3 fields in slot.

      Off : constant := 387;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Master_Entity;

   function Has_Missing_Return (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Missing_Return;

   procedure Set_Has_Missing_Return (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Missing_Return;

   function Has_Nested_Block_With_Handler (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 388 = 12 slots + 4 fields in slot.

      Off : constant := 388;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Nested_Block_With_Handler;

   procedure Set_Has_Nested_Block_With_Handler (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 388 = 12 slots + 4 fields in slot.

      Off : constant := 388;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Nested_Block_With_Handler;

   function Has_Nested_Subprogram (N : Subprogram_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 742 = 23 slots + 6 fields in slot.

      Off : constant := 742;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Nested_Subprogram;

   procedure Set_Has_Nested_Subprogram (N : Subprogram_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 742 = 23 slots + 6 fields in slot.

      Off : constant := 742;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Nested_Subprogram;

   function Has_Non_Standard_Rep (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 389 = 12 slots + 5 fields in slot.

      Off : constant := 389;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Non_Standard_Rep;

   procedure Set_Has_Non_Standard_Rep (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 389 = 12 slots + 5 fields in slot.

      Off : constant := 389;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Non_Standard_Rep;

   function Has_Object_Size_Clause (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 941 = 29 slots + 13 fields in slot.

      Off : constant := 941;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Object_Size_Clause;

   procedure Set_Has_Object_Size_Clause (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 941 = 29 slots + 13 fields in slot.

      Off : constant := 941;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Object_Size_Clause;

   function Has_Out_Or_In_Out_Parameter (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 738 = 23 slots + 2 fields in slot.

      Off : constant := 738;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Out_Or_In_Out_Parameter;

   procedure Set_Has_Out_Or_In_Out_Parameter (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 738 = 23 slots + 2 fields in slot.

      Off : constant := 738;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Out_Or_In_Out_Parameter;

   function Has_Own_DIC (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 942 = 29 slots + 14 fields in slot.

      Off : constant := 942;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Own_DIC;

   procedure Set_Has_Own_DIC (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 942 = 29 slots + 14 fields in slot.

      Off : constant := 942;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Own_DIC;

   function Has_Own_Invariants (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 943 = 29 slots + 15 fields in slot.

      Off : constant := 943;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Own_Invariants;

   procedure Set_Has_Own_Invariants (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 943 = 29 slots + 15 fields in slot.

      Off : constant := 943;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Own_Invariants;

   function Has_Partial_Visible_Refinement (N : E_Abstract_State_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Partial_Visible_Refinement;

   procedure Set_Has_Partial_Visible_Refinement (N : E_Abstract_State_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Partial_Visible_Refinement;

   function Has_Per_Object_Constraint (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 390 = 12 slots + 6 fields in slot.

      Off : constant := 390;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Per_Object_Constraint;

   procedure Set_Has_Per_Object_Constraint (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 390 = 12 slots + 6 fields in slot.

      Off : constant := 390;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Per_Object_Constraint;

   function Has_Pragma_Controlled (N : Access_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Controlled;

   procedure Set_Has_Pragma_Controlled (N : Access_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Controlled;

   function Has_Pragma_Elaborate_Body (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 391 = 12 slots + 7 fields in slot.

      Off : constant := 391;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Elaborate_Body;

   procedure Set_Has_Pragma_Elaborate_Body (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 391 = 12 slots + 7 fields in slot.

      Off : constant := 391;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Elaborate_Body;

   function Has_Pragma_Inline (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 392 = 12 slots + 8 fields in slot.

      Off : constant := 392;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Inline;

   procedure Set_Has_Pragma_Inline (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 392 = 12 slots + 8 fields in slot.

      Off : constant := 392;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Inline;

   function Has_Pragma_Inline_Always (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 393 = 12 slots + 9 fields in slot.

      Off : constant := 393;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Inline_Always;

   procedure Set_Has_Pragma_Inline_Always (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 393 = 12 slots + 9 fields in slot.

      Off : constant := 393;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Inline_Always;

   function Has_Pragma_No_Inline (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 394 = 12 slots + 10 fields in slot.

      Off : constant := 394;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_No_Inline;

   procedure Set_Has_Pragma_No_Inline (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 394 = 12 slots + 10 fields in slot.

      Off : constant := 394;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_No_Inline;

   function Has_Pragma_Ordered (N : Enumeration_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 975 = 30 slots + 15 fields in slot.

      Off : constant := 975;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Ordered;

   procedure Set_Has_Pragma_Ordered (N : Enumeration_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 975 = 30 slots + 15 fields in slot.

      Off : constant := 975;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Ordered;

   function Has_Pragma_Pack (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Pack;

   procedure Set_Has_Pragma_Pack (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Pack;

   function Has_Pragma_Preelab_Init (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 395 = 12 slots + 11 fields in slot.

      Off : constant := 395;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Preelab_Init;

   procedure Set_Has_Pragma_Preelab_Init (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 395 = 12 slots + 11 fields in slot.

      Off : constant := 395;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Preelab_Init;

   function Has_Pragma_Pure (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 396 = 12 slots + 12 fields in slot.

      Off : constant := 396;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Pure;

   procedure Set_Has_Pragma_Pure (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 396 = 12 slots + 12 fields in slot.

      Off : constant := 396;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Pure;

   function Has_Pragma_Pure_Function (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 397 = 12 slots + 13 fields in slot.

      Off : constant := 397;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Pure_Function;

   procedure Set_Has_Pragma_Pure_Function (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 397 = 12 slots + 13 fields in slot.

      Off : constant := 397;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Pure_Function;

   function Has_Pragma_Thread_Local_Storage (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 398 = 12 slots + 14 fields in slot.

      Off : constant := 398;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Thread_Local_Storage;

   procedure Set_Has_Pragma_Thread_Local_Storage (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 398 = 12 slots + 14 fields in slot.

      Off : constant := 398;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Thread_Local_Storage;

   function Has_Pragma_Unmodified (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 399 = 12 slots + 15 fields in slot.

      Off : constant := 399;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Unmodified;

   procedure Set_Has_Pragma_Unmodified (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 399 = 12 slots + 15 fields in slot.

      Off : constant := 399;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Unmodified;

   function Has_Pragma_Unreferenced (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 400 = 12 slots + 16 fields in slot.

      Off : constant := 400;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Unreferenced;

   procedure Set_Has_Pragma_Unreferenced (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 400 = 12 slots + 16 fields in slot.

      Off : constant := 400;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Unreferenced;

   function Has_Pragma_Unreferenced_Objects (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 944 = 29 slots + 16 fields in slot.

      Off : constant := 944;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Unreferenced_Objects;

   procedure Set_Has_Pragma_Unreferenced_Objects (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 944 = 29 slots + 16 fields in slot.

      Off : constant := 944;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Unreferenced_Objects;

   function Has_Pragma_Unused (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 401 = 12 slots + 17 fields in slot.

      Off : constant := 401;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Pragma_Unused;

   procedure Set_Has_Pragma_Unused (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 401 = 12 slots + 17 fields in slot.

      Off : constant := 401;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Pragma_Unused;

   function Has_Predicates (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Predicates;

   procedure Set_Has_Predicates (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Predicates;

   function Has_Primitive_Operations (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 945 = 29 slots + 17 fields in slot.

      Off : constant := 945;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Primitive_Operations;

   procedure Set_Has_Primitive_Operations (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 945 = 29 slots + 17 fields in slot.

      Off : constant := 945;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Primitive_Operations;

   function Has_Private_Ancestor (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 402 = 12 slots + 18 fields in slot.

      Off : constant := 402;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Private_Ancestor;

   procedure Set_Has_Private_Ancestor (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 402 = 12 slots + 18 fields in slot.

      Off : constant := 402;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Private_Ancestor;

   function Has_Private_Declaration (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 403 = 12 slots + 19 fields in slot.

      Off : constant := 403;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Private_Declaration;

   procedure Set_Has_Private_Declaration (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 403 = 12 slots + 19 fields in slot.

      Off : constant := 403;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Private_Declaration;

   function Has_Private_Extension (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 946 = 29 slots + 18 fields in slot.

      Off : constant := 946;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Tagged_Type (N));
      return Val;
   end Has_Private_Extension;

   procedure Set_Has_Private_Extension (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 946 = 29 slots + 18 fields in slot.

      Off : constant := 946;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Tagged_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Private_Extension;

   function Has_Protected (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 404 = 12 slots + 20 fields in slot.

      Off : constant := 404;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Protected;

   procedure Set_Has_Protected (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 404 = 12 slots + 20 fields in slot.

      Off : constant := 404;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Protected;

   function Has_Qualified_Name (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 405 = 12 slots + 21 fields in slot.

      Off : constant := 405;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Qualified_Name;

   procedure Set_Has_Qualified_Name (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 405 = 12 slots + 21 fields in slot.

      Off : constant := 405;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Qualified_Name;

   function Has_RACW (N : E_Package_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 960 = 30 slots + 0 fields in slot.

      Off : constant := 960;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_RACW;

   procedure Set_Has_RACW (N : E_Package_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 960 = 30 slots + 0 fields in slot.

      Off : constant := 960;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_RACW;

   function Has_Record_Rep_Clause (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 980 = 30 slots + 20 fields in slot.

      Off : constant := 980;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Record_Rep_Clause;

   procedure Set_Has_Record_Rep_Clause (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 980 = 30 slots + 20 fields in slot.

      Off : constant := 980;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Record_Rep_Clause;

   function Has_Recursive_Call (N : Subprogram_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 743 = 23 slots + 7 fields in slot.

      Off : constant := 743;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Recursive_Call;

   procedure Set_Has_Recursive_Call (N : Subprogram_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 743 = 23 slots + 7 fields in slot.

      Off : constant := 743;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Recursive_Call;

   function Has_Relaxed_Finalization (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 406 = 12 slots + 22 fields in slot.

      Off : constant := 406;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Relaxed_Finalization;

   procedure Set_Has_Relaxed_Finalization (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 406 = 12 slots + 22 fields in slot.

      Off : constant := 406;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Relaxed_Finalization;

   function Has_Shift_Operator (N : Integer_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Shift_Operator;

   procedure Set_Has_Shift_Operator (N : Integer_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Shift_Operator;

   function Has_Size_Clause (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 407 = 12 slots + 23 fields in slot.

      Off : constant := 407;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Size_Clause;

   procedure Set_Has_Size_Clause (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 407 = 12 slots + 23 fields in slot.

      Off : constant := 407;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Size_Clause;

   function Has_Small_Clause (N : Ordinary_Fixed_Point_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Small_Clause;

   procedure Set_Has_Small_Clause (N : Ordinary_Fixed_Point_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Small_Clause;

   function Has_Specified_Layout (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 947 = 29 slots + 19 fields in slot.

      Off : constant := 947;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Specified_Layout;

   procedure Set_Has_Specified_Layout (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 947 = 29 slots + 19 fields in slot.

      Off : constant := 947;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Specified_Layout;

   function Has_Specified_Stream_Input (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 948 = 29 slots + 20 fields in slot.

      Off : constant := 948;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Specified_Stream_Input;

   procedure Set_Has_Specified_Stream_Input (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 948 = 29 slots + 20 fields in slot.

      Off : constant := 948;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Specified_Stream_Input;

   function Has_Specified_Stream_Output (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 949 = 29 slots + 21 fields in slot.

      Off : constant := 949;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Specified_Stream_Output;

   procedure Set_Has_Specified_Stream_Output (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 949 = 29 slots + 21 fields in slot.

      Off : constant := 949;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Specified_Stream_Output;

   function Has_Specified_Stream_Read (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 950 = 29 slots + 22 fields in slot.

      Off : constant := 950;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Specified_Stream_Read;

   procedure Set_Has_Specified_Stream_Read (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 950 = 29 slots + 22 fields in slot.

      Off : constant := 950;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Specified_Stream_Read;

   function Has_Specified_Stream_Write (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 951 = 29 slots + 23 fields in slot.

      Off : constant := 951;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Specified_Stream_Write;

   procedure Set_Has_Specified_Stream_Write (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 951 = 29 slots + 23 fields in slot.

      Off : constant := 951;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Specified_Stream_Write;

   function Has_Static_Discriminants (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Static_Discriminants;

   procedure Set_Has_Static_Discriminants (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Static_Discriminants;

   function Has_Static_Predicate (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 952 = 29 slots + 24 fields in slot.

      Off : constant := 952;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Static_Predicate;

   procedure Set_Has_Static_Predicate (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 952 = 29 slots + 24 fields in slot.

      Off : constant := 952;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Static_Predicate;

   function Has_Static_Predicate_Aspect (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 953 = 29 slots + 25 fields in slot.

      Off : constant := 953;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Static_Predicate_Aspect;

   procedure Set_Has_Static_Predicate_Aspect (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 953 = 29 slots + 25 fields in slot.

      Off : constant := 953;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Static_Predicate_Aspect;

   function Has_Storage_Size_Clause (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 975 = 30 slots + 15 fields in slot.

      Off : constant := 975;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Storage_Size_Clause;

   procedure Set_Has_Storage_Size_Clause (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 975 = 30 slots + 15 fields in slot.

      Off : constant := 975;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Storage_Size_Clause;

   function Has_Stream_Size_Clause (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 408 = 12 slots + 24 fields in slot.

      Off : constant := 408;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Stream_Size_Clause;

   procedure Set_Has_Stream_Size_Clause (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 408 = 12 slots + 24 fields in slot.

      Off : constant := 408;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Stream_Size_Clause;

   function Has_Task (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 409 = 12 slots + 25 fields in slot.

      Off : constant := 409;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Task;

   procedure Set_Has_Task (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 409 = 12 slots + 25 fields in slot.

      Off : constant := 409;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Task;

   function Has_Timing_Event (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 410 = 12 slots + 26 fields in slot.

      Off : constant := 410;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Timing_Event;

   procedure Set_Has_Timing_Event (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 410 = 12 slots + 26 fields in slot.

      Off : constant := 410;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Timing_Event;

   function Has_Thunks (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 411 = 12 slots + 27 fields in slot.

      Off : constant := 411;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Thunks;

   procedure Set_Has_Thunks (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 411 = 12 slots + 27 fields in slot.

      Off : constant := 411;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Thunks;

   function Has_Unchecked_Union (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 412 = 12 slots + 28 fields in slot.

      Off : constant := 412;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Unchecked_Union;

   procedure Set_Has_Unchecked_Union (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 412 = 12 slots + 28 fields in slot.

      Off : constant := 412;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Unchecked_Union;

   function Has_Unknown_Discriminants (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 954 = 29 slots + 26 fields in slot.

      Off : constant := 954;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Unknown_Discriminants;

   procedure Set_Has_Unknown_Discriminants (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 954 = 29 slots + 26 fields in slot.

      Off : constant := 954;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Unknown_Discriminants;

   function Has_Visible_Refinement (N : E_Abstract_State_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Visible_Refinement;

   procedure Set_Has_Visible_Refinement (N : E_Abstract_State_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 538 = 16 slots + 26 fields in slot.

      Off : constant := 538;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Visible_Refinement;

   function Has_Volatile_Components (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 413 = 12 slots + 29 fields in slot.

      Off : constant := 413;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Volatile_Components;

   procedure Set_Has_Volatile_Components (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 413 = 12 slots + 29 fields in slot.

      Off : constant := 413;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Volatile_Components;

   function Has_Xref_Entry (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 414 = 12 slots + 30 fields in slot.

      Off : constant := 414;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Xref_Entry;

   procedure Set_Has_Xref_Entry (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 414 = 12 slots + 30 fields in slot.

      Off : constant := 414;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Xref_Entry;

   function Has_Yield_Aspect (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 415 = 12 slots + 31 fields in slot.

      Off : constant := 415;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Has_Yield_Aspect;

   procedure Set_Has_Yield_Aspect (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 415 = 12 slots + 31 fields in slot.

      Off : constant := 415;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Has_Yield_Aspect;

   function Hiding_Loop_Variable (N : E_Variable_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Hiding_Loop_Variable;

   procedure Set_Hiding_Loop_Variable (N : E_Variable_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Hiding_Loop_Variable;

   function Hidden_In_Formal_Instance (N : E_Package_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Hidden_In_Formal_Instance;

   procedure Set_Hidden_In_Formal_Instance (N : E_Package_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Hidden_In_Formal_Instance;

   function Homonym (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Homonym;

   procedure Set_Homonym (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 1 = 1 slots + 0 fields in slot.

      Off : constant := 1;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Homonym;

   function Ignored_Class_Postconditions (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Ignored_Class_Postconditions;

   procedure Set_Ignored_Class_Postconditions (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Ignored_Class_Postconditions;

   function Ignored_Class_Preconditions (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Ignored_Class_Preconditions;

   procedure Set_Ignored_Class_Preconditions (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Ignored_Class_Preconditions;

   function Ignore_SPARK_Mode_Pragmas (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Ignore_SPARK_Mode_Pragmas;

   procedure Set_Ignore_SPARK_Mode_Pragmas (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Ignore_SPARK_Mode_Pragmas;

   function Import_Pragma (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Import_Pragma;

   procedure Set_Import_Pragma (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Import_Pragma;

   function Incomplete_Actuals (N : E_Package_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Incomplete_Actuals;

   procedure Set_Incomplete_Actuals (N : E_Package_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 34 = 34 slots + 0 fields in slot.

      Off : constant := 34;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Incomplete_Actuals;

   function Indirect_Call_Wrapper (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Indirect_Call_Wrapper;

   procedure Set_Indirect_Call_Wrapper (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Indirect_Call_Wrapper;

   function In_Package_Body (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 416 = 13 slots + 0 fields in slot.

      Off : constant := 416;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end In_Package_Body;

   procedure Set_In_Package_Body (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 416 = 13 slots + 0 fields in slot.

      Off : constant := 416;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_In_Package_Body;

   function In_Private_Part (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 417 = 13 slots + 1 fields in slot.

      Off : constant := 417;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end In_Private_Part;

   procedure Set_In_Private_Part (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 417 = 13 slots + 1 fields in slot.

      Off : constant := 417;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_In_Private_Part;

   function In_Use (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 418 = 13 slots + 2 fields in slot.

      Off : constant := 418;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end In_Use;

   procedure Set_In_Use (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 418 = 13 slots + 2 fields in slot.

      Off : constant := 418;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_In_Use;

   function Initialization_Statements (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Initialization_Statements;

   procedure Set_Initialization_Statements (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Initialization_Statements;

   function Inner_Instances (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Inner_Instances;

   procedure Set_Inner_Instances (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Inner_Instances;

   function Interface_Alias (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Interface_Alias;

   procedure Set_Interface_Alias (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Interface_Alias;

   function Interface_Name (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 22 = 22 slots + 0 fields in slot.

      Off : constant := 22;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Interface_Name;

   procedure Set_Interface_Name (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 22 = 22 slots + 0 fields in slot.

      Off : constant := 22;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Interface_Name;

   function Interfaces (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Interfaces;

   procedure Set_Interfaces (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Interfaces;

   function Is_Abstract_Subprogram (N : Overloadable_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 736 = 23 slots + 0 fields in slot.

      Off : constant := 736;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Abstract_Subprogram;

   procedure Set_Is_Abstract_Subprogram (N : Overloadable_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 736 = 23 slots + 0 fields in slot.

      Off : constant := 736;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Abstract_Subprogram;

   function Is_Abstract_Type (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 955 = 29 slots + 27 fields in slot.

      Off : constant := 955;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Abstract_Type;

   procedure Set_Is_Abstract_Type (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 955 = 29 slots + 27 fields in slot.

      Off : constant := 955;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Abstract_Type;

   function Is_Access_Constant (N : Access_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Access_Constant;

   procedure Set_Is_Access_Constant (N : Access_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 974 = 30 slots + 14 fields in slot.

      Off : constant := 974;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Access_Constant;

   function Is_Activation_Record (N : E_In_Parameter_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Activation_Record;

   procedure Set_Is_Activation_Record (N : E_In_Parameter_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Activation_Record;

   function Is_Actual_Subtype (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 956 = 29 slots + 28 fields in slot.

      Off : constant := 956;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Actual_Subtype;

   procedure Set_Is_Actual_Subtype (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 956 = 29 slots + 28 fields in slot.

      Off : constant := 956;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Actual_Subtype;

   function Is_Ada_2005_Only (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 419 = 13 slots + 3 fields in slot.

      Off : constant := 419;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ada_2005_Only;

   procedure Set_Is_Ada_2005_Only (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 419 = 13 slots + 3 fields in slot.

      Off : constant := 419;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ada_2005_Only;

   function Is_Ada_2012_Only (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 420 = 13 slots + 4 fields in slot.

      Off : constant := 420;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ada_2012_Only;

   procedure Set_Is_Ada_2012_Only (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 420 = 13 slots + 4 fields in slot.

      Off : constant := 420;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ada_2012_Only;

   function Is_Ada_2022_Only (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 421 = 13 slots + 5 fields in slot.

      Off : constant := 421;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ada_2022_Only;

   procedure Set_Is_Ada_2022_Only (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 421 = 13 slots + 5 fields in slot.

      Off : constant := 421;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ada_2022_Only;

   function Is_Aliased (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 422 = 13 slots + 6 fields in slot.

      Off : constant := 422;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Aliased;

   procedure Set_Is_Aliased (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 422 = 13 slots + 6 fields in slot.

      Off : constant := 422;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Aliased;

   function Is_Asynchronous (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Asynchronous;

   procedure Set_Is_Asynchronous (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Asynchronous;

   function Is_Atomic (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 423 = 13 slots + 7 fields in slot.

      Off : constant := 423;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Atomic;

   procedure Set_Is_Atomic (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 423 = 13 slots + 7 fields in slot.

      Off : constant := 423;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Atomic;

   function Is_Bit_Packed_Array (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 424 = 13 slots + 8 fields in slot.

      Off : constant := 424;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Bit_Packed_Array;

   procedure Set_Is_Bit_Packed_Array (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 424 = 13 slots + 8 fields in slot.

      Off : constant := 424;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Bit_Packed_Array;

   function Is_Called (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 542 = 16 slots + 30 fields in slot.

      Off : constant := 542;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Called;

   procedure Set_Is_Called (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 542 = 16 slots + 30 fields in slot.

      Off : constant := 542;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Called;

   function Is_Character_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 425 = 13 slots + 9 fields in slot.

      Off : constant := 425;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Character_Type;

   procedure Set_Is_Character_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 425 = 13 slots + 9 fields in slot.

      Off : constant := 425;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Character_Type;

   function Is_Checked_Ghost_Entity (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 426 = 13 slots + 10 fields in slot.

      Off : constant := 426;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Checked_Ghost_Entity;

   procedure Set_Is_Checked_Ghost_Entity (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 426 = 13 slots + 10 fields in slot.

      Off : constant := 426;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Checked_Ghost_Entity;

   function Is_Child_Unit (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 427 = 13 slots + 11 fields in slot.

      Off : constant := 427;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Child_Unit;

   procedure Set_Is_Child_Unit (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 427 = 13 slots + 11 fields in slot.

      Off : constant := 427;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Child_Unit;

   function Is_Class_Wide_Equivalent_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 428 = 13 slots + 12 fields in slot.

      Off : constant := 428;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Class_Wide_Equivalent_Type;

   procedure Set_Is_Class_Wide_Equivalent_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 428 = 13 slots + 12 fields in slot.

      Off : constant := 428;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Class_Wide_Equivalent_Type;

   function Is_Class_Wide_Wrapper (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 429 = 13 slots + 13 fields in slot.

      Off : constant := 429;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Class_Wide_Wrapper;

   procedure Set_Is_Class_Wide_Wrapper (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 429 = 13 slots + 13 fields in slot.

      Off : constant := 429;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Class_Wide_Wrapper;

   function Is_Compilation_Unit (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 430 = 13 slots + 14 fields in slot.

      Off : constant := 430;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Compilation_Unit;

   procedure Set_Is_Compilation_Unit (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 430 = 13 slots + 14 fields in slot.

      Off : constant := 430;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Compilation_Unit;

   function Is_Completely_Hidden (N : E_Discriminant_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Completely_Hidden;

   procedure Set_Is_Completely_Hidden (N : E_Discriminant_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Completely_Hidden;

   function Is_Concurrent_Record_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 431 = 13 slots + 15 fields in slot.

      Off : constant := 431;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Concurrent_Record_Type;

   procedure Set_Is_Concurrent_Record_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 431 = 13 slots + 15 fields in slot.

      Off : constant := 431;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Concurrent_Record_Type;

   function Is_Constr_Array_Subt_With_Bounds (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 432 = 13 slots + 16 fields in slot.

      Off : constant := 432;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Constr_Array_Subt_With_Bounds;

   procedure Set_Is_Constr_Array_Subt_With_Bounds (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 432 = 13 slots + 16 fields in slot.

      Off : constant := 432;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Constr_Array_Subt_With_Bounds;

   function Is_Constr_Subt_For_U_Nominal (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 433 = 13 slots + 17 fields in slot.

      Off : constant := 433;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Constr_Subt_For_U_Nominal;

   procedure Set_Is_Constr_Subt_For_U_Nominal (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 433 = 13 slots + 17 fields in slot.

      Off : constant := 433;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Constr_Subt_For_U_Nominal;

   function Is_Constrained (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 434 = 13 slots + 18 fields in slot.

      Off : constant := 434;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Constrained;

   procedure Set_Is_Constrained (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 434 = 13 slots + 18 fields in slot.

      Off : constant := 434;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Constrained;

   function Is_Constructor (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 435 = 13 slots + 19 fields in slot.

      Off : constant := 435;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Constructor;

   procedure Set_Is_Constructor (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 435 = 13 slots + 19 fields in slot.

      Off : constant := 435;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Constructor;

   function Is_Controlled_Active (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 436 = 13 slots + 20 fields in slot.

      Off : constant := 436;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Controlled_Active;

   procedure Set_Is_Controlled_Active (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 436 = 13 slots + 20 fields in slot.

      Off : constant := 436;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Controlled_Active;

   function Is_Controlling_Formal (N : Formal_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Controlling_Formal;

   procedure Set_Is_Controlling_Formal (N : Formal_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Controlling_Formal;

   function Is_CPP_Class (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 437 = 13 slots + 21 fields in slot.

      Off : constant := 437;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_CPP_Class;

   procedure Set_Is_CPP_Class (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 437 = 13 slots + 21 fields in slot.

      Off : constant := 437;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_CPP_Class;

   function Is_CUDA_Kernel (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 745 = 23 slots + 9 fields in slot.

      Off : constant := 745;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_CUDA_Kernel;

   procedure Set_Is_CUDA_Kernel (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 745 = 23 slots + 9 fields in slot.

      Off : constant := 745;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_CUDA_Kernel;

   function Is_Descendant_Of_Address (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 438 = 13 slots + 22 fields in slot.

      Off : constant := 438;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Descendant_Of_Address;

   procedure Set_Is_Descendant_Of_Address (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 438 = 13 slots + 22 fields in slot.

      Off : constant := 438;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Descendant_Of_Address;

   function Is_DIC_Procedure (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 746 = 23 slots + 10 fields in slot.

      Off : constant := 746;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_DIC_Procedure;

   procedure Set_Is_DIC_Procedure (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 746 = 23 slots + 10 fields in slot.

      Off : constant := 746;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_DIC_Procedure;

   function Is_Discrim_SO_Function (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 439 = 13 slots + 23 fields in slot.

      Off : constant := 439;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Discrim_SO_Function;

   procedure Set_Is_Discrim_SO_Function (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 439 = 13 slots + 23 fields in slot.

      Off : constant := 439;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Discrim_SO_Function;

   function Is_Discriminant_Check_Function (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 440 = 13 slots + 24 fields in slot.

      Off : constant := 440;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Discriminant_Check_Function;

   procedure Set_Is_Discriminant_Check_Function (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 440 = 13 slots + 24 fields in slot.

      Off : constant := 440;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Discriminant_Check_Function;

   function Is_Dispatch_Table_Entity (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 441 = 13 slots + 25 fields in slot.

      Off : constant := 441;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Dispatch_Table_Entity;

   procedure Set_Is_Dispatch_Table_Entity (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 441 = 13 slots + 25 fields in slot.

      Off : constant := 441;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Dispatch_Table_Entity;

   function Is_Dispatch_Table_Wrapper (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 442 = 13 slots + 26 fields in slot.

      Off : constant := 442;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Dispatch_Table_Wrapper;

   procedure Set_Is_Dispatch_Table_Wrapper (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 442 = 13 slots + 26 fields in slot.

      Off : constant := 442;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Dispatch_Table_Wrapper;

   function Is_Dispatching_Operation (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 443 = 13 slots + 27 fields in slot.

      Off : constant := 443;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Dispatching_Operation;

   procedure Set_Is_Dispatching_Operation (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 443 = 13 slots + 27 fields in slot.

      Off : constant := 443;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Dispatching_Operation;

   function Is_Elaboration_Checks_OK_Id (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Elaboration_Checks_OK_Id;

   procedure Set_Is_Elaboration_Checks_OK_Id (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Elaboration_Checks_OK_Id;

   function Is_Elaboration_Warnings_OK_Id (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Elaboration_Warnings_OK_Id;

   procedure Set_Is_Elaboration_Warnings_OK_Id (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Elaboration_Warnings_OK_Id;

   function Is_Eliminated (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 444 = 13 slots + 28 fields in slot.

      Off : constant := 444;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Eliminated;

   procedure Set_Is_Eliminated (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 444 = 13 slots + 28 fields in slot.

      Off : constant := 444;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Eliminated;

   function Is_Entry_Formal (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 445 = 13 slots + 29 fields in slot.

      Off : constant := 445;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Entry_Formal;

   procedure Set_Is_Entry_Formal (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 445 = 13 slots + 29 fields in slot.

      Off : constant := 445;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Entry_Formal;

   function Is_Entry_Wrapper (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 446 = 13 slots + 30 fields in slot.

      Off : constant := 446;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Entry_Wrapper;

   procedure Set_Is_Entry_Wrapper (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 446 = 13 slots + 30 fields in slot.

      Off : constant := 446;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Entry_Wrapper;

   function Is_Exception_Handler (N : E_Block_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Exception_Handler;

   procedure Set_Is_Exception_Handler (N : E_Block_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Exception_Handler;

   function Is_Exported (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 447 = 13 slots + 31 fields in slot.

      Off : constant := 447;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Exported;

   procedure Set_Is_Exported (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 447 = 13 slots + 31 fields in slot.

      Off : constant := 447;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Exported;

   function Is_Finalized_Transient (N : Allocatable_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Finalized_Transient;

   procedure Set_Is_Finalized_Transient (N : Allocatable_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 539 = 16 slots + 27 fields in slot.

      Off : constant := 539;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Finalized_Transient;

   function Is_Finalizer (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 448 = 14 slots + 0 fields in slot.

      Off : constant := 448;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Finalizer;

   procedure Set_Is_Finalizer (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 448 = 14 slots + 0 fields in slot.

      Off : constant := 448;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Finalizer;

   function Is_First_Subtype (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 449 = 14 slots + 1 fields in slot.

      Off : constant := 449;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_First_Subtype;

   procedure Set_Is_First_Subtype (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 449 = 14 slots + 1 fields in slot.

      Off : constant := 449;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_First_Subtype;

   function Is_Fixed_Lower_Bound_Array_Subtype (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 957 = 29 slots + 29 fields in slot.

      Off : constant := 957;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Fixed_Lower_Bound_Array_Subtype;

   procedure Set_Is_Fixed_Lower_Bound_Array_Subtype (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 957 = 29 slots + 29 fields in slot.

      Off : constant := 957;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Fixed_Lower_Bound_Array_Subtype;

   function Is_Fixed_Lower_Bound_Index_Subtype (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 958 = 29 slots + 30 fields in slot.

      Off : constant := 958;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Fixed_Lower_Bound_Index_Subtype;

   procedure Set_Is_Fixed_Lower_Bound_Index_Subtype (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 958 = 29 slots + 30 fields in slot.

      Off : constant := 958;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Fixed_Lower_Bound_Index_Subtype;

   function Is_Formal_Subprogram (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 450 = 14 slots + 2 fields in slot.

      Off : constant := 450;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Formal_Subprogram;

   procedure Set_Is_Formal_Subprogram (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 450 = 14 slots + 2 fields in slot.

      Off : constant := 450;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Formal_Subprogram;

   function Is_Frozen (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 451 = 14 slots + 3 fields in slot.

      Off : constant := 451;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Frozen;

   procedure Set_Is_Frozen (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 451 = 14 slots + 3 fields in slot.

      Off : constant := 451;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Frozen;

   function Is_Generic_Actual_Subprogram (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 747 = 23 slots + 11 fields in slot.

      Off : constant := 747;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Generic_Actual_Subprogram;

   procedure Set_Is_Generic_Actual_Subprogram (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 747 = 23 slots + 11 fields in slot.

      Off : constant := 747;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Generic_Actual_Subprogram;

   function Is_Generic_Actual_Type (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 959 = 29 slots + 31 fields in slot.

      Off : constant := 959;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Generic_Actual_Type;

   procedure Set_Is_Generic_Actual_Type (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 959 = 29 slots + 31 fields in slot.

      Off : constant := 959;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Generic_Actual_Type;

   function Is_Generic_Instance (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Generic_Instance;

   procedure Set_Is_Generic_Instance (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 19 = 0 slots + 19 fields in slot.

      Off : constant := 19;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Generic_Instance;

   function Is_Generic_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 452 = 14 slots + 4 fields in slot.

      Off : constant := 452;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Generic_Type;

   procedure Set_Is_Generic_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 452 = 14 slots + 4 fields in slot.

      Off : constant := 452;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Generic_Type;

   function Is_Hidden (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 453 = 14 slots + 5 fields in slot.

      Off : constant := 453;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Hidden;

   procedure Set_Is_Hidden (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 453 = 14 slots + 5 fields in slot.

      Off : constant := 453;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Hidden;

   function Is_Hidden_Non_Overridden_Subpgm (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 454 = 14 slots + 6 fields in slot.

      Off : constant := 454;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Hidden_Non_Overridden_Subpgm;

   procedure Set_Is_Hidden_Non_Overridden_Subpgm (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 454 = 14 slots + 6 fields in slot.

      Off : constant := 454;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Hidden_Non_Overridden_Subpgm;

   function Is_Hidden_Open_Scope (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 455 = 14 slots + 7 fields in slot.

      Off : constant := 455;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Hidden_Open_Scope;

   procedure Set_Is_Hidden_Open_Scope (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 455 = 14 slots + 7 fields in slot.

      Off : constant := 455;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Hidden_Open_Scope;

   function Is_Ignored_For_Finalization (N : Allocatable_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ignored_For_Finalization;

   procedure Set_Is_Ignored_For_Finalization (N : Allocatable_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 540 = 16 slots + 28 fields in slot.

      Off : constant := 540;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ignored_For_Finalization;

   function Is_Ignored_Ghost_Entity (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 456 = 14 slots + 8 fields in slot.

      Off : constant := 456;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Ignored_Ghost_Entity;

   procedure Set_Is_Ignored_Ghost_Entity (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 456 = 14 slots + 8 fields in slot.

      Off : constant := 456;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Ignored_Ghost_Entity;

   function Is_Immediately_Visible (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Immediately_Visible;

   procedure Set_Is_Immediately_Visible (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 16 = 0 slots + 16 fields in slot.

      Off : constant := 16;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Immediately_Visible;

   function Is_Implementation_Defined (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 457 = 14 slots + 9 fields in slot.

      Off : constant := 457;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Implementation_Defined;

   procedure Set_Is_Implementation_Defined (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 457 = 14 slots + 9 fields in slot.

      Off : constant := 457;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Implementation_Defined;

   function Is_Implicit_Full_View (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 961 = 30 slots + 1 fields in slot.

      Off : constant := 961;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Implicit_Full_View;

   procedure Set_Is_Implicit_Full_View (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 961 = 30 slots + 1 fields in slot.

      Off : constant := 961;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Implicit_Full_View;

   function Is_Imported (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 458 = 14 slots + 10 fields in slot.

      Off : constant := 458;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Imported;

   procedure Set_Is_Imported (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 458 = 14 slots + 10 fields in slot.

      Off : constant := 458;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Imported;

   function Is_Independent (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 459 = 14 slots + 11 fields in slot.

      Off : constant := 459;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Independent;

   procedure Set_Is_Independent (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 459 = 14 slots + 11 fields in slot.

      Off : constant := 459;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Independent;

   function Is_Initial_Condition_Procedure (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 748 = 23 slots + 12 fields in slot.

      Off : constant := 748;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Initial_Condition_Procedure;

   procedure Set_Is_Initial_Condition_Procedure (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 748 = 23 slots + 12 fields in slot.

      Off : constant := 748;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Initial_Condition_Procedure;

   function Is_Inlined (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 460 = 14 slots + 12 fields in slot.

      Off : constant := 460;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Inlined;

   procedure Set_Is_Inlined (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 460 = 14 slots + 12 fields in slot.

      Off : constant := 460;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Inlined;

   function Is_Inlined_Always (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 749 = 23 slots + 13 fields in slot.

      Off : constant := 749;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Inlined_Always;

   procedure Set_Is_Inlined_Always (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 749 = 23 slots + 13 fields in slot.

      Off : constant := 749;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Inlined_Always;

   function Is_Instantiated (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 461 = 14 slots + 13 fields in slot.

      Off : constant := 461;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Instantiated;

   procedure Set_Is_Instantiated (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 461 = 14 slots + 13 fields in slot.

      Off : constant := 461;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Instantiated;

   function Is_Interface (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 462 = 14 slots + 14 fields in slot.

      Off : constant := 462;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Interface;

   procedure Set_Is_Interface (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 462 = 14 slots + 14 fields in slot.

      Off : constant := 462;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Interface;

   function Is_Internal (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 463 = 14 slots + 15 fields in slot.

      Off : constant := 463;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Internal;

   procedure Set_Is_Internal (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 463 = 14 slots + 15 fields in slot.

      Off : constant := 463;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Internal;

   function Is_Interrupt_Handler (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 464 = 14 slots + 16 fields in slot.

      Off : constant := 464;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Interrupt_Handler;

   procedure Set_Is_Interrupt_Handler (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 464 = 14 slots + 16 fields in slot.

      Off : constant := 464;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Interrupt_Handler;

   function Is_Intrinsic_Subprogram (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 465 = 14 slots + 17 fields in slot.

      Off : constant := 465;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Intrinsic_Subprogram;

   procedure Set_Is_Intrinsic_Subprogram (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 465 = 14 slots + 17 fields in slot.

      Off : constant := 465;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Intrinsic_Subprogram;

   function Is_Invariant_Procedure (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 750 = 23 slots + 14 fields in slot.

      Off : constant := 750;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Invariant_Procedure;

   procedure Set_Is_Invariant_Procedure (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 750 = 23 slots + 14 fields in slot.

      Off : constant := 750;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Invariant_Procedure;

   function Is_Itype (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 466 = 14 slots + 18 fields in slot.

      Off : constant := 466;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Itype;

   procedure Set_Is_Itype (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 466 = 14 slots + 18 fields in slot.

      Off : constant := 466;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Itype;

   function Is_Known_Non_Null (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 467 = 14 slots + 19 fields in slot.

      Off : constant := 467;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Known_Non_Null;

   procedure Set_Is_Known_Non_Null (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 467 = 14 slots + 19 fields in slot.

      Off : constant := 467;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Known_Non_Null;

   function Is_Known_Null (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 468 = 14 slots + 20 fields in slot.

      Off : constant := 468;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Known_Null;

   procedure Set_Is_Known_Null (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 468 = 14 slots + 20 fields in slot.

      Off : constant := 468;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Known_Null;

   function Is_Known_Valid (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 469 = 14 slots + 21 fields in slot.

      Off : constant := 469;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Known_Valid;

   procedure Set_Is_Known_Valid (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 469 = 14 slots + 21 fields in slot.

      Off : constant := 469;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Known_Valid;

   function Is_Limited_Composite (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 470 = 14 slots + 22 fields in slot.

      Off : constant := 470;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Limited_Composite;

   procedure Set_Is_Limited_Composite (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 470 = 14 slots + 22 fields in slot.

      Off : constant := 470;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Limited_Composite;

   function Is_Limited_Interface (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 471 = 14 slots + 23 fields in slot.

      Off : constant := 471;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Limited_Interface;

   procedure Set_Is_Limited_Interface (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 471 = 14 slots + 23 fields in slot.

      Off : constant := 471;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Limited_Interface;

   function Is_Limited_Record (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 472 = 14 slots + 24 fields in slot.

      Off : constant := 472;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Limited_Record;

   procedure Set_Is_Limited_Record (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 472 = 14 slots + 24 fields in slot.

      Off : constant := 472;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Limited_Record;

   function Is_Local_Anonymous_Access (N : Access_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Local_Anonymous_Access;

   procedure Set_Is_Local_Anonymous_Access (N : Access_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Local_Anonymous_Access;

   function Is_Loop_Parameter (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 473 = 14 slots + 25 fields in slot.

      Off : constant := 473;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Loop_Parameter;

   procedure Set_Is_Loop_Parameter (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 473 = 14 slots + 25 fields in slot.

      Off : constant := 473;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Loop_Parameter;

   function Is_Machine_Code_Subprogram (N : Subprogram_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 744 = 23 slots + 8 fields in slot.

      Off : constant := 744;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Machine_Code_Subprogram;

   procedure Set_Is_Machine_Code_Subprogram (N : Subprogram_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 744 = 23 slots + 8 fields in slot.

      Off : constant := 744;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Machine_Code_Subprogram;

   function Is_Mutably_Tagged_Type (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 962 = 30 slots + 2 fields in slot.

      Off : constant := 962;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Mutably_Tagged_Type;

   procedure Set_Is_Mutably_Tagged_Type (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 962 = 30 slots + 2 fields in slot.

      Off : constant := 962;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Mutably_Tagged_Type;

   function Is_Non_Static_Subtype (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 963 = 30 slots + 3 fields in slot.

      Off : constant := 963;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Non_Static_Subtype;

   procedure Set_Is_Non_Static_Subtype (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 963 = 30 slots + 3 fields in slot.

      Off : constant := 963;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Non_Static_Subtype;

   function Is_Null_Init_Proc (N : E_Procedure_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 755 = 23 slots + 19 fields in slot.

      Off : constant := 755;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Null_Init_Proc;

   procedure Set_Is_Null_Init_Proc (N : E_Procedure_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 755 = 23 slots + 19 fields in slot.

      Off : constant := 755;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Null_Init_Proc;

   function Is_Obsolescent (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 474 = 14 slots + 26 fields in slot.

      Off : constant := 474;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Obsolescent;

   procedure Set_Is_Obsolescent (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 474 = 14 slots + 26 fields in slot.

      Off : constant := 474;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Obsolescent;

   function Is_Only_Out_Parameter (N : Formal_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Only_Out_Parameter;

   procedure Set_Is_Only_Out_Parameter (N : Formal_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Only_Out_Parameter;

   function Is_Package_Body_Entity (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 475 = 14 slots + 27 fields in slot.

      Off : constant := 475;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Package_Body_Entity;

   procedure Set_Is_Package_Body_Entity (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 475 = 14 slots + 27 fields in slot.

      Off : constant := 475;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Package_Body_Entity;

   function Is_Packed (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 476 = 14 slots + 28 fields in slot.

      Off : constant := 476;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Packed;

   procedure Set_Is_Packed (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 476 = 14 slots + 28 fields in slot.

      Off : constant := 476;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Packed;

   function Is_Packed_Array_Impl_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 477 = 14 slots + 29 fields in slot.

      Off : constant := 477;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Packed_Array_Impl_Type;

   procedure Set_Is_Packed_Array_Impl_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 477 = 14 slots + 29 fields in slot.

      Off : constant := 477;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Packed_Array_Impl_Type;

   function Is_Not_Self_Hidden (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 478 = 14 slots + 30 fields in slot.

      Off : constant := 478;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Not_Self_Hidden;

   procedure Set_Is_Not_Self_Hidden (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 478 = 14 slots + 30 fields in slot.

      Off : constant := 478;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Not_Self_Hidden;

   function Is_Param_Block_Component_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Param_Block_Component_Type;

   procedure Set_Is_Param_Block_Component_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Param_Block_Component_Type;

   function Is_Partial_Invariant_Procedure (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 751 = 23 slots + 15 fields in slot.

      Off : constant := 751;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Partial_Invariant_Procedure;

   procedure Set_Is_Partial_Invariant_Procedure (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 751 = 23 slots + 15 fields in slot.

      Off : constant := 751;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Partial_Invariant_Procedure;

   function Is_Potentially_Use_Visible (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Potentially_Use_Visible;

   procedure Set_Is_Potentially_Use_Visible (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 18 = 0 slots + 18 fields in slot.

      Off : constant := 18;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Node_Offsets.Table (N).Slots (Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Potentially_Use_Visible;

   function Is_Predicate_Function (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 752 = 23 slots + 16 fields in slot.

      Off : constant := 752;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Predicate_Function;

   procedure Set_Is_Predicate_Function (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 752 = 23 slots + 16 fields in slot.

      Off : constant := 752;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Predicate_Function;

   function Is_Preelaborated (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 479 = 14 slots + 31 fields in slot.

      Off : constant := 479;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Preelaborated;

   procedure Set_Is_Preelaborated (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 479 = 14 slots + 31 fields in slot.

      Off : constant := 479;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Preelaborated;

   function Is_Primitive (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 541 = 16 slots + 29 fields in slot.

      Off : constant := 541;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Primitive;

   procedure Set_Is_Primitive (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 541 = 16 slots + 29 fields in slot.

      Off : constant := 541;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Primitive;

   function Is_Primitive_Wrapper (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 753 = 23 slots + 17 fields in slot.

      Off : constant := 753;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Primitive_Wrapper;

   procedure Set_Is_Primitive_Wrapper (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 753 = 23 slots + 17 fields in slot.

      Off : constant := 753;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Primitive_Wrapper;

   function Is_Private_Composite (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 964 = 30 slots + 4 fields in slot.

      Off : constant := 964;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Private_Composite;

   procedure Set_Is_Private_Composite (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 964 = 30 slots + 4 fields in slot.

      Off : constant := 964;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Private_Composite;

   function Is_Private_Descendant (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 480 = 15 slots + 0 fields in slot.

      Off : constant := 480;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Private_Descendant;

   procedure Set_Is_Private_Descendant (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 480 = 15 slots + 0 fields in slot.

      Off : constant := 480;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Private_Descendant;

   function Is_Private_Primitive (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 754 = 23 slots + 18 fields in slot.

      Off : constant := 754;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Private_Primitive;

   procedure Set_Is_Private_Primitive (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 754 = 23 slots + 18 fields in slot.

      Off : constant := 754;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Private_Primitive;

   function Is_Public (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 481 = 15 slots + 1 fields in slot.

      Off : constant := 481;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Public;

   procedure Set_Is_Public (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 481 = 15 slots + 1 fields in slot.

      Off : constant := 481;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Public;

   function Is_Pure (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 482 = 15 slots + 2 fields in slot.

      Off : constant := 482;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Pure;

   procedure Set_Is_Pure (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 482 = 15 slots + 2 fields in slot.

      Off : constant := 482;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Pure;

   function Is_Pure_Unit_Access_Type (N : Access_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 977 = 30 slots + 17 fields in slot.

      Off : constant := 977;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Pure_Unit_Access_Type;

   procedure Set_Is_Pure_Unit_Access_Type (N : Access_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 977 = 30 slots + 17 fields in slot.

      Off : constant := 977;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Pure_Unit_Access_Type;

   function Is_RACW_Stub_Type (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 965 = 30 slots + 5 fields in slot.

      Off : constant := 965;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_RACW_Stub_Type;

   procedure Set_Is_RACW_Stub_Type (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 965 = 30 slots + 5 fields in slot.

      Off : constant := 965;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_RACW_Stub_Type;

   function Is_Raised (N : E_Exception_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Raised;

   procedure Set_Is_Raised (N : E_Exception_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Raised;

   function Is_Remote_Call_Interface (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 483 = 15 slots + 3 fields in slot.

      Off : constant := 483;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Remote_Call_Interface;

   procedure Set_Is_Remote_Call_Interface (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 483 = 15 slots + 3 fields in slot.

      Off : constant := 483;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Remote_Call_Interface;

   function Is_Remote_Types (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 484 = 15 slots + 4 fields in slot.

      Off : constant := 484;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Remote_Types;

   procedure Set_Is_Remote_Types (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 484 = 15 slots + 4 fields in slot.

      Off : constant := 484;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Remote_Types;

   function Is_Renaming_Of_Object (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 485 = 15 slots + 5 fields in slot.

      Off : constant := 485;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Renaming_Of_Object;

   procedure Set_Is_Renaming_Of_Object (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 485 = 15 slots + 5 fields in slot.

      Off : constant := 485;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Renaming_Of_Object;

   function Is_Return_Object (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 486 = 15 slots + 6 fields in slot.

      Off : constant := 486;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Return_Object;

   procedure Set_Is_Return_Object (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 486 = 15 slots + 6 fields in slot.

      Off : constant := 486;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Return_Object;

   function Is_Safe_To_Reevaluate (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 487 = 15 slots + 7 fields in slot.

      Off : constant := 487;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Safe_To_Reevaluate;

   procedure Set_Is_Safe_To_Reevaluate (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 487 = 15 slots + 7 fields in slot.

      Off : constant := 487;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Safe_To_Reevaluate;

   function Is_Shared_Passive (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 488 = 15 slots + 8 fields in slot.

      Off : constant := 488;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Shared_Passive;

   procedure Set_Is_Shared_Passive (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 488 = 15 slots + 8 fields in slot.

      Off : constant := 488;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Shared_Passive;

   function Is_Static_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 489 = 15 slots + 9 fields in slot.

      Off : constant := 489;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Static_Type;

   procedure Set_Is_Static_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 489 = 15 slots + 9 fields in slot.

      Off : constant := 489;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Static_Type;

   function Is_Statically_Allocated (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 490 = 15 slots + 10 fields in slot.

      Off : constant := 490;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Statically_Allocated;

   procedure Set_Is_Statically_Allocated (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 490 = 15 slots + 10 fields in slot.

      Off : constant := 490;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Statically_Allocated;

   function Is_Tag (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 491 = 15 slots + 11 fields in slot.

      Off : constant := 491;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Tag;

   procedure Set_Is_Tag (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 491 = 15 slots + 11 fields in slot.

      Off : constant := 491;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Tag;

   function Is_Tagged_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 492 = 15 slots + 12 fields in slot.

      Off : constant := 492;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Tagged_Type;

   procedure Set_Is_Tagged_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 492 = 15 slots + 12 fields in slot.

      Off : constant := 492;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Tagged_Type;

   function Is_Thunk (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 493 = 15 slots + 13 fields in slot.

      Off : constant := 493;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Thunk;

   procedure Set_Is_Thunk (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 493 = 15 slots + 13 fields in slot.

      Off : constant := 493;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Thunk;

   function Is_Trivial_Subprogram (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 494 = 15 slots + 14 fields in slot.

      Off : constant := 494;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Trivial_Subprogram;

   procedure Set_Is_Trivial_Subprogram (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 494 = 15 slots + 14 fields in slot.

      Off : constant := 494;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Trivial_Subprogram;

   function Is_True_Constant (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 495 = 15 slots + 15 fields in slot.

      Off : constant := 495;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_True_Constant;

   procedure Set_Is_True_Constant (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 495 = 15 slots + 15 fields in slot.

      Off : constant := 495;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_True_Constant;

   function Is_Unchecked_Union (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 496 = 15 slots + 16 fields in slot.

      Off : constant := 496;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Unchecked_Union;

   procedure Set_Is_Unchecked_Union (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 496 = 15 slots + 16 fields in slot.

      Off : constant := 496;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Unchecked_Union;

   function Is_Underlying_Full_View (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 497 = 15 slots + 17 fields in slot.

      Off : constant := 497;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Underlying_Full_View;

   procedure Set_Is_Underlying_Full_View (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 497 = 15 slots + 17 fields in slot.

      Off : constant := 497;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Underlying_Full_View;

   function Is_Underlying_Record_View (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 498 = 15 slots + 18 fields in slot.

      Off : constant := 498;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Underlying_Record_View;

   procedure Set_Is_Underlying_Record_View (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 498 = 15 slots + 18 fields in slot.

      Off : constant := 498;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Underlying_Record_View;

   function Is_Unimplemented (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 499 = 15 slots + 19 fields in slot.

      Off : constant := 499;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Unimplemented;

   procedure Set_Is_Unimplemented (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 499 = 15 slots + 19 fields in slot.

      Off : constant := 499;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Unimplemented;

   function Is_Unsigned_Type (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 966 = 30 slots + 6 fields in slot.

      Off : constant := 966;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Unsigned_Type;

   procedure Set_Is_Unsigned_Type (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 966 = 30 slots + 6 fields in slot.

      Off : constant := 966;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Unsigned_Type;

   function Is_Uplevel_Referenced_Entity (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 500 = 15 slots + 20 fields in slot.

      Off : constant := 500;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Uplevel_Referenced_Entity;

   procedure Set_Is_Uplevel_Referenced_Entity (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 500 = 15 slots + 20 fields in slot.

      Off : constant := 500;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Uplevel_Referenced_Entity;

   function Is_Valued_Procedure (N : E_Procedure_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 756 = 23 slots + 20 fields in slot.

      Off : constant := 756;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Valued_Procedure;

   procedure Set_Is_Valued_Procedure (N : E_Procedure_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 756 = 23 slots + 20 fields in slot.

      Off : constant := 756;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Valued_Procedure;

   function Is_Visible_Formal (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 501 = 15 slots + 21 fields in slot.

      Off : constant := 501;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Visible_Formal;

   procedure Set_Is_Visible_Formal (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 501 = 15 slots + 21 fields in slot.

      Off : constant := 501;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Visible_Formal;

   function Is_Visible_Lib_Unit (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 502 = 15 slots + 22 fields in slot.

      Off : constant := 502;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Visible_Lib_Unit;

   procedure Set_Is_Visible_Lib_Unit (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 502 = 15 slots + 22 fields in slot.

      Off : constant := 502;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Visible_Lib_Unit;

   function Is_Volatile_Type (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 503 = 15 slots + 23 fields in slot.

      Off : constant := 503;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Volatile_Type;

   procedure Set_Is_Volatile_Type (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 503 = 15 slots + 23 fields in slot.

      Off : constant := 503;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Volatile_Type;

   function Is_Volatile_Object (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 504 = 15 slots + 24 fields in slot.

      Off : constant := 504;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Volatile_Object;

   procedure Set_Is_Volatile_Object (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 504 = 15 slots + 24 fields in slot.

      Off : constant := 504;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Volatile_Object;

   function Is_Volatile_Full_Access (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 505 = 15 slots + 25 fields in slot.

      Off : constant := 505;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Volatile_Full_Access;

   procedure Set_Is_Volatile_Full_Access (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 505 = 15 slots + 25 fields in slot.

      Off : constant := 505;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Volatile_Full_Access;

   function Is_Wrapper (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 506 = 15 slots + 26 fields in slot.

      Off : constant := 506;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Is_Wrapper;

   procedure Set_Is_Wrapper (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 506 = 15 slots + 26 fields in slot.

      Off : constant := 506;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Is_Wrapper;

   function Itype_Printed (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 967 = 30 slots + 7 fields in slot.

      Off : constant := 967;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Itype (N));
      return Val;
   end Itype_Printed;

   procedure Set_Itype_Printed (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 967 = 30 slots + 7 fields in slot.

      Off : constant := 967;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Itype (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Itype_Printed;

   function Kill_Elaboration_Checks (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 507 = 15 slots + 27 fields in slot.

      Off : constant := 507;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Kill_Elaboration_Checks;

   procedure Set_Kill_Elaboration_Checks (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 507 = 15 slots + 27 fields in slot.

      Off : constant := 507;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Kill_Elaboration_Checks;

   function Known_To_Have_Preelab_Init (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 968 = 30 slots + 8 fields in slot.

      Off : constant := 968;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Known_To_Have_Preelab_Init;

   procedure Set_Known_To_Have_Preelab_Init (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 968 = 30 slots + 8 fields in slot.

      Off : constant := 968;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Known_To_Have_Preelab_Init;

   function Last_Aggregate_Assignment (N : Constant_Or_Variable_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 39 = 39 slots + 0 fields in slot.

      Off : constant := 39;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Last_Aggregate_Assignment;

   procedure Set_Last_Aggregate_Assignment (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 39 = 39 slots + 0 fields in slot.

      Off : constant := 39;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Last_Aggregate_Assignment;

   function Last_Assignment (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Last_Assignment;

   procedure Set_Last_Assignment (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 33 = 33 slots + 0 fields in slot.

      Off : constant := 33;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Last_Assignment;

   function Last_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 27 = 27 slots + 0 fields in slot.

      Off : constant := 27;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Last_Entity;

   procedure Set_Last_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 27 = 27 slots + 0 fields in slot.

      Off : constant := 27;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Last_Entity;

   function Limited_View (N : E_Package_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Limited_View;

   procedure Set_Limited_View (N : E_Package_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Limited_View;

   function Linker_Section_Pragma (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Linker_Section_Pragma;

   procedure Set_Linker_Section_Pragma (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Linker_Section_Pragma;

   function Lit_Hash (N : Enumeration_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Root_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Lit_Hash;

   procedure Set_Lit_Hash (N : Enumeration_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Lit_Hash;

   function Lit_Indexes (N : Enumeration_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Lit_Indexes;

   procedure Set_Lit_Indexes (N : Enumeration_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Lit_Indexes;

   function Lit_Strings (N : Enumeration_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Lit_Strings;

   procedure Set_Lit_Strings (N : Enumeration_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Lit_Strings;

   function Low_Bound_Tested (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 508 = 15 slots + 28 fields in slot.

      Off : constant := 508;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Low_Bound_Tested;

   procedure Set_Low_Bound_Tested (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 508 = 15 slots + 28 fields in slot.

      Off : constant := 508;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Low_Bound_Tested;

   function LSP_Subprogram (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end LSP_Subprogram;

   procedure Set_LSP_Subprogram (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_LSP_Subprogram;

   function Machine_Radix_10 (N : Decimal_Fixed_Point_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Machine_Radix_10;

   procedure Set_Machine_Radix_10 (N : Decimal_Fixed_Point_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Machine_Radix_10;

   function Master_Id (N : Access_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Master_Id;

   procedure Set_Master_Id (N : Access_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Master_Id;

   function Materialize_Entity (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 509 = 15 slots + 29 fields in slot.

      Off : constant := 509;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Materialize_Entity;

   procedure Set_Materialize_Entity (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 509 = 15 slots + 29 fields in slot.

      Off : constant := 509;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Materialize_Entity;

   function May_Inherit_Delayed_Rep_Aspects (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 510 = 15 slots + 30 fields in slot.

      Off : constant := 510;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end May_Inherit_Delayed_Rep_Aspects;

   procedure Set_May_Inherit_Delayed_Rep_Aspects (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 510 = 15 slots + 30 fields in slot.

      Off : constant := 510;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_May_Inherit_Delayed_Rep_Aspects;

   function Mechanism (N : Entity_Id) return Mechanism_Type is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Mechanism_Type := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Mechanism;

   procedure Set_Mechanism (N : Entity_Id; Val : Mechanism_Type) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Mechanism;

   function Minimum_Accessibility (N : Formal_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Minimum_Accessibility;

   procedure Set_Minimum_Accessibility (N : Formal_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Minimum_Accessibility;

   function Modulus (N : Modular_Integer_Kind_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Modulus;

   procedure Set_Modulus (N : Modular_Integer_Kind_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Modulus;

   function Must_Be_On_Byte_Boundary (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 969 = 30 slots + 9 fields in slot.

      Off : constant := 969;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Must_Be_On_Byte_Boundary;

   procedure Set_Must_Be_On_Byte_Boundary (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 969 = 30 slots + 9 fields in slot.

      Off : constant := 969;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Must_Be_On_Byte_Boundary;

   function Must_Have_Preelab_Init (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 970 = 30 slots + 10 fields in slot.

      Off : constant := 970;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Must_Have_Preelab_Init;

   procedure Set_Must_Have_Preelab_Init (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 970 = 30 slots + 10 fields in slot.

      Off : constant := 970;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Must_Have_Preelab_Init;

   function Needs_Activation_Record (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 511 = 15 slots + 31 fields in slot.

      Off : constant := 511;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Needs_Activation_Record;

   procedure Set_Needs_Activation_Record (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 511 = 15 slots + 31 fields in slot.

      Off : constant := 511;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Needs_Activation_Record;

   function Needs_Debug_Info (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 512 = 16 slots + 0 fields in slot.

      Off : constant := 512;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Needs_Debug_Info;

   procedure Set_Needs_Debug_Info (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 512 = 16 slots + 0 fields in slot.

      Off : constant := 512;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Needs_Debug_Info;

   function Needs_No_Actuals (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 975 = 30 slots + 15 fields in slot.

      Off : constant := 975;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Needs_No_Actuals;

   procedure Set_Needs_No_Actuals (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 975 = 30 slots + 15 fields in slot.

      Off : constant := 975;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Needs_No_Actuals;

   function Never_Set_In_Source (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 513 = 16 slots + 1 fields in slot.

      Off : constant := 513;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Never_Set_In_Source;

   procedure Set_Never_Set_In_Source (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 513 = 16 slots + 1 fields in slot.

      Off : constant := 513;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Never_Set_In_Source;

   function Next_Inlined_Subprogram (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 40 = 40 slots + 0 fields in slot.

      Off : constant := 40;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Next_Inlined_Subprogram;

   procedure Set_Next_Inlined_Subprogram (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 40 = 40 slots + 0 fields in slot.

      Off : constant := 40;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Next_Inlined_Subprogram;

   function No_Dynamic_Predicate_On_Actual (N : Discrete_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Dynamic_Predicate_On_Actual;

   procedure Set_No_Dynamic_Predicate_On_Actual (N : Discrete_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Dynamic_Predicate_On_Actual;

   function No_Pool_Assigned (N : Access_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 978 = 30 slots + 18 fields in slot.

      Off : constant := 978;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Root_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Pool_Assigned;

   procedure Set_No_Pool_Assigned (N : Access_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 978 = 30 slots + 18 fields in slot.

      Off : constant := 978;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Pool_Assigned;

   function No_Predicate_On_Actual (N : Discrete_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Predicate_On_Actual;

   procedure Set_No_Predicate_On_Actual (N : Discrete_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Predicate_On_Actual;

   function No_Raise (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 739 = 23 slots + 3 fields in slot.

      Off : constant := 739;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Raise;

   procedure Set_No_Raise (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 739 = 23 slots + 3 fields in slot.

      Off : constant := 739;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Raise;

   function No_Reordering (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 981 = 30 slots + 21 fields in slot.

      Off : constant := 981;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Reordering;

   procedure Set_No_Reordering (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 981 = 30 slots + 21 fields in slot.

      Off : constant := 981;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Reordering;

   function No_Return (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 740 = 23 slots + 4 fields in slot.

      Off : constant := 740;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Return;

   procedure Set_No_Return (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 740 = 23 slots + 4 fields in slot.

      Off : constant := 740;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Return;

   function No_Strict_Aliasing (N : Access_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 979 = 30 slots + 19 fields in slot.

      Off : constant := 979;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end No_Strict_Aliasing;

   procedure Set_No_Strict_Aliasing (N : Access_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 979 = 30 slots + 19 fields in slot.

      Off : constant := 979;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_No_Strict_Aliasing;

   function No_Tagged_Streams_Pragma (N : Type_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 39 = 39 slots + 0 fields in slot.

      Off : constant := 39;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Tagged_Type (N));
      return Val;
   end No_Tagged_Streams_Pragma;

   procedure Set_No_Tagged_Streams_Pragma (N : Type_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 39 = 39 slots + 0 fields in slot.

      Off : constant := 39;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Tagged_Type (N));
      S := Slot (Raw);
   end Set_No_Tagged_Streams_Pragma;

   function Non_Binary_Modulus (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 971 = 30 slots + 11 fields in slot.

      Off : constant := 971;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Non_Binary_Modulus;

   procedure Set_Non_Binary_Modulus (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 971 = 30 slots + 11 fields in slot.

      Off : constant := 971;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Non_Binary_Modulus;

   function Non_Limited_View (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Non_Limited_View;

   procedure Set_Non_Limited_View (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Non_Limited_View;

   function Nonzero_Is_True (N : Enumeration_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Root_Type (N) = Standard_Boolean);
      return Val;
   end Nonzero_Is_True;

   procedure Set_Nonzero_Is_True (N : Enumeration_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Root_Type (N) = Standard_Boolean);
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Nonzero_Is_True;

   function Normalized_First_Bit (N : Record_Field_Kind_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 26 = 26 slots + 0 fields in slot.

      Off : constant := 26;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Normalized_First_Bit;

   procedure Set_Normalized_First_Bit (N : Record_Field_Kind_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 26 = 26 slots + 0 fields in slot.

      Off : constant := 26;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Normalized_First_Bit;

   function Normalized_Position (N : Record_Field_Kind_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 27 = 27 slots + 0 fields in slot.

      Off : constant := 27;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Normalized_Position;

   procedure Set_Normalized_Position (N : Record_Field_Kind_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 27 = 27 slots + 0 fields in slot.

      Off : constant := 27;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Normalized_Position;

   function OK_To_Rename (N : E_Variable_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 961 = 30 slots + 1 fields in slot.

      Off : constant := 961;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end OK_To_Rename;

   procedure Set_OK_To_Rename (N : E_Variable_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 961 = 30 slots + 1 fields in slot.

      Off : constant := 961;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_OK_To_Rename;

   function Optimize_Alignment_Space (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 541 = 16 slots + 29 fields in slot.

      Off : constant := 541;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Optimize_Alignment_Space;

   procedure Set_Optimize_Alignment_Space (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 541 = 16 slots + 29 fields in slot.

      Off : constant := 541;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Optimize_Alignment_Space;

   function Optimize_Alignment_Time (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 542 = 16 slots + 30 fields in slot.

      Off : constant := 542;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Optimize_Alignment_Time;

   procedure Set_Optimize_Alignment_Time (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 542 = 16 slots + 30 fields in slot.

      Off : constant := 542;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Optimize_Alignment_Time;

   function Original_Access_Type (N : E_Access_Subprogram_Type_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Original_Access_Type;

   procedure Set_Original_Access_Type (N : E_Access_Subprogram_Type_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Original_Access_Type;

   function Original_Array_Type (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Original_Array_Type;

   procedure Set_Original_Array_Type (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Original_Array_Type;

   function Original_Protected_Subprogram (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 57 = 57 slots + 0 fields in slot.

      Off : constant := 57;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Original_Protected_Subprogram;

   procedure Set_Original_Protected_Subprogram (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 57 = 57 slots + 0 fields in slot.

      Off : constant := 57;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Original_Protected_Subprogram;

   function Original_Record_Component (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Original_Record_Component;

   procedure Set_Original_Record_Component (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Original_Record_Component;

   function Overlays_Constant (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 514 = 16 slots + 2 fields in slot.

      Off : constant := 514;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Overlays_Constant;

   procedure Set_Overlays_Constant (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 514 = 16 slots + 2 fields in slot.

      Off : constant := 514;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Overlays_Constant;

   function Overridden_Operation (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Overridden_Operation;

   procedure Set_Overridden_Operation (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Overridden_Operation;

   function Package_Instantiation (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Package_Instantiation;

   procedure Set_Package_Instantiation (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Package_Instantiation;

   function Packed_Array_Impl_Type (N : Array_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Packed_Array_Impl_Type;

   procedure Set_Packed_Array_Impl_Type (N : Array_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Packed_Array_Impl_Type;

   function Parent_Subtype (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Parent_Subtype;

   procedure Set_Parent_Subtype (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Parent_Subtype;

   function Part_Of_Constituents (N : Entity_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Part_Of_Constituents;

   procedure Set_Part_Of_Constituents (N : Entity_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Part_Of_Constituents;

   function Part_Of_References (N : E_Variable_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Part_Of_References;

   procedure Set_Part_Of_References (N : E_Variable_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Part_Of_References;

   function Partial_View_Has_Unknown_Discr (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 972 = 30 slots + 12 fields in slot.

      Off : constant := 972;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Partial_View_Has_Unknown_Discr;

   procedure Set_Partial_View_Has_Unknown_Discr (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 972 = 30 slots + 12 fields in slot.

      Off : constant := 972;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Partial_View_Has_Unknown_Discr;

   function Predicate_Expression (N : E_Function_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 61 = 61 slots + 0 fields in slot.

      Off : constant := 61;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Predicate_Expression;

   procedure Set_Predicate_Expression (N : E_Function_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 61 = 61 slots + 0 fields in slot.

      Off : constant := 61;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Predicate_Expression;

   function Prev_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 17 = 17 slots + 0 fields in slot.

      Off : constant := 17;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Prev_Entity;

   procedure Set_Prev_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 17 = 17 slots + 0 fields in slot.

      Off : constant := 17;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Prev_Entity;

   function Prival (N : E_Component_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Protected_Component (N));
      return Val;
   end Prival;

   procedure Set_Prival (N : E_Component_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Protected_Component (N));
      S := Slot (Raw);
   end Set_Prival;

   function Prival_Link (N : Constant_Or_Variable_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 40 = 40 slots + 0 fields in slot.

      Off : constant := 40;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Prival_Link;

   procedure Set_Prival_Link (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 40 = 40 slots + 0 fields in slot.

      Off : constant := 40;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Prival_Link;

   function Private_Dependents (N : Incomplete_Or_Private_Kind_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Private_Dependents;

   procedure Set_Private_Dependents (N : Incomplete_Or_Private_Kind_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 47 = 47 slots + 0 fields in slot.

      Off : constant := 47;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Private_Dependents;

   function Protected_Body_Subprogram (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Protected_Body_Subprogram;

   procedure Set_Protected_Body_Subprogram (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 29 = 29 slots + 0 fields in slot.

      Off : constant := 29;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Protected_Body_Subprogram;

   function Protected_Formal (N : Formal_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Protected_Formal;

   procedure Set_Protected_Formal (N : Formal_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 37 = 37 slots + 0 fields in slot.

      Off : constant := 37;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Protected_Formal;

   function Protected_Subprogram (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 58 = 58 slots + 0 fields in slot.

      Off : constant := 58;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Protected_Subprogram;

   procedure Set_Protected_Subprogram (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 58 = 58 slots + 0 fields in slot.

      Off : constant := 58;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Protected_Subprogram;

   function Protection_Object (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 53 = 53 slots + 0 fields in slot.

      Off : constant := 53;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Protection_Object;

   procedure Set_Protection_Object (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 53 = 53 slots + 0 fields in slot.

      Off : constant := 53;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Protection_Object;

   function Reachable (N : E_Label_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Reachable;

   procedure Set_Reachable (N : E_Label_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Reachable;

   function Receiving_Entry (N : E_Procedure_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Receiving_Entry;

   procedure Set_Receiving_Entry (N : E_Procedure_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Receiving_Entry;

   function Referenced (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 515 = 16 slots + 3 fields in slot.

      Off : constant := 515;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Referenced;

   procedure Set_Referenced (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 515 = 16 slots + 3 fields in slot.

      Off : constant := 515;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Referenced;

   function Referenced_As_LHS (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 516 = 16 slots + 4 fields in slot.

      Off : constant := 516;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Referenced_As_LHS;

   procedure Set_Referenced_As_LHS (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 516 = 16 slots + 4 fields in slot.

      Off : constant := 516;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Referenced_As_LHS;

   function Referenced_As_Out_Parameter (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 517 = 16 slots + 5 fields in slot.

      Off : constant := 517;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Referenced_As_Out_Parameter;

   procedure Set_Referenced_As_Out_Parameter (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 517 = 16 slots + 5 fields in slot.

      Off : constant := 517;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Referenced_As_Out_Parameter;

   function Refinement_Constituents (N : E_Abstract_State_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Refinement_Constituents;

   procedure Set_Refinement_Constituents (N : E_Abstract_State_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Refinement_Constituents;

   function Register_Exception_Call (N : E_Exception_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Register_Exception_Call;

   procedure Set_Register_Exception_Call (N : E_Exception_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 20 = 20 slots + 0 fields in slot.

      Off : constant := 20;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Register_Exception_Call;

   function Related_Array_Object (N : Array_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Related_Array_Object;

   procedure Set_Related_Array_Object (N : Array_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Related_Array_Object;

   function Related_Expression (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Related_Expression;

   procedure Set_Related_Expression (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 32 = 32 slots + 0 fields in slot.

      Off : constant := 32;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Related_Expression;

   function Related_Instance (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Related_Instance;

   procedure Set_Related_Instance (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Related_Instance;

   function Related_Type (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Related_Type;

   procedure Set_Related_Type (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 31 = 31 slots + 0 fields in slot.

      Off : constant := 31;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Related_Type;

   function Relative_Deadline_Variable (N : Task_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Relative_Deadline_Variable;

   procedure Set_Relative_Deadline_Variable (N : Task_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 48 = 48 slots + 0 fields in slot.

      Off : constant := 48;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Relative_Deadline_Variable;

   function Renamed_In_Spec (N : E_Package_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 961 = 30 slots + 1 fields in slot.

      Off : constant := 961;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Renamed_In_Spec;

   procedure Set_Renamed_In_Spec (N : E_Package_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 961 = 30 slots + 1 fields in slot.

      Off : constant := 961;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Renamed_In_Spec;

   function Renamed_Or_Alias (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 18 = 18 slots + 0 fields in slot.

      Off : constant := 18;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Renamed_Or_Alias;

   procedure Set_Renamed_Or_Alias (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 18 = 18 slots + 0 fields in slot.

      Off : constant := 18;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Renamed_Or_Alias;

   function Renames_Limited_View (N : E_Package_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 962 = 30 slots + 2 fields in slot.

      Off : constant := 962;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Renames_Limited_View;

   procedure Set_Renames_Limited_View (N : E_Package_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 962 = 30 slots + 2 fields in slot.

      Off : constant := 962;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Renames_Limited_View;

   function Requires_Overriding (N : Overloadable_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 737 = 23 slots + 1 fields in slot.

      Off : constant := 737;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Requires_Overriding;

   procedure Set_Requires_Overriding (N : Overloadable_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 737 = 23 slots + 1 fields in slot.

      Off : constant := 737;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Requires_Overriding;

   function Return_Applies_To (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Return_Applies_To;

   procedure Set_Return_Applies_To (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Return_Applies_To;

   function Return_Present (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 518 = 16 slots + 6 fields in slot.

      Off : constant := 518;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Return_Present;

   procedure Set_Return_Present (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 518 = 16 slots + 6 fields in slot.

      Off : constant := 518;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Return_Present;

   function Return_Statement (N : Constant_Or_Variable_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Return_Statement;

   procedure Set_Return_Statement (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Return_Statement;

   function Returns_By_Ref (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 519 = 16 slots + 7 fields in slot.

      Off : constant := 519;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Returns_By_Ref;

   procedure Set_Returns_By_Ref (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 519 = 16 slots + 7 fields in slot.

      Off : constant := 519;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Returns_By_Ref;

   function Reverse_Bit_Order (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 982 = 30 slots + 22 fields in slot.

      Off : constant := 982;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Reverse_Bit_Order;

   procedure Set_Reverse_Bit_Order (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 982 = 30 slots + 22 fields in slot.

      Off : constant := 982;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Reverse_Bit_Order;

   function Reverse_Storage_Order (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Reverse_Storage_Order;

   procedure Set_Reverse_Storage_Order (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 543 = 16 slots + 31 fields in slot.

      Off : constant := 543;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Reverse_Storage_Order;

   function RM_Size (N : Entity_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end RM_Size;

   procedure Set_RM_Size (N : Entity_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_RM_Size;

   function Scalar_Range (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Scalar_Range;

   procedure Set_Scalar_Range (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 45 = 45 slots + 0 fields in slot.

      Off : constant := 45;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Scalar_Range;

   function Scale_Value (N : Entity_Id) return Uint is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 57 = 57 slots + 0 fields in slot.

      Off : constant := 57;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Uint :=
        (if Raw = 0 then No_Uint else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Scale_Value;

   procedure Set_Scale_Value (N : Entity_Id; Val : Uint) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 57 = 57 slots + 0 fields in slot.

      Off : constant := 57;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Scale_Value;

   function Scope_Depth_Value (N : Entity_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Scope_Depth_Value;

   procedure Set_Scope_Depth_Value (N : Entity_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 36 = 36 slots + 0 fields in slot.

      Off : constant := 36;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Scope_Depth_Value;

   function Sec_Stack_Needed_For_Return (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 520 = 16 slots + 8 fields in slot.

      Off : constant := 520;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Sec_Stack_Needed_For_Return;

   procedure Set_Sec_Stack_Needed_For_Return (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 520 = 16 slots + 8 fields in slot.

      Off : constant := 520;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Sec_Stack_Needed_For_Return;

   function Shared_Var_Procs_Instance (N : E_Variable_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Shared_Var_Procs_Instance;

   procedure Set_Shared_Var_Procs_Instance (N : E_Variable_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Shared_Var_Procs_Instance;

   function Size_Check_Code (N : Constant_Or_Variable_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Size_Check_Code;

   procedure Set_Size_Check_Code (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Size_Check_Code;

   function Size_Depends_On_Discriminant (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 521 = 16 slots + 9 fields in slot.

      Off : constant := 521;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Size_Depends_On_Discriminant;

   procedure Set_Size_Depends_On_Discriminant (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 521 = 16 slots + 9 fields in slot.

      Off : constant := 521;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Size_Depends_On_Discriminant;

   function Size_Known_At_Compile_Time (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 522 = 16 slots + 10 fields in slot.

      Off : constant := 522;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Size_Known_At_Compile_Time;

   procedure Set_Size_Known_At_Compile_Time (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 522 = 16 slots + 10 fields in slot.

      Off : constant := 522;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Size_Known_At_Compile_Time;

   function Small_Value (N : Fixed_Point_Kind_Id) return Ureal is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Ureal := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Small_Value;

   procedure Set_Small_Value (N : Fixed_Point_Kind_Id; Val : Ureal) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Small_Value;

   function SPARK_Aux_Pragma (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SPARK_Aux_Pragma;

   procedure Set_SPARK_Aux_Pragma (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 44 = 44 slots + 0 fields in slot.

      Off : constant := 44;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_SPARK_Aux_Pragma;

   function SPARK_Aux_Pragma_Inherited (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SPARK_Aux_Pragma_Inherited;

   procedure Set_SPARK_Aux_Pragma_Inherited (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_SPARK_Aux_Pragma_Inherited;

   function SPARK_Pragma (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SPARK_Pragma;

   procedure Set_SPARK_Pragma (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 24 = 24 slots + 0 fields in slot.

      Off : constant := 24;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_SPARK_Pragma;

   function SPARK_Pragma_Inherited (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SPARK_Pragma_Inherited;

   procedure Set_SPARK_Pragma_Inherited (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 536 = 16 slots + 24 fields in slot.

      Off : constant := 536;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_SPARK_Pragma_Inherited;

   function Spec_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 22 = 22 slots + 0 fields in slot.

      Off : constant := 22;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Spec_Entity;

   procedure Set_Spec_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 22 = 22 slots + 0 fields in slot.

      Off : constant := 22;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Spec_Entity;

   function SSO_Set_High_By_Default (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SSO_Set_High_By_Default;

   procedure Set_SSO_Set_High_By_Default (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 976 = 30 slots + 16 fields in slot.

      Off : constant := 976;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_SSO_Set_High_By_Default;

   function SSO_Set_Low_By_Default (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 977 = 30 slots + 17 fields in slot.

      Off : constant := 977;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end SSO_Set_Low_By_Default;

   procedure Set_SSO_Set_Low_By_Default (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 977 = 30 slots + 17 fields in slot.

      Off : constant := 977;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_SSO_Set_Low_By_Default;

   function Static_Call_Helper (N : Subprogram_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 51 = 51 slots + 0 fields in slot.

      Off : constant := 51;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Static_Call_Helper;

   procedure Set_Static_Call_Helper (N : Subprogram_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 51 = 51 slots + 0 fields in slot.

      Off : constant := 51;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Static_Call_Helper;

   function Static_Discrete_Predicate (N : Discrete_Kind_Id) return List_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant List_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Static_Discrete_Predicate;

   procedure Set_Static_Discrete_Predicate (N : Discrete_Kind_Id; Val : List_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 43 = 43 slots + 0 fields in slot.

      Off : constant := 43;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Static_Discrete_Predicate;

   function Static_Elaboration_Desired (N : E_Package_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 963 = 30 slots + 3 fields in slot.

      Off : constant := 963;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Static_Elaboration_Desired;

   procedure Set_Static_Elaboration_Desired (N : E_Package_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 963 = 30 slots + 3 fields in slot.

      Off : constant := 963;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Static_Elaboration_Desired;

   function Static_Initialization (N : E_Procedure_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (not Is_Dispatching_Operation (N));
      return Val;
   end Static_Initialization;

   procedure Set_Static_Initialization (N : E_Procedure_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 35 = 35 slots + 0 fields in slot.

      Off : constant := 35;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (not Is_Dispatching_Operation (N));
      S := Slot (Raw);
   end Set_Static_Initialization;

   function Static_Real_Or_String_Predicate (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Static_Real_Or_String_Predicate;

   procedure Set_Static_Real_Or_String_Predicate (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Static_Real_Or_String_Predicate;

   function Storage_Size_Variable (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Storage_Size_Variable;

   procedure Set_Storage_Size_Variable (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 42 = 42 slots + 0 fields in slot.

      Off : constant := 42;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := Slot (Raw);
   end Set_Storage_Size_Variable;

   function Stored_Constraint (N : Type_Kind_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 40 = 40 slots + 0 fields in slot.

      Off : constant := 40;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Stored_Constraint;

   procedure Set_Stored_Constraint (N : Type_Kind_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 40 = 40 slots + 0 fields in slot.

      Off : constant := 40;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Stored_Constraint;

   function Stores_Attribute_Old_Prefix (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 523 = 16 slots + 11 fields in slot.

      Off : constant := 523;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Stores_Attribute_Old_Prefix;

   procedure Set_Stores_Attribute_Old_Prefix (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 523 = 16 slots + 11 fields in slot.

      Off : constant := 523;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Stores_Attribute_Old_Prefix;

   function Strict_Alignment (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 524 = 16 slots + 12 fields in slot.

      Off : constant := 524;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Strict_Alignment;

   procedure Set_Strict_Alignment (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 524 = 16 slots + 12 fields in slot.

      Off : constant := 524;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Strict_Alignment;

   function String_Literal_Length (N : E_String_Literal_Subtype_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end String_Literal_Length;

   procedure Set_String_Literal_Length (N : E_String_Literal_Subtype_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_String_Literal_Length;

   function String_Literal_Low_Bound (N : E_String_Literal_Subtype_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end String_Literal_Low_Bound;

   procedure Set_String_Literal_Low_Bound (N : E_String_Literal_Subtype_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_String_Literal_Low_Bound;

   function Subprograms_For_Type (N : Type_Kind_Id) return Elist_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Elist_Id :=
        (if Raw = 0 then No_Elist else Cast (Raw));
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Subprograms_For_Type;

   procedure Set_Subprograms_For_Type (N : Type_Kind_Id; Val : Elist_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 41 = 41 slots + 0 fields in slot.

      Off : constant := 41;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Subprograms_For_Type;

   function Subps_Index (N : Subprogram_Kind_Id) return Unat is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 52 = 52 slots + 0 fields in slot.

      Off : constant := 52;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Unat := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Subps_Index;

   procedure Set_Subps_Index (N : Subprogram_Kind_Id; Val : Unat) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 52 = 52 slots + 0 fields in slot.

      Off : constant := 52;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Subps_Index;

   function Suppress_Elaboration_Warnings (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 525 = 16 slots + 13 fields in slot.

      Off : constant := 525;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Suppress_Elaboration_Warnings;

   procedure Set_Suppress_Elaboration_Warnings (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 525 = 16 slots + 13 fields in slot.

      Off : constant := 525;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Suppress_Elaboration_Warnings;

   function Suppress_Initialization (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 960 = 30 slots + 0 fields in slot.

      Off : constant := 960;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Suppress_Initialization;

   procedure Set_Suppress_Initialization (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 960 = 30 slots + 0 fields in slot.

      Off : constant := 960;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Suppress_Initialization;

   function Suppress_Style_Checks (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 526 = 16 slots + 14 fields in slot.

      Off : constant := 526;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Suppress_Style_Checks;

   procedure Set_Suppress_Style_Checks (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 526 = 16 slots + 14 fields in slot.

      Off : constant := 526;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Suppress_Style_Checks;

   function Suppress_Value_Tracking_On_Call (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 527 = 16 slots + 15 fields in slot.

      Off : constant := 527;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Suppress_Value_Tracking_On_Call;

   procedure Set_Suppress_Value_Tracking_On_Call (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 527 = 16 slots + 15 fields in slot.

      Off : constant := 527;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Suppress_Value_Tracking_On_Call;

   function Task_Body_Procedure (N : Task_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Task_Body_Procedure;

   procedure Set_Task_Body_Procedure (N : Task_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 49 = 49 slots + 0 fields in slot.

      Off : constant := 49;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Task_Body_Procedure;

   function Thunk_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 59 = 59 slots + 0 fields in slot.

      Off : constant := 59;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Thunk (N));
      return Val;
   end Thunk_Entity;

   procedure Set_Thunk_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 59 = 59 slots + 0 fields in slot.

      Off : constant := 59;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Thunk (N));
      S := Slot (Raw);
   end Set_Thunk_Entity;

   function Treat_As_Volatile (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 528 = 16 slots + 16 fields in slot.

      Off : constant := 528;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Treat_As_Volatile;

   procedure Set_Treat_As_Volatile (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 528 = 16 slots + 16 fields in slot.

      Off : constant := 528;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Treat_As_Volatile;

   function Underlying_Full_View (N : Private_Kind_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Underlying_Full_View;

   procedure Set_Underlying_Full_View (N : Private_Kind_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Underlying_Full_View;

   function Underlying_Record_View (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Underlying_Record_View;

   procedure Set_Underlying_Record_View (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 46 = 46 slots + 0 fields in slot.

      Off : constant := 46;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Underlying_Record_View;

   function Universal_Aliasing (N : Type_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 973 = 30 slots + 13 fields in slot.

      Off : constant := 973;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (Implementation_Base_Type (N)).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Universal_Aliasing;

   procedure Set_Universal_Aliasing (N : Type_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 973 = 30 slots + 13 fields in slot.

      Off : constant := 973;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Base_Type (N));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Universal_Aliasing;

   function Unset_Reference (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Unset_Reference;

   procedure Set_Unset_Reference (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 28 = 28 slots + 0 fields in slot.

      Off : constant := 28;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Unset_Reference;

   function Used_As_Generic_Actual (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 529 = 16 slots + 17 fields in slot.

      Off : constant := 529;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Used_As_Generic_Actual;

   procedure Set_Used_As_Generic_Actual (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 529 = 16 slots + 17 fields in slot.

      Off : constant := 529;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Used_As_Generic_Actual;

   function Uses_Lock_Free (N : Protected_Kind_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Uses_Lock_Free;

   procedure Set_Uses_Lock_Free (N : Protected_Kind_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 537 = 16 slots + 25 fields in slot.

      Off : constant := 537;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Uses_Lock_Free;

   function Uses_Sec_Stack (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 530 = 16 slots + 18 fields in slot.

      Off : constant := 530;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Uses_Sec_Stack;

   procedure Set_Uses_Sec_Stack (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 530 = 16 slots + 18 fields in slot.

      Off : constant := 530;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Uses_Sec_Stack;

   function Validated_Object (N : E_Variable_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Validated_Object;

   procedure Set_Validated_Object (N : E_Variable_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 50 = 50 slots + 0 fields in slot.

      Off : constant := 50;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Validated_Object;

   function Warnings_Off (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 531 = 16 slots + 19 fields in slot.

      Off : constant := 531;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Warnings_Off;

   procedure Set_Warnings_Off (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 531 = 16 slots + 19 fields in slot.

      Off : constant := 531;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Warnings_Off;

   function Warnings_Off_Used (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 532 = 16 slots + 20 fields in slot.

      Off : constant := 532;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Warnings_Off_Used;

   procedure Set_Warnings_Off_Used (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 532 = 16 slots + 20 fields in slot.

      Off : constant := 532;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Warnings_Off_Used;

   function Warnings_Off_Used_Unmodified (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 533 = 16 slots + 21 fields in slot.

      Off : constant := 533;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Warnings_Off_Used_Unmodified;

   procedure Set_Warnings_Off_Used_Unmodified (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 533 = 16 slots + 21 fields in slot.

      Off : constant := 533;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Warnings_Off_Used_Unmodified;

   function Warnings_Off_Used_Unreferenced (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 534 = 16 slots + 22 fields in slot.

      Off : constant := 534;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Warnings_Off_Used_Unreferenced;

   procedure Set_Warnings_Off_Used_Unreferenced (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 534 = 16 slots + 22 fields in slot.

      Off : constant := 534;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Warnings_Off_Used_Unreferenced;

   function Was_Hidden (N : Entity_Id) return Flag is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 535 = 16 slots + 23 fields in slot.

      Off : constant := 535;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit :=
        Field_Size_1_Bit (Shift_Right (S, V) and Mask);
      Val : constant Flag := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Was_Hidden;

   procedure Set_Was_Hidden (N : Entity_Id; Val : Flag := True) is
      --  32  1-bit fields per 32-bit slot.
      --  Offset 535 = 16 slots + 23 fields in slot.

      Off : constant := 535;
      F_Size : constant := 1;
      Mask : constant := 2**F_Size - 1;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      V : constant Natural := Natural ((Off mod F_Per_Slot) * F_Size);

      Raw : constant Field_Size_1_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := (S and not Shift_Left (Mask, V)) or Shift_Left (Slot (Raw), V);
   end Set_Was_Hidden;

   function Wrapped_Entity (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 60 = 60 slots + 0 fields in slot.

      Off : constant := 60;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      pragma Assert (Is_Primitive_Wrapper (N));
      return Val;
   end Wrapped_Entity;

   procedure Set_Wrapped_Entity (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 60 = 60 slots + 0 fields in slot.

      Off : constant := 60;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      pragma Assert (Is_Primitive_Wrapper (N));
      S := Slot (Raw);
   end Set_Wrapped_Entity;

   function Wrapped_Statements (N : Entity_Id) return Node_Id is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 54 = 54 slots + 0 fields in slot.

      Off : constant := 54;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit :=
        Field_Size_32_Bit (S);
      Val : constant Node_Id := Cast (Raw);
   begin
      --  pragma Debug (Validate_Node_And_Offset (NN, Slot_Off));
      return Val;
   end Wrapped_Statements;

   procedure Set_Wrapped_Statements (N : Entity_Id; Val : Node_Id) is
      --  1  32-bit fields per 32-bit slot.
      --  Offset 54 = 54 slots + 0 fields in slot.

      Off : constant := 54;
      F_Size : constant := 32;
      F_Per_Slot : constant Field_Offset := Slot_Size / F_Size;
      Slot_Off : constant Field_Offset := Off / F_Per_Slot;
      S : Slot renames Slots.Table (Node_Offsets.Table (N).Offset + Slot_Off);
      Raw : constant Field_Size_32_Bit := Cast (Val);
   begin
      --  pragma Debug (Validate_Node_And_Offset_Write (N, Slot_Off));
      S := Slot (Raw);
   end Set_Wrapped_Statements;

end Einfo.Entities;
