/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ldaptive.AbstractOperation;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AttributeModification;
import org.ldaptive.Connection;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.ext.MergeRequest;

public class MergeOperation
extends AbstractOperation<MergeRequest, Void> {
    public MergeOperation(Connection conn) {
        super(conn);
    }

    @Override
    protected Response<Void> invoke(MergeRequest request) throws LdapException {
        Response<Void> response;
        Response searchResponse;
        LdapEntry sourceEntry;
        block7: {
            sourceEntry = request.getEntry();
            searchResponse = null;
            try {
                SearchOperation search = new SearchOperation(this.getConnection());
                searchResponse = search.execute(SearchRequest.newObjectScopeSearchRequest(sourceEntry.getDn(), request.getSearchAttributes()));
            }
            catch (LdapException e) {
                if (e.getResultCode() == ResultCode.NO_SUCH_OBJECT) break block7;
                throw e;
            }
        }
        if (searchResponse != null && searchResponse.getResultCode() != ResultCode.SUCCESS && searchResponse.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            throw new LdapException(String.format("Error searching for entry: %s, response did not return success or no_such_object: %s", sourceEntry, searchResponse));
        }
        if (searchResponse == null || ((SearchResult)searchResponse.getResult()).size() == 0) {
            if (request.getDeleteEntry()) {
                this.logger.info("target entry does not exist, no delete performed for request {}", (Object)request);
                response = new Response<Object>(null, null);
            } else {
                response = this.add(request, sourceEntry);
            }
        } else {
            response = request.getDeleteEntry() ? this.delete(request, sourceEntry) : this.modify(request, sourceEntry, ((SearchResult)searchResponse.getResult()).getEntry());
        }
        return response;
    }

    protected Response<Void> modify(MergeRequest request, LdapEntry source, LdapEntry target) throws LdapException {
        AttributeModification[] modifications = LdapEntry.computeModifications(source, target);
        if (modifications != null && modifications.length > 0) {
            List<String> l;
            ArrayList<AttributeModification> resultModifications = new ArrayList<AttributeModification>(modifications.length);
            String[] includeAttrs = request.getIncludeAttributes();
            String[] excludeAttrs = request.getExcludeAttributes();
            if (includeAttrs != null && includeAttrs.length > 0) {
                l = Arrays.asList(includeAttrs);
                for (AttributeModification am : modifications) {
                    if (!l.contains(am.getAttribute().getName())) continue;
                    resultModifications.add(am);
                }
            } else if (excludeAttrs != null && excludeAttrs.length > 0) {
                l = Arrays.asList(excludeAttrs);
                for (AttributeModification am : modifications) {
                    if (l.contains(am.getAttribute().getName())) continue;
                    resultModifications.add(am);
                }
            } else {
                Collections.addAll(resultModifications, modifications);
            }
            if (!resultModifications.isEmpty()) {
                this.logger.info("modifying target entry {} with modifications {} from source entry {} for request {}", new Object[]{target, resultModifications, source, request});
                ModifyOperation modify = new ModifyOperation(this.getConnection());
                Response<Void> response = modify.execute(new ModifyRequest(target.getDn(), resultModifications.toArray(new AttributeModification[resultModifications.size()])));
                this.logger.info("modified target entry {} with modifications {} from source entry {} for request {}", new Object[]{target, resultModifications, source, request});
                return response;
            }
        }
        Response<Object> response = new Response<Object>(null, null);
        this.logger.info("target entry {} equals source entry {}, no modification performed for request {}", new Object[]{target, source, request});
        return response;
    }

    protected Response<Void> add(MergeRequest request, LdapEntry entry) throws LdapException {
        AddOperation add = new AddOperation(this.getConnection());
        Response<Void> response = add.execute(new AddRequest(entry.getDn(), entry.getAttributes()));
        this.logger.info("added entry {} for request {}", (Object)entry, (Object)request);
        return response;
    }

    protected Response<Void> delete(MergeRequest request, LdapEntry entry) throws LdapException {
        DeleteOperation delete = new DeleteOperation(this.getConnection());
        Response<Void> response = delete.execute(new DeleteRequest(entry.getDn()));
        this.logger.info("delete entry {} for request {}", (Object)entry, (Object)request);
        return response;
    }
}

