/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;

public class SerializedJwt {
    private final String token;
    private final String header;
    private final String payload;
    private final String signature;

    public SerializedJwt(String token) {
        token = token == null ? "" : token.trim();
        if (token.isEmpty()) {
            throw new ValidateException("Malformed JWT provided; expected three sections (header, payload, and signature)");
        }
        String[] splits = token.split("\\.");
        if (splits.length != 3) {
            throw new ValidateException("Malformed JWT provided; expected three sections (header, payload, and signature)");
        }
        this.token = token.trim();
        this.header = this.validateSection(splits[0]);
        this.payload = this.validateSection(splits[1]);
        this.signature = this.validateSection(splits[2]);
    }

    public String getToken() {
        return this.token;
    }

    public String getHeader() {
        return this.header;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    private String validateSection(String section) throws ValidateException {
        if ((section = section.trim()).isEmpty()) {
            throw new ValidateException("Malformed JWT provided; expected three sections (header, payload, and signature)");
        }
        return section;
    }
}

