/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.azure;

import java.util.Arrays;

public enum TokenCredentialType {
    MANAGED_IDENTITY("managed");

    private final String type;

    private TokenCredentialType(String type) {
        this.type = type;
    }

    public static String[] getTokenCredentialTypes() {
        return (String[])Arrays.stream(TokenCredentialType.values()).map(tokenCredentialType -> tokenCredentialType.type).toArray(String[]::new);
    }

    static TokenCredentialType valueOfType(String type) {
        for (TokenCredentialType value : TokenCredentialType.values()) {
            if (!value.type.equalsIgnoreCase(type) && !value.name().equalsIgnoreCase(type)) continue;
            return value;
        }
        throw new IllegalArgumentException("The token credential type '" + type + "' is unsupported, please use one of the following values: " + String.join((CharSequence)", ", TokenCredentialType.getTokenCredentialTypes()));
    }
}

