# frozen_string_literal: true

class CreateVulnerabilityArchivedRecords < Gitlab::Database::Migration[2.2]
  milestone '17.9'

  VULNERABILITY_ID_INDEX_NAME = 'index_vulnerability_archived_records_on_vulnerability_id'

  def change
    create_table :vulnerability_archived_records do |t| # rubocop:disable Migration/EnsureFactoryForTable -- false positive
      t.timestamps_with_timezone null: false

      t.bigint :project_id, null: false, index: true
      t.references :archive, null: false, foreign_key: { on_delete: :cascade, to_table: 'vulnerability_archives' }
      t.bigint :vulnerability_identifier, null: false, index: { name: VULNERABILITY_ID_INDEX_NAME, unique: true }
      t.jsonb :data, null: false, default: {}
    end
  end
end
