"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeAxesGeometriesSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var axis_utils_1 = require("../../utils/axis_utils");
var compute_axis_ticks_dimensions_1 = require("./compute_axis_ticks_dimensions");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var compute_series_domains_1 = require("./compute_series_domains");
var compute_small_multiple_scales_1 = require("./compute_small_multiple_scales");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var get_axis_styles_1 = require("./get_axis_styles");
var get_bar_paddings_1 = require("./get_bar_paddings");
var get_specs_1 = require("./get_specs");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
exports.computeAxesGeometriesSelector = create_selector_1.createCustomCachedSelector([
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_chart_theme_1.getChartThemeSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_specs_1.getAxisSpecsSelector,
    compute_axis_ticks_dimensions_1.computeAxisTicksDimensionsSelector,
    get_axis_styles_1.getAxesStylesSelector,
    compute_series_domains_1.computeSeriesDomainsSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
    get_bar_paddings_1.getBarPaddingsSelector,
    get_specs_1.getSeriesSpecsSelector,
    compute_small_multiple_scales_1.computeSmallMultipleScalesSelector,
], function (chartDimensions, chartTheme, settingsSpec, axesSpecs, axesTicksDimensions, axesStyles, seriesDomainsAndData, totalBarsInCluster, isHistogramMode, barsPadding, seriesSpecs, smScales) {
    var _a, _b;
    var fallBackTickFormatter = (_b = (_a = seriesSpecs.find(function (_a) {
        var tickFormat = _a.tickFormat;
        return tickFormat;
    })) === null || _a === void 0 ? void 0 : _a.tickFormat) !== null && _b !== void 0 ? _b : axis_utils_1.defaultTickFormatter;
    var xDomain = seriesDomainsAndData.xDomain, yDomains = seriesDomainsAndData.yDomains;
    return axis_utils_1.getAxesGeometries(chartDimensions, chartTheme, settingsSpec.rotation, axesSpecs, axesTicksDimensions, axesStyles, xDomain, yDomains, smScales, totalBarsInCluster, isHistogramMode, fallBackTickFormatter, barsPadding);
});
//# sourceMappingURL=compute_axes_geometries.js.map