/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.search.startree.filter.DimensionFilter;

@ExperimentalApi
public class StarTreeFilter {
    private final Map<String, List<DimensionFilter>> dimensionFilterMap;

    public StarTreeFilter(Map<String, List<DimensionFilter>> dimensionFilterMap) {
        this.dimensionFilterMap = dimensionFilterMap;
    }

    public List<DimensionFilter> getFiltersForDimension(String dimension) {
        return this.dimensionFilterMap.containsKey(dimension) ? this.dimensionFilterMap.get(dimension) : (List)this.dimensionFilterMap.values().stream().filter(filters -> filters != null && !filters.isEmpty() && dimension.equals(((DimensionFilter)filters.getFirst()).getMatchingDimension())).findFirst().orElse(null);
    }

    public Set<String> getDimensions() {
        return this.dimensionFilterMap.keySet();
    }

    public Set<String> getMatchingDimensions() {
        HashSet<String> matchingDimensions = new HashSet<String>();
        for (Map.Entry<String, List<DimensionFilter>> entry : this.dimensionFilterMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            String matchingDimension = entry.getValue().getFirst().getMatchingDimension();
            matchingDimensions.add(matchingDimension == null ? entry.getKey() : matchingDimension);
        }
        return matchingDimensions;
    }
}

