/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

binary morphological closing of an image.


This filter removes small (i.e., smaller than the structuring element)
holes and tube like structures in the interior or at the boundaries of
the image. The morphological closing of an image "f" is defined as:
Closing(f) = Erosion(Dilation(f)).

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: "Binary
morphological closing and opening image filters" by Lehmann G. https://doi.org/10.54294/bcwtvq


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleErodeImageFilter

 itk::simple::BinaryMorphologicalClosing for the procedural interface

 itk::BinaryMorphologicalClosingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMorphologicalClosingImageFilter.h
*/
public class BinaryMorphologicalClosingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryMorphologicalClosingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryMorphologicalClosingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryMorphologicalClosingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryMorphologicalClosingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryMorphologicalClosingImageFilter::~BinaryMorphologicalClosingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryMorphologicalClosingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryMorphologicalClosingImageFilter::BinaryMorphologicalClosingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryMorphologicalClosingImageFilter() {
    this(SimpleITKJNI.new_BinaryMorphologicalClosingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.BinaryMorphologicalClosingImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.BinaryMorphologicalClosingImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BinaryMorphologicalClosingImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.BinaryMorphologicalClosingImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalClosingImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.BinaryMorphologicalClosingImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::BinaryMorphologicalClosingImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.BinaryMorphologicalClosingImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalClosingImageFilter::SetForegroundValue(double ForegroundValue)

Set the value in the image to consider as "foreground". Defaults to
maximum value of InputPixelType.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryMorphologicalClosingImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryMorphologicalClosingImageFilter::GetForegroundValue() const

Get the value in the image considered as "foreground". Defaults to
maximum value of InputPixelType.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryMorphologicalClosingImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalClosingImageFilter::SetSafeBorder(bool SafeBorder)

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public  void setSafeBorder(boolean SafeBorder) {
    SimpleITKJNI.BinaryMorphologicalClosingImageFilter_setSafeBorder(swigCPtr, this, SafeBorder);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalClosingImageFilter::SafeBorderOn()

Set the value of SafeBorder to true or false respectfully.

*/
public  void safeBorderOn() {
    SimpleITKJNI.BinaryMorphologicalClosingImageFilter_safeBorderOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryMorphologicalClosingImageFilter::SafeBorderOff()
*/
public  void safeBorderOff() {
    SimpleITKJNI.BinaryMorphologicalClosingImageFilter_safeBorderOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryMorphologicalClosingImageFilter::GetSafeBorder() const

A safe border is added to input image to avoid borders effects and
remove it once the closing is done

*/
public  boolean getSafeBorder() {
    return SimpleITKJNI.BinaryMorphologicalClosingImageFilter_getSafeBorder(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMorphologicalClosingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryMorphologicalClosingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMorphologicalClosingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryMorphologicalClosingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryMorphologicalClosingImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryMorphologicalClosingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
