/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageReaderBase;
import org.itk.simple.PixelIDValueEnum;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorDouble;
import org.itk.simple.VectorInt32;
import org.itk.simple.VectorString;
import org.itk.simple.VectorUInt32;
import org.itk.simple.VectorUInt64;

public class ImageFileReader
extends ImageReaderBase {
    private transient long swigCPtr;

    protected ImageFileReader(long l, boolean bl) {
        super(SimpleITKJNI.ImageFileReader_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(ImageFileReader imageFileReader) {
        return imageFileReader == null ? 0L : imageFileReader.swigCPtr;
    }

    protected static long swigRelease(ImageFileReader imageFileReader) {
        long l = 0L;
        if (imageFileReader != null) {
            if (!imageFileReader.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = imageFileReader.swigCPtr;
            imageFileReader.swigCMemOwn = false;
            imageFileReader.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_ImageFileReader(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ImageFileReader() {
        this(SimpleITKJNI.new_ImageFileReader(), true);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.ImageFileReader_toString(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.ImageFileReader_getName(this.swigCPtr, this);
    }

    public void setFileName(String string) {
        SimpleITKJNI.ImageFileReader_setFileName(this.swigCPtr, this, string);
    }

    public String getFileName() {
        return SimpleITKJNI.ImageFileReader_getFileName(this.swigCPtr, this);
    }

    @Override
    public Image execute() {
        return new Image(SimpleITKJNI.ImageFileReader_execute(this.swigCPtr, this), true);
    }

    public void readImageInformation() {
        SimpleITKJNI.ImageFileReader_readImageInformation(this.swigCPtr, this);
    }

    public PixelIDValueEnum getPixelID() {
        return PixelIDValueEnum.swigToEnum(SimpleITKJNI.ImageFileReader_getPixelID(this.swigCPtr, this));
    }

    public int getPixelIDValue() {
        return SimpleITKJNI.ImageFileReader_getPixelIDValue(this.swigCPtr, this);
    }

    public long getDimension() {
        return SimpleITKJNI.ImageFileReader_getDimension(this.swigCPtr, this);
    }

    public long getNumberOfComponents() {
        return SimpleITKJNI.ImageFileReader_getNumberOfComponents(this.swigCPtr, this);
    }

    public VectorDouble getOrigin() {
        return new VectorDouble(SimpleITKJNI.ImageFileReader_getOrigin(this.swigCPtr, this), false);
    }

    public VectorDouble getSpacing() {
        return new VectorDouble(SimpleITKJNI.ImageFileReader_getSpacing(this.swigCPtr, this), false);
    }

    public VectorDouble getDirection() {
        return new VectorDouble(SimpleITKJNI.ImageFileReader_getDirection(this.swigCPtr, this), false);
    }

    public VectorUInt64 getSize() {
        return new VectorUInt64(SimpleITKJNI.ImageFileReader_getSize(this.swigCPtr, this), false);
    }

    public VectorString getMetaDataKeys() {
        return new VectorString(SimpleITKJNI.ImageFileReader_getMetaDataKeys(this.swigCPtr, this), true);
    }

    public boolean hasMetaDataKey(String string) {
        return SimpleITKJNI.ImageFileReader_hasMetaDataKey(this.swigCPtr, this, string);
    }

    public String getMetaData(String string) {
        return SimpleITKJNI.ImageFileReader_getMetaData(this.swigCPtr, this, string);
    }

    public void setExtractSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.ImageFileReader_setExtractSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getExtractSize() {
        return new VectorUInt32(SimpleITKJNI.ImageFileReader_getExtractSize(this.swigCPtr, this), false);
    }

    public void setExtractIndex(VectorInt32 vectorInt32) {
        SimpleITKJNI.ImageFileReader_setExtractIndex(this.swigCPtr, this, VectorInt32.getCPtr(vectorInt32), vectorInt32);
    }

    public VectorInt32 getExtractIndex() {
        return new VectorInt32(SimpleITKJNI.ImageFileReader_getExtractIndex(this.swigCPtr, this), false);
    }
}

