/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.datasource;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.impl.ArrayExample;
import org.tribuo.provenance.DataSourceProvenance;

public final class LibSVMDataSource<T extends Output<T>>
implements ConfigurableDataSource<T> {
    private static final Logger logger = Logger.getLogger(LibSVMDataSource.class.getName());
    private static final Pattern splitPattern = Pattern.compile("\\s+");
    @Config(description="URL to load the data from. Either this or path must be set.")
    private URL url;
    @Config(description="Path to load the data from. Either this or url must be set.")
    private Path path;
    @Config(mandatory=true, description="The output factory to use.")
    private OutputFactory<T> outputFactory;
    @Config(description="Set to true if the features are zero indexed.")
    private boolean zeroIndexed;
    @Config(description="Sets the maximum feature id to load from the file.")
    private int maxFeatureID = Integer.MIN_VALUE;
    private boolean rangeSet;
    private int minFeatureID = Integer.MAX_VALUE;
    private final ArrayList<Example<T>> data = new ArrayList();
    private LibSVMDataSourceProvenance provenance;

    private LibSVMDataSource() {
    }

    public LibSVMDataSource(Path path, OutputFactory<T> outputFactory) throws IOException {
        this(path.normalize(), path.normalize().toUri().toURL(), outputFactory, false, false, 0);
    }

    public LibSVMDataSource(Path path, OutputFactory<T> outputFactory, boolean zeroIndexed, int maxFeatureID) throws IOException {
        this(path.normalize(), path.normalize().toUri().toURL(), outputFactory, true, zeroIndexed, maxFeatureID);
    }

    public LibSVMDataSource(URL url, OutputFactory<T> outputFactory) throws IOException {
        this(null, url, outputFactory, false, false, 0);
    }

    public LibSVMDataSource(URL url, OutputFactory<T> outputFactory, boolean zeroIndexed, int maxFeatureID) throws IOException {
        this(null, url, outputFactory, true, zeroIndexed, maxFeatureID);
    }

    private LibSVMDataSource(Path path, URL url, OutputFactory<T> outputFactory, boolean rangeSet, boolean zeroIndexed, int maxFeatureID) throws IOException {
        if (url == null && path == null) {
            throw new IllegalArgumentException("Must supply a non-null path or url.");
        }
        this.path = path;
        this.url = url;
        if (outputFactory == null) {
            throw new IllegalArgumentException("outputFactory must not be null");
        }
        this.outputFactory = outputFactory;
        this.rangeSet = rangeSet;
        if (rangeSet) {
            this.zeroIndexed = zeroIndexed;
            int n = this.minFeatureID = zeroIndexed ? 0 : 1;
            if (maxFeatureID < this.minFeatureID + 1) {
                throw new IllegalArgumentException("maxFeatureID must be positive, found " + maxFeatureID);
            }
            this.maxFeatureID = maxFeatureID;
        }
        this.read();
    }

    public void postConfig() throws IOException {
        if (this.maxFeatureID != Integer.MIN_VALUE) {
            this.rangeSet = true;
            int n = this.minFeatureID = this.zeroIndexed ? 0 : 1;
            if (this.maxFeatureID < this.minFeatureID + 1) {
                throw new IllegalArgumentException("maxFeatureID must be positive, found " + this.maxFeatureID);
            }
        }
        if (this.url == null && this.path == null) {
            throw new PropertyException("", "path", "At most one of url and path must be set.");
        }
        if (this.url != null && this.path != null && !this.path.toUri().toURL().equals(this.url)) {
            throw new PropertyException("", "path", "At most one of url and path must be set");
        }
        if (this.path != null) {
            try {
                this.url = this.path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new PropertyException((Throwable)e, "", "path", "Path was not a valid URL");
            }
        }
        this.read();
    }

    public boolean isZeroIndexed() {
        return this.minFeatureID == 0;
    }

    public int getMaxFeatureID() {
        return this.maxFeatureID;
    }

    public String toString() {
        if (this.path != null) {
            return "LibSVMDataSource(path=" + this.path.toString() + ",zeroIndexed=" + this.zeroIndexed + ",minFeatureID=" + this.minFeatureID + ",maxFeatureID=" + this.maxFeatureID + ")";
        }
        return "LibSVMDataSource(url=" + this.url.toString() + ",zeroIndexed=" + this.zeroIndexed + ",minFeatureID=" + this.minFeatureID + ",maxFeatureID=" + this.maxFeatureID + ")";
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    public synchronized DataSourceProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = this.cacheProvenance();
        }
        return this.provenance;
    }

    private LibSVMDataSourceProvenance cacheProvenance() {
        return new LibSVMDataSourceProvenance(this);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read() throws IOException {
        int i;
        ArrayList<String> labels;
        ArrayList processedData;
        block27: {
            int pos = 0;
            processedData = new ArrayList();
            labels = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(this.url.openStream(), StandardCharsets.UTF_8));){
                while (true) {
                    String line;
                    if ((line = r.readLine()) == null) {
                        break block27;
                    }
                    ++pos;
                    String[] fields = splitPattern.split(line);
                    boolean valid = true;
                    HashMap<Integer, Double> features = new HashMap<Integer, Double>();
                    for (i = 1; i < fields.length && valid; ++i) {
                        int ind = fields[i].indexOf(58);
                        if (ind < 0) {
                            logger.warning(String.format("Weird line at %d", pos));
                            valid = false;
                        }
                        String ids = fields[i].substring(0, ind);
                        int id = Integer.parseInt(ids);
                        if (!this.rangeSet && this.maxFeatureID < id) {
                            this.maxFeatureID = id;
                        }
                        if (!this.rangeSet && this.minFeatureID > id) {
                            this.minFeatureID = id;
                        }
                        double val = Double.parseDouble(fields[i].substring(ind + 1));
                        Double value = features.put(id, val);
                        if (value == null) continue;
                        logger.warning(String.format("Repeated features at line %d", pos));
                        valid = false;
                    }
                    if (!valid) throw new IOException("Invalid LibSVM format file");
                    labels.add(fields[0]);
                    processedData.add(features);
                    continue;
                    break;
                }
                catch (NumberFormatException ex) {
                    logger.warning(String.format("Weird line at %d", pos));
                    throw new IOException("Invalid LibSVM format file", ex);
                }
            }
        }
        int width = ("" + this.maxFeatureID).length();
        String formatString = "%0" + width + "d";
        int maxID = this.maxFeatureID;
        if (this.minFeatureID != 0) {
            this.minFeatureID = 1;
            this.zeroIndexed = false;
        } else {
            ++maxID;
            this.zeroIndexed = true;
        }
        String[] featureNames = new String[maxID];
        for (int i2 = 0; i2 < maxID; ++i2) {
            featureNames[i2] = String.format(formatString, i2);
        }
        ArrayList<Feature> buffer = new ArrayList<Feature>();
        for (i = 0; i < processedData.size(); ++i) {
            String labelStr = (String)labels.get(i);
            HashMap features = (HashMap)processedData.get(i);
            try {
                T curLabel = this.outputFactory.generateOutput(labelStr);
                ArrayExample<T> example = new ArrayExample<T>(curLabel);
                buffer.clear();
                for (Map.Entry e : features.entrySet()) {
                    int id = (Integer)e.getKey() - this.minFeatureID;
                    if (id >= maxID) continue;
                    double value = (Double)e.getValue();
                    Feature f = new Feature(featureNames[id], value);
                    buffer.add(f);
                }
                example.addAll(buffer);
                this.data.add(example);
                continue;
            }
            catch (NumberFormatException e) {
                logger.warning(String.format("Failed to parse example %d", i));
                throw new IOException("Invalid LibSVM format file");
            }
        }
    }

    public int size() {
        return this.data.size();
    }

    @Override
    public Iterator<Example<T>> iterator() {
        return this.data.iterator();
    }

    public static <T extends Output<T>> void writeLibSVMFormat(Dataset<T> dataset, PrintStream out, boolean zeroIndexed, Function<T, Number> transformationFunc) {
        int modifier = zeroIndexed ? 0 : 1;
        ImmutableFeatureMap featureMap = dataset.getFeatureIDMap();
        for (Example<T> example : dataset) {
            out.print(transformationFunc.apply(example.getOutput()));
            out.print(' ');
            for (Feature feature : example) {
                out.print(featureMap.get(feature.getName()).getID() + modifier);
                out.print(':');
                out.print(feature.getValue());
                out.print(' ');
            }
            out.print('\n');
        }
    }

    public static final class LibSVMDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements DataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private final DateTimeProvenance fileModifiedTime;
        private final DateTimeProvenance dataSourceCreationTime;
        private final HashProvenance sha256Hash;

        <T extends Output<T>> LibSVMDataSourceProvenance(LibSVMDataSource<T> host) {
            super(host, "DataSource");
            Optional time = ProvenanceUtil.getModifiedTime((URL)((LibSVMDataSource)host).url);
            this.fileModifiedTime = time.map(offsetDateTime -> new DateTimeProvenance("file-modified-time", offsetDateTime)).orElseGet(() -> new DateTimeProvenance("file-modified-time", OffsetDateTime.MIN));
            this.dataSourceCreationTime = new DateTimeProvenance("datasource-creation-time", OffsetDateTime.now());
            this.sha256Hash = new HashProvenance(DEFAULT_HASH_TYPE, "resource-hash", ProvenanceUtil.hashResource((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, (URL)((LibSVMDataSource)host).url));
        }

        public LibSVMDataSourceProvenance(Map<String, Provenance> map) {
            this(LibSVMDataSourceProvenance.extractProvenanceInfo(map));
        }

        private LibSVMDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
            this.fileModifiedTime = (DateTimeProvenance)info.instanceValues.get("file-modified-time");
            this.dataSourceCreationTime = (DateTimeProvenance)info.instanceValues.get("datasource-creation-time");
            this.sha256Hash = (HashProvenance)info.instanceValues.get("resource-hash");
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)LibSVMDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)LibSVMDataSourceProvenance.class.getSimpleName())).getValue();
            HashMap<String, Provenance> instanceParameters = new HashMap<String, Provenance>();
            instanceParameters.put("file-modified-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"file-modified-time", DateTimeProvenance.class, (String)LibSVMDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("datasource-creation-time", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"datasource-creation-time", DateTimeProvenance.class, (String)LibSVMDataSourceProvenance.class.getSimpleName()));
            instanceParameters.put("resource-hash", ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"resource-hash", HashProvenance.class, (String)LibSVMDataSourceProvenance.class.getSimpleName()));
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, instanceParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LibSVMDataSourceProvenance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LibSVMDataSourceProvenance pairs = (LibSVMDataSourceProvenance)o;
            return this.fileModifiedTime.equals((Object)pairs.fileModifiedTime) && this.dataSourceCreationTime.equals((Object)pairs.dataSourceCreationTime) && this.sha256Hash.equals((Object)pairs.sha256Hash);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fileModifiedTime, this.dataSourceCreationTime, this.sha256Hash);
        }

        public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
            Map map = super.getInstanceValues();
            map.put("file-modified-time", this.fileModifiedTime);
            map.put("datasource-creation-time", this.dataSourceCreationTime);
            map.put("resource-hash", this.sha256Hash);
            return map;
        }
    }
}

