/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.CryptlibObjectIdentifiers;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.BigIntegers;

class JcaJcePGPUtil {
    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string = PGPUtil.getSymmetricCipherName(n);
        if (string == null) {
            throw new PGPException("unknown symmetric algorithm: " + n);
        }
        return new SecretKeySpec(byArray, string);
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
    }

    static NamedECDomainParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return ECDomainParametersIndex.lookupDomainParameters((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
    }

    static HybridValueParameterSpec getHybridValueParameterSpecWithPrepend(byte[] byArray, PublicKeyPacket publicKeyPacket, String string) throws IOException {
        throw new UnsupportedOperationException("not yet supported");
    }

    static Key getSecret(OperatorHelper operatorHelper, PublicKey publicKey, String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, Key key) throws GeneralSecurityException {
        KeyAgreement keyAgreement = operatorHelper.createKeyAgreement(string2);
        keyAgreement.init(key, algorithmParameterSpec);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret(string);
    }

    static boolean isX25519(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519) || aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_X25519);
    }
}

