/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rule.RulePersistenceService;
import org.opensearch.rule.RulePersistenceServiceRegistry;
import org.opensearch.rule.action.GetRuleRequest;
import org.opensearch.rule.action.GetRuleResponse;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetRuleAction
extends HandledTransportAction<GetRuleRequest, GetRuleResponse> {
    private final RulePersistenceServiceRegistry rulePersistenceServiceRegistry;
    private final ThreadPool threadPool;

    @Inject
    public TransportGetRuleAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, RulePersistenceServiceRegistry rulePersistenceServiceRegistry) {
        super("cluster:admin/opensearch/rule/_get", transportService, actionFilters, GetRuleRequest::new);
        this.threadPool = threadPool;
        this.rulePersistenceServiceRegistry = rulePersistenceServiceRegistry;
    }

    protected void doExecute(Task task, GetRuleRequest request, ActionListener<GetRuleResponse> listener) {
        this.threadPool.executor("get").execute(() -> {
            RulePersistenceService rulePersistenceService = this.rulePersistenceServiceRegistry.getRulePersistenceService(request.getFeatureType());
            rulePersistenceService.getRule(request, listener);
        });
    }
}

