import { textUtil } from '@grafana/data';
import { useUrlParams } from 'app/core/navigation/hooks';

export const usePullRequestParam = () => {
  const [params] = useUrlParams();
  const prParam = params.get('pull_request_url');
  const newPrParam = params.get('new_pull_request_url');

  return {
    prURL: prParam ? textUtil.sanitizeUrl(prParam) : undefined,
    newPrURL: newPrParam ? textUtil.sanitizeUrl(newPrParam) : undefined,
  };
};
